/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.cmdframework;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandMgrInitException;
import com.ibm.ws.management.cmdframework.impl.ClientCommandMgr;
import com.ibm.ws.management.cmdframework.impl.CommandUtility;

public final class CommandMgrInitializer {
    private static TraceComponent tc = Tr.register(CommandMgrInitializer.class, "CommandMgrInitializer", "com.ibm.websphere.management.resources.cmdframework");
    private CommandMgr commandMgr;

    private CommandMgrInitializer() {
    }

    public static synchronized void initializeClientMode(AdminClient adminclient) throws CommandMgrInitException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeClientMode, AdminClient: " + adminclient);
        }
        CommandMgr.initialized = true;
        if (adminclient == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adminclient is null.  Just return");
            }
            return;
        }
        try {
            CommandUtility.getRemoteCmdMgrMbean(adminclient);
            Class<?> cmdMgrClass = Class.forName("com.ibm.ws.management.cmdframework.impl.ClientCommandMgr");
            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
            ClientCommandMgr cmdMgrInstance = null;
            cmdMgrInstance = cmdMgr == null || !cmdMgrClass.isInstance(cmdMgr) ? (ClientCommandMgr)cmdMgrClass.newInstance() : (ClientCommandMgr)cmdMgr;
            ClientCommandMgr.cmdMgr = cmdMgrInstance;
            cmdMgrInstance.setAdminClient(adminclient);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeClientMode, CommandMgr: " + cmdMgr + ", cmdMgrInstance: " + ClientCommandMgr.cmdMgr);
            }
        }
        catch (Throwable ex) {
            Manager.Ffdc.log(ex, CommandMgrInitializer.class, "com.ibm.websphere.management.cmdframework.CommandMgrInitializer", "52");
            Tr.error(tc, "commandframework failed to initialize in client mode", ex);
            throw new CommandMgrInitException(ex, "ClientMode");
        }
    }

    public static synchronized void initializeServerMode() {
        try {
            Class<?> cmdMgrClass = Class.forName("com.ibm.ws.management.cmdframework.impl.ServerCommandMgr");
            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
            if (cmdMgr == null || !cmdMgrClass.isInstance(cmdMgr)) {
                cmdMgrClass.newInstance();
            }
            CommandMgr.initialized = true;
        }
        catch (Throwable ex) {
            Manager.Ffdc.log(ex, CommandMgrInitializer.class, "com.ibm.websphere.management.cmdframework.CommandMgrInitializer", "52");
            Tr.error(tc, "commandframework failed to initialize in server mode", ex);
        }
    }

    public static void initializeLocalMode() {
        try {
            Class<?> cmdMgrClass = Class.forName("com.ibm.ws.management.cmdframework.impl.LocalCommandMgr");
            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
            if (cmdMgr == null || !cmdMgrClass.isInstance(cmdMgr)) {
                cmdMgrClass.newInstance();
            }
            CommandMgr.initialized = true;
        }
        catch (Throwable ex) {
            Manager.Ffdc.log(ex, CommandMgrInitializer.class, "com.ibm.websphere.management.cmdframework.CommandMgrInitializer", "52");
            Tr.error(tc, "commandframework failed to initialize in local mode", ex);
        }
    }
}

