/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.ws.management.application.sync.AddBinaryTask;
import com.ibm.ws.management.application.sync.AppSyncUtils;
import com.ibm.ws.management.application.sync.FilePermissionTask;
import com.ibm.ws.management.application.sync.RemoveBinaryTask;
import com.ibm.ws.management.application.sync.StartDeploymentTask;
import com.ibm.ws.management.application.sync.StopDeploymentTask;
import java.util.Hashtable;
import javax.security.auth.Subject;

public abstract class AbstractAppSyncTask {
    private static final String defaultBundleName = "com.ibm.ws.management.resources.AppDeploymentMessages";
    private static TraceComponent tc = Tr.register(AbstractAppSyncTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    protected ConfigRepository _repository;
    protected String _cellName;
    protected String _nodeName;
    protected Subject _subject = null;
    protected boolean _isLocal;
    protected boolean _isStandAlone;
    protected Object _notify;
    protected Class _cls;
    protected Hashtable _cachedSIMap;
    protected Hashtable _newSIMap;
    public static final String ADDBINARYTASK = AddBinaryTask.class.getName();
    public static final String REMOVEBINARYTASK = RemoveBinaryTask.class.getName();
    public static final String STARTDEPLOYMENTTASK = StartDeploymentTask.class.getName();
    public static final String STOPDEPLOYMENTTASK = StopDeploymentTask.class.getName();
    public static final String FILEPERMISSIONTASK = FilePermissionTask.class.getName();

    public void setData(ConfigRepository repo, String cell, String node, boolean local, Hashtable cachedSIMap, Hashtable newSIMap) {
        this._repository = repo;
        this._cellName = cell;
        this._nodeName = node;
        this._isLocal = local;
        this._cachedSIMap = cachedSIMap;
        this._newSIMap = newSIMap;
        this._isStandAlone = !AppSyncUtils.isCellDistributed(this._cellName, this._repository);
    }

    public void setSecurity(Subject sub, Object notify, Class cls) {
        this._subject = sub;
        this._notify = notify;
        this._cls = cls;
    }

    public boolean appIsDeployedOnNode(String appname) {
        boolean b;
        if (AdminServiceFactory.getAdminService() != null && "NodeAgent".equals(AdminServiceFactory.getAdminService().getProcessType())) {
            return true;
        }
        boolean bl = b = this._newSIMap.get(appname) != null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, appname + " appIsDeployedOnNode: " + b);
        }
        return b;
    }

    public boolean appWasDeployedOnNode(String appname) {
        boolean b;
        if (AdminServiceFactory.getAdminService() != null && "NodeAgent".equals(AdminServiceFactory.getAdminService().getProcessType())) {
            return true;
        }
        boolean bl = b = this._cachedSIMap.get(appname) != null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, appname + " appWasDeployedOnNode: " + b);
        }
        return b;
    }

    public abstract boolean performTask(AppData var1, AppData var2, Hashtable var3) throws Exception;
}

