/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.DefaultBinding;
import com.ibm.ws.management.application.client.DefaultBindingHelper;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import java.util.Hashtable;
import java.util.Vector;

public class RedeploymentController
extends AppDeploymentController {
    private static final long serialVersionUID = 6387558788656394772L;
    private static TraceComponent tc = Tr.register(RedeploymentController.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    Vector tasksWOBindings = null;
    Vector oldAppTasks = null;
    boolean forceDfltBndg = false;
    String mode = "redeploy.default.merge";

    public RedeploymentController(AppDeploymentInfo i, Hashtable p, Vector tInfo, Vector oldTasks, Vector noBnd) throws AppDeploymentException {
        super(i, p, tInfo);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RedeploymentController");
        }
        this.oldAppTasks = oldTasks;
        this.tasksWOBindings = noBnd;
        RedeploymentController.patchInfo(this.deploymentInfo, oldTasks);
        if (p.get("redeploy.ignore.new") != null) {
            this.mode = "redeploy.ignore.new";
        }
        RedeploymentController.dbg("Mode is: " + this.mode);
        Object o = p.get("usedefaultbindings");
        if (o != null) {
            Preferences dfltPref = null;
            if (o instanceof Preferences) {
                dfltPref = (Preferences)o;
            } else if (o instanceof DefaultBinding) {
                dfltPref = DefaultBindingHelper.getPreferences((DefaultBinding)o);
            }
            if (dfltPref != null) {
                this.forceDfltBndg = dfltPref.getForceBindings();
            }
            RedeploymentController.dbg("Force : " + this.forceDfltBndg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RedeploymentController");
        }
    }

    protected void setDeploymentMode(Hashtable prefs) throws AppDeploymentException {
        String cType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDeploymentMode");
        }
        if ("modulefile".equals(cType = (String)prefs.get("contenttype"))) {
            this._deploymentMode = 65536L;
        } else if ("app".equals(cType)) {
            this._deploymentMode = 4096L;
        } else {
            throw new AppDeploymentException("Internal Error: Invalid content type for app update: " + cType, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDeploymentMode:" + this._deploymentMode);
        }
    }

    private static void patchInfo(AppDeploymentInfo info, Vector tasks) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "patchInfo");
        }
        if (tasks == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "patchInfo = null");
            }
            return;
        }
        Hashtable options = info.getAppOptions();
        for (int i = 0; i < tasks.size(); ++i) {
            Hashtable<String, String> tbl;
            if (((AppDeploymentTask)tasks.elementAt(i)).getName().equals("AppDeploymentOptions")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found AppDeplOptions");
                }
                String[][] data = ((AppDeploymentTask)tasks.elementAt(i)).getTaskData();
                for (int j = 0; j < data[0].length; ++j) {
                    if (data[0][j].equals("buildVersion")) continue;
                    if (data[1][j].equals("AppDeploymentOption.Yes")) {
                        options.put(data[0][j], Boolean.TRUE);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Patched option: " + data[0][j] + "val: TRUE");
                        continue;
                    }
                    if (data[1][j].equals("AppDeploymentOption.No")) {
                        options.put(data[0][j], Boolean.FALSE);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Patched option: " + data[0][j] + "val: FALSE");
                        continue;
                    }
                    options.put(data[0][j], data[1][j]);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Patched option: " + data[0][j] + "val: " + data[1][j]);
                }
                continue;
            }
            if (!((AppDeploymentTask)tasks.elementAt(i)).getName().equals("MapModulesToServers")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found MapMod2Svr");
            }
            if ((tbl = (Hashtable<String, String>)options.get("moduleToServer")) == null) {
                tbl = new Hashtable<String, String>();
                options.put("moduleToServer", tbl);
            }
            String[][] data = ((AppDeploymentTask)tasks.elementAt(i)).getTaskData();
            for (int j = 1; j < data.length; ++j) {
                String uri = util.createUniqueModuleNameFromUriString(data[j][1]);
                tbl.put(uri, data[j][2]);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Patched in: " + uri + " = " + data[j][2]);
            }
        }
    }

    protected void prepareTask(int i, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask: redepl:" + t.getName());
        }
        super.prepareTask(i, t);
        if (t.isTaskEmpty()) {
            return;
        }
        if (this.oldAppTasks == null && this.tasksWOBindings == null) {
            return;
        }
        AppDeploymentTask oldTask = this.findMatchingTask(t, this.oldAppTasks);
        AppDeploymentTask noBndTask = this.findMatchingTask(t, this.tasksWOBindings);
        if (oldTask == null && noBndTask == null) {
            RedeploymentController.dbg("No match: " + t.getName());
            return;
        }
        String[][] finalData = this.createNewData(t, oldTask, noBndTask);
        t.setTaskData(finalData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    private AppDeploymentTask findMatchingTask(AppDeploymentTask t, Vector v) {
        if (v == null) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findMatchingTask");
        }
        AppDeploymentTask ret = null;
        for (int i = 0; i < v.size(); ++i) {
            String[] matchCols;
            AppDeploymentTask tsk = (AppDeploymentTask)v.elementAt(i);
            if (!tsk.getName().equals(t.getName())) continue;
            String[] cols = t.getColumnNames();
            if (cols.length != (matchCols = tsk.getColumnNames()).length) break;
            boolean allMatch = true;
            for (int j = 0; j < cols.length; ++j) {
                if (cols[j].equals(matchCols[j])) continue;
                allMatch = false;
                break;
            }
            if (!allMatch) break;
            ret = (AppDeploymentTask)v.elementAt(i);
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "found match: " + ret.getName());
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findMatchingTask: " + ret);
        }
        return ret;
    }

    private String[][] createNewData(AppDeploymentTask t, AppDeploymentTask oldTask, AppDeploymentTask noBndTask) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNewData: " + t.getName());
        }
        String[][] data = t.getTaskData();
        String[][] result = new String[data.length][];
        result[0] = data[0];
        RedeploymentController.dbg("For: " + t.getName() + " data rows: " + (data.length - 1));
        for (int i = 1; i < data.length; ++i) {
            String[] a = this.findMatchingRow(data[i], t, oldTask);
            String[] b = this.findMatchingRow(data[i], t, noBndTask);
            String[] c = data[i];
            if (t.getName().equals("AppDeploymentOptions") || t.getName().equals("MapModulesToServers")) {
                b = c;
                RedeploymentController.dbg("Setting b to c for AppDeplOptions and Mod2Svr");
            }
            RedeploymentController.printSA(a, "a row");
            RedeploymentController.printSA(b, "b row");
            RedeploymentController.printSA(c, "c row");
            if (this.mode.equals("redeploy.ignore.new")) {
                if (this.isFull(t, a)) {
                    result[i] = a;
                    RedeploymentController.dbg("a won ignoreNew.");
                } else {
                    result[i] = c;
                    RedeploymentController.dbg("c won ignoreNew.");
                }
            } else {
                if (this.isFull(t, b)) {
                    if (this.forceDfltBndg) {
                        result[i] = c;
                        RedeploymentController.dbg("c won - default mode - forcedflt.");
                    } else {
                        result[i] = b;
                        RedeploymentController.dbg("b won - default mode.");
                        this.copyNonReqColumns(result[i], a != null ? a : c, t);
                    }
                } else if (this.tasksWOBindings == null && this.isFull(t, c)) {
                    if (!this.isDefaultDSSet(t)) {
                        c = a;
                    }
                    result[i] = c;
                    RedeploymentController.dbg("c won nodfltbndg.");
                    this.copyNonReqColumns(result[i], a, t);
                } else if (this.isFull(t, a)) {
                    result[i] = a;
                    RedeploymentController.dbg("a won - default mode.");
                }
                if (result[i] == null) {
                    result[i] = c;
                    RedeploymentController.dbg("c won finally in default mode.");
                }
            }
            RedeploymentController.printSA(result[i], t.getName() + "[" + i + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNewData");
        }
        return result;
    }

    private String[] findMatchingRow(String[] orig, AppDeploymentTask finalTask, AppDeploymentTask compareTask) {
        if (compareTask == null || compareTask.getTaskData() == null) {
            return null;
        }
        boolean[] mutables = finalTask.getMutableColumns();
        String[][] data = compareTask.getTaskData();
        for (int i = 1; i < data.length; ++i) {
            boolean found = true;
            for (int j = 0; j < data[i].length; ++j) {
                if (mutables[j] || finalTask.isHiddenColumn(j) || data[i][j] == null || data[i][j].equals(orig[j])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return data[i];
        }
        return null;
    }

    private boolean isDefaultDSSet(AppDeploymentTask t) {
        if (t.getName().equals("DataSourceFor20EJBModules")) {
            String[][] data = t.getTaskData();
            for (int i = 1; i < data.length; ++i) {
                Tr.debug(tc, "default DS jndi: " + data[i][3]);
                if (data[i][3] != null && !data[i][3].trim().equals("")) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isFull(AppDeploymentTask t, String[] row) {
        if (row == null) {
            return false;
        }
        boolean[] req = t.getRequiredColumns();
        if (req.length != row.length) {
            RedeploymentController.printSA(row, "isFull - Something wrong in " + t.getName());
            return false;
        }
        for (int i = 0; i < row.length; ++i) {
            if (!req[i] || !AppUtils.isEmpty(row[i])) continue;
            return false;
        }
        return true;
    }

    private void copyNonReqColumns(String[] dest, String[] src, AppDeploymentTask t) {
        if (src == null || dest == null) {
            return;
        }
        for (int i = 0; i < dest.length; ++i) {
            if (src[i] == null) continue;
            if (AppUtils.isEmpty(dest[i])) {
                dest[i] = src[i];
                continue;
            }
            if (!t.getName().equals("MapRolesToUsers") || !"AppDeploymentOption.No".equals(dest[i]) || !"AppDeploymentOption.Yes".equals(src[i])) continue;
            dest[i] = src[i];
        }
    }

    private static void printSA(String[] ar, String front) {
        if (ar == null) {
            RedeploymentController.dbg("Null array");
            return;
        }
        String s = front + " --> ";
        for (int i = 0; i < ar.length; ++i) {
            if (i != 0) {
                s = s + ", ";
            }
            s = s + ar[i];
        }
        RedeploymentController.dbg(s);
    }

    private static void dbg(String s) {
        if (System.getProperty("redeploy.debug") != null) {
            AppUtils.dbg(tc, s);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, s);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/websphere/management/application/client/RedeploymentController.java, WAS.admin.installapp.client, WAS70.SERV1, q0834.18, ver. 1.17");
        }
        CLASS_NAME = RedeploymentController.class.getName();
    }
}

