/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentMessages;
import com.ibm.ws.bootstrap.ExtClassLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class AppDeploymentTaskMessages
implements AppDeploymentMessages {
    private static TraceComponent tc = Tr.register(AppDeploymentTaskMessages.class);
    private ResourceBundle bundle = null;
    private static final String defaultBundleName = "com.ibm.ws.management.resources.AppDeploymentMessages";
    private String bundleName = "com.ibm.ws.management.resources.AppDeploymentMessages";

    public AppDeploymentTaskMessages() {
        this(defaultBundleName, Locale.getDefault());
    }

    public AppDeploymentTaskMessages(String bundleName) {
        this(bundleName, Locale.getDefault());
    }

    public AppDeploymentTaskMessages(Locale locale) {
        this(defaultBundleName, locale);
    }

    public AppDeploymentTaskMessages(String bundleName, Locale locale) {
        this.bundleName = bundleName;
        this.getBundle(bundleName, locale);
    }

    public AppDeploymentTaskMessages(ResourceBundle b, String bName) {
        this.bundle = b;
        this.bundleName = bName;
    }

    private void getBundle(String bundleName, Locale locale) {
        block4: {
            String bun = bundleName == null ? defaultBundleName : bundleName;
            Locale loc = locale == null ? Locale.getDefault() : locale;
            try {
                this.bundle = ResourceBundle.getBundle(bun, loc);
            }
            catch (MissingResourceException e) {
                try {
                    this.bundle = ResourceBundle.getBundle(bun, loc, ExtClassLoader.getInstance());
                }
                catch (Throwable th) {
                    this.bundle = null;
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "Error loading class: " + bundleName + ", locale " + locale + e);
                }
            }
        }
    }

    private String getString(String key) {
        if (this.bundle != null) {
            try {
                return this.bundle.getString(key);
            }
            catch (MissingResourceException e) {
                return key;
            }
        }
        return key;
    }

    public String getGoalTitle(String key) {
        return this.getString(key + ".goalTitle");
    }

    public String getGoalMessage(String key) {
        return this.getString(key + ".goalMessage");
    }

    public String getEmptyTaskMessage(String key) {
        return this.getString(key + ".emptyMessage");
    }

    public String getDisableTaskMessage(String key) {
        return this.getString(key + ".disableMessage");
    }

    public String getColumnName(String key) {
        return this.getString(key + ".column");
    }

    public String getColumnName(String key, String taskName) {
        return this.getColumnName(key);
    }

    public String getMessage(String key) {
        return this.getString(key);
    }
}

