/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.attributes.AttrInfo;
import com.ibm.toad.cfparse.attributes.AttrInfoList;
import com.ibm.toad.cfparse.attributes.CodeAttrInfo;
import com.ibm.toad.cfparse.utils.Access;
import com.ibm.toad.cfparse.utils.BadJavaError;
import com.ibm.toad.cfparse.utils.CPUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.Vector;

public final class MethodInfo {
    private ConstantPool d_cp;
    private int d_accessFlags;
    private int d_idxName;
    private int d_idxDescriptor;
    private AttrInfoList d_attrs;

    MethodInfo(ConstantPool constantPool) {
        this.d_cp = constantPool;
        this.d_accessFlags = -1;
        this.d_idxName = -1;
        this.d_idxDescriptor = -1;
        this.d_attrs = new AttrInfoList(constantPool, 2);
    }

    MethodInfo(ConstantPool constantPool, String string) {
        int n;
        this.d_cp = constantPool;
        this.d_accessFlags = Access.getFromString(string);
        int n2 = 0;
        while ((n = string.indexOf(" ", n2)) != -1 && Access.isFlag(string.substring(n2, n).trim())) {
            n2 = n + 1;
        }
        String string2 = string;
        if ((string = CPUtils.java2method(string.substring(n2))) == null) {
            throw new BadJavaError("Unparsable Method " + string2);
        }
        String string3 = string.substring(0, string.indexOf(" ")).trim();
        String string4 = string.substring(string.indexOf(" ")).trim();
        this.d_idxName = constantPool.find(1, string3);
        if (this.d_idxName == -1) {
            this.d_idxName = constantPool.addUtf8(string3);
        }
        this.d_idxDescriptor = constantPool.find(1, string4);
        if (this.d_idxDescriptor == -1) {
            this.d_idxDescriptor = constantPool.addUtf8(string4);
        }
        this.d_attrs = new AttrInfoList(constantPool, 2);
        if (!Access.isAbstract(this.d_accessFlags) && !Access.isNative(this.d_accessFlags)) {
            this.d_attrs.add("Code");
        }
    }

    BitSet uses() {
        BitSet bitSet = new BitSet(this.d_cp.length());
        bitSet.set(this.d_idxName);
        bitSet.set(this.d_idxDescriptor);
        bitSet.or(this.d_attrs.uses());
        return bitSet;
    }

    void sort(int[] nArray) {
        this.d_idxName = nArray[this.d_idxName];
        this.d_idxDescriptor = nArray[this.d_idxDescriptor];
        this.d_attrs.sort(nArray);
    }

    void read(DataInputStream dataInputStream) throws IOException {
        this.d_accessFlags = dataInputStream.readUnsignedShort();
        this.d_idxName = dataInputStream.readUnsignedShort();
        this.d_idxDescriptor = dataInputStream.readUnsignedShort();
        this.d_attrs.read(dataInputStream);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.d_accessFlags);
        dataOutputStream.writeShort(this.d_idxName);
        dataOutputStream.writeShort(this.d_idxDescriptor);
        this.d_attrs.write(dataOutputStream);
    }

    public String getAbout() {
        if (this.d_attrs == null) {
            return "<unavailable>";
        }
        AttrInfo attrInfo = this.d_attrs.get("Code");
        if (attrInfo == null) {
            return "<unavailable>";
        }
        CodeAttrInfo codeAttrInfo = (CodeAttrInfo)attrInfo;
        return "max_stack: " + codeAttrInfo.getMaxStack() + " max_locals: " + codeAttrInfo.getMaxLocals() + " #bytes " + (codeAttrInfo.getCode() == null ? 0 : codeAttrInfo.getCode().length);
    }

    public int getAccess() {
        return this.d_accessFlags;
    }

    public AttrInfoList getAttrs() {
        return this.d_attrs;
    }

    public String getName() {
        return this.d_cp.getAsString(this.d_idxName);
    }

    public String[] getParams() {
        int n;
        int n2;
        int n3;
        String string = this.d_cp.getAsString(this.d_idxDescriptor);
        String string2 = CPUtils.method2java(string);
        int n4 = string2.indexOf(" ");
        String string3 = n4 == -1 ? string2 : string2.substring(n4 + 1);
        Vector<String> vector = new Vector<String>();
        if (string3.charAt(0) != '(') {
            System.out.println("Bad parameter String");
        }
        if ((n3 = 1) == (n2 = string3.indexOf(")"))) {
            return new String[0];
        }
        while ((n = string3.indexOf(",", n3)) != -1) {
            vector.addElement(string3.substring(n3, n).trim());
            n3 = n + 1;
        }
        vector.addElement(string3.substring(n3, n2).trim());
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String getDesc() {
        return this.d_cp.getAsString(this.d_idxDescriptor);
    }

    public void setDesc(String string) {
        this.d_idxDescriptor = this.d_cp.find(1, string);
        if (this.d_idxDescriptor == -1) {
            this.d_idxDescriptor = this.d_cp.addUtf8(string);
        }
    }

    public String getReturnType() {
        String string = this.d_cp.getAsString(this.d_idxDescriptor);
        String string2 = CPUtils.method2java(string);
        int n = string2.indexOf(" ");
        String string3 = "";
        if (n == -1) {
            return "";
        }
        return string2.substring(0, n);
    }

    public void setAccess(int n) {
        this.d_accessFlags = n;
    }

    public void setAttrs(AttrInfoList attrInfoList) {
        this.d_attrs = attrInfoList;
    }

    public void setName(String string) {
        this.d_idxName = this.d_cp.find(1, string);
        if (this.d_idxName == -1) {
            this.d_idxName = this.d_cp.addUtf8(string);
        }
    }

    public void setParams(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("(");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(CPUtils.java2internal(stringArray[i]));
        }
        stringBuffer.append(")");
        String string = this.d_cp.getAsString(this.d_idxDescriptor);
        stringBuffer.append(string.substring(string.lastIndexOf(")") + 1));
        this.setDesc(stringBuffer.toString());
    }

    public void setReturnType(String string) {
        String string2 = this.d_cp.getAsString(this.d_idxDescriptor);
        String string3 = string2.substring(0, string2.lastIndexOf(")"));
        StringBuffer stringBuffer = new StringBuffer(string3);
        stringBuffer.append(CPUtils.java2internal(string));
        this.setDesc(stringBuffer.toString());
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (Access.isPublic(this.d_accessFlags)) {
            stringBuffer.append("public ");
        }
        if (Access.isPrivate(this.d_accessFlags)) {
            stringBuffer.append("private ");
        }
        if (Access.isProtected(this.d_accessFlags)) {
            stringBuffer.append("protected ");
        }
        if (Access.isFinal(this.d_accessFlags)) {
            stringBuffer.append("final ");
        }
        if (Access.isStatic(this.d_accessFlags)) {
            stringBuffer.append("static ");
        }
        if (Access.isVolatile(this.d_accessFlags)) {
            stringBuffer.append("volatile ");
        }
        if (Access.isTransient(this.d_accessFlags)) {
            stringBuffer.append("transient ");
        }
        if (Access.isSynchronized(this.d_accessFlags)) {
            stringBuffer.append("synchronized ");
        }
        if (Access.isNative(this.d_accessFlags)) {
            stringBuffer.append("native ");
        }
        if (Access.isAbstract(this.d_accessFlags)) {
            stringBuffer.append("abstract ");
        }
        String string2 = this.d_cp.getAsString(this.d_idxDescriptor);
        String string3 = CPUtils.method2java(string2);
        String string4 = "";
        int n = string3.indexOf(" ");
        if (n == -1) {
            string = string3;
        } else {
            string4 = string3.substring(0, n);
            string = string3.substring(n + 1);
        }
        stringBuffer.append(string4 + " " + this.d_cp.getAsString(this.d_idxName) + string + "\n" + this.d_attrs);
        return stringBuffer.toString();
    }
}

