/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ffdc.util.provider;

import com.ibm.ffdc.config.Formattable;
import com.ibm.ffdc.config.IncidentStream;
import com.ibm.ffdc.util.formatting.DateFormatProvider;
import com.ibm.ffdc.util.formatting.IncidentReportHeader;
import com.ibm.ffdc.util.provider.FfdcProvider;
import com.ibm.ffdc.util.provider.FfdcProviderDependent;
import com.ibm.ffdc.util.provider.Incident;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncidentLogger<T extends FfdcProvider>
extends FfdcProviderDependent<T> {
    public IncidentLogger(T provider) {
        super(provider);
    }

    protected String log(Incident incident, Object reporter, Throwable th, Object[] capturedDataElements) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void writeIncidentTo(IncidentStream is, Incident incident, Object reporter, Throwable th, List<Formattable> data) throws IOException {
        assert (data != null);
        this.writeHeader(is, incident, th, reporter);
        for (Formattable formattable : data) {
            formattable.formatTo(is);
        }
    }

    protected void writeHeader(IncidentStream is, Incident incident, Throwable th, Object reporter) throws IOException {
        IncidentReportHeader incidentReportHeader = new IncidentReportHeader(incident, th, reporter);
        is.write(incidentReportHeader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logIncidentSummary(OutputStream os2, List<Incident> incidents) {
        PrintStream ps = new PrintStream(os2);
        try {
            ps.println();
            ps.println(" Index  Count  Time of first Occurrence    Time of last Occurrence     Exception SourceId ProbeId");
            ps.println("------+------+---------------------------+---------------------------+---------------------------");
            int i = -1;
            for (Incident incident : incidents) {
                ps.println(this.formatIncidentEntry(incident, ++i));
            }
            ps.println("------+------+---------------------------+---------------------------+---------------------------");
        }
        finally {
            ps.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatIncidentEntry(Incident entry, int index) {
        int fill;
        int count;
        long timeStamp;
        Incident incident = entry;
        synchronized (incident) {
            timeStamp = entry.getTimeStamp();
            count = entry.getCount();
        }
        Date dateOfFirstOccurrence = entry.getDateOfFirstOccurrence();
        String exceptionName = entry.getExceptionName();
        String sourceId = entry.getSourceId();
        String probeId = entry.getProbeId();
        String label = entry.getLabel();
        DateFormat formatter = this.getDateFormatter();
        String dateString = "";
        String firstDateString = "";
        Date date = new Date(timeStamp);
        try {
            dateString = formatter.format(date);
            firstDateString = formatter.format(dateOfFirstOccurrence);
        }
        catch (Throwable th) {
            this.ffdcerror(th);
        }
        StringBuffer outputBuffer = new StringBuffer();
        String temp = String.valueOf(index);
        int length = 6 - temp.length();
        for (fill = 0; fill < length; ++fill) {
            outputBuffer.append(' ');
        }
        outputBuffer.append(temp);
        outputBuffer.append(' ');
        temp = String.valueOf(count);
        length = 6 - temp.length();
        for (fill = 0; fill < length; ++fill) {
            outputBuffer.append(' ');
        }
        outputBuffer.append(temp);
        outputBuffer.append(' ');
        temp = firstDateString;
        length = 27 - temp.length();
        for (fill = 0; fill < length; ++fill) {
            outputBuffer.append(' ');
        }
        outputBuffer.append(temp);
        outputBuffer.append(' ');
        temp = dateString;
        length = 27 - temp.length();
        for (fill = 0; fill < length; ++fill) {
            outputBuffer.append(' ');
        }
        outputBuffer.append(temp);
        outputBuffer.append(' ');
        outputBuffer.append(exceptionName);
        outputBuffer.append(' ');
        outputBuffer.append(sourceId);
        outputBuffer.append(' ');
        outputBuffer.append(probeId);
        if (label != null) {
            outputBuffer.append(' ');
            outputBuffer.append(label);
        }
        return outputBuffer.toString();
    }

    protected DateFormat getDateFormatter() {
        return DateFormatProvider.getDateFormat();
    }
}

