/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ffdc.util.provider;

import com.ibm.ffdc.config.Formattable;
import com.ibm.ffdc.util.bulkdata.CapacityException;
import com.ibm.ffdc.util.bulkdata.FixedCapacityOutputStream;
import com.ibm.ffdc.util.provider.FfdcProvider;
import com.ibm.ffdc.util.provider.Incident;
import com.ibm.ffdc.util.provider.IncidentEntry;
import com.ibm.ffdc.util.provider.IncidentLogger;
import com.ibm.ffdc.util.provider.IncidentStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FfdcOnPrintStreamProvider
extends FfdcProvider
implements com.ibm.ffdc.provider.FfdcProvider {
    private final PrintStream ps;
    private final String psName;
    private static final int MAXSUMMARYSIZE = 0x100000;
    private static final int MAXINCIDENTSIZE = 0x400000;
    private static final String thisClass = FfdcOnPrintStreamProvider.class.getName();
    private static Logger LOGGER;

    public FfdcOnPrintStreamProvider(PrintStream ps, String psName) {
        this.ps = ps;
        this.psName = psName;
    }

    @Override
    protected synchronized void logIncident(IncidentEntry incident, Object reporter, Throwable th, List<Formattable> data) {
        FixedCapacityOutputStream os2 = new FixedCapacityOutputStream();
        IncidentLogger<FfdcOnPrintStreamProvider> incidentLogger = new IncidentLogger<FfdcOnPrintStreamProvider>(this);
        this.logIncident(incidentLogger, os2, incident, reporter, th, data);
        this.logSummary(incidentLogger, os2, this.getIncidents());
    }

    protected void logIncident(IncidentLogger<FfdcOnPrintStreamProvider> incidentLogger, FixedCapacityOutputStream os2, IncidentEntry incident, Object reporter, Throwable th, List<Formattable> data) {
        boolean isTruncated;
        os2.reset(this.getMaxIncidentSize());
        try {
            IncidentStream<FfdcOnPrintStreamProvider> is = new IncidentStream<FfdcOnPrintStreamProvider>(this, os2);
            incidentLogger.writeIncidentTo(is, incident, reporter, th, data);
            is.release();
            isTruncated = false;
        }
        catch (CapacityException cex) {
            isTruncated = true;
        }
        catch (IOException e) {
            this.abort(e);
            return;
        }
        this.ps.flush();
        try {
            os2.writeTo(this.ps);
        }
        catch (IOException e) {
            this.abort(e);
            return;
        }
        if (isTruncated) {
            this.ps.println("FFDC report truncated");
        }
        LOGGER.logp(Level.INFO, FfdcOnPrintStreamProvider.class.getName(), "logIncident", "FFDCIncidentEmitted", new Object[]{this.psName, incident.getSourceId(), incident.getProbeId()});
    }

    protected void logSummary(IncidentLogger<FfdcOnPrintStreamProvider> incidentLogger, FixedCapacityOutputStream os2, List<Incident> incidents) {
        boolean isTruncated;
        os2.reset(this.getmaxSummarySize());
        try {
            incidentLogger.logIncidentSummary(os2, incidents);
            isTruncated = false;
        }
        catch (CapacityException cex) {
            isTruncated = true;
        }
        this.ps.flush();
        try {
            os2.writeTo(this.ps);
        }
        catch (IOException e) {
            this.abort(e);
            return;
        }
        if (isTruncated) {
            this.ps.println("FFDC summary report truncated");
        }
    }

    protected int getMaxIncidentSize() {
        return 0x400000;
    }

    protected int getmaxSummarySize() {
        return 0x400000;
    }

    static {
        try {
            LOGGER = Logger.getLogger(thisClass, "com.ibm.ffdc.FFDCBundleMessages");
        }
        catch (Throwable t) {
            LOGGER = Logger.getLogger(thisClass);
        }
    }
}

