/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.command;

import com.ibm.etools.common.command.AbstractCommand;
import com.ibm.etools.common.command.Command;
import com.ibm.etools.common.command.CompoundCommand;
import java.util.List;
import java.util.ListIterator;

public class StrictCompoundCommand
extends CompoundCommand {
    protected boolean isUndoable;
    protected boolean isPessimistic;
    protected int rightMostExecutedCommandIndex = -1;

    public StrictCompoundCommand() {
        this.resultIndex = Integer.MIN_VALUE;
    }

    public StrictCompoundCommand(String label) {
        super(label);
        this.resultIndex = Integer.MIN_VALUE;
    }

    public StrictCompoundCommand(String label, String description) {
        super(label, description);
        this.resultIndex = Integer.MIN_VALUE;
    }

    public StrictCompoundCommand(String label, String description, List commandList) {
        super(label, description, commandList);
        this.resultIndex = Integer.MIN_VALUE;
    }

    public StrictCompoundCommand(String label, List commandList) {
        super(label, commandList);
        this.resultIndex = Integer.MIN_VALUE;
    }

    public StrictCompoundCommand(List commandList) {
        super(commandList);
        this.resultIndex = Integer.MIN_VALUE;
    }

    public boolean appendAndExecute(Command command) {
        if (command != null) {
            block8: {
                if (!this.isPrepared) {
                    if (this.commandList.isEmpty()) {
                        this.isPrepared = true;
                        this.isExecutable = true;
                    } else {
                        this.isExecutable = this.prepare();
                        this.isPrepared = true;
                        this.isPessimistic = true;
                        if (this.isExecutable) {
                            this.execute();
                        }
                    }
                }
                if (command.canExecute()) {
                    try {
                        command.execute();
                        this.commandList.add(command);
                        ++this.rightMostExecutedCommandIndex;
                        this.isUndoable = command.canUndo();
                        return true;
                    }
                    catch (RuntimeException exception) {
                        if (!AbstractCommand.Trace.isEnabled) break block8;
                        AbstractCommand.Trace.out.println("! Exception is NOT rethrown.", true);
                        exception.printStackTrace(AbstractCommand.Trace.out);
                        AbstractCommand.Trace.out.println("! Unrolling commands due to exception.", true);
                    }
                }
            }
            command.dispose();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (AbstractCommand.Trace.isEnabled) {
            AbstractCommand.Trace.out.enter("StrictCompoundCommand.execute", this);
        }
        if (this.isPessimistic) {
            ListIterator commands = this.commandList.listIterator();
            while (commands.hasNext()) {
                try {
                    Command command = (Command)commands.next();
                    if (commands.previousIndex() <= this.rightMostExecutedCommandIndex) {
                        command.redo();
                        continue;
                    }
                    command.execute();
                }
                catch (RuntimeException exception) {
                    if (AbstractCommand.Trace.isEnabled) {
                        AbstractCommand.Trace.out.println("! Unrolling commands due to exception.", true);
                        exception.printStackTrace(AbstractCommand.Trace.out);
                    }
                    commands.previous();
                    while (commands.hasPrevious()) {
                        commands.previous();
                        Command command = (Command)commands.previous();
                        if (!command.canUndo()) break;
                        command.undo();
                    }
                    if (AbstractCommand.Trace.isEnabled) {
                        AbstractCommand.Trace.out.leave("Rethrowing...", true);
                    }
                    throw exception;
                }
            }
            if (AbstractCommand.Trace.isEnabled) {
                AbstractCommand.Trace.out.leave();
            }
        } else if (!this.commandList.isEmpty()) {
            Command command = (Command)this.commandList.get(this.commandList.size() - 1);
            try {
                command.execute();
            }
            finally {
                if (AbstractCommand.Trace.isEnabled) {
                    AbstractCommand.Trace.out.leave();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean prepare() {
        Command command;
        boolean result;
        ListIterator commands;
        block15: {
            if (AbstractCommand.Trace.isEnabled) {
                AbstractCommand.Trace.out.enter("StrictCompoundCommand.prepare", this);
            }
            if ((commands = this.commandList.listIterator()).hasNext()) {
                result = true;
            } else {
                this.isUndoable = false;
                if (AbstractCommand.Trace.isEnabled) {
                    AbstractCommand.Trace.out.leave("false *** This used to return true when the command list is empty.", true);
                }
                return false;
            }
            while ((command = (Command)commands.next()).canExecute()) {
                if (commands.hasNext()) {
                    if (command.canUndo()) {
                        try {
                            if (commands.previousIndex() <= this.rightMostExecutedCommandIndex) {
                                command.redo();
                                continue;
                            }
                            ++this.rightMostExecutedCommandIndex;
                            command.execute();
                            continue;
                        }
                        catch (RuntimeException exception) {
                            if (AbstractCommand.Trace.isEnabled) {
                                AbstractCommand.Trace.out.println("! Exception is NOT rethrown.", true);
                                exception.printStackTrace(AbstractCommand.Trace.out);
                                AbstractCommand.Trace.out.println("! Unrolling commands due to exception.", true);
                            }
                            result = false;
                            break block15;
                        }
                    }
                    result = false;
                    if (AbstractCommand.Trace.isEnabled) {
                        AbstractCommand.Trace.out.println("! Giving up because the command can't be undone.", true);
                    }
                    break block15;
                }
                this.isUndoable = command.canUndo();
                break block15;
            }
            result = false;
        }
        if (this.isPessimistic) {
            commands.previous();
            while (commands.hasPrevious()) {
                command = (Command)commands.previous();
                command.undo();
            }
        }
        if (AbstractCommand.Trace.isEnabled) {
            AbstractCommand.Trace.out.leave(result, !result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        if (this.isPessimistic) {
            super.redo();
        } else if (!this.commandList.isEmpty()) {
            if (AbstractCommand.Trace.isEnabled) {
                AbstractCommand.Trace.out.enter("StrictCompoundCommand.redo", this);
            }
            Command command = (Command)this.commandList.get(this.commandList.size() - 1);
            try {
                command.redo();
            }
            finally {
                if (AbstractCommand.Trace.isEnabled) {
                    AbstractCommand.Trace.out.leave();
                }
            }
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (isUndoable: " + this.isUndoable + ")");
        result.append(" (isPessimistic: " + this.isPessimistic + ")");
        result.append(" (rightMostExecutedCommandIndex: " + this.rightMostExecutedCommandIndex + ")");
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        if (this.isPessimistic) {
            super.undo();
        } else if (!this.commandList.isEmpty()) {
            if (AbstractCommand.Trace.isEnabled) {
                AbstractCommand.Trace.out.enter("StrictCompoundCommand.undo", this);
            }
            Command command = (Command)this.commandList.get(this.commandList.size() - 1);
            try {
                command.undo();
            }
            finally {
                if (AbstractCommand.Trace.isEnabled) {
                    AbstractCommand.Trace.out.leave();
                }
            }
        }
    }
}

