/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasEvent;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.ras.Traceable;
import com.ibm.ejs.ras.Untraceable;
import com.ibm.websphere.ras.RasMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;
import java.util.Locale;

public class MessageEvent
extends RasEvent
implements RasMessage {
    private static final long serialVersionUID = 4537833367680944037L;
    private static final int svClassVersion = 2;
    private static int svMaxStringSize = 1000;
    private int ivClassVersion = 2;
    String ivBundleName;
    private Object[] ivMsgParms;
    private transient String tivFormattedMessage = null;

    public MessageEvent(int type, TraceComponent tc, String msgKey, String msgFile, Object msgParms, String organization, String product2, String component2, String className, String methodName, String extendedMessage) {
        super(type, tc, className, methodName, msgKey, organization, product2, component2, extendedMessage, true);
        this.ivBundleName = msgFile;
        this.convertParameters(msgParms);
        if (this.ivBundleName == null) {
            if (this.ivMsgParms != null) {
                StringBuffer sb = new StringBuffer(this.ivMsgKey);
                int length = this.ivMsgParms.length;
                for (int i = 0; i < length; ++i) {
                    sb.append(" ");
                    sb.append(this.ivMsgParms[i].toString());
                }
                this.ivMsgKey = new String(sb);
            }
            this.tivFormattedMessage = this.ivMsgKey;
        } else {
            this.tivFormattedMessage = this.getLocalizedMessage(Locale.getDefault());
        }
    }

    MessageEvent(int type, TraceComponent tc, String methodName, String msgKey, Object msgParms) {
        super(type, tc, null, methodName, msgKey, "IBM", "WebSphere", "Application Server", null, false);
        this.ivBundleName = tc.getResourceBundleName();
        this.convertParameters(msgParms);
        this.tivFormattedMessage = this.getLocalizedMessage(Locale.getDefault());
    }

    MessageEvent() {
    }

    public String getMessageSeverity() {
        switch (this.ivType) {
            case 1: {
                return "Audit";
            }
            case 4: {
                return "Error";
            }
            case 8: {
                return "Fatal";
            }
            case 9: {
                return "Service";
            }
            case 10: {
                return "Warning";
            }
            case 11: {
                return "Informational";
            }
        }
        return "Unknown";
    }

    public String getMessageKey() {
        return this.ivMsgKey;
    }

    public String getResourceBundleName() {
        return this.ivBundleName;
    }

    public String getMessageOriginator() {
        return this.ivEventSource;
    }

    public String getLocalizedMessage(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.ivBundleName == null) {
            return this.ivMsgKey;
        }
        String key = this.ivMsgKey.replace(' ', '.');
        if (this.ivMsgParms == null) {
            return TraceNLS.getStringFromBundle(this.ivBundleName, key, locale, this.ivMsgKey);
        }
        return TraceNLS.getFormattedMessage(this.ivBundleName, key, locale, this.ivMsgParms, this.ivMsgKey);
    }

    public String formatBasic(StringBuffer buffer, DateFormat formatter, Date date, FieldPosition fPos) {
        this.formatHeaderBasic(buffer, formatter, date, fPos);
        buffer.append(this.tivFormattedMessage);
        if (this.ivExtendedMessage != null) {
            buffer.append(lineSeparator);
            buffer.append(svBasicPadding);
            buffer.append(this.ivExtendedMessage);
        }
        return new String(buffer);
    }

    public String formatAdvanced(StringBuffer buffer, DateFormat formatter, Date date, FieldPosition fPos) {
        this.formatHeaderAdvanced(buffer, formatter, date, fPos);
        buffer.append(lineSeparator);
        buffer.append(svAdvancedPadding);
        buffer.append(this.tivFormattedMessage);
        if (this.ivExtendedMessage != null) {
            buffer.append(lineSeparator);
            buffer.append(svAdvancedPadding);
            buffer.append(this.ivExtendedMessage);
        }
        return new String(buffer);
    }

    final Object[] getMessageInserts() {
        return this.ivMsgParms;
    }

    private void convertParameters(Object msgParms) {
        if (msgParms == null) {
            this.ivMsgParms = null;
            return;
        }
        Object[] objs = null;
        Class<?> objectClass = msgParms.getClass();
        objs = objectClass.isArray() ? (Object.class.isAssignableFrom(objectClass.getComponentType()) ? (Object[])msgParms : RasHelper.primitiveArrayToString(msgParms)) : new Object[]{msgParms};
        int numObjs = objs.length;
        this.ivMsgParms = new Object[numObjs];
        String param = null;
        for (int i = numObjs - 1; i >= 0; --i) {
            if (objs[i] == null) {
                this.ivMsgParms[i] = "<null>";
                continue;
            }
            if (objs[i] instanceof String) {
                this.ivMsgParms[i] = objs[i];
                continue;
            }
            if (objs[i] instanceof Number || objs[i] instanceof Date) {
                this.ivMsgParms[i] = objs[i];
                continue;
            }
            try {
                param = objs[i] instanceof Untraceable ? objs[i].getClass().getName() : (objs[i] instanceof Traceable ? ((Traceable)objs[i]).toTraceString() : (objs[i] instanceof Throwable ? RasHelper.throwableToString((Throwable)objs[i]) : objs[i].toString()));
                if (param == null) {
                    param = "<malformed parameter>";
                }
                this.ivMsgParms[i] = param;
                continue;
            }
            catch (Throwable t) {
                this.ivMsgParms[i] = "<malformed parameter>";
            }
        }
    }

    void writeToStream(DataOutputStream dos) throws IOException {
        dos.writeInt(this.ivClassVersion);
        if (this.ivOrganization == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivOrganization);
        }
        if (this.ivProduct == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivProduct);
        }
        if (this.ivComponent == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivComponent);
        }
        dos.writeUTF(this.ivVersion);
        if (this.ivEventSource == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivEventSource);
        }
        if (this.ivMethodName == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivMethodName);
        }
        dos.writeUTF(this.ivThreadId);
        if (this.ivProcessId == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivProcessId);
        }
        dos.writeUTF(this.ivServerName);
        if (this.ivMsgKey == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivMsgKey);
        }
        if (this.ivBundleName == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivBundleName);
        }
        if (this.ivExtendedMessage == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivExtendedMessage);
        }
        if (this.ivUnitOfWork == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivUnitOfWork);
        }
        dos.writeLong(this.ivTimeStamp);
        dos.writeInt(this.ivType);
        if (this.ivMsgParms == null) {
            dos.writeInt(0);
        } else {
            int numberOfParms = this.ivMsgParms.length;
            dos.writeInt(numberOfParms);
            for (int i = 0; i < numberOfParms; ++i) {
                dos.writeUTF(this.ivMsgParms[i].toString());
            }
        }
        if (this.ivRawData == null) {
            dos.writeInt(0);
        } else {
            int rawDataLength = this.ivRawData.length;
            dos.writeInt(rawDataLength);
            dos.write(this.ivRawData, 0, rawDataLength);
        }
        if (this.ivClassName == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivClassName);
        }
    }

    void readFromStream(DataInputStream dis) throws IOException {
        this.ivClassVersion = dis.readInt();
        this.ivOrganization = dis.readUTF();
        this.ivProduct = dis.readUTF();
        this.ivComponent = dis.readUTF();
        this.ivVersion = dis.readUTF();
        this.ivEventSource = dis.readUTF();
        this.ivMethodName = dis.readUTF();
        this.ivThreadId = dis.readUTF();
        this.ivProcessId = dis.readUTF();
        this.ivServerName = dis.readUTF();
        this.ivMsgKey = dis.readUTF();
        this.ivBundleName = dis.readUTF();
        this.ivExtendedMessage = dis.readUTF();
        this.ivUnitOfWork = dis.readUTF();
        this.ivTimeStamp = dis.readLong();
        this.ivType = dis.readInt();
        int numberOfParms = dis.readInt();
        if (numberOfParms == 0) {
            this.ivMsgParms = null;
        } else {
            this.ivMsgParms = new Object[numberOfParms];
            for (int i = 0; i < numberOfParms; ++i) {
                String parm = dis.readUTF();
                this.ivMsgParms[i] = parm;
            }
        }
        int rawDataLength = dis.readInt();
        if (rawDataLength == 0) {
            this.ivRawData = null;
        } else {
            this.ivRawData = new byte[rawDataLength];
            dis.read(this.ivRawData, 0, rawDataLength);
        }
        if (this.ivClassVersion == 2) {
            this.ivClassName = dis.readUTF();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.ivMsgParms != null) {
            int size = this.ivMsgParms.length;
            for (int i = 0; i < size; ++i) {
                String s;
                if (!(this.ivMsgParms[i] instanceof String) || (s = (String)this.ivMsgParms[i]).length() <= svMaxStringSize) continue;
                s = s.substring(0, svMaxStringSize - 1) + "  -- <truncated> --";
                this.ivMsgParms[i] = s;
            }
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    static {
        try {
            String x = RasHelper.getSystemProperty("com.ibm.ws.ras.MessageElementSize");
            if (x == null) {
                svMaxStringSize = 1000;
            } else {
                svMaxStringSize = Integer.parseInt(x);
                if (svMaxStringSize < 100) {
                    svMaxStringSize = 100;
                }
            }
        }
        catch (Throwable t) {
            svMaxStringSize = 1000;
        }
    }
}

