/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceLogger;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.logging.LevelConstants;
import com.ibm.ws.logging.TraceLogFormatter;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;

class ExtendedTraceLogger
extends TraceLogger {
    private static final String svSpace = " ";
    private static final String svEquals = "=";
    private static final String svEqualsQuote = "=\"";
    private static final String svQuote = "\"";
    private static final String svQuoteSpace = "\" ";
    private static final String svXmlStart = "<";
    private static final String svXmlEnd = "/>";
    private static final String emptyString = "";
    private static final String svBundle = "com.ibm.ejs.resources.RasMessages";
    private String manufacturerLabel;
    private String productLabel;
    private String versionLabel;
    private String compIDLabel;
    private String processIDLabel;
    private String threadIDLabel;
    private String threadNameLabel;
    private String sourceIDLabel;
    private String classNameLabel;
    private String methodNameLabel;
    private String serverNameLabel;
    private String timeStampLabel;
    private String uowLabel;
    private String severityLabel;
    private String categoryLabel;
    private String primMessageLabel;
    private String extMessageLabel;
    private NumberFormat numberFormat;
    private Date ivDate = new Date();
    protected FieldPosition ivFieldPos = new FieldPosition(0);
    private SimpleDateFormat ivFormatter;
    private int paddingCounter = 0;
    private long previousTimestamp = -1L;
    private String ivLineSep;
    private StringBuffer ivTimeBuffer = new StringBuffer();
    private StringBuffer ivNormalizeBuffer = new StringBuffer();
    ByteArrayOutputStream ivBaos = null;
    PrintStream ivPs = null;
    private boolean ivOutputXML = false;
    private Locale ivLocale;

    ExtendedTraceLogger(OutputStream stream) {
        this(stream, false, Locale.getDefault());
    }

    ExtendedTraceLogger(OutputStream stream, boolean xml, Locale locale) {
        super(stream);
        this.constructorHelper(stream, xml, locale);
        this.ivBaos = new ByteArrayOutputStream();
        this.ivPs = new PrintStream(this.ivBaos);
    }

    ExtendedTraceLogger(OutputStream stream, boolean xml, Locale locale, String charEncoding) throws UnsupportedEncodingException {
        super(stream, charEncoding);
        this.constructorHelper(stream, xml, locale);
        this.ivBaos = new ByteArrayOutputStream();
        this.ivPs = new PrintStream((OutputStream)this.ivBaos, false, charEncoding);
        this.ivCharEncoding = charEncoding;
    }

    private void constructorHelper(OutputStream stream, boolean xml, Locale locale) {
        this.ivOutputXML = xml;
        this.ivLocale = locale;
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setMaximumIntegerDigits(6);
        this.numberFormat.setMinimumIntegerDigits(6);
        this.ivFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.ivLineSep = RasHelper.getSystemProperty("line.separator");
        if (this.ivOutputXML) {
            this.manufacturerLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_MANUFAC", this.ivLocale, "Manufacturer");
            this.productLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PRODUCT", this.ivLocale, "Product");
            this.versionLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_VERSION", this.ivLocale, "Version");
            this.compIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_COMPID", this.ivLocale, "ComponentId");
            this.processIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PROCESSID", this.ivLocale, "ProcessId");
            this.threadIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_THREADID", this.ivLocale, "ThreadId");
            this.threadNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_THREADNAME", this.ivLocale, "ThreadName");
            this.sourceIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SOURCEID", this.ivLocale, "SourceId");
            this.classNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_CLASSNAME", this.ivLocale, "ClassName");
            this.methodNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_METHODNAME", this.ivLocale, "MethodName");
            this.serverNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SERVNAME", this.ivLocale, "ServerName");
            this.timeStampLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_TIMESTMP", this.ivLocale, "TimeStamp");
            this.uowLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_UOW", this.ivLocale, "UnitOfWork");
            this.severityLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SEVERITY", this.ivLocale, "Severity");
            this.categoryLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_CATEGORY", this.ivLocale, "Category");
            this.primMessageLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PRIMMSG", this.ivLocale, "PrimaryMessage");
            this.extMessageLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_EXTMSG", this.ivLocale, "ExtendedMessage");
        } else {
            this.manufacturerLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_MANUFAC", this.ivLocale, "Manufacturer") + ":\t ";
            this.productLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PRODUCT", this.ivLocale, "Product") + ":\t ";
            this.versionLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_VERSION", this.ivLocale, "Version") + ":\t ";
            this.compIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_COMPID", this.ivLocale, "ComponentId") + ":\t ";
            this.processIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PROCESSID", this.ivLocale, "ProcessId") + ":\t ";
            this.threadIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_THREADID", this.ivLocale, "ThreadId") + ":\t ";
            this.threadNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_THREADNAME", this.ivLocale, "ThreadName") + ":\t ";
            this.sourceIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SOURCEID", this.ivLocale, "SourceId") + ":\t ";
            this.classNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_CLASSNAME", this.ivLocale, "ClassName") + ":\t ";
            this.methodNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_METHODNAME", this.ivLocale, "MethodName") + ":\t ";
            this.serverNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SERVNAME", this.ivLocale, "ServerName") + ":\t ";
            this.timeStampLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_TIMESTMP", this.ivLocale, "TimeStamp") + ":\t ";
            this.uowLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_UOW", this.ivLocale, "UnitOfWork") + ":\t ";
            this.severityLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SEVERITY", this.ivLocale, "Severity") + ":\t ";
            this.categoryLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_CATEGORY", this.ivLocale, "Category") + ":\t ";
            this.primMessageLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PRIMMSG", this.ivLocale, "PrimaryMessage") + ":\t ";
            this.extMessageLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_EXTMSG", this.ivLocale, "ExtendedMessage") + ": ";
        }
    }

    void printHeader() {
        String c;
        String a = this.ivLocale.getLanguage();
        String b = this.ivLocale.getCountry();
        String string = c = this.ivCharEncoding == null ? RasHelper.getSystemProperty("file.encoding") : this.ivCharEncoding;
        if (this.ivOutputXML) {
            this.ivOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.ivOut.println("<WASActivityLogFile>");
            this.ivOut.println("<encoding language=\"" + a + "_" + b + svQuoteSpace + "codeset=\"" + c + svQuote + svXmlEnd);
        } else {
            this.ivOut.println("$LANG = " + a + "_" + b);
            this.ivOut.println("$CODESET = " + c);
        }
    }

    synchronized void printFooter(int numberOfMessages) {
        String number = Integer.toString(numberOfMessages);
        if (this.ivOutputXML) {
            this.ivOut.println("<total records=\"" + number + svQuote + svXmlEnd);
            this.ivOut.println("</WASActivityLogFile>");
        } else {
            this.ivOut.println(TraceNLS.getFormattedMessage(svBundle, "SHOWLOG_MSG006", this.ivLocale, new Object[]{number}, "{0} records found and printed."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doLog(LogRecord event2) {
        if (event2 == null) {
            return;
        }
        String primaryMessage = TraceLogFormatter.formatMessage(event2, this.ivLocale, 1);
        ExtendedTraceLogger extendedTraceLogger = this;
        synchronized (extendedTraceLogger) {
            this.ivBaos.reset();
            if (this.ivOutputXML) {
                this.ivPs.println(this.formatMessageInXML(primaryMessage, event2));
            } else {
                this.ivPs.println(this.formatEntryHeader(event2));
                this.ivPs.println(this.primMessageLabel + primaryMessage);
                this.ivPs.println(this.formatEntryTrailer(event2));
            }
            this.ivPs.flush();
            try {
                this.ivOs.write(this.ivBaos.toByteArray());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    synchronized void logSystemStream(LogRecord event2) {
    }

    private String formatEntryHeader(LogRecord event2) {
        long curTime;
        WsLogRecord wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(event2);
        String methodName = emptyString;
        String unitOfWork = emptyString;
        String eventSource = emptyString;
        String datePadding = "000000";
        String component2 = emptyString;
        String organization = emptyString;
        String product2 = emptyString;
        String version = emptyString;
        String serverName = emptyString;
        String processId = emptyString;
        String threadName = emptyString;
        String className = emptyString;
        String sTemp = event2.getSourceClassName();
        if (sTemp != null) {
            className = sTemp;
        }
        if ((sTemp = event2.getSourceMethodName()) != null) {
            methodName = sTemp;
        }
        if ((sTemp = event2.getLoggerName()) != null) {
            eventSource = sTemp;
        }
        if (wsLogRecord != null) {
            sTemp = wsLogRecord.getCorrelationId();
            if (sTemp != null) {
                unitOfWork = sTemp;
            }
            if ((sTemp = wsLogRecord.getComponent()) != null) {
                component2 = sTemp;
            }
            if ((sTemp = wsLogRecord.getOrganization()) != null) {
                organization = sTemp;
            }
            if ((sTemp = wsLogRecord.getProduct()) != null) {
                product2 = sTemp;
            }
            if ((sTemp = wsLogRecord.getVersion()) != null) {
                version = sTemp;
            }
            if ((sTemp = wsLogRecord.getProcessName()) != null) {
                serverName = sTemp;
            }
            if ((sTemp = wsLogRecord.getProcessId()) != null) {
                processId = sTemp;
            }
            if ((sTemp = wsLogRecord.getReporterOrSourceThreadName()) != null) {
                threadName = sTemp;
            }
        }
        if ((curTime = event2.getMillis()) == this.previousTimestamp) {
            ++this.paddingCounter;
            datePadding = this.numberFormat.format(this.paddingCounter);
        } else {
            this.previousTimestamp = curTime;
            this.paddingCounter = 0;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("---------------------------------------------------------------");
        buffer.append(this.ivLineSep);
        buffer.append(this.compIDLabel);
        buffer.append(component2);
        buffer.append(this.ivLineSep);
        buffer.append(this.processIDLabel);
        buffer.append(processId);
        buffer.append(this.ivLineSep);
        buffer.append(this.threadIDLabel);
        buffer.append(RasHelper.getThreadId(event2));
        buffer.append(this.ivLineSep);
        buffer.append(this.threadNameLabel);
        buffer.append(threadName);
        buffer.append(this.ivLineSep);
        buffer.append(this.sourceIDLabel);
        buffer.append(eventSource);
        buffer.append(this.ivLineSep);
        buffer.append(this.classNameLabel);
        buffer.append(className);
        buffer.append(this.ivLineSep);
        buffer.append(this.methodNameLabel);
        buffer.append(methodName);
        buffer.append(this.ivLineSep);
        buffer.append(this.manufacturerLabel);
        buffer.append(organization);
        buffer.append(this.ivLineSep);
        buffer.append(this.productLabel);
        buffer.append(product2);
        buffer.append(this.ivLineSep);
        buffer.append(this.versionLabel);
        buffer.append(version);
        buffer.append(this.ivLineSep);
        buffer.append(this.serverNameLabel);
        buffer.append(serverName);
        buffer.append(this.ivLineSep);
        this.ivDate.setTime(curTime);
        this.ivTimeBuffer.setLength(0);
        this.ivTimeBuffer = this.ivFormatter.format(this.ivDate, this.ivTimeBuffer, this.ivFieldPos);
        buffer.append(this.timeStampLabel);
        buffer.append(this.ivTimeBuffer.toString() + datePadding);
        buffer.append(this.ivLineSep);
        buffer.append(this.uowLabel);
        buffer.append(unitOfWork);
        buffer.append(this.ivLineSep);
        buffer.append(this.severityLabel);
        buffer.append(ExtendedTraceLogger.getSeverity(event2.getLevel()));
        buffer.append(this.ivLineSep);
        buffer.append(this.categoryLabel);
        buffer.append(event2.getLevel().getName());
        return buffer.toString();
    }

    private String formatEntryTrailer(LogRecord event2) {
        String sTemp;
        WsLogRecord wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(event2);
        String extendedMessage = emptyString;
        if (wsLogRecord != null && (sTemp = wsLogRecord.getStackTrace()) != null) {
            extendedMessage = sTemp;
        }
        return this.extMessageLabel + extendedMessage;
    }

    private String formatMessageInXML(String primaryMessage, LogRecord event2) {
        long curTime;
        WsLogRecord wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(event2);
        String methodName = emptyString;
        String unitOfWork = emptyString;
        String eventSource = emptyString;
        String datePadding = "000000";
        String component2 = emptyString;
        String organization = emptyString;
        String product2 = emptyString;
        String version = emptyString;
        String serverName = emptyString;
        String processId = emptyString;
        String className = emptyString;
        String extendedMessage = emptyString;
        String threadName = emptyString;
        primaryMessage = this.normalize(primaryMessage);
        String sTemp = event2.getSourceClassName();
        if (sTemp != null) {
            className = this.normalize(sTemp);
        }
        if ((sTemp = event2.getSourceMethodName()) != null) {
            methodName = this.normalize(sTemp);
        }
        if ((sTemp = event2.getLoggerName()) != null) {
            eventSource = this.normalize(sTemp);
        }
        if (wsLogRecord != null) {
            sTemp = wsLogRecord.getCorrelationId();
            if (sTemp != null) {
                unitOfWork = this.normalize(sTemp);
            }
            if ((sTemp = wsLogRecord.getComponent()) != null) {
                component2 = this.normalize(sTemp);
            }
            if ((sTemp = wsLogRecord.getOrganization()) != null) {
                organization = this.normalize(sTemp);
            }
            if ((sTemp = wsLogRecord.getProduct()) != null) {
                product2 = this.normalize(sTemp);
            }
            if ((sTemp = wsLogRecord.getVersion()) != null) {
                version = this.normalize(sTemp);
            }
            if ((sTemp = wsLogRecord.getProcessName()) != null) {
                serverName = this.normalize(sTemp);
            }
            if ((sTemp = wsLogRecord.getProcessId()) != null) {
                processId = this.normalize(sTemp);
            }
            if ((sTemp = wsLogRecord.getStackTrace()) != null) {
                extendedMessage = this.normalize(sTemp);
            }
            if ((sTemp = wsLogRecord.getReporterOrSourceThreadName()) != null) {
                threadName = this.normalize(sTemp);
            }
        }
        if ((curTime = event2.getMillis()) == this.previousTimestamp) {
            ++this.paddingCounter;
            datePadding = this.numberFormat.format(this.paddingCounter);
        } else {
            this.previousTimestamp = curTime;
            this.paddingCounter = 0;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<WASActivityLogEntry");
        buffer.append(svSpace);
        buffer.append(this.compIDLabel);
        buffer.append(svEqualsQuote);
        buffer.append(component2);
        buffer.append(svQuoteSpace);
        buffer.append(this.processIDLabel);
        buffer.append(svEqualsQuote);
        buffer.append(processId);
        buffer.append(svQuoteSpace);
        buffer.append(this.threadIDLabel);
        buffer.append(svEqualsQuote);
        buffer.append(RasHelper.getThreadId(event2));
        buffer.append(svQuoteSpace);
        buffer.append(this.threadNameLabel);
        buffer.append(svEqualsQuote);
        buffer.append(threadName);
        buffer.append(svQuoteSpace);
        buffer.append(this.sourceIDLabel);
        buffer.append(svEqualsQuote);
        buffer.append(eventSource);
        buffer.append(svQuoteSpace);
        buffer.append(this.classNameLabel);
        buffer.append(svEqualsQuote);
        buffer.append(className);
        buffer.append(svQuoteSpace);
        buffer.append(this.methodNameLabel);
        buffer.append(svEqualsQuote);
        buffer.append(methodName);
        buffer.append(svQuoteSpace);
        buffer.append(this.manufacturerLabel);
        buffer.append(svEqualsQuote);
        buffer.append(organization);
        buffer.append(svQuoteSpace);
        buffer.append(this.productLabel);
        buffer.append(svEqualsQuote);
        buffer.append(product2);
        buffer.append(svQuoteSpace);
        buffer.append(this.versionLabel);
        buffer.append(svEqualsQuote);
        buffer.append(version);
        buffer.append(svQuoteSpace);
        buffer.append(this.serverNameLabel);
        buffer.append(svEqualsQuote);
        buffer.append(serverName);
        buffer.append(svQuoteSpace);
        this.ivDate.setTime(curTime);
        this.ivTimeBuffer.setLength(0);
        this.ivTimeBuffer = this.ivFormatter.format(this.ivDate, this.ivTimeBuffer, this.ivFieldPos);
        buffer.append(this.timeStampLabel);
        buffer.append(svEqualsQuote);
        buffer.append(this.ivTimeBuffer.toString() + datePadding);
        buffer.append(svQuoteSpace);
        buffer.append(this.uowLabel);
        buffer.append(svEqualsQuote);
        buffer.append(unitOfWork);
        buffer.append(svQuoteSpace);
        buffer.append(this.severityLabel);
        buffer.append(svEqualsQuote);
        buffer.append(ExtendedTraceLogger.getSeverity(event2.getLevel()));
        buffer.append(svQuoteSpace);
        buffer.append(this.categoryLabel);
        buffer.append(svEqualsQuote);
        buffer.append(event2.getLevel().getName());
        buffer.append(svQuoteSpace);
        buffer.append(this.primMessageLabel);
        buffer.append(svEqualsQuote);
        buffer.append(primaryMessage);
        buffer.append(svQuoteSpace);
        buffer.append(this.extMessageLabel);
        buffer.append(svEqualsQuote);
        buffer.append(extendedMessage);
        buffer.append(svQuote);
        buffer.append(svXmlEnd);
        return buffer.toString();
    }

    private String normalize(String string) {
        if (string == null) {
            return null;
        }
        int length = string.length();
        this.ivNormalizeBuffer.setLength(0);
        for (int counter = 0; counter < length; ++counter) {
            char character = string.charAt(counter);
            if (character == '<') {
                this.ivNormalizeBuffer.append("&lt;");
                continue;
            }
            if (character == '>') {
                this.ivNormalizeBuffer.append("&gt;");
                continue;
            }
            if (character == '&') {
                this.ivNormalizeBuffer.append("&amp;");
                continue;
            }
            if (character == '\"') {
                this.ivNormalizeBuffer.append("&quot;");
                continue;
            }
            if (character == '\'') {
                this.ivNormalizeBuffer.append("&apos;");
                continue;
            }
            if (character == '\t') {
                this.ivNormalizeBuffer.append("&#x9;");
                continue;
            }
            if (character == '\n') {
                this.ivNormalizeBuffer.append("&#xA;");
                continue;
            }
            if (character == '\r') {
                this.ivNormalizeBuffer.append("&#xD;");
                continue;
            }
            this.ivNormalizeBuffer.append(character);
        }
        return this.ivNormalizeBuffer.toString();
    }

    private static int getSeverity(Level level) {
        int levelInt = level.intValue();
        int severity = levelInt >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[13]] ? 1 : (levelInt >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[12]] ? 2 : 3);
        return severity;
    }
}

