/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.TraceLogger;
import com.ibm.ws.logging.TraceLogFormatter;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.logging.LogRecord;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class CBETraceLogger
extends TraceLogger {
    private static String svHeaderString = "<CommonBaseEvents xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"commonbaseevent1_0.xsd\">" + System.getProperty("line.separator");
    private static String svFooterString = "</CommonBaseEvents>" + System.getProperty("line.separator");
    private byte[] ivHeader;
    private byte[] ivFooter;
    private Locale ivLocale;

    public CBETraceLogger(OutputStream stream, Locale locale) {
        super(stream);
        this.ivLocale = locale;
        this.ivHeader = svHeaderString.getBytes();
        this.ivFooter = svFooterString.getBytes();
    }

    public CBETraceLogger(OutputStream stream, Locale locale, String charEncoding) throws UnsupportedEncodingException {
        super(stream, charEncoding);
        this.ivLocale = locale;
        this.ivHeader = svHeaderString.getBytes(charEncoding);
        this.ivFooter = svFooterString.getBytes(charEncoding);
    }

    synchronized void doLog(LogRecord logRecord) {
        CommonBaseEventLogRecord cbeLogRecord = WsLogRecordFactory.convertToCBELogRecord(logRecord);
        CommonBaseEvent cbe = cbeLogRecord.getCommonBaseEvent();
        String output = TraceLogFormatter.formatCBEXML101(cbe, logRecord.getResourceBundle(), logRecord.getResourceBundleName(), this.ivLocale);
        if (output != null) {
            this.ivOut.println(output);
        }
    }

    synchronized void printHeader() {
        try {
            this.ivOs.write(this.ivHeader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    synchronized void printFooter(int numberOfMessages) {
        try {
            this.ivOs.write(this.ivFooter);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

