/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.oa;

import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.ObjectResolver;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.oa.AdapterAlreadyExistsException;
import com.ibm.ejs.oa.EJSOAImpl;
import com.ibm.ejs.oa.EJSObjectAdapter;
import com.ibm.ejs.oa.EJSRootObjectAdapter;
import com.ibm.ejs.oa.InvalidUserKeyException;
import com.ibm.ejs.oa.LocationService;
import com.ibm.ejs.oa.UserKey;
import com.ibm.ejs.oa.WLMProfileService;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.ejs.util.FastHashtable;
import com.ibm.ejs.util.MathUtil;
import com.ibm.ejs.util.Util;
import com.ibm.websphere.csi.ObjectAdapter;
import com.ibm.websphere.csi.ServantManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.Identity;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.NamingContext;

public class EJSRootOAImpl
implements EJSRootObjectAdapter,
ObjectResolver {
    private static final TraceComponent tc = Tr.register(EJSRootOAImpl.class, "ObjectAdapter", "com.ibm.ws.runtime.runtime");
    private static final String CLASS_NAME = "com.ibm.ejs.oa.EJSRootOAImpl";
    private static final int DEFAULT_SERVANT_CACHE_SIZE = 7001;
    public static final String RemoteObjectCacheSize = "com.ibm.websphere.RemoteObjectCacheSize";
    private ORB orb;
    private final Hashtable objAdapters = new Hashtable();
    private final FastHashtable ivServantObjects;
    private final FastHashtable ivServantKeys;
    private final int ivServantCacheSize;
    private boolean quiesce = false;
    private SystemException quiesceException = null;
    private byte[] serverNameBytes = null;
    private byte[] modelNameBytes = null;
    private ObjectResolver delegateOR;

    protected EJSRootOAImpl() {
        int servantCacheSize = 7001;
        String cacheSizeString = System.getProperty(RemoteObjectCacheSize);
        if (cacheSizeString != null) {
            try {
                int cacheSize = Integer.parseInt(cacheSizeString);
                if (cacheSize >= 100 && cacheSize <= 50000) {
                    servantCacheSize = MathUtil.findNextPrime((int)cacheSize);
                    Tr.info(tc, "WSVR0115I", Integer.toString(servantCacheSize));
                } else {
                    Tr.warning(tc, "WSVR0116W", new java.lang.Object[]{cacheSizeString, Integer.toString(servantCacheSize)});
                }
            }
            catch (NumberFormatException nfe) {
                FFDCFilter.processException((Throwable)nfe, "com.ibm.ejs.oa.EJSRootOAImpl.<init>", "144", this);
                Tr.warning(tc, "WSVR0117W", new java.lang.Object[]{cacheSizeString, Integer.toString(servantCacheSize)});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "RemoteObjectCacheSize = " + servantCacheSize);
        }
        this.ivServantObjects = new FastHashtable(servantCacheSize);
        this.ivServantKeys = new FastHashtable(servantCacheSize);
        this.ivServantCacheSize = servantCacheSize;
    }

    public void setDelegateResolver(ObjectResolver or) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setDelegateResolver: " + or);
        }
        this.delegateOR = or;
    }

    public void setModelName(String modelName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setModelName: " + modelName);
        }
        if (modelName != null) {
            this.modelNameBytes = modelName.getBytes();
        }
    }

    public void init(ORB orb, NamingContext nc, String serverName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "init: " + serverName);
        }
        this.orb = orb;
        this.serverNameBytes = serverName.getBytes();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "init: " + serverName);
        }
    }

    public java.lang.Object keyToObject(byte[] byteKey) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "keyToObject", byteKey);
        }
        if (this.quiesce) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "keyToObject: Server in quiesce state, throw exception");
            }
            throw this.quiesceException;
        }
        try {
            UserKey key = new UserKey(byteKey);
            java.lang.Object result = this.ivServantObjects.get((java.lang.Object)key);
            if (result == null) {
                EJSOAImpl ejsOA;
                ByteArray oaKey = new ByteArray(key.getOAKey());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "OA key: " + oaKey);
                }
                if ((ejsOA = (EJSOAImpl)this.objAdapters.get(oaKey)) == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "keyToObject: Unknown object adapter");
                    }
                    throw new NoSuchObjectException("Unknown object adapter");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Cache miss, calling OA", ejsOA);
                }
                result = ejsOA.keyToObject(key.getServantKey());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "keyToObject: " + Util.identity((java.lang.Object)result));
            }
            return result;
        }
        catch (InvalidUserKeyException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ejs.oa.EJSRootOAImpl.keyToObject", "264", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "keyToObject: Invalid object key");
            }
            throw new NoSuchObjectException("Invalid object key");
        }
    }

    public byte[] objectToKey(java.lang.Object object) {
        Tr.warning(tc, "WSVR0055W", new java.lang.Object[]{object});
        return null;
    }

    public java.lang.Object preinvoke(java.lang.Object object, String operation) {
        if (this.delegateOR != null) {
            return this.delegateOR.preinvoke(object, operation);
        }
        return null;
    }

    public void postinvoke(java.lang.Object object) {
        if (this.delegateOR != null) {
            this.delegateOR.postinvoke(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectAdapter createObjectAdapter(String name) throws AdapterAlreadyExistsException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createObjectAdapter: " + name);
        }
        ObjectAdapter ejsoa = null;
        ByteArray key = new ByteArray(name.getBytes());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "OA key: " + key);
        }
        Hashtable hashtable = this.objAdapters;
        synchronized (hashtable) {
            ejsoa = (ObjectAdapter)this.objAdapters.get(key);
            if (ejsoa == null) {
                ejsoa = new EJSOAImpl(this, name);
                this.objAdapters.put(key, ejsoa);
                if (!EJSPlatformHelper.isZOS()) {
                    LocationService.registerObjectAdapter(this.orb, name);
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "createObjectAdapter: Adapter already exists.");
                }
                throw new AdapterAlreadyExistsException();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createObjectAdapter", ejsoa);
        }
        return ejsoa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EJSObjectAdapter createObjectAdapter(String name, ServantManager manager) throws AdapterAlreadyExistsException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createObjectAdapter: " + name);
        }
        EJSObjectAdapter ejsoa = null;
        ByteArray key = new ByteArray(name.getBytes());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "OA key: " + key);
        }
        Hashtable hashtable = this.objAdapters;
        synchronized (hashtable) {
            ejsoa = (EJSObjectAdapter)this.objAdapters.get(key);
            if (ejsoa == null) {
                ejsoa = new EJSOAImpl(this, name, manager);
                this.objAdapters.put(key, ejsoa);
                if (!EJSPlatformHelper.isZOS()) {
                    LocationService.registerObjectAdapter(this.orb, name);
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "createObjectAdapter: Adapter already exists.");
                }
                throw new AdapterAlreadyExistsException();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createObjectAdapter", ejsoa);
        }
        return ejsoa;
    }

    public void destroyObjectAdapter(String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "destroyObjectAdapter: " + name);
        }
        this.objAdapters.remove(new ByteArray(name.getBytes()));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "destroyObjectAdapter");
        }
    }

    public void quiesce(SystemException e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "quiesce: exception to throw for new incoming requests=" + (java.lang.Object)((java.lang.Object)e));
        }
        this.quiesce = true;
        this.quiesceException = e;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "quiesce");
        }
    }

    public void retireObjectAdapter(String name) {
        if (!EJSPlatformHelper.isZOS()) {
            LocationService.unregisterObjectAdapter(this.orb, name);
        }
    }

    public java.lang.Object getDelegateOR() {
        return this.delegateOR;
    }

    public ObjectAdapter getObjectAdapter(String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectAdapter", name);
        }
        ObjectAdapter ejsoa = null;
        ByteArray key = new ByteArray(name.getBytes());
        ejsoa = (ObjectAdapter)this.objAdapters.get(key);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectAdapter", ejsoa);
        }
        return ejsoa;
    }

    void registerServant(Object servant, byte[] key, boolean wlmable, boolean useLsd, EJSOAImpl oa) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerServant", new java.lang.Object[]{Util.identity((java.lang.Object)servant), new ByteArray(key), new Boolean(wlmable), new Boolean(useLsd), oa});
        }
        UserKey completeKey = null;
        try {
            completeKey = wlmable && this.modelNameBytes != null ? new UserKey(this.modelNameBytes, true, oa.getKey().getBytes(), key) : new UserKey(this.serverNameBytes, false, oa.getKey().getBytes(), key);
            Profile profile = null;
            if (!EJSPlatformHelper.isZOS()) {
                if (useLsd) {
                    profile = LocationService.getLSDIORProfile();
                }
                if (profile == null) {
                    profile = this.orb.getTransportProfile();
                }
                if (wlmable && this.modelNameBytes != null) {
                    profile = (Profile)profile.clone();
                    if (WLMProfileService.getService() != null) {
                        WLMProfileService.getService().setProfile(profile);
                    }
                }
            }
            this.orb.register(servant, completeKey.getBytes(), profile);
            this.ivServantObjects.put((java.lang.Object)completeKey, (java.lang.Object)servant);
            this.ivServantKeys.put((java.lang.Object)servant, (java.lang.Object)completeKey);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                int numServants = this.ivServantObjects.size();
                Tr.debug(tc, "ServantCache: " + numServants + "/" + this.ivServantCacheSize);
                if (numServants > this.ivServantCacheSize) {
                    Tr.debug(tc, "ServantCache: Optimal capacity exceeded!");
                }
            }
        }
        catch (InvalidUserKeyException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ejs.oa.EJSRootOAImpl.registerServant", "574", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "registerServant", ex);
            }
            throw new Error("Invalid servant key");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerServant");
        }
    }

    void registerServant(Object servant, byte[] key, Identity cluster, boolean useLsd, EJSOAImpl oa) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerServant", new java.lang.Object[]{Util.identity((java.lang.Object)servant), new ByteArray(key), cluster, new Boolean(useLsd), oa});
        }
        UserKey completeKey = null;
        boolean wlmable = cluster != null;
        try {
            completeKey = wlmable && this.modelNameBytes != null ? new UserKey(this.modelNameBytes, true, oa.getKey().getBytes(), key) : new UserKey(this.serverNameBytes, false, oa.getKey().getBytes(), key);
            Profile profile = null;
            if (!EJSPlatformHelper.isZOS()) {
                if (useLsd) {
                    profile = LocationService.getLSDIORProfile();
                }
                if (profile == null) {
                    profile = this.orb.getTransportProfile();
                }
                if (cluster != null) {
                    profile = (Profile)profile.clone();
                    if (WLMProfileService.getService() != null) {
                        WLMProfileService.getService().setProfile(profile, cluster);
                    }
                }
            }
            this.orb.register(servant, completeKey.getBytes(), profile);
            this.ivServantObjects.put((java.lang.Object)completeKey, (java.lang.Object)servant);
            this.ivServantKeys.put((java.lang.Object)servant, (java.lang.Object)completeKey);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                int numServants = this.ivServantObjects.size();
                Tr.debug(tc, "ServantCache: " + numServants + "/" + this.ivServantCacheSize);
                if (numServants > this.ivServantCacheSize) {
                    Tr.debug(tc, "ServantCache: Optimal capacity exceeded!");
                }
            }
        }
        catch (InvalidUserKeyException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ejs.oa.EJSRootOAImpl.registerServant", "574", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "registerServant", ex);
            }
            throw new Error("Invalid servant key");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerServant");
        }
    }

    void registerServant(Object servant, ByteArray key, boolean wlmable, boolean useLsd, EJSOAImpl oa) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerServant", new java.lang.Object[]{Util.identity((java.lang.Object)servant), key, new Boolean(wlmable), new Boolean(useLsd), oa});
        }
        UserKey completeKey = null;
        try {
            completeKey = wlmable && this.modelNameBytes != null ? new UserKey(this.modelNameBytes, true, oa.getKey().getBytes(), key) : new UserKey(this.serverNameBytes, false, oa.getKey().getBytes(), key);
            Profile profile = null;
            if (!EJSPlatformHelper.isZOS()) {
                if (useLsd) {
                    profile = LocationService.getLSDIORProfile();
                }
                if (profile == null) {
                    profile = this.orb.getTransportProfile();
                }
                if (wlmable && this.modelNameBytes != null) {
                    profile = (Profile)profile.clone();
                    if (WLMProfileService.getService() != null) {
                        WLMProfileService.getService().setProfile(profile);
                    }
                }
            }
            this.orb.register(servant, completeKey.getBytes(), profile);
            this.ivServantObjects.put((java.lang.Object)completeKey, (java.lang.Object)servant);
            this.ivServantKeys.put((java.lang.Object)servant, (java.lang.Object)completeKey);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                int numServants = this.ivServantObjects.size();
                Tr.debug(tc, "ServantCache: " + numServants + "/" + this.ivServantCacheSize);
                if (numServants > this.ivServantCacheSize) {
                    Tr.debug(tc, "ServantCache: Optimal capacity exceeded!");
                }
            }
        }
        catch (InvalidUserKeyException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ejs.oa.EJSRootOAImpl.registerServant", "667", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "registerServant", ex);
            }
            throw new Error("Invalid servant key");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerServant");
        }
    }

    void registerServant(Object servant, ByteArray key, Identity cluster, boolean useLsd, EJSOAImpl oa) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerServant", new java.lang.Object[]{Util.identity((java.lang.Object)servant), key, cluster, new Boolean(useLsd), oa});
        }
        UserKey completeKey = null;
        boolean wlmable = cluster != null;
        try {
            completeKey = wlmable && this.modelNameBytes != null ? new UserKey(this.modelNameBytes, true, oa.getKey().getBytes(), key) : new UserKey(this.serverNameBytes, false, oa.getKey().getBytes(), key);
            Profile profile = null;
            if (!EJSPlatformHelper.isZOS()) {
                if (useLsd) {
                    profile = LocationService.getLSDIORProfile();
                }
                if (profile == null) {
                    profile = this.orb.getTransportProfile();
                }
                if (cluster != null) {
                    profile = (Profile)profile.clone();
                    if (WLMProfileService.getService() != null) {
                        WLMProfileService.getService().setProfile(profile, cluster);
                    }
                }
            }
            this.orb.register(servant, completeKey.getBytes(), profile);
            this.ivServantObjects.put((java.lang.Object)completeKey, (java.lang.Object)servant);
            this.ivServantKeys.put((java.lang.Object)servant, (java.lang.Object)completeKey);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                int numServants = this.ivServantObjects.size();
                Tr.debug(tc, "ServantCache: " + numServants + "/" + this.ivServantCacheSize);
                if (numServants > this.ivServantCacheSize) {
                    Tr.debug(tc, "ServantCache: Optimal capacity exceeded!");
                }
            }
        }
        catch (InvalidUserKeyException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ejs.oa.EJSRootOAImpl.registerServant", "764", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "registerServant", ex);
            }
            throw new Error("Invalid servant key");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerServant");
        }
    }

    void registerServant(Object servant) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerServant", Util.identity((java.lang.Object)servant));
        }
        this.orb.connect(servant);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerServant");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterServant(Object servant) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "unregisterServant", Util.identity((java.lang.Object)servant));
        }
        try {
            this.orb.disconnect(servant);
        }
        finally {
            UserKey key = (UserKey)this.ivServantKeys.get((java.lang.Object)servant);
            if (key != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Removing servant from cache");
                }
                this.ivServantObjects.remove((java.lang.Object)key);
                this.ivServantKeys.remove((java.lang.Object)servant);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Servant not found in cache");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unregisterServant");
        }
    }

    void unregisterServantNoOrb(Object servant) {
        UserKey key;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "unregisterServantNoOrb", Util.identity((java.lang.Object)servant));
        }
        if ((key = (UserKey)this.ivServantKeys.get((java.lang.Object)servant)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Removing servant from cache");
            }
            this.ivServantObjects.remove((java.lang.Object)key);
            this.ivServantKeys.remove((java.lang.Object)servant);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Servant not found in cache");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unregisterServantNoOrb");
        }
    }

    public IOR createIOR(ByteArray key, Identity cluster, boolean useLsd, String typeid, EJSOAImpl oa) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createIOR", new java.lang.Object[]{key, cluster, new Boolean(useLsd), oa});
        }
        UserKey completeKey = null;
        IOR ior = null;
        boolean wlmable = cluster != null;
        try {
            completeKey = wlmable && this.modelNameBytes != null ? new UserKey(this.modelNameBytes, true, oa.getKey().getBytes(), key) : new UserKey(this.serverNameBytes, false, oa.getKey().getBytes(), key);
            Profile profile = null;
            if (!EJSPlatformHelper.isZOS()) {
                if (useLsd) {
                    profile = LocationService.getLSDIORProfile();
                }
                if (profile == null) {
                    profile = this.orb.getTransportProfile();
                }
                if (wlmable && this.modelNameBytes != null) {
                    profile = (Profile)profile.clone();
                    if (WLMProfileService.getService() != null) {
                        WLMProfileService.getService().setProfile(profile, cluster);
                    }
                }
            } else if (wlmable && this.modelNameBytes != null && WLMProfileService.getService() != null) {
                profile = new com.ibm.rmi.Profile((com.ibm.rmi.ORB)this.orb);
                WLMProfileService.getService().setProfile(profile, cluster);
            }
            ObjectKey objectKey = new ObjectKey(completeKey.getBytes());
            ior = ORB.createIOR((ORB)this.orb, (String)typeid, (Profile)profile, (int)1, (com.ibm.CORBA.iiop.UserKey)completeKey);
        }
        catch (InvalidUserKeyException ex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createIOR", ex);
            }
            throw new Error("Invalid key");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createIOR");
        }
        return ior;
    }

    public UserKey createCompleteKey(boolean wlmable, EJSOAImpl oa, byte[] key) {
        UserKey completeKey = null;
        try {
            completeKey = wlmable && this.modelNameBytes != null ? new UserKey(this.modelNameBytes, true, oa.getKey().getBytes(), key) : new UserKey(this.serverNameBytes, false, oa.getKey().getBytes(), key);
        }
        catch (InvalidUserKeyException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ejs.oa.EJSRootOAImpl.createCompleteKey", "1066", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createCompleteKey", e);
            }
            throw new Error("Invalid servant key");
        }
        return completeKey;
    }
}

