/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.Principal;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;

public final class StateofCurrObj {
    private static TraceComponent tc = Tr.register(StateofCurrObj.class, "SASRas");
    private boolean isAnyPropagationEnabled = false;
    private Subject callerSubject = null;
    private Subject ownSubject = null;
    private Subject invocationSubject = null;
    private Subject savedSubject = null;
    private Subject recSavedSubject = null;
    private boolean includeRunAsChangesInCallerList = false;
    String firstAuthUser = null;
    boolean authFlag = false;

    public StateofCurrObj() {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (csiv2 != null) {
            this.includeRunAsChangesInCallerList = csiv2.getBoolean("com.ibm.ws.security.includeRunAsChangesInCallerList");
        }
        this.isAnyPropagationEnabled = RasHelper.isServer() && (WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled());
    }

    public StateofCurrObj(WSCredential[] in_receivedCreds, WSCredential in_ownCreds, WSCredential in_invocationCreds) {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (csiv2 != null) {
            this.includeRunAsChangesInCallerList = csiv2.getBoolean("com.ibm.ws.security.includeRunAsChangesInCallerList");
        }
        this.isAnyPropagationEnabled = RasHelper.isServer() && (WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled());
        this.callerSubject = in_receivedCreds == null || in_receivedCreds[0] == null ? null : SubjectHelper.createSubjectFromWSCredential(in_receivedCreds[0]);
        this.ownSubject = in_ownCreds == null ? null : SubjectHelper.createSubjectFromWSCredential(in_ownCreds);
        this.invocationSubject = in_invocationCreds == null ? null : SubjectHelper.createSubjectFromWSCredential(in_invocationCreds);
    }

    public StateofCurrObj(Subject in_callerSubject, Subject in_ownSubject, Subject in_invocationSubject) {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (csiv2 != null) {
            this.includeRunAsChangesInCallerList = csiv2.getBoolean("com.ibm.ws.security.includeRunAsChangesInCallerList");
        }
        this.isAnyPropagationEnabled = RasHelper.isServer() && (WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled());
        this.callerSubject = in_callerSubject == null ? null : in_callerSubject;
        this.ownSubject = in_ownSubject == null ? null : in_ownSubject;
        this.invocationSubject = in_invocationSubject == null ? null : in_invocationSubject;
    }

    public WSCredential getWSInvocationCred() {
        return SubjectHelper.getWSCredentialFromSubject(this.invocationSubject);
    }

    public WSCredential getWSOwnCred() {
        return SubjectHelper.getWSCredentialFromSubject(this.ownSubject);
    }

    public WSCredential[] getWSReceivedCreds() {
        WSCredential[] credArray = new WSCredential[]{SubjectHelper.getWSCredentialFromSubject(this.callerSubject)};
        return credArray;
    }

    public void setWSInvocationCred(WSCredential creds) {
        this.invocationSubject = SubjectHelper.createSubjectFromWSCredential(creds);
        if (tc.isEntryEnabled()) {
            this.traceSetSubject("setWSInvocationCred", this.invocationSubject);
        }
        if (this.includeRunAsChangesInCallerList && this.isAnyPropagationEnabled) {
            SubjectHelper.updatePropagationTokenWithSubjectChange(this.invocationSubject);
        }
    }

    public void setWSOwnCred(WSCredential creds) {
        this.ownSubject = SubjectHelper.createSubjectFromWSCredential(creds);
        if (tc.isEntryEnabled()) {
            this.traceSetSubject("setWSOwnCred", this.ownSubject);
        }
    }

    public void setWSReceivedCreds(WSCredential[] creds) {
        if (creds == null || creds[0] == null) {
            this.callerSubject = null;
        } else {
            WSCredential cred = creds[0];
            this.callerSubject = SubjectHelper.createSubjectFromWSCredential(cred);
            if (this.isAnyPropagationEnabled) {
                SubjectHelper.updatePropagationTokenWithSubjectChange(this.callerSubject);
            }
        }
        if (tc.isEntryEnabled()) {
            this.traceSetSubject("setWSReceivedCreds", this.callerSubject);
        }
    }

    public Subject getInvocationSubject() {
        return this.invocationSubject;
    }

    public Subject getOwnSubject() {
        return this.ownSubject;
    }

    public Subject getCallerSubject() {
        return this.callerSubject;
    }

    public Subject[] getSavedSubjects() {
        Subject[] savedSubjects = new Subject[]{this.savedSubject, this.recSavedSubject};
        return savedSubjects;
    }

    public boolean setSavedSubjects(Subject savedSbj, Subject recSavedSbj) {
        boolean subjectSaved = false;
        if (this.savedSubject == null && this.recSavedSubject == null) {
            this.savedSubject = savedSbj;
            this.recSavedSubject = recSavedSbj;
            subjectSaved = true;
        }
        return subjectSaved;
    }

    public void clearSavedSubjects() {
        this.savedSubject = null;
        this.recSavedSubject = null;
    }

    public void setInvocationSubject(Subject subject) {
        this.invocationSubject = subject;
        if (tc.isEntryEnabled()) {
            this.traceSetSubject("setInvocationSubject", subject);
        }
        if (this.includeRunAsChangesInCallerList && this.isAnyPropagationEnabled) {
            SubjectHelper.updatePropagationTokenWithSubjectChange(this.invocationSubject);
        }
    }

    public void setOwnSubject(Subject subject) {
        this.ownSubject = subject;
        if (tc.isEntryEnabled()) {
            this.traceSetSubject("setOwnSubject", subject);
        }
    }

    public void setCallerSubject(Subject subject) {
        this.callerSubject = subject;
        if (tc.isEntryEnabled()) {
            this.traceSetSubject("setCallerSubject", subject);
        }
        if (this.isAnyPropagationEnabled) {
            SubjectHelper.updatePropagationTokenWithSubjectChange(this.callerSubject);
        }
    }

    private void traceSetSubject(String method2, Subject subject) {
        if (tc.isEntryEnabled()) {
            StringBuffer sb = new StringBuffer(method2);
            sb.append("()");
            if (subject == null) {
                sb.append(" null subject");
            } else {
                Set<Principal> s = subject.getPrincipals();
                Principal[] principal = s.toArray(new Principal[0]);
                for (int n = 0; n < principal.length; ++n) {
                    sb.append(" principal");
                    if (n > 0) {
                        sb.append(n + 1);
                    }
                    sb.append(" \"");
                    sb.append(principal[n].getName());
                    sb.append("\" ");
                }
            }
            boolean printStack = false;
            WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
            String stackTrace = System.getProperty("com.ibm.ISecurityUtilityImpl.StateofCurrObj.setSubjectStack");
            if (stackTrace != null) {
                if ((stackTrace = stackTrace.trim()).equalsIgnoreCase("true")) {
                    printStack = true;
                } else {
                    boolean methodFound = false;
                    boolean userFound = false;
                    StringTokenizer st = new StringTokenizer(stackTrace, "|");
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken().trim().toLowerCase();
                        if (token.equals("allmethods")) {
                            methodFound = true;
                        }
                        if (token.equals("allusers")) {
                            userFound = true;
                        }
                        if (sb.toString().toLowerCase().indexOf(token) > -1) {
                            userFound = true;
                        }
                        if (sb.toString().toLowerCase().indexOf(token) != 0) continue;
                        methodFound = true;
                    }
                    boolean bl = printStack = methodFound && userFound;
                }
            }
            if (printStack) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                new Throwable().printStackTrace(new PrintStream(baos));
                sb.append("\n");
                sb.append(baos);
            }
            Tr.debug(tc, sb.toString());
        }
    }

    public String getFirstAuthUser() {
        return this.firstAuthUser;
    }

    public boolean getAuthFlag() {
        return this.authFlag;
    }

    public void setFirstAuthUser(String user) {
        this.firstAuthUser = user;
    }

    public void setAuthFlag(boolean flag) {
        this.authFlag = flag;
    }
}

