/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException;
import com.ibm.ISecurityUtilityImpl.InvalidPasswordEncodingException;
import com.ibm.ISecurityUtilityImpl.KeyFileEntry;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.UnsupportedCryptoAlgorithmException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.security.util.AccessController;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class KeyFile
extends Hashtable {
    private static final long serialVersionUID = -7416596310773730895L;
    String keyfileName = "";
    long keyfileSize = 0L;
    boolean isSvrKyFile = true;
    Vector tmpFileBuff = null;
    private static final TraceComponent tc = Tr.register(KeyFile.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");

    public KeyFile(String keyfileName) {
        if (keyfileName != null) {
            this.keyfileName = keyfileName;
        }
        this.load();
    }

    public KeyFileEntry find(String qualifiedName) {
        KeyFileEntry keyFileEntry;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "find", new Object[]{qualifiedName, this});
        }
        if ((keyFileEntry = (KeyFileEntry)this.get(qualifiedName.toLowerCase())) != null) {
            return keyFileEntry;
        }
        String realmName = RealmSecurityName.getRealm(qualifiedName);
        String securityName = RealmSecurityName.getSecurityName(qualifiedName);
        if (realmName != null && !realmName.trim().equals("") && securityName != null && !securityName.trim().equals("")) {
            boolean firstEntryFound = false;
            KeyFileEntry firstEntry = null;
            Enumeration keys = this.keys();
            Enumeration entries = this.elements();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                KeyFileEntry entry = (KeyFileEntry)entries.nextElement();
                if (!firstEntryFound) {
                    firstEntry = entry;
                    firstEntryFound = true;
                }
                String entryRealmName = RealmSecurityName.getRealm(key);
                String entrySecurityName = RealmSecurityName.getSecurityName(key);
                if (realmName != null && entryRealmName != null && realmName.equalsIgnoreCase(entryRealmName)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "find", entry);
                    }
                    return entry;
                }
                if (securityName == null || entrySecurityName == null || !securityName.equals(entrySecurityName)) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "find", entry);
                }
                return entry;
            }
            if (firstEntryFound) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "find", firstEntry);
                }
                return firstEntry;
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "find", null);
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "find", null);
        }
        return null;
    }

    public KeyFileEntry find(String realmName, String securityName) {
        return this.find(RealmSecurityName.getRealm(realmName, securityName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void load() {
        String keyEntryLine;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "load", this);
        }
        final File keyfileHandle = new File(this.keyfileName);
        RandomAccessFile keyfile = null;
        long fileBegins = 0L;
        try {
            try {
                keyfile = (RandomAccessFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (!keyfileHandle.canWrite()) {
                            return null;
                        }
                        return new RandomAccessFile(keyfileHandle, "rw");
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "262", this);
                throw e.getException();
            }
            if (keyfile != null && keyfile.length() != 0L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, SecurityMessages.getMsgOrUseDefault("ActMsg460", "Successfully loaded configured key file: "));
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, SecurityMessages.getMsgOrUseDefault("ErrMsg482", "Failed to load configured key file: "));
                }
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "load");
                return;
            }
            this.keyfileSize = keyfile.length();
            this.tmpFileBuff = new Vector((int)this.keyfileSize);
            fileBegins = keyfile.getFilePointer();
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "285", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, SecurityMessages.getMsgOrUseDefault("ErrMsg482", "Failed to load configured key file: ") + (this.keyfileName == null ? "" : this.keyfileName), new Object[]{e});
            }
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "load");
            return;
        }
        String realmName = null;
        String userid = null;
        String oripword = null;
        String decodedpwd = null;
        Object exceptionCaught = null;
        while ((keyEntryLine = keyfile.readLine()) != null) {
            if (keyEntryLine.charAt(0) != '#') {
                StringTokenizer keyEntryTokenLine = new StringTokenizer(keyEntryLine);
                if (keyEntryTokenLine.countTokens() == 3) {
                    block46: {
                        realmName = keyEntryTokenLine.nextToken();
                        userid = keyEntryTokenLine.nextToken();
                        oripword = keyEntryTokenLine.nextToken();
                        try {
                            decodedpwd = PasswordUtil.decode(oripword);
                        }
                        catch (InvalidPasswordDecodingException e) {
                            Manager.Ffdc.log((Throwable)((Object)e), this, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "338", this);
                            decodedpwd = oripword;
                            try {
                                oripword = PasswordUtil.encode(oripword);
                            }
                            catch (UnsupportedCryptoAlgorithmException e3) {
                                Manager.Ffdc.log((Throwable)((Object)e3), this, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "348", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Encountered unsupported cryptographic algorithm while encoding the password from key file " + this.keyfileName, new Object[]{e3});
                                }
                            }
                            catch (InvalidPasswordEncodingException e3) {
                                Manager.Ffdc.log((Throwable)((Object)e3), this, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "353", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Encountered invalidly encoded password from key file " + this.keyfileName, new Object[]{e});
                                }
                            }
                        }
                        catch (Exception e) {
                            Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "360", this);
                            decodedpwd = oripword;
                            if (!tc.isDebugEnabled()) break block46;
                            Tr.debug(tc, e.toString() + " caught while decoding the password from key file " + this.keyfileName, new Object[]{e});
                        }
                    }
                    KeyFileEntry keyEntry = new KeyFileEntry(userid, decodedpwd);
                    this.tmpFileBuff.addElement(realmName + " " + userid + " " + oripword + "\r" + "\n");
                    if (this.put(realmName.toLowerCase(), keyEntry) == null || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Duplicated entry for realm name: " + realmName);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "An entry contains wrong number of values.");
                }
                keyEntryLine = keyEntryLine + "\r" + "\n";
                this.tmpFileBuff.addElement(keyEntryLine);
                continue;
            }
            keyEntryLine = keyEntryLine + "\r" + "\n";
            this.tmpFileBuff.addElement(keyEntryLine);
        }
        Object var15_22 = null;
        if (exceptionCaught != null && !exceptionCaught.equals(new EOFException())) return;
        try {
            if (this.tmpFileBuff != null && !this.tmpFileBuff.isEmpty()) {
                if (keyfile != null) {
                    keyfile.seek(fileBegins);
                }
                for (int i = 0; i < this.tmpFileBuff.size(); ++i) {
                    keyfile.writeBytes(String.valueOf(this.tmpFileBuff.elementAt(i)));
                }
            }
            keyfile.close();
            return;
        }
        catch (IOException e2) {
            Manager.Ffdc.log(e2, this, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "448", this);
            Tr.error(tc, "security.JSAS0400E");
        }
        return;
        {
            catch (EOFException e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "405", this);
                try {
                    keyfile.close();
                }
                catch (IOException e2) {
                    Manager.Ffdc.log(e2, this, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "414", this);
                    Tr.error(tc, "security.JSAS0400E");
                    exceptionCaught = e2;
                }
                exceptionCaught = e;
                Object var15_23 = null;
                if (exceptionCaught != null && !exceptionCaught.equals(new EOFException())) return;
                try {
                    if (this.tmpFileBuff != null && !this.tmpFileBuff.isEmpty()) {
                        if (keyfile != null) {
                            keyfile.seek(fileBegins);
                        }
                        for (int i = 0; i < this.tmpFileBuff.size(); ++i) {
                            keyfile.writeBytes(String.valueOf(this.tmpFileBuff.elementAt(i)));
                        }
                    }
                    keyfile.close();
                    return;
                }
                catch (IOException e2) {
                    Manager.Ffdc.log(e2, this, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "448", this);
                    Tr.error(tc, "security.JSAS0400E");
                }
                return;
            }
            catch (IOException e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "423", this);
                Tr.error(tc, "security.JSAS0400E", new Object[]{e});
                Object var15_24 = null;
                if (exceptionCaught != null && !exceptionCaught.equals(new EOFException())) return;
                try {
                    if (this.tmpFileBuff != null && !this.tmpFileBuff.isEmpty()) {
                        if (keyfile != null) {
                            keyfile.seek(fileBegins);
                        }
                        for (int i = 0; i < this.tmpFileBuff.size(); ++i) {
                            keyfile.writeBytes(String.valueOf(this.tmpFileBuff.elementAt(i)));
                        }
                    }
                    keyfile.close();
                    return;
                }
                catch (IOException e2) {
                    Manager.Ffdc.log(e2, this, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "448", this);
                    Tr.error(tc, "security.JSAS0400E");
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var15_25 = null;
            if (exceptionCaught != null && !exceptionCaught.equals(new EOFException())) throw throwable;
            try {
                if (this.tmpFileBuff != null && !this.tmpFileBuff.isEmpty()) {
                    if (keyfile != null) {
                        keyfile.seek(fileBegins);
                    }
                    for (int i = 0; i < this.tmpFileBuff.size(); ++i) {
                        keyfile.writeBytes(String.valueOf(this.tmpFileBuff.elementAt(i)));
                    }
                }
                keyfile.close();
                throw throwable;
            }
            catch (IOException e2) {
                Manager.Ffdc.log(e2, this, "com.ibm.ISecurityUtilityImpl.KeyFile.load", "448", this);
                Tr.error(tc, "security.JSAS0400E");
            }
            throw throwable;
        }
    }
}

