/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectCSIv2UtilityImpl;

import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSEncodeDecodeException;
import com.ibm.ffdc.Manager;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;

public final class OID {
    private Vector theVector = new Vector();

    public OID(String s) throws GSSEncodeDecodeException {
        StringTokenizer stringtokenizer = new StringTokenizer(s, "\t\n\r.oid:, ", false);
        try {
            while (stringtokenizer.hasMoreTokens()) {
                this.theVector.addElement(new Integer(stringtokenizer.nextToken()));
            }
        }
        catch (Exception exception) {
            Manager.Ffdc.log(exception, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID.OID", "66", this);
            throw new GSSEncodeDecodeException(3);
        }
    }

    public OID(byte[] inbyte) throws GSSEncodeDecodeException {
        if (inbyte == null || inbyte.length < 3) {
            throw new GSSEncodeDecodeException(3);
        }
        int index = 0;
        helperInt theInt = new helperInt(0);
        index = this.getValue(inbyte, 0, theInt);
        if (theInt.val != 6) {
            throw new GSSEncodeDecodeException(3);
        }
        index = this.getValue(inbyte, index, theInt);
        int j = index + theInt.val;
        index = this.getValue(inbyte, index, theInt);
        int k = theInt.val;
        if (k <= 39) {
            this.theVector.addElement(new Integer(0));
            this.theVector.addElement(new Integer(k));
        } else if (k <= 79) {
            this.theVector.addElement(new Integer(1));
            this.theVector.addElement(new Integer(k - 40));
        } else {
            this.theVector.addElement(new Integer(2));
            this.theVector.addElement(new Integer(k - 80));
        }
        while (index < j) {
            index = this.getValue(inbyte, index, theInt);
            this.theVector.addElement(new Integer(theInt.val));
        }
    }

    public String toString() {
        String s = new String();
        if (this.theVector.size() > 0) {
            for (int index = 0; index < this.theVector.size(); ++index) {
                if (index > 0) {
                    s = s.concat(".");
                }
                s = s.concat(((Integer)this.theVector.elementAt(index)).toString());
            }
            return s;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OID)) {
            return false;
        }
        OID oid = (OID)obj;
        String s = this.toString();
        if (s == null) {
            return false;
        }
        return s.equals(oid.toString());
    }

    public byte[] getDER() {
        if (this.theVector == null) {
            return null;
        }
        Vector<Integer> aVector = new Vector<Integer>();
        aVector.addElement(new Integer(6));
        int k = 40 * (Integer)this.theVector.elementAt(0);
        if (this.theVector.size() > 1) {
            k += ((Integer)this.theVector.elementAt(1)).intValue();
        }
        int k1 = 1;
        int l1 = 0;
        int i2 = 0;
        do {
            int l = k % 128;
            aVector.insertElementAt(new Integer(l + i2), k1);
            ++l1;
            i2 = 128;
        } while ((k /= 128) > 0);
        k1 += l1;
        for (int index = 2; index < this.theVector.size(); ++index) {
            k = (Integer)this.theVector.elementAt(index);
            l1 = 0;
            i2 = 0;
            do {
                int i1 = k % 128;
                aVector.insertElementAt(new Integer(i1 + i2), k1);
                ++l1;
                i2 = 128;
            } while ((k /= 128) > 0);
            k1 += l1;
        }
        k = aVector.size() - 1;
        k1 = 1;
        l1 = 0;
        i2 = 0;
        do {
            int j1 = k % 128;
            aVector.insertElementAt(new Integer(j1 + i2), k1);
            i2 = 128;
        } while ((k /= 128) > 0);
        byte[] returnbyte = new byte[aVector.size()];
        if (returnbyte == null) {
            return null;
        }
        for (int j = 0; j < aVector.size(); ++j) {
            returnbyte[j] = (byte)((Integer)aVector.elementAt(j)).intValue();
        }
        return returnbyte;
    }

    public boolean containedIn(OID[] aoid) {
        if (aoid == null) {
            return false;
        }
        for (int index = 0; index < aoid.length; ++index) {
            if (!this.equals(aoid[index])) continue;
            return true;
        }
        return false;
    }

    public static OID getInstance(String s) {
        try {
            return new OID(s);
        }
        catch (Exception exception) {
            Manager.Ffdc.log(exception, OID.class, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID.getInstance", "307");
            return null;
        }
    }

    public static boolean compareOIDs(String OID1, String OID2) {
        String OID1WithoutPrefix = "";
        String OID2WithoutPrefix = "";
        if (OID1 == null || OID2 == null) {
            return false;
        }
        int colonOID1 = OID1.indexOf(":");
        OID1WithoutPrefix = colonOID1 == -1 ? OID1 : OID1.substring(colonOID1 + 1);
        int colonOID2 = OID2.indexOf(":");
        OID2WithoutPrefix = colonOID2 == -1 ? OID2 : OID2.substring(colonOID2 + 1);
        boolean result = OID1WithoutPrefix.compareTo(OID2WithoutPrefix) == 0;
        return result;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private int size() {
        return this.theVector.size();
    }

    private int getValue(byte[] inbyte, int index, helperInt theInt) throws GSSEncodeDecodeException {
        int j = 0;
        int k = inbyte.length;
        while (index < k) {
            j *= 128;
            if (inbyte[index] >= 0) {
                theInt.val = j + inbyte[index];
                return index + 1;
            }
            j += inbyte[index++] & 0x7F;
        }
        throw new GSSEncodeDecodeException(3);
    }

    private int getValue(InputStream inputstream, helperInt theInt) throws GSSEncodeDecodeException {
        int index = 0;
        int j = 1;
        try {
            int k = inputstream.read();
            while (k > -1) {
                index *= 128;
                if (k < 127) {
                    theInt.val = index + k;
                    return j;
                }
                index += k & 0x7F;
                k = inputstream.read();
                ++j;
            }
        }
        catch (Exception exception) {
            Manager.Ffdc.log(exception, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID.getValue", "370", this);
            throw new GSSEncodeDecodeException(3, exception.getMessage());
        }
        throw new GSSEncodeDecodeException(3);
    }

    private class helperInt {
        int val;

        public helperInt(int num) {
            this.val = num;
        }
    }
}

