/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBaseL13Impl;

import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy;
import com.ibm.ISecurityUtilityImpl.ThreadContextImpl;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.internals.ContextManagerInternals;
import com.ibm.wsspi.security.token.PropagationToken;
import java.util.Map;
import javax.security.auth.Subject;

public class CurrentImpl {
    private ContextManagerInternals cMgr = null;

    public ThreadContextImpl getThreadLocal() {
        return this.getContextManager().getThreadLocal();
    }

    public void clear_requestor_context() {
        try {
            this.getContextManager().clearCallerContext();
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CurrentImpl.clearCallerContext", "150");
        }
    }

    public void clear_ws_requestor_context() {
        try {
            this.getContextManager().clearCallerContext();
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CurrentImpl.clear_ws_requestor_context", "169");
        }
    }

    public synchronized void initialize_requestor_context(Subject received_subject) {
        try {
            this.getContextManager().initializeCallerContext(received_subject);
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CurrentImpl.initialize_requestor_context", "184");
        }
    }

    public synchronized void initialize_ws_requestor_context(WSCredential[] received_credentials) {
        try {
            this.getContextManager().initializeCallerContext(received_credentials);
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CurrentImpl.initialize_ws_requestor_context", "204");
        }
    }

    public boolean isSecurityEnabled() {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        return csiv2.getBoolean("com.ibm.CORBA.securityEnabled");
    }

    public boolean isSSLSecurityTagExported() {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        return csiv2.getBoolean("com.ibm.CORBA.serverSecurityEnabled");
    }

    public WSCredential get_ws_invocation_credentials() throws WSSecurityException {
        return this.getContextManager().getInvocationCredential();
    }

    public WSCredential get_ws_own_credentials() throws WSSecurityException {
        Subject subject = this.getContextManager().getOwnSubject();
        return SubjectHelper.getWSCredentialFromSubject(subject);
    }

    public WSCredential[] get_ws_received_credentials() throws WSSecurityException {
        return this.getContextManager().getCallerCredentials();
    }

    public Subject get_invocation_subject() throws WSSecurityException {
        return this.getContextManager().getInvocationSubject();
    }

    public Subject get_own_subject() throws WSSecurityException {
        return this.getContextManager().getOwnSubject();
    }

    public Subject get_caller_subject() throws WSSecurityException {
        return this.getContextManager().getCallerSubject();
    }

    public void set_ws_received_credentials(WSCredential[] received_credentials) throws WSSecurityException {
        this.getContextManager().setCallerCredentials(received_credentials);
    }

    public synchronized void set_ws_invocation_credentials(WSCredential creds) throws WSSecurityException {
        this.getContextManager().setInvocationCredential(creds);
    }

    public synchronized void set_ws_own_credentials(WSCredential creds) throws WSSecurityException {
        this.getContextManager().setOwnSubject(SubjectHelper.createSubjectFromWSCredential(creds));
    }

    public void set_caller_subject(Subject subject) throws WSSecurityException {
        this.getContextManager().setCallerSubject(subject);
    }

    public synchronized void set_invocation_subject(Subject subject) throws WSSecurityException {
        this.getContextManager().setInvocationSubject(subject);
    }

    public synchronized void set_own_subject(Subject subject) throws WSSecurityException {
        this.getContextManager().setOwnSubject(subject);
    }

    protected void setSecurityContext(SecurityContextImpl security_context) {
        this.getThreadLocal().set_security_context_csi(security_context);
    }

    protected SecurityContextImpl getSecurityContext() {
        return this.getThreadLocal().get_security_context_csi();
    }

    protected void setEffectivePolicy(CSIv2EffectivePerformPolicy effPolicy) {
        this.getThreadLocal().set_effective_policy(effPolicy);
    }

    public CSIv2EffectivePerformPolicy getEffectivePolicy() {
        CSIv2EffectivePerformPolicy effPolicy = this.getThreadLocal().get_effective_policy();
        return effPolicy;
    }

    public void setWSSecurityContext(WSSecurityContext wsSecContext) {
        this.getThreadLocal().set_WSSecurityContext(wsSecContext);
    }

    public WSSecurityContext getWSSecurityContext() {
        WSSecurityContext wsSecContext = this.getThreadLocal().get_WSSecurityContext();
        return wsSecContext;
    }

    public void setRootException(Throwable t) {
        this.getThreadLocal().set_root_exception(t);
    }

    public Throwable getRootException() {
        return this.getThreadLocal().get_root_exception();
    }

    public void setThreadSubject(Subject subject) throws SecurityException {
        this.getThreadLocal().set_thread_subject(subject);
    }

    public Subject getThreadSubject() {
        return this.getThreadLocal().get_thread_subject();
    }

    public void setServerSecurityEnabled(boolean value) {
        this.getThreadLocal().set_server_security_enabled(value);
    }

    public boolean getServerSecurityEnabled() {
        return this.getThreadLocal().get_server_security_enabled();
    }

    public void setAuthRetryForJAAS(boolean value) {
        this.getThreadLocal().set_authretry_for_jaas(value);
    }

    public boolean getAuthRetryForJAAS() {
        return this.getThreadLocal().get_authretry_for_jaas();
    }

    public void setAllowUnauthCredForAuthenticate(boolean value) {
        this.getThreadLocal().set_allowunauthcred_for_authenticate(value);
    }

    public boolean getAllowUnauthCredForAuthenticate() {
        return this.getThreadLocal().get_allowunauthcred_for_authenticate();
    }

    public void setFirstHost(String value) {
        this.getThreadLocal().set_first_host(value);
    }

    public void setAllHosts(String value) {
        this.getThreadLocal().set_all_hosts(value);
    }

    public String getFirstHost() {
        return this.getThreadLocal().get_first_host();
    }

    public String getAllHosts() {
        return this.getThreadLocal().get_all_hosts();
    }

    public void setFirstPort(String value) {
        this.getThreadLocal().set_first_port(value);
    }

    public void setAllPorts(String value) {
        this.getThreadLocal().set_all_ports(value);
    }

    public String getFirstPort() {
        return this.getThreadLocal().get_first_port();
    }

    public String getAllPorts() {
        return this.getThreadLocal().get_all_ports();
    }

    public Object setProperty(String key, Object value) {
        return this.getContextManager().put(key, value);
    }

    public Object getProperty(String key) {
        return this.getContextManager().get(key);
    }

    public boolean containsProperty(String key) {
        return this.getContextManager().contains(key);
    }

    public void setTargetSecurityRealm(String value) {
        this.getThreadLocal().set_target_security_realm(value);
    }

    public String getTargetSecurityRealm() {
        return this.getThreadLocal().get_target_security_realm();
    }

    public int get_retry_count() {
        return this.getThreadLocal().get_retry_count();
    }

    public void increment_retry_count() {
        this.getThreadLocal().increment_retry_count();
    }

    public void clear_retry_count() {
        this.getThreadLocal().clear_retry_count();
    }

    public PropagationToken setPropagationToken(String key, PropagationToken token) {
        return this.getThreadLocal().set_propagation_token(key, token);
    }

    public PropagationToken getPropagationToken(String key) {
        return this.getThreadLocal().get_propagation_token(key);
    }

    public Map getPropagationTokens() {
        return this.getThreadLocal().get_propagation_tokens();
    }

    private ContextManagerInternals getContextManager() {
        if (this.cMgr == null) {
            this.cMgr = (ContextManagerInternals)ContextManagerFactory.getInstance();
        }
        return this.cMgr;
    }
}

