/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.internal.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.sql.RowSetMetaData;
import javax.sql.rowset.BaseRowSet;
import javax.sql.rowset.spi.SyncResolver;
import org.apache.harmony.luni.util.NotImplementedException;
import org.apache.harmony.sql.internal.nls.Messages;
import org.apache.harmony.sql.internal.rowset.CachedRow;

public class SyncResolverImpl
extends BaseRowSet
implements SyncResolver {
    private static final long serialVersionUID = 4964648528867743289L;
    private List<ConflictedRow> conflictRows;
    private int currentIndex;
    private RowSetMetaData metadata;

    public SyncResolverImpl(RowSetMetaData rowSetMetaData) {
        this.metadata = rowSetMetaData;
        this.conflictRows = new ArrayList<ConflictedRow>();
        this.currentIndex = -1;
    }

    public void addConflictRow(CachedRow cachedRow, int n, int n2) {
        this.conflictRows.add(new ConflictedRow(cachedRow, n, n2));
    }

    @Override
    public Object getConflictValue(int n) throws SQLException {
        if (n <= 0 || n > this.metadata.getColumnCount()) {
            throw new SQLException(Messages.getString("sql.27", (Object)n));
        }
        if (this.currentIndex < 0 || this.currentIndex >= this.conflictRows.size()) {
            throw new SQLException(Messages.getString("rowset.7"));
        }
        return this.conflictRows.get((int)this.currentIndex).row.getObject(n);
    }

    @Override
    public Object getConflictValue(String string) throws SQLException {
        return this.getConflictValue(this.getIndexByName(string));
    }

    @Override
    public int getStatus() {
        if (this.currentIndex < 0 || this.currentIndex >= this.conflictRows.size()) {
            throw new NullPointerException(Messages.getString("rowset.7"));
        }
        return this.conflictRows.get((int)this.currentIndex).status;
    }

    @Override
    public boolean nextConflict() throws SQLException {
        if (this.currentIndex == this.conflictRows.size()) {
            return false;
        }
        ++this.currentIndex;
        return this.currentIndex >= 0 && this.currentIndex < this.conflictRows.size();
    }

    @Override
    public boolean previousConflict() throws SQLException {
        if (this.currentIndex == -1) {
            return false;
        }
        --this.currentIndex;
        return this.currentIndex >= 0 && this.currentIndex < this.conflictRows.size();
    }

    @Override
    public void setResolvedValue(int n, Object object) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void setResolvedValue(String string, Object object) throws SQLException {
        this.setResolvedValue(this.getIndexByName(string), object);
    }

    @Override
    public int getRow() throws SQLException {
        if (this.currentIndex < 0 || this.currentIndex >= this.conflictRows.size()) {
            return 0;
        }
        return this.conflictRows.get((int)this.currentIndex).index;
    }

    private int getIndexByName(String string) throws SQLException {
        for (int i = 1; i <= this.metadata.getColumnCount(); ++i) {
            if (!string.equalsIgnoreCase(this.metadata.getColumnName(i))) continue;
            return i;
        }
        throw new SQLException(Messages.getString("rowset.1"));
    }

    @Override
    public void execute() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int findColumn(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean first() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array getArray(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array getArray(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getByte(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getByte(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloat(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloat(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getTime(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getTime(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean last() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean next() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean previous() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean relative(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNull(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNull(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean wasNull() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getHoldability() throws SQLException, NotImplementedException {
        return 0;
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException, NotImplementedException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException, NotImplementedException {
        return null;
    }

    @Override
    public NClob getNClob(int n) throws SQLException, NotImplementedException {
        return null;
    }

    @Override
    public NClob getNClob(String string) throws SQLException, NotImplementedException {
        return null;
    }

    @Override
    public String getNString(int n) throws SQLException, NotImplementedException {
        return null;
    }

    @Override
    public String getNString(String string) throws SQLException, NotImplementedException {
        return null;
    }

    @Override
    public RowId getRowId(int n) throws SQLException, NotImplementedException {
        return null;
    }

    @Override
    public RowId getRowId(String string) throws SQLException, NotImplementedException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException, NotImplementedException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException, NotImplementedException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException, NotImplementedException {
        return false;
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateNString(int n, String string) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException, NotImplementedException {
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException, NotImplementedException {
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException, NotImplementedException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException, NotImplementedException {
        return null;
    }

    private static class ConflictedRow {
        CachedRow row;
        int index;
        int status;

        public ConflictedRow(CachedRow cachedRow, int n, int n2) {
            this.row = cachedRow;
            this.index = n;
            this.status = n2;
        }
    }
}

