/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialException;
import org.apache.harmony.sql.internal.nls.Messages;

public class SerialBlob
implements Blob,
Serializable,
Cloneable {
    private static final long serialVersionUID = -8144641928112860441L;
    private byte[] buf;
    private Blob blob;
    private long len;
    private long origLen;

    public SerialBlob(Blob blob) throws SerialException, SQLException {
        if (blob == null) {
            throw new SQLException(Messages.getString("sql.13"));
        }
        this.blob = blob;
        this.buf = blob.getBytes(1L, (int)blob.length());
        this.origLen = this.len = (long)this.buf.length;
    }

    public SerialBlob(byte[] byArray) throws SerialException, SQLException {
        this.buf = new byte[byArray.length];
        this.origLen = this.len = (long)byArray.length;
        System.arraycopy(byArray, 0, this.buf, 0, (int)this.len);
    }

    @Override
    public InputStream getBinaryStream() throws SerialException {
        this.checkValidation();
        return new ByteArrayInputStream(this.buf);
    }

    @Override
    public byte[] getBytes(long l, int n) throws SerialException {
        this.checkValidation();
        if (l < 1L || l > this.len || n < 0) {
            throw new SerialException(Messages.getString("sql.14"));
        }
        if ((long)n > this.len - l + 1L) {
            n = (int)(this.len - l + 1L);
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf, (int)l - 1, byArray, 0, n);
        return byArray;
    }

    @Override
    public long length() throws SerialException {
        this.checkValidation();
        return this.len;
    }

    @Override
    public long position(Blob blob, long l) throws SerialException, SQLException {
        this.checkValidation();
        byte[] byArray = blob.getBytes(1L, (int)blob.length());
        return this.position(byArray, l);
    }

    @Override
    public long position(byte[] byArray, long l) throws SerialException, SQLException {
        this.checkValidation();
        if (l < 1L || this.len - (l - 1L) < (long)byArray.length) {
            return -1L;
        }
        int n = (int)(l - 1L);
        while ((long)n <= this.len - (long)byArray.length) {
            if (this.match(this.buf, n, byArray)) {
                return n + 1;
            }
            ++n;
        }
        return -1L;
    }

    private boolean match(byte[] byArray, int n, byte[] byArray2) {
        int n2 = 0;
        while (n2 < byArray2.length) {
            if (byArray[n++] == byArray2[n2++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public OutputStream setBinaryStream(long l) throws SerialException, SQLException {
        this.checkValidation();
        if (this.blob == null) {
            throw new SerialException(Messages.getString("sql.18"));
        }
        OutputStream outputStream = this.blob.setBinaryStream(l);
        if (outputStream == null) {
            throw new SerialException(Messages.getString("sql.18"));
        }
        return outputStream;
    }

    @Override
    public int setBytes(long l, byte[] byArray) throws SerialException, SQLException {
        this.checkValidation();
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        this.checkValidation();
        if (l < 1L || n2 < 0 || l > this.len - (long)n2 + 1L) {
            throw new SerialException(Messages.getString("sql.15"));
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new SerialException(Messages.getString("sql.16"));
        }
        System.arraycopy(byArray, n, this.buf, (int)l - 1, n2);
        return n2;
    }

    @Override
    public void truncate(long l) throws SerialException {
        if (l > this.len) {
            this.checkValidation();
            throw new SerialException(Messages.getString("sql.17"));
        }
        this.buf = this.getBytes(1L, (int)l);
        this.len = l;
    }

    @Override
    public void free() throws SQLException {
        if (this.len != -1L) {
            this.len = -1L;
            this.blob = null;
            this.buf = null;
        }
    }

    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        this.checkValidation();
        return new ByteArrayInputStream(this.buf, (int)l, (int)l2);
    }

    private void checkValidation() throws SerialException {
        if (this.len == -1L) {
            throw new SerialException(Messages.getString("sql.38"));
        }
    }
}

