/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.DOMAESCBC;
import com.ibm.xml.enc.dom.DOMKWAES;
import com.ibm.xml.enc.dom.DOMKWTripleDES;
import com.ibm.xml.enc.dom.DOMRSA15;
import com.ibm.xml.enc.dom.DOMRSAOAEP;
import com.ibm.xml.enc.dom.DOMTripleDESCBC;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.enc.spec.EncryptionMethodParameterSpec;

public final class DOMEncManager {
    static AlgorithmMethod getEncryptionMethod(String alg, Integer keySize, AlgorithmParameterSpec params) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
            if (keySize != null && keySize != 128) {
                throw new NoSuchAlgorithmException("keysize doesn't match");
            }
            return new DOMAESCBC(alg, keySize, (AlgorithmParameterSpec)((EncryptionMethodParameterSpec)params));
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
            if (keySize != null && keySize != 192) {
                throw new NoSuchAlgorithmException("keysize doesn't match");
            }
            return new DOMAESCBC(alg, keySize, (AlgorithmParameterSpec)((EncryptionMethodParameterSpec)params));
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
            if (keySize != null && keySize != 256) {
                throw new NoSuchAlgorithmException("keysize doesn't match");
            }
            return new DOMAESCBC(alg, keySize, (AlgorithmParameterSpec)((EncryptionMethodParameterSpec)params));
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            return new DOMTripleDESCBC(keySize, (AlgorithmParameterSpec)((EncryptionMethodParameterSpec)params));
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5")) {
            return new DOMRSA15(keySize, (AlgorithmParameterSpec)((EncryptionMethodParameterSpec)params));
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) {
            return new DOMRSAOAEP(keySize, (AlgorithmParameterSpec)((EncryptionMethodParameterSpec)params));
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128")) {
            if (keySize != null && keySize != 128) {
                throw new NoSuchAlgorithmException("keysize doesn't match");
            }
            return new DOMKWAES("http://www.w3.org/2001/04/xmlenc#kw-aes128", keySize, params);
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192")) {
            if (keySize != null && keySize != 192) {
                throw new NoSuchAlgorithmException("keysize doesn't match");
            }
            return new DOMKWAES("http://www.w3.org/2001/04/xmlenc#kw-aes192", keySize, params);
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256")) {
            if (keySize != null && keySize != 256) {
                throw new NoSuchAlgorithmException("keysize doesn't match");
            }
            return new DOMKWAES("http://www.w3.org/2001/04/xmlenc#kw-aes256", keySize, params);
        }
        if (alg.equals("http://www.w3.org/2001/04/xmlenc#kw-tripledes")) {
            return new DOMKWTripleDES(keySize, params);
        }
        throw new NoSuchAlgorithmException("unsupported algorithm: " + alg);
    }
}

