/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.extObjectInputStream;

public class SealedObject
implements Serializable {
    static final long serialVersionUID = 4482838265551344752L;
    private byte[] encryptedContent = null;
    private String sealAlg = null;
    private String paramsAlg = null;
    protected byte[] encodedParams = null;
    private static String[] z;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SealedObject(Serializable serializable, Cipher cipher) throws IOException, IllegalBlockSizeException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        try {
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        finally {
            objectOutputStream.close();
        }
        try {
            this.encryptedContent = cipher.doFinal(byArray);
        }
        catch (BadPaddingException badPaddingException) {
            // empty catch block
        }
        if (cipher.getParameters() != null) {
            this.encodedParams = cipher.getParameters().getEncoded();
            this.paramsAlg = cipher.getParameters().getAlgorithm();
        }
        this.sealAlg = cipher.getAlgorithm();
    }

    protected SealedObject(SealedObject sealedObject) {
        this.encryptedContent = (byte[])sealedObject.encryptedContent.clone();
        this.sealAlg = sealedObject.sealAlg;
        this.paramsAlg = sealedObject.paramsAlg;
        this.encodedParams = (byte[])(sealedObject.encodedParams != null ? (byte[])sealedObject.encodedParams.clone() : null);
    }

    public final String getAlgorithm() {
        return this.sealAlg;
    }

    public final Object getObject(Key key) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, InvalidKeyException {
        if (key == null) {
            throw new NullPointerException(z[0]);
        }
        try {
            return this.a(key, null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(z[4]);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getObject(Cipher cipher) throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray = cipher.doFinal(this.encryptedContent);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        extObjectInputStream extObjectInputStream2 = new extObjectInputStream(byteArrayInputStream);
        try {
            Object object;
            Object object2 = object = extObjectInputStream2.readObject();
            return object2;
        }
        finally {
            extObjectInputStream2.close();
        }
    }

    public final Object getObject(Key key, String string) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        if (key == null) {
            throw new NullPointerException(z[0]);
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(z[1]);
        }
        try {
            return this.a(key, string);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object a(Key key, String string) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher;
        AlgorithmParameters algorithmParameters = null;
        if (this.encodedParams != null) {
            try {
                algorithmParameters = string != null ? AlgorithmParameters.getInstance(this.paramsAlg, string) : AlgorithmParameters.getInstance(this.paramsAlg);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                if (string == null) {
                    throw new NoSuchAlgorithmException(this.paramsAlg + z[3]);
                }
                throw new NoSuchProviderException(noSuchProviderException.getMessage());
            }
            algorithmParameters.init(this.encodedParams);
        }
        try {
            cipher = string != null ? Cipher.getInstance(this.sealAlg, string) : Cipher.getInstance(this.sealAlg);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException(z[2]);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (string == null) {
                throw new NoSuchAlgorithmException(this.sealAlg + z[3]);
            }
            throw new NoSuchProviderException(noSuchProviderException.getMessage());
        }
        try {
            if (algorithmParameters != null) {
                cipher.init(2, key, algorithmParameters);
            } else {
                cipher.init(2, key);
            }
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException(invalidAlgorithmParameterException.getMessage());
        }
        byte[] byArray = cipher.doFinal(this.encryptedContent);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        extObjectInputStream extObjectInputStream2 = new extObjectInputStream(byteArrayInputStream);
        try {
            Object object;
            Object object2 = object = extObjectInputStream2.readObject();
            return object2;
        }
        finally {
            extObjectInputStream2.close();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.encryptedContent != null) {
            this.encryptedContent = (byte[])this.encryptedContent.clone();
        }
        if (this.encodedParams != null) {
            this.encodedParams = (byte[])this.encodedParams.clone();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block54: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block53: {
                char[] cArray3;
                Object var0;
                block52: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block51: {
                        char[] cArray5;
                        block50: {
                            int n6;
                            int n7;
                            char[] cArray6;
                            block49: {
                                char[] cArray7;
                                block48: {
                                    int n8;
                                    int n9;
                                    char[] cArray8;
                                    block47: {
                                        char[] cArray9;
                                        block46: {
                                            int n10;
                                            int n11;
                                            char[] cArray10;
                                            block45: {
                                                stringArray = new String[5];
                                                var0 = null;
                                                char[] cArray11 = "/K\u00028e7\u000e\u0015m`(".toCharArray();
                                                n3 = 0;
                                                int n12 = cArray11.length;
                                                cArray10 = cArray11;
                                                n11 = n12;
                                                if (n12 <= 1) break block45;
                                                cArray9 = cArray10;
                                                n10 = n11;
                                                if (n11 <= n3) break block46;
                                            }
                                            do {
                                                char[] cArray12 = cArray10;
                                                char[] cArray13 = cArray10;
                                                int n13 = n3;
                                                while (true) {
                                                    int n14;
                                                    char c2 = cArray12[n13];
                                                    switch (n3 % 5) {
                                                        case 0: {
                                                            n14 = 68;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n14 = 46;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n14 = 123;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n14 = 24;
                                                            break;
                                                        }
                                                        default: {
                                                            n14 = 12;
                                                        }
                                                    }
                                                    cArray12[n13] = (char)(c2 ^ n14);
                                                    ++n3;
                                                    cArray10 = cArray13;
                                                    n11 = n11;
                                                    if (n11 != 0) break;
                                                    cArray13 = cArray10;
                                                    n10 = n11;
                                                    n13 = n11;
                                                    cArray12 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n10 = n11;
                                            } while (n11 > n3);
                                        }
                                        stringArray[0] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray14 = ")G\bke*I[h~+X\u0012|i6".toCharArray();
                                        n3 = 0;
                                        int n15 = cArray14.length;
                                        cArray8 = cArray14;
                                        n9 = n15;
                                        if (n15 <= 1) break block47;
                                        cArray7 = cArray8;
                                        n8 = n9;
                                        if (n9 <= n3) break block48;
                                    }
                                    do {
                                        char[] cArray15 = cArray8;
                                        char[] cArray16 = cArray8;
                                        int n16 = n3;
                                        while (true) {
                                            int n17;
                                            char c3 = cArray15[n16];
                                            switch (n3 % 5) {
                                                case 0: {
                                                    n17 = 68;
                                                    break;
                                                }
                                                case 1: {
                                                    n17 = 46;
                                                    break;
                                                }
                                                case 2: {
                                                    n17 = 123;
                                                    break;
                                                }
                                                case 3: {
                                                    n17 = 24;
                                                    break;
                                                }
                                                default: {
                                                    n17 = 12;
                                                }
                                            }
                                            cArray15[n16] = (char)(c3 ^ n17);
                                            ++n3;
                                            cArray8 = cArray16;
                                            n9 = n9;
                                            if (n9 != 0) break;
                                            cArray16 = cArray8;
                                            n8 = n9;
                                            n16 = n9;
                                            cArray15 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n8 = n9;
                                    } while (n9 > n3);
                                }
                                stringArray[1] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray17 = "\u0014O\u001f|e*I[ld%Z[om7\u000e\u000eki \u000e\u0012v,7K\u001ate*I[w|!\\\u001ale+@[vc0\u000e\u001anm-B\u001az`!".toCharArray();
                                n3 = 0;
                                int n18 = cArray17.length;
                                cArray6 = cArray17;
                                n7 = n18;
                                if (n18 <= 1) break block49;
                                cArray5 = cArray6;
                                n6 = n7;
                                if (n7 <= n3) break block50;
                            }
                            do {
                                char[] cArray18 = cArray6;
                                char[] cArray19 = cArray6;
                                int n19 = n3;
                                while (true) {
                                    int n20;
                                    char c4 = cArray18[n19];
                                    switch (n3 % 5) {
                                        case 0: {
                                            n20 = 68;
                                            break;
                                        }
                                        case 1: {
                                            n20 = 46;
                                            break;
                                        }
                                        case 2: {
                                            n20 = 123;
                                            break;
                                        }
                                        case 3: {
                                            n20 = 24;
                                            break;
                                        }
                                        default: {
                                            n20 = 12;
                                        }
                                    }
                                    cArray18[n19] = (char)(c4 ^ n20);
                                    ++n3;
                                    cArray6 = cArray19;
                                    n7 = n7;
                                    if (n7 != 0) break;
                                    cArray19 = cArray6;
                                    n6 = n7;
                                    n19 = n7;
                                    cArray18 = cArray6;
                                }
                                cArray5 = cArray6;
                                n6 = n7;
                            } while (n7 > n3);
                        }
                        stringArray[2] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray20 = "d@\u0014l,\"A\u000evh".toCharArray();
                        n3 = 0;
                        int n21 = cArray20.length;
                        cArray4 = cArray20;
                        n5 = n21;
                        if (n21 <= 1) break block51;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block52;
                    }
                    do {
                        char[] cArray21 = cArray4;
                        char[] cArray22 = cArray4;
                        int n22 = n3;
                        while (true) {
                            int n23;
                            char c5 = cArray21[n22];
                            switch (n3 % 5) {
                                case 0: {
                                    n23 = 68;
                                    break;
                                }
                                case 1: {
                                    n23 = 46;
                                    break;
                                }
                                case 2: {
                                    n23 = 123;
                                    break;
                                }
                                case 3: {
                                    n23 = 24;
                                    break;
                                }
                                default: {
                                    n23 = 12;
                                }
                            }
                            cArray21[n22] = (char)(c5 ^ n23);
                            ++n3;
                            cArray4 = cArray22;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray22 = cArray4;
                            n4 = n5;
                            n22 = n5;
                            cArray21 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[3] = new String(cArray3).intern();
                var0 = null;
                char[] cArray23 = "%B\u001cw~-Z\u0013u,*A\u000f8j+[\u0015|".toCharArray();
                n3 = 0;
                int n24 = cArray23.length;
                cArray2 = cArray23;
                n2 = n24;
                if (n24 <= 1) break block53;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block54;
            }
            do {
                char[] cArray24 = cArray2;
                char[] cArray25 = cArray2;
                int n25 = n3;
                while (true) {
                    int n26;
                    char c6 = cArray24[n25];
                    switch (n3 % 5) {
                        case 0: {
                            n26 = 68;
                            break;
                        }
                        case 1: {
                            n26 = 46;
                            break;
                        }
                        case 2: {
                            n26 = 123;
                            break;
                        }
                        case 3: {
                            n26 = 24;
                            break;
                        }
                        default: {
                            n26 = 12;
                        }
                    }
                    cArray24[n25] = (char)(c6 ^ n26);
                    ++n3;
                    cArray2 = cArray25;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray25 = cArray2;
                    n = n2;
                    n25 = n2;
                    cArray24 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[4] = new String(cArray).intern();
        z = stringArray;
    }
}

