/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public abstract class CipherSpi {
    private static String[] z;

    protected abstract void engineSetMode(String var1) throws NoSuchAlgorithmException;

    protected abstract void engineSetPadding(String var1) throws NoSuchPaddingException;

    protected abstract int engineGetBlockSize();

    protected abstract int engineGetOutputSize(int var1);

    protected abstract byte[] engineGetIV();

    protected abstract AlgorithmParameters engineGetParameters();

    protected abstract void engineInit(int var1, Key var2, SecureRandom var3) throws InvalidKeyException;

    protected abstract void engineInit(int var1, Key var2, AlgorithmParameterSpec var3, SecureRandom var4) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract void engineInit(int var1, Key var2, AlgorithmParameters var3, SecureRandom var4) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract byte[] engineUpdate(byte[] var1, int var2, int var3);

    protected abstract int engineUpdate(byte[] var1, int var2, int var3, byte[] var4, int var5) throws ShortBufferException;

    protected int engineUpdate(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException {
        try {
            return this.a(byteBuffer, byteBuffer2, true);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new ProviderException(z[0]);
        }
        catch (BadPaddingException badPaddingException) {
            throw new ProviderException(z[0]);
        }
    }

    protected abstract byte[] engineDoFinal(byte[] var1, int var2, int var3) throws IllegalBlockSizeException, BadPaddingException;

    protected abstract int engineDoFinal(byte[] var1, int var2, int var3, byte[] var4, int var5) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException;

    protected int engineDoFinal(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.a(byteBuffer, byteBuffer2, false);
    }

    static int a(int n) {
        return Math.min(4096, n);
    }

    private int a(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n;
        byte[] byArray;
        int n2;
        if (byteBuffer == null || byteBuffer2 == null) {
            throw new NullPointerException(z[3]);
        }
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        if (bl && n2 == 0) {
            return 0;
        }
        int n5 = this.engineGetOutputSize(n2);
        if (byteBuffer2.remaining() < n5) {
            throw new ShortBufferException(z[2] + n5 + z[1]);
        }
        boolean bl2 = byteBuffer.hasArray();
        boolean bl3 = byteBuffer2.hasArray();
        if (bl2 && bl3) {
            byte[] byArray2 = byteBuffer.array();
            int n6 = byteBuffer.arrayOffset() + n3;
            byte[] byArray3 = byteBuffer2.array();
            int n7 = byteBuffer2.position();
            int n8 = byteBuffer2.arrayOffset() + n7;
            int n9 = bl ? this.engineUpdate(byArray2, n6, n2, byArray3, n8) : this.engineDoFinal(byArray2, n6, n2, byArray3, n8);
            byteBuffer.position(n4);
            byteBuffer2.position(n7 + n9);
            return n9;
        }
        if (!bl2 && bl3) {
            int n10;
            int n11 = byteBuffer2.position();
            byte[] byArray4 = byteBuffer2.array();
            int n12 = byteBuffer2.arrayOffset() + n11;
            byte[] byArray5 = new byte[CipherSpi.a(n2)];
            int n13 = 0;
            for (n2 = n4 - n3; n2 > 0; n2 -= n10) {
                n10 = Math.min(n2, byArray5.length);
                byteBuffer.get(byArray5, 0, n10);
                int n14 = bl || n2 != n10 ? this.engineUpdate(byArray5, 0, n10, byArray4, n12) : this.engineDoFinal(byArray5, 0, n10, byArray4, n12);
                n13 += n14;
                n12 += n14;
            }
            byteBuffer2.position(n11 + n13);
            return n13;
        }
        if (bl2) {
            byArray = byteBuffer.array();
            n = byteBuffer.arrayOffset() + n3;
        } else {
            byArray = new byte[CipherSpi.a(n2)];
            n = 0;
        }
        byte[] byArray6 = new byte[CipherSpi.a(n5)];
        int n15 = byArray6.length;
        int n16 = 0;
        boolean bl4 = false;
        while (n2 > 0) {
            int n17 = Math.min(n2, n15);
            if (!bl2 && !bl4) {
                byteBuffer.get(byArray, 0, n17);
                n = 0;
            }
            try {
                int n18 = bl || n2 != n17 ? this.engineUpdate(byArray, n, n17, byArray6, 0) : this.engineDoFinal(byArray, n, n17, byArray6, 0);
                bl4 = false;
                n += n17;
                n2 -= n17;
                byteBuffer2.put(byArray6, 0, n18);
                n16 += n18;
            }
            catch (ShortBufferException shortBufferException) {
                if (bl4) {
                    throw (ProviderException)new ProviderException(z[4]).initCause(shortBufferException);
                }
                bl4 = true;
                int n19 = this.engineGetOutputSize(n17);
                byArray6 = new byte[n19];
            }
        }
        byteBuffer.position(n4);
        return n16;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        throw new UnsupportedOperationException();
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block54: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block53: {
                char[] cArray3;
                Object var0;
                block52: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block51: {
                        char[] cArray5;
                        block50: {
                            int n6;
                            int n7;
                            char[] cArray6;
                            block49: {
                                char[] cArray7;
                                block48: {
                                    int n8;
                                    int n9;
                                    char[] cArray8;
                                    block47: {
                                        char[] cArray9;
                                        block46: {
                                            int n10;
                                            int n11;
                                            char[] cArray10;
                                            block45: {
                                                stringArray = new String[5];
                                                var0 = null;
                                                char[] cArray11 = "8\b3Bg\u001f\u0007+\u0007p\u0003\u0014(U5\u0018\bgRe\u0015\u00073B=X".toCharArray();
                                                n3 = 0;
                                                int n12 = cArray11.length;
                                                cArray10 = cArray11;
                                                n11 = n12;
                                                if (n12 <= 1) break block45;
                                                cArray9 = cArray10;
                                                n10 = n11;
                                                if (n11 <= n3) break block46;
                                            }
                                            do {
                                                char[] cArray12 = cArray10;
                                                char[] cArray13 = cArray10;
                                                int n13 = n3;
                                                while (true) {
                                                    int n14;
                                                    char c2 = cArray12[n13];
                                                    switch (n3 % 5) {
                                                        case 0: {
                                                            n14 = 113;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n14 = 102;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n14 = 71;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n14 = 39;
                                                            break;
                                                        }
                                                        default: {
                                                            n14 = 21;
                                                        }
                                                    }
                                                    cArray12[n13] = (char)(c2 ^ n14);
                                                    ++n3;
                                                    cArray10 = cArray13;
                                                    n11 = n11;
                                                    if (n11 != 0) break;
                                                    cArray13 = cArray10;
                                                    n10 = n11;
                                                    n13 = n11;
                                                    cArray12 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n10 = n11;
                                            } while (n11 > n3);
                                        }
                                        stringArray[0] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray14 = "Q\u0004>Sp\u0002F(A5\u0002\u0016&DpQ\u000f)\u0007z\u0004\u00127RaQ\u00042As\u0014\u0014".toCharArray();
                                        n3 = 0;
                                        int n15 = cArray14.length;
                                        cArray8 = cArray14;
                                        n9 = n15;
                                        if (n15 <= 1) break block47;
                                        cArray7 = cArray8;
                                        n8 = n9;
                                        if (n9 <= n3) break block48;
                                    }
                                    do {
                                        char[] cArray15 = cArray8;
                                        char[] cArray16 = cArray8;
                                        int n16 = n3;
                                        while (true) {
                                            int n17;
                                            char c3 = cArray15[n16];
                                            switch (n3 % 5) {
                                                case 0: {
                                                    n17 = 113;
                                                    break;
                                                }
                                                case 1: {
                                                    n17 = 102;
                                                    break;
                                                }
                                                case 2: {
                                                    n17 = 71;
                                                    break;
                                                }
                                                case 3: {
                                                    n17 = 39;
                                                    break;
                                                }
                                                default: {
                                                    n17 = 21;
                                                }
                                            }
                                            cArray15[n16] = (char)(c3 ^ n17);
                                            ++n3;
                                            cArray8 = cArray16;
                                            n9 = n9;
                                            if (n9 != 0) break;
                                            cArray16 = cArray8;
                                            n8 = n9;
                                            n16 = n9;
                                            cArray15 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n8 = n9;
                                    } while (n9 > n3);
                                }
                                stringArray[1] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray17 = "?\u0003\"C5\u0010\u0012gKp\u0010\u00153\u0007".toCharArray();
                                n3 = 0;
                                int n18 = cArray17.length;
                                cArray6 = cArray17;
                                n7 = n18;
                                if (n18 <= 1) break block49;
                                cArray5 = cArray6;
                                n6 = n7;
                                if (n7 <= n3) break block50;
                            }
                            do {
                                char[] cArray18 = cArray6;
                                char[] cArray19 = cArray6;
                                int n19 = n3;
                                while (true) {
                                    int n20;
                                    char c4 = cArray18[n19];
                                    switch (n3 % 5) {
                                        case 0: {
                                            n20 = 113;
                                            break;
                                        }
                                        case 1: {
                                            n20 = 102;
                                            break;
                                        }
                                        case 2: {
                                            n20 = 71;
                                            break;
                                        }
                                        case 3: {
                                            n20 = 39;
                                            break;
                                        }
                                        default: {
                                            n20 = 21;
                                        }
                                    }
                                    cArray18[n19] = (char)(c4 ^ n20);
                                    ++n3;
                                    cArray6 = cArray19;
                                    n7 = n7;
                                    if (n7 != 0) break;
                                    cArray19 = cArray6;
                                    n6 = n7;
                                    n19 = n7;
                                    cArray18 = cArray6;
                                }
                                cArray5 = cArray6;
                                n6 = n7;
                            } while (n7 > n3);
                        }
                        stringArray[2] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray20 = "8\b7RaQ\u0007)C5\u001e\u00133W`\u0005F%Rs\u0017\u00035T5\u001c\u00134S5\u001f\t3\u0007w\u0014F)Ry\u001d".toCharArray();
                        n3 = 0;
                        int n21 = cArray20.length;
                        cArray4 = cArray20;
                        n5 = n21;
                        if (n21 <= 1) break block51;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block52;
                    }
                    do {
                        char[] cArray21 = cArray4;
                        char[] cArray22 = cArray4;
                        int n22 = n3;
                        while (true) {
                            int n23;
                            char c5 = cArray21[n22];
                            switch (n3 % 5) {
                                case 0: {
                                    n23 = 113;
                                    break;
                                }
                                case 1: {
                                    n23 = 102;
                                    break;
                                }
                                case 2: {
                                    n23 = 71;
                                    break;
                                }
                                case 3: {
                                    n23 = 39;
                                    break;
                                }
                                default: {
                                    n23 = 21;
                                }
                            }
                            cArray21[n22] = (char)(c5 ^ n23);
                            ++n3;
                            cArray4 = cArray22;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray22 = cArray4;
                            n4 = n5;
                            n22 = n5;
                            cArray21 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[3] = new String(cArray3).intern();
                var0 = null;
                char[] cArray23 = "2\t2KqQ\b(S5\u0015\u00033Bg\u001c\u000f)B5\u0013\u0013!Ap\u0003F4No\u0014".toCharArray();
                n3 = 0;
                int n24 = cArray23.length;
                cArray2 = cArray23;
                n2 = n24;
                if (n24 <= 1) break block53;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block54;
            }
            do {
                char[] cArray24 = cArray2;
                char[] cArray25 = cArray2;
                int n25 = n3;
                while (true) {
                    int n26;
                    char c6 = cArray24[n25];
                    switch (n3 % 5) {
                        case 0: {
                            n26 = 113;
                            break;
                        }
                        case 1: {
                            n26 = 102;
                            break;
                        }
                        case 2: {
                            n26 = 71;
                            break;
                        }
                        case 3: {
                            n26 = 39;
                            break;
                        }
                        default: {
                            n26 = 21;
                        }
                    }
                    cArray24[n25] = (char)(c6 ^ n26);
                    ++n3;
                    cArray2 = cArray25;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray25 = cArray2;
                    n = n2;
                    n25 = n2;
                    cArray24 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[4] = new String(cArray).intern();
        z = stringArray;
    }
}

