/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionQueue;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.pkcs11.PKCS11Slot;
import com.ibm.pkcs11.PKCS11TokenInfo;
import java.util.Hashtable;
import java.util.Iterator;

public class SessionManager {
    private static final int DEFAULT_MAX_SESSIONS = 32;
    private PKCS11Slot tokenSlot;
    private SessionQueue opSessionQueue;
    private SessionQueue objSessionQueue;
    private int openSessionFlags;
    private int maxSessionCount;
    private int sessionCount;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static Hashtable managerTable = new Hashtable(1);

    SessionManager(PKCS11Slot tokenSlot) throws PKCS11Exception {
        int maxCount;
        if (debug != null) {
            debug.entry(16384L, (Object)"SessionManager", "SessionManager(PKCS11Slot)");
        }
        this.tokenSlot = tokenSlot;
        this.opSessionQueue = new SessionQueue();
        this.objSessionQueue = new SessionQueue();
        PKCS11TokenInfo token = tokenSlot.getTokenInfo();
        int flags = token.flags();
        if ((flags & 2) != 0) {
            maxCount = token.maxSessionCount();
            this.openSessionFlags = 4;
        } else {
            maxCount = token.maxRwSessionCount();
            this.openSessionFlags = 6;
        }
        if (maxCount == 0) {
            this.maxSessionCount = Integer.MAX_VALUE;
            if (debug != null) {
                debug.text(16384L, (Object)"SessionManager", "SessionManager(PKCS11Slot)", "max session count is infinite");
            }
        } else if (maxCount < 0) {
            this.maxSessionCount = 32;
            if (debug != null) {
                debug.text(16384L, (Object)"SessionManager", "SessionManager(PKCS11Slot)", "max session count is not available");
            }
        } else {
            this.maxSessionCount = maxCount;
            if (debug != null) {
                debug.text(16384L, (Object)"SessionManager", "SessionManager(PKCS11Slot)", "max session count=" + maxCount);
            }
        }
        this.openOpSession();
        managerTable.put(tokenSlot, this);
        if (debug != null) {
            debug.exit(16384L, (Object)"SessionManager", "SessionManager(PKCS11Slot)");
        }
    }

    public static SessionManager getInstance(PKCS11Slot tokenSlot) {
        SessionManager temp = null;
        temp = (SessionManager)managerTable.get(tokenSlot);
        if (temp != null) {
            return temp;
        }
        return new SessionManager(tokenSlot);
    }

    public synchronized Session getOpSession() throws PKCS11Exception {
        if (debug != null) {
            debug.entry(16384L, (Object)"SessionManager", "getOpSession()");
        }
        if (this.opSessionQueue.isEmpty()) {
            if (debug != null) {
                debug.text(16384L, (Object)"SessionManager", "getOpSession", "opSession queue is empty");
            }
            if (this.sessionCount < this.maxSessionCount) {
                this.openOpSession();
                Session sess = this.opSessionQueue.poll();
                --this.sessionCount;
                if (debug != null) {
                    debug.text(16384L, (Object)"SessionManager", "getOpSession()", "session handle = " + sess.getID() + ", session count = " + this.sessionCount + ", session " + sess);
                    debug.exit(16384L, (Object)"SessionManager", "getOpSession()");
                }
                return sess;
            }
            Session sess = this.objSessionQueue.poll();
            if (sess != null) {
                --this.sessionCount;
                if (debug != null) {
                    debug.text(16384L, (Object)"SessionManager", "getOpSession()", "get ObjSession, session handle = " + sess.getID() + ", session count = " + this.sessionCount + ", session " + sess);
                    debug.exit(16384L, (Object)"SessionManager", "getOpSession()");
                }
                return sess;
            }
            throw new PKCS11Exception("number of active sessions reached the max");
        }
        Session sess = this.opSessionQueue.poll();
        --this.sessionCount;
        if (debug != null) {
            debug.text(16384L, (Object)"SessionManager", "getOpSession()", "session handle = " + sess.getID() + ", session count = " + this.sessionCount + ", session " + sess);
            debug.exit(16384L, (Object)"SessionManager", "getOpSession()");
        }
        return sess;
    }

    public synchronized Session getObjSession() throws PKCS11Exception {
        if (debug != null) {
            debug.entry(16384L, (Object)"SessionManager", "getObjSession");
        }
        if (this.objSessionQueue.isEmpty()) {
            if (debug != null) {
                debug.text(16384L, (Object)"SessionManager", "getObjSession", "object session queue is empty");
            }
            if (this.sessionCount < this.maxSessionCount) {
                this.openObjSession();
                Session sess = this.objSessionQueue.poll();
                --this.sessionCount;
                if (debug != null) {
                    debug.text(16384L, (Object)"SessionManager", "getObjSession()", "obj session handle = " + sess.getID() + ", session count=" + this.sessionCount + ", session " + sess);
                    debug.exit(16384L, (Object)"SessionManager", "getObjSession()");
                }
                return sess;
            }
            Session sess = this.opSessionQueue.poll();
            if (sess != null) {
                --this.sessionCount;
                if (debug != null) {
                    debug.text(16384L, (Object)"SessionManager", "getObjSession()", "get obj session handle = " + sess.getID() + ", session count = " + this.sessionCount + ", session " + sess);
                    debug.exit(16384L, (Object)"SessionManager", "getObjSession");
                }
                return sess;
            }
            throw new PKCS11Exception("number of active sessions reached the max");
        }
        Session sess = this.objSessionQueue.poll();
        --this.sessionCount;
        if (debug != null) {
            debug.text(16384L, (Object)"SessionManager", "getObjSession()", "get obj session handle = " + sess.getID() + ", session count = " + this.sessionCount + ", session " + sess);
            debug.exit(16384L, (Object)"SessionManager", "getObjSession");
        }
        return sess;
    }

    private void openOpSession() throws PKCS11Exception {
        this.openSession(false);
    }

    private void openObjSession() throws PKCS11Exception {
        this.openSession(true);
    }

    private void openSession(boolean objSession) throws PKCS11Exception {
        PKCS11Session pkcs11Session;
        block11: {
            if (this.sessionCount >= this.maxSessionCount) {
                throw new PKCS11Exception("No more sessions available");
            }
            if (debug != null) {
                debug.text(16384L, (Object)"SessionManager", "openSession", "object session ? " + objSession);
            }
            pkcs11Session = null;
            try {
                pkcs11Session = this.tokenSlot.openSession(this.openSessionFlags, null, null);
            }
            catch (PKCS11Exception e) {
                if (debug != null) {
                    debug.exception(16384L, (Object)"SessionManager", "openOpSession", (Throwable)e);
                }
                if (e.getCode() != 226) break block11;
                pkcs11Session = this.tokenSlot.openSession(4, null, null);
            }
        }
        if (pkcs11Session != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"SessionManager", "openSession(boolean)", "open new session handle = " + pkcs11Session.getID());
            }
            ++this.sessionCount;
            if (objSession) {
                this.objSessionQueue.add(new Session(this, pkcs11Session, objSession));
            } else {
                this.opSessionQueue.add(new Session(this, pkcs11Session, false));
            }
        } else if (debug != null) {
            debug.text(16384L, (Object)"SessionManager", "openSession", "tokenSlot.openSession returns null");
        }
    }

    public PKCS11TokenInfo getToken() {
        return this.tokenSlot.getTokenInfo();
    }

    public PKCS11Slot getTokenSlot() {
        return this.tokenSlot;
    }

    public synchronized void releaseSession(Session session) {
        if (debug != null) {
            debug.entry(16384L, (Object)"SessionManager", "releaseSession");
            debug.text(16384L, (Object)"SessionManager", "releaseSession", "release session handle = " + session.getID() + ", session " + session);
        }
        long time = System.currentTimeMillis();
        session.setAccessTime(time);
        if (session.hasObjects()) {
            this.objSessionQueue.add(session);
            ++this.sessionCount;
            if (debug != null) {
                debug.text(16384L, (Object)"SessionManager", "releaseSession", "session has object, session count = " + this.sessionCount);
            }
        } else {
            this.opSessionQueue.add(session);
            session.setObjSession(false);
            ++this.sessionCount;
            if (debug != null) {
                debug.text(16384L, (Object)"SessionManager", "releaseSession", "session count = " + this.sessionCount);
            }
            if (this.opSessionQueue.size() > 5 && this.opSessionQueue.cleanup(time)) {
                --this.sessionCount;
                if (debug != null) {
                    debug.text(16384L, (Object)"SessionManager", "releaseSession", "session count = " + this.sessionCount);
                }
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"SessionManager", "releaseSession");
        }
    }

    public synchronized void releaseSessionAndObj(Session session) {
        if (debug != null) {
            debug.entry(16384L, (Object)"SessionManager", "releaseSessionAndObj");
            debug.text(16384L, (Object)"SessionManager", "releaseSessionAndObj", "release session handle = " + session.getID());
        }
        long time = System.currentTimeMillis();
        session.setAccessTime(time);
        session.removeObject();
        if (!session.hasObjects()) {
            session.setObjSession(false);
            this.opSessionQueue.add(session);
            if (this.opSessionQueue.size() > 5) {
                this.opSessionQueue.cleanup(time);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"SessionManager", "releaseSessionAndObj");
        }
    }

    public synchronized void demoteObjSession(Session objSession) {
        boolean present;
        if (debug != null) {
            debug.entry(16384L, (Object)"SessionManager", "demoteObjSession");
        }
        if (!(present = this.objSessionQueue.remove(objSession))) {
            if (debug != null) {
                debug.text(16384L, (Object)"SessionManager", "demoteObjSession", "session handle " + objSession.getID() + " not in queue");
                debug.exit(16384L, (Object)"SessionManager", "demoteObjSession");
            }
            return;
        }
        long time = System.currentTimeMillis();
        objSession.setAccessTime(time);
        objSession.setObjSession(false);
        this.opSessionQueue.add(objSession);
        if (this.opSessionQueue.size() > 5 && this.opSessionQueue.cleanup(time)) {
            --this.sessionCount;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"SessionManager", "demoteObjSession");
        }
    }

    public synchronized void closeSession(Session session) {
        if (debug != null) {
            debug.entry(16384L, (Object)"SessionManager", "closeSession");
            debug.text(16384L, (Object)"SessionManager", "closeSession", "close session handle = " + session.getID());
        }
        if (session != null) {
            session.close();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"SessionManager", "closeSession");
        }
    }

    public synchronized void closeAllSessions() {
        if (debug != null) {
            debug.entry(16384L, (Object)"SessionManager", "closeAllSessions");
        }
        Iterator it = this.objSessionQueue.allSessions().iterator();
        while (it.hasNext()) {
            this.closeSession((Session)it.next());
        }
        this.objSessionQueue = new SessionQueue();
        it = this.opSessionQueue.allSessions().iterator();
        while (it.hasNext()) {
            this.closeSession((Session)it.next());
        }
        this.opSessionQueue = new SessionQueue();
        if (debug != null) {
            debug.exit(16384L, (Object)"SessionManger", "closeAllSessions");
        }
    }
}

