/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11KeySpec;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public final class RSAPKCS11KeyFactory
extends KeyFactorySpi {
    private SessionManager sessionManager = null;
    private Config config = null;
    private static Debug debug1 = Debug.getInstance((String)"pkcs11impl");
    private static Debug debug2 = Debug.getInstance((String)"rsapkcs11keyfactory");
    private static Debug debug = debug1 == null ? debug2 : debug1;
    private static String className = "com.ibm.crypto.pkcs11impl.provider.RSAPKCS11KeyFactory";

    public RSAPKCS11KeyFactory(Provider provider) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RSAPKCS11KeyFactory");
        }
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "RSAPKCS11KeyFactory");
        }
    }

    public RSAPKCS11KeyFactory() {
        this(Security.getProvider("IBMPKCS11Impl"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGeneratePublic", (Object)keySpec);
        }
        try {
            if (keySpec instanceof RSAPublicKeySpec) {
                RSAPublicKeySpec rsaPubKeySpec = (RSAPublicKeySpec)keySpec;
                PKCS11Object object = null;
                byte[] ID = null;
                Boolean isToken = Boolean.FALSE;
                Boolean isVerify = Boolean.TRUE;
                Boolean isEncrypt = Boolean.TRUE;
                Boolean isWrap = Boolean.TRUE;
                BigInteger modulus = rsaPubKeySpec.getModulus();
                Integer modulusBits = new Integer(String.valueOf(rsaPubKeySpec.getModulus().toByteArray().length * 8));
                BigInteger publicExponent = rsaPubKeySpec.getPublicExponent();
                int[] attrTypes = null;
                Object[] attrValues = null;
                ID = this.genID();
                HashMap<Integer, Object> hattrs = null;
                Set<Integer> keys = null;
                int numEles = 0;
                if (this.config != null) {
                    hattrs = this.config.getAttributes("IMPORT", PKCS11Object.PUBLIC_KEY, PKCS11Object.RSA);
                    keys = hattrs.keySet();
                    numEles = keys.size();
                    attrTypes = new int[5 + numEles];
                    attrValues = new Object[5 + numEles];
                    attrTypes[0] = 0;
                    attrTypes[1] = 256;
                    attrTypes[2] = 258;
                    attrTypes[3] = 288;
                    attrTypes[4] = 290;
                    attrValues[0] = PKCS11Object.PUBLIC_KEY;
                    attrValues[1] = PKCS11Object.RSA;
                    attrValues[2] = ID;
                    attrValues[3] = modulus;
                    attrValues[4] = publicExponent;
                    Iterator<Integer> it = keys.iterator();
                    int i = 1;
                    while (it.hasNext()) {
                        Integer key = it.next();
                        attrTypes[4 + i] = key;
                        attrValues[4 + i] = hattrs.get(key);
                        ++i;
                    }
                } else {
                    attrTypes = new int[]{0, 256, 258, 1, 266, 260, 262, 288, 290};
                    attrValues = new Object[]{PKCS11Object.PUBLIC_KEY, PKCS11Object.RSA, ID, isToken, isVerify, isEncrypt, isWrap, modulus, publicExponent};
                }
                Session session = null;
                try {
                    session = this.sessionManager.getObjSession();
                    object = session.createObject(attrTypes, attrValues);
                    if (session.getBoolAttributeValue(object, 1)) {
                        session.addObject();
                    }
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGeneratePublic_1");
                    }
                    RSAPublicKey rSAPublicKey = new RSAPublicKey(session, object, ID, null, null, isToken, isVerify, isEncrypt, isWrap, modulus, modulusBits, publicExponent);
                    return rSAPublicKey;
                }
                finally {
                    this.sessionManager.releaseSession(session);
                }
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePublic_2");
                }
                Session session = null;
                try {
                    session = this.sessionManager.getObjSession();
                    RSAPublicKey object = new RSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded(), session, this.config);
                    return object;
                }
                finally {
                    this.sessionManager.releaseSession(session);
                }
            }
            if (!(keySpec instanceof PKCS11KeySpec)) {
                if (debug == null) throw new InvalidKeySpecException("Inappropriate key specification");
                debug.text(16384L, (Object)className, "engineGeneratePublic", "Inappropriate key specification");
                debug.exit(16384L, (Object)className, "engineGeneratePublic");
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "engineGeneratePublic_3");
            }
            PKCS11Object object = ((PKCS11KeySpec)keySpec).getObject();
            Session session = null;
            try {
                session = this.sessionManager.getOpSession();
                RSAPublicKey rSAPublicKey = new RSAPublicKey(session, object, (byte[])this.getAttrValue(session, object, 258), (byte[])this.getAttrValue(session, object, 257), (String)this.getAttrValue(session, object, 3), (Boolean)this.getAttrValue(session, object, 1), (Boolean)this.getAttrValue(session, object, 266), (Boolean)this.getAttrValue(session, object, 260), (Boolean)this.getAttrValue(session, object, 262), (BigInteger)this.getAttrValue(session, object, 288), (Integer)this.getAttrValue(session, object, 289), (BigInteger)this.getAttrValue(session, object, 290));
                return rSAPublicKey;
            }
            finally {
                this.sessionManager.releaseSession(session);
            }
        }
        catch (InvalidKeyException e) {
            if (debug == null) throw new InvalidKeySpecException("Inappropriate key specification: " + e.getMessage());
            debug.exception(16384L, (Object)className, "engineGeneratePublic", (Throwable)e);
            debug.exit(16384L, (Object)className, "engineGeneratePublic");
            throw new InvalidKeySpecException("Inappropriate key specification: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGeneratePrivate", (Object)keySpec);
        }
        try {
            PKCS11Object object = null;
            byte[] ID = null;
            Boolean isToken = Boolean.FALSE;
            Boolean isSensitive = Boolean.FALSE;
            Boolean isSign = Boolean.TRUE;
            Boolean isDecrypt = Boolean.TRUE;
            Boolean isUnwrap = Boolean.TRUE;
            Boolean isExtractable = null;
            BigInteger modulus = null;
            BigInteger publicExponent = null;
            BigInteger privateExponent = null;
            BigInteger prime1 = null;
            BigInteger prime2 = null;
            BigInteger exponent1 = null;
            BigInteger exponent2 = null;
            BigInteger coefficient = null;
            int[] attrTypes = null;
            Object[] attrValues = null;
            if (keySpec instanceof RSAPrivateCrtKeySpec) {
                RSAPrivateCrtKeySpec rsaPrivKeySpec = (RSAPrivateCrtKeySpec)keySpec;
                ID = this.genID();
                modulus = rsaPrivKeySpec.getModulus();
                publicExponent = rsaPrivKeySpec.getPublicExponent();
                privateExponent = rsaPrivKeySpec.getPrivateExponent();
                prime1 = rsaPrivKeySpec.getPrimeP();
                prime2 = rsaPrivKeySpec.getPrimeQ();
                exponent1 = rsaPrivKeySpec.getPrimeExponentP();
                exponent2 = rsaPrivKeySpec.getPrimeExponentQ();
                coefficient = rsaPrivKeySpec.getCrtCoefficient();
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "Modulus: " + modulus);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "publicExponent: " + publicExponent);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "privateExponent: " + privateExponent);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "prime1: " + prime1);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "prime2: " + prime2);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "exponent1: " + exponent1);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "exponent2: " + exponent2);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "coefficient: " + coefficient);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "ID: " + ID);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "isToken: " + isToken);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "isSensitive: " + isSensitive);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "isSign: " + isSign);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "isDecrypt: " + isDecrypt);
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "isUnwrap: " + isUnwrap);
                }
                HashMap<Integer, Object> hattrs = null;
                Set<Integer> keys = null;
                int numEles = 0;
                if (this.config != null) {
                    hattrs = this.config.getAttributes("IMPORT", PKCS11Object.PRIVATE_KEY, PKCS11Object.RSA);
                    keys = hattrs.keySet();
                    numEles = keys.size();
                    attrTypes = new int[11 + numEles];
                    attrValues = new Object[11 + numEles];
                    attrTypes[0] = 0;
                    attrTypes[1] = 256;
                    attrTypes[2] = 258;
                    attrTypes[3] = 288;
                    attrTypes[4] = 290;
                    attrTypes[5] = 291;
                    attrTypes[6] = 292;
                    attrTypes[7] = 293;
                    attrTypes[8] = 294;
                    attrTypes[9] = 295;
                    attrTypes[10] = 296;
                    attrValues[0] = PKCS11Object.PRIVATE_KEY;
                    attrValues[1] = PKCS11Object.RSA;
                    attrValues[2] = ID;
                    attrValues[3] = modulus;
                    attrValues[4] = publicExponent;
                    attrValues[5] = privateExponent;
                    attrValues[6] = prime1;
                    attrValues[7] = prime2;
                    attrValues[8] = exponent1;
                    attrValues[9] = exponent2;
                    attrValues[10] = coefficient;
                    Iterator<Integer> it = keys.iterator();
                    int i = 1;
                    while (it.hasNext()) {
                        Integer key = it.next();
                        attrTypes[10 + i] = key;
                        attrValues[10 + i] = hattrs.get(key);
                        ++i;
                    }
                } else {
                    attrTypes = new int[]{0, 256, 258, 1, 2, 259, 264, 261, 263, 288, 290, 291, 292, 293, 294, 295, 296};
                    attrValues = new Object[]{PKCS11Object.PRIVATE_KEY, PKCS11Object.RSA, ID, isToken, Boolean.TRUE, isSensitive, isSign, isDecrypt, isUnwrap, modulus, publicExponent, privateExponent, prime1, prime2, exponent1, exponent2, coefficient};
                }
                Session session = this.sessionManager.getObjSession();
                try {
                    object = session.createObject(attrTypes, attrValues);
                    if (session.getBoolAttributeValue(object, 1)) {
                        session.addObject();
                    }
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGeneratePrivate_1");
                    }
                    RSAPrivateKey i = new RSAPrivateKey(session, object, ID, null, null, isToken, isSensitive, isSign, isDecrypt, isUnwrap, isExtractable, modulus, publicExponent, privateExponent, prime1, prime2, exponent1, exponent2, coefficient);
                    return i;
                }
                finally {
                    this.sessionManager.releaseSession(session);
                }
            }
            if (keySpec instanceof RSAPrivateKeySpec) {
                RSAPrivateKeySpec rsaPrivKeySpec = (RSAPrivateKeySpec)keySpec;
                ID = this.genID();
                modulus = rsaPrivKeySpec.getModulus();
                privateExponent = rsaPrivKeySpec.getPrivateExponent();
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "Modulus not CRT: " + modulus.intValue());
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "privateExponent length not CRT: " + privateExponent.bitLength());
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "privateExponent not CRT: " + privateExponent);
                }
                HashMap<Integer, Object> hattrs = null;
                Set<Integer> keys = null;
                int numEles = 0;
                if (this.config != null) {
                    hattrs = this.config.getAttributes("IMPORT", PKCS11Object.PRIVATE_KEY, PKCS11Object.RSA);
                    keys = hattrs.keySet();
                    numEles = keys.size();
                    attrTypes = new int[5 + numEles];
                    attrValues = new Object[5 + numEles];
                    attrTypes[0] = 0;
                    attrTypes[1] = 256;
                    attrTypes[2] = 258;
                    attrTypes[3] = 288;
                    attrTypes[4] = 291;
                    attrValues[0] = PKCS11Object.PRIVATE_KEY;
                    attrValues[1] = PKCS11Object.RSA;
                    attrValues[2] = ID;
                    attrValues[3] = modulus;
                    attrValues[4] = privateExponent;
                    Iterator<Integer> it = keys.iterator();
                    int i = 1;
                    while (it.hasNext()) {
                        Integer key = it.next();
                        attrTypes[4 + i] = key;
                        attrValues[4 + i] = hattrs.get(key);
                        ++i;
                    }
                } else {
                    attrTypes = new int[]{0, 256, 258, 1, 2, 259, 264, 261, 263, 288, 291};
                    attrValues = new Object[]{PKCS11Object.PRIVATE_KEY, PKCS11Object.RSA, ID, isToken, Boolean.TRUE, isSensitive, isSign, isDecrypt, isUnwrap, modulus, privateExponent};
                }
                Session session = null;
                try {
                    session = this.sessionManager.getObjSession();
                    object = session.createObject(attrTypes, attrValues);
                    if (session.getBoolAttributeValue(object, 1)) {
                        session.addObject();
                    }
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGeneratePrivate_2");
                    }
                    RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(session, object, ID, null, null, isToken, isSensitive, isSign, isDecrypt, isUnwrap, isExtractable, modulus, publicExponent, privateExponent, prime1, prime2, exponent1, exponent2, coefficient);
                    return rSAPrivateKey;
                }
                finally {
                    this.sessionManager.releaseSession(session);
                }
            }
            if (!(keySpec instanceof PKCS11KeySpec)) {
                if (debug == null) throw new InvalidKeySpecException("Inappropriate key specification");
                debug.text(16384L, (Object)className, "engineGeneratePrivate", "Inappropriate key specification");
                debug.exit(16384L, (Object)className, "engineGeneratePrivate");
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "engineGeneratePublic_3");
            }
            object = ((PKCS11KeySpec)keySpec).getObject();
            Session session = null;
            try {
                session = this.sessionManager.getOpSession();
                RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(session, object, (byte[])this.getAttrValue(session, object, 258), (byte[])this.getAttrValue(session, object, 257), (String)this.getAttrValue(session, object, 3), (Boolean)this.getAttrValue(session, object, 1), (Boolean)this.getAttrValue(session, object, 259), (Boolean)this.getAttrValue(session, object, 264), (Boolean)this.getAttrValue(session, object, 261), (Boolean)this.getAttrValue(session, object, 263), (Boolean)this.getAttrValue(session, object, 354), (BigInteger)this.getAttrValue(session, object, 288), (BigInteger)this.getAttrValue(session, object, 290), (BigInteger)this.getAttrValue(session, object, 291), (BigInteger)this.getAttrValue(session, object, 292), (BigInteger)this.getAttrValue(session, object, 293), (BigInteger)this.getAttrValue(session, object, 294), (BigInteger)this.getAttrValue(session, object, 295), (BigInteger)this.getAttrValue(session, object, 296));
                return rSAPrivateKey;
            }
            finally {
                this.sessionManager.releaseSession(session);
            }
        }
        catch (InvalidKeyException e) {
            if (debug == null) throw new InvalidKeySpecException("Inappropriate key specification: " + e.getMessage());
            debug.exception(16384L, (Object)className, "engineGeneratePrivate", (Throwable)e);
            debug.exit(16384L, (Object)className, "engineGeneratePrivate");
            throw new InvalidKeySpecException("Inappropriate key specification: " + e.getMessage());
        }
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            String keyString = key.toString();
            debug.entry(16384L, (Object)className, "engineGetKeySpec", (Object)keyString, keySpec);
        }
        try {
            Class<Object> rsaPrivCrtKeySpec;
            Class<T> rsaPubKeySpec;
            if (key instanceof PKCS11RSAPublicKey) {
                rsaPubKeySpec = Class.forName("java.security.spec.RSAPublicKeySpec");
                Class<T> x509KeySpec = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (rsaPubKeySpec.isAssignableFrom(keySpec)) {
                    RSAPublicKey rsaPubKey = (RSAPublicKey)key;
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec");
                    }
                    return (T)new RSAPublicKeySpec(rsaPubKey.getModulus(), rsaPubKey.getPublicExponent());
                }
                if (x509KeySpec.isAssignableFrom(keySpec)) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_1");
                    }
                    return (T)new X509EncodedKeySpec(key.getEncoded());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec_2", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec_2");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof java.security.interfaces.RSAPublicKey) {
                rsaPubKeySpec = Class.forName("java.security.spec.RSAPublicKeySpec");
                Class<T> x509KeySpec = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (rsaPubKeySpec.isAssignableFrom(keySpec)) {
                    java.security.interfaces.RSAPublicKey rsaPubKey = (java.security.interfaces.RSAPublicKey)key;
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_3");
                    }
                    return (T)new RSAPublicKeySpec(rsaPubKey.getModulus(), rsaPubKey.getPublicExponent());
                }
                if (x509KeySpec.isAssignableFrom(keySpec)) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_4");
                    }
                    return (T)new X509EncodedKeySpec(key.getEncoded());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec_5", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec_5");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof PKCS11RSAPrivateKey) {
                rsaPrivCrtKeySpec = Class.forName("java.security.spec.RSAPrivateCrtKeySpec");
                Class<T> rsaPrivKeySpec = Class.forName("java.security.spec.RSAPrivateKeySpec");
                if (rsaPrivCrtKeySpec.isAssignableFrom(keySpec)) {
                    RSAPrivateKey rsaPrivCrtKey = (RSAPrivateKey)key;
                    if (rsaPrivCrtKey.getSensitive().booleanValue()) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineGetKeySpec_6", "Private key value is not exportable");
                            debug.exit(16384L, (Object)className, "engineGetKeySpec_6");
                        }
                        throw new PKCS11Exception("Private key value is not exportable");
                    }
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_7");
                    }
                    return (T)new RSAPrivateCrtKeySpec(rsaPrivCrtKey.getModulus(), rsaPrivCrtKey.getPublicExponent(), rsaPrivCrtKey.getPrivateExponent(), rsaPrivCrtKey.getPrime1(), rsaPrivCrtKey.getPrime2(), rsaPrivCrtKey.getExponent1(), rsaPrivCrtKey.getExponent2(), rsaPrivCrtKey.getCoefficient());
                }
                if (rsaPrivKeySpec.isAssignableFrom(keySpec)) {
                    RSAPrivateKey rsaPrivKey = (RSAPrivateKey)key;
                    if (rsaPrivKey.getSensitive().booleanValue()) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineGetKeySpec_8", "Private key value is not exportable");
                            debug.exit(16384L, (Object)className, "engineGetKeySpec_8");
                        }
                        throw new PKCS11Exception("Private key value is not exportable");
                    }
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_9");
                    }
                    return (T)new RSAPrivateKeySpec(rsaPrivKey.getModulus(), rsaPrivKey.getPrivateExponent());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof RSAPrivateCrtKey) {
                rsaPrivCrtKeySpec = Class.forName("java.security.spec.RSAPrivateCrtKeySpec");
                if (rsaPrivCrtKeySpec.isAssignableFrom(keySpec)) {
                    RSAPrivateCrtKey rsaPrivCrtKey = (RSAPrivateCrtKey)key;
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_10");
                    }
                    return (T)new RSAPrivateCrtKeySpec(rsaPrivCrtKey.getModulus(), rsaPrivCrtKey.getPublicExponent(), rsaPrivCrtKey.getPrivateExponent(), rsaPrivCrtKey.getPrimeP(), rsaPrivCrtKey.getPrimeQ(), rsaPrivCrtKey.getPrimeExponentP(), rsaPrivCrtKey.getPrimeExponentQ(), rsaPrivCrtKey.getCrtCoefficient());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec_11", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec_11");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof java.security.interfaces.RSAPrivateKey) {
                Class<T> rsaPrivKeySpec = Class.forName("java.security.spec.RSAPrivateKeySpec");
                if (rsaPrivKeySpec.isAssignableFrom(keySpec)) {
                    java.security.interfaces.RSAPrivateKey rsaPrivKey = (java.security.interfaces.RSAPrivateKey)key;
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_12");
                    }
                    return (T)new RSAPrivateKeySpec(rsaPrivKey.getModulus(), rsaPrivKey.getPrivateExponent());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec_13", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec_13");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineGetKeySpec_14", "Inappropriate key type");
                debug.exit(16384L, (Object)className, "engineGetKeySpec_14");
            }
            throw new InvalidKeySpecException("Inappropriate key type");
        }
        catch (ClassNotFoundException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGetKeySpec", (Throwable)e);
                debug.exit(16384L, (Object)className, "engineGetKeySpec");
            }
            throw new InvalidKeySpecException("Unsupported key specification: " + e.getMessage());
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (debug != null) {
            String keyString = key.toString();
            debug.entry(16384L, (Object)className, "engineTranslateKey", (Object)keyString);
        }
        try {
            RSAPrivateKeySpec rsaPrivKeySpec;
            if (key instanceof java.security.interfaces.RSAPublicKey) {
                if (key instanceof RSAPublicKey) {
                    return key;
                }
                RSAPublicKeySpec rsaPubKeySpec = this.engineGetKeySpec(key, RSAPublicKeySpec.class);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineTranslateKey", (Object)"RSAPublicKey");
                }
                return this.engineGeneratePublic(rsaPubKeySpec);
            }
            if (key instanceof RSAPrivateCrtKey) {
                if (key instanceof RSAPrivateKey) {
                    return key;
                }
                rsaPrivKeySpec = this.engineGetKeySpec(key, RSAPrivateCrtKeySpec.class);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineTranslateKey", (Object)"RSAPrivateCrtKey");
                }
                return this.engineGeneratePrivate(rsaPrivKeySpec);
            }
            if (key instanceof java.security.interfaces.RSAPrivateKey) {
                if (key instanceof RSAPrivateKey) {
                    return key;
                }
                rsaPrivKeySpec = this.engineGetKeySpec(key, RSAPrivateKeySpec.class);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineTranslateKey", (Object)"RSAPrivateKey");
                }
                return this.engineGeneratePrivate(rsaPrivKeySpec);
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineTranslateKey", "Wrong algorithm type");
                debug.exit(16384L, (Object)className, "engineTranslateKey");
            }
            throw new InvalidKeyException("Wrong algorithm type");
        }
        catch (InvalidKeySpecException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineTranslateKey", (Throwable)e);
                debug.exit(16384L, (Object)className, "engineTranslateKey");
            }
            throw new InvalidKeyException("Cannot translate key: " + e.getMessage());
        }
    }

    private byte[] genID() {
        byte[] labelName = new byte[33];
        byte[] labelSaltData = new byte[24];
        byte[] labelTmp = null;
        int labelLength = 0;
        try {
            SecureRandom random = SecureRandom.getInstance("IBMSecureRandom", "IBMPKCS11Impl");
            random.nextBytes(labelSaltData);
        }
        catch (Exception e) {
            // empty catch block
        }
        BigInteger bigInt = new BigInteger(1, labelSaltData);
        try {
            labelTmp = bigInt.toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("Can not convert string");
        }
        labelLength = bigInt.toString().length();
        if (labelLength > 24) {
            labelLength = 24;
        }
        System.arraycopy(labelTmp, 0, labelName, 9, labelLength);
        labelName[0] = 73;
        labelName[1] = 66;
        labelName[2] = 77;
        labelName[3] = 80;
        labelName[4] = 75;
        labelName[5] = 67;
        labelName[6] = 83;
        labelName[7] = 49;
        labelName[8] = 49;
        return labelName;
    }

    private Object getAttrValue(Session session, PKCS11Object pkcs11obj, int attr) {
        return session.getAttrValue(pkcs11obj, attr);
    }
}

