/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.CipherMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.KeyMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.MechanismBuilder;
import com.ibm.pkcs11.PKCS11Mechanism;
import com.ibm.pkcs11.PKCS11Object;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.NoSuchPaddingException;

class MechanismBuilderImpl
implements CipherMechanismBuilder,
KeyMechanismBuilder {
    private String type;
    private String algorithm;
    private int mechanism = 0;
    private MODES mode;
    private PADDING padding;
    private static Map<String, String> AliasesMap = new HashMap<String, String>();

    public static CipherMechanismBuilder createCipherMechanismBuilder(String alg) {
        return new MechanismBuilderImpl(alg, "Cipher");
    }

    public static KeyMechanismBuilder createKeyMechanismBuilder(String alg) {
        return new MechanismBuilderImpl(alg, "KeyFactory");
    }

    public static MechanismBuilder createMechanismBuilder(String alg, String type) {
        return new MechanismBuilderImpl(alg, type);
    }

    protected MechanismBuilderImpl(String alg, String algType) {
        this.type = algType;
        this.algorithm = alg;
        this.mode = MODES.ECB;
        this.padding = PADDING.NOPADDING;
    }

    @Override
    public void setMode(String mode) throws NoSuchAlgorithmException {
        try {
            this.mode = MODES.valueOf(mode.toUpperCase());
            this.mechanism = 0;
        }
        catch (IllegalArgumentException ex) {
            throw new NoSuchAlgorithmException("Invalid Mode value: " + mode);
        }
    }

    @Override
    public void setPadding(String padding) throws NoSuchPaddingException {
        try {
            this.padding = PADDING.valueOf(padding.toUpperCase());
            this.mechanism = 0;
            if (this.padding == PADDING.PAD && this.mode == MODES.ECB) {
                throw new NoSuchPaddingException("No padding implemented for ECB mode");
            }
        }
        catch (IllegalArgumentException ex) {
            throw new NoSuchPaddingException("Padding: " + padding + " can not be verified for use. " + "Use Pad instead.");
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public boolean isCompatibleOperationMode(int opmode, AlgorithmParameterSpec paramSpec) {
        return this.mode != MODES.CBC || opmode != 2 && opmode != 4 || paramSpec != null;
    }

    @Override
    public boolean isIVRequired() {
        return this.mode == MODES.CBC;
    }

    @Override
    public boolean isPadding() {
        return this.padding == PADDING.PAD;
    }

    @Override
    public int getMechanism() {
        if (this.mechanism != 0) {
            return this.mechanism;
        }
        String mechanismAlgName = AliasesMap.containsKey(this.algorithm.toUpperCase()) ? AliasesMap.get(this.algorithm.toUpperCase()) : this.algorithm.toUpperCase();
        StringBuilder mechanismName = new StringBuilder(mechanismAlgName);
        if (this.type.equalsIgnoreCase("KeyFactory")) {
            mechanismName.append("_KEY_GEN");
        } else if (this.type.equalsIgnoreCase("Cipher") && !mechanismAlgName.equalsIgnoreCase("RC4")) {
            mechanismName.append('_');
            mechanismName.append((Object)this.mode);
            if (this.padding == PADDING.PAD) {
                mechanismName.append('_');
                mechanismName.append((Object)this.padding);
            }
        }
        try {
            final String mn = mechanismName.toString();
            this.mechanism = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalAccessException, NoSuchFieldException {
                    int i = PKCS11Mechanism.class.getDeclaredField(mn).getInt(null);
                    return new Integer(i);
                }
            });
        }
        catch (Exception e) {
            return -1;
        }
        return this.mechanism;
    }

    @Override
    public Integer getKeyType() {
        try {
            final String mechanismAlgName = AliasesMap.containsKey(this.algorithm.toUpperCase()) ? AliasesMap.get(this.algorithm.toUpperCase()) : this.algorithm.toUpperCase();
            return (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalAccessException, NoSuchFieldException {
                    return PKCS11Object.class.getDeclaredField(mechanismAlgName).get(null);
                }
            });
        }
        catch (Exception e) {
            return new Integer(-1);
        }
    }

    @Override
    public int getDefaultKeySize() {
        switch (this.getMechanism()) {
            case 288: {
                return 64;
            }
            case 305: {
                return 192;
            }
            case 272: 
            case 4224: 
            case 4240: {
                return 128;
            }
        }
        return 0;
    }

    static {
        AliasesMap.put("DESEDE", "DES3");
        AliasesMap.put("ARCFOUR", "RC4");
        AliasesMap.put("HMACMD5", "MD5_HMAC");
        AliasesMap.put("HMACSHA1", "SHA_1_HMAC");
        AliasesMap.put("GENERIC", "GENERIC_SECRET");
        AliasesMap.put("TLSRSAPREMASTERSECRET", "GENERIC_SECRET");
        AliasesMap.put("MAC", "GENERIC_SECRET");
    }

    private static enum PADDING {
        NOPADDING,
        PAD;

    }

    private static enum MODES {
        ECB,
        CBC;

    }
}

