/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.crypto.pkcs11impl.provider.Signature;
import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

final class GeneralSignature
extends SignatureSpi {
    private Signature sig;
    private int mechanism = 0;
    private SessionManager sessionManager;
    private Session session;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.GeneralSignature";
    private boolean isSign;
    private String algorithm;
    private boolean initialized;
    private boolean isSingle;
    private MessageDigest md;
    private static final int RAW_ECDSA_MAX = 128;
    private byte[] buffer;
    private int bytesProcessed;
    private Key sigKey;

    public GeneralSignature(Provider provider, String algorithm, int mechanism) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "GeneralSignature");
        }
        this.algorithm = algorithm;
        this.mechanism = mechanism;
        switch (mechanism) {
            case 4161: {
                this.isSingle = true;
                String digestAlg = null;
                if (this.algorithm.equalsIgnoreCase("NONEwithECDSA")) {
                    this.buffer = new byte[128];
                } else if (this.algorithm.equalsIgnoreCase("SHA1withECDSA")) {
                    digestAlg = "SHA-1";
                } else if (this.algorithm.equalsIgnoreCase("SHA256withECDSA")) {
                    digestAlg = "SHA-256";
                } else if (this.algorithm.equalsIgnoreCase("SHA384withECDSA")) {
                    digestAlg = "SHA-384";
                } else if (this.algorithm.equalsIgnoreCase("SHA512withECDSA")) {
                    digestAlg = "SHA-512";
                }
                if (digestAlg == null) break;
                this.md = MessageDigest.getInstance(digestAlg);
                break;
            }
            case 4162: {
                this.isSingle = true;
                String digestAlg = "SHA-1";
                this.md = MessageDigest.getInstance(digestAlg);
            }
        }
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.sig = new Signature(mechanism, provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "GeneralSignature");
        }
    }

    @Override
    protected void engineSetParameter(String key, Object param) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetParameter");
            debug.exit(16384L, (Object)className, "engineSetParameter");
        }
    }

    @Override
    protected Object engineGetParameter(String key) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetParameter", (Object)key);
            debug.exit(16384L, (Object)className, "engineGetParameter");
        }
        return null;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (debug != null) {
            String keyString = privateKey.toString();
            debug.entry(16384L, (Object)className, "engineInitSign", (Object)keyString);
        }
        this.cancelOperation();
        if (this.session == null) {
            this.session = this.sessionManager.getOpSession();
        }
        try {
            this.sig.engineInitSign(this.session, privateKey);
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            if (this.session != null) {
                this.sessionManager.releaseSession(this.session);
                this.session = null;
            }
            throw new InvalidKeyException(ex);
        }
        catch (InvalidKeyException ex) {
            this.sessionManager.releaseSession(this.session);
            this.session = null;
            throw ex;
        }
        this.isSign = true;
        this.initialized = true;
        this.sigKey = privateKey;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInitSign");
        }
    }

    private void cancelOperation() {
        if (!this.initialized) {
            return;
        }
        if (this.session == null) {
            return;
        }
        if (this.md != null) {
            this.md.reset();
        }
        this.bytesProcessed = 0;
        this.isSign = false;
        this.isSingle = false;
        this.initialized = false;
        if (!this.session.hasObjects()) {
            this.sessionManager.closeSession(this.session);
            this.session = null;
            return;
        }
        if (this.isSign) {
            try {
                this.sig.engineSign(this.session);
            }
            catch (SignatureException e) {
                if (debug != null) {
                    debug.exception(16384L, (Object)"GeneralSignature", "cancelOperation", (Throwable)e);
                }
            }
        } else {
            this.sig.engineDummyVerify(this.session, this.algorithm);
        }
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (debug != null) {
            String keyString = publicKey.toString();
            debug.entry(16384L, (Object)className, "engineInitVerify", (Object)keyString);
        }
        this.cancelOperation();
        if (this.session == null) {
            this.session = this.sessionManager.getOpSession();
        }
        try {
            this.sig.engineInitVerify(this.session, publicKey);
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            if (this.session != null) {
                this.sessionManager.releaseSession(this.session);
                this.session = null;
            }
            throw new InvalidKeyException(ex);
        }
        catch (InvalidKeyException ex) {
            this.sessionManager.releaseSession(this.session);
            this.session = null;
            throw ex;
        }
        this.isSign = false;
        this.initialized = true;
        this.sigKey = publicKey;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInitVerify");
        }
    }

    @Override
    protected void engineUpdate(byte b) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineUpdate(byte)", (Object)b);
        }
        if (this.session == null) {
            try {
                if (this.isSign) {
                    this.engineInitSign((PrivateKey)this.sigKey);
                } else {
                    this.engineInitVerify((PublicKey)this.sigKey);
                }
            }
            catch (InvalidKeyException ex) {
                throw new RuntimeException(ex);
            }
        }
        byte[] onebyte = new byte[]{b};
        if (!this.initialized) {
            throw new IllegalStateException("Signature is not initialized");
        }
        if (this.isSingle) {
            this.singleUpdate(onebyte, 0, 1);
        } else {
            try {
                this.sig.engineUpdate(this.session, onebyte, 0, 1);
            }
            catch (PKCS11Exception ex) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineUpdate(byte)", (Throwable)ex);
                }
                this.cancelOperation();
                if (this.session != null) {
                    this.sessionManager.releaseSession(this.session);
                    this.session = null;
                }
                throw ex;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate(byte)");
        }
    }

    @Override
    protected void engineUpdate(byte[] data, int off, int len) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineUpdate(byte[], int, int)", (Object)data, (Object)new Integer(len));
        }
        if (!this.initialized) {
            throw new IllegalStateException("Signature is not initialized");
        }
        if (this.session == null) {
            try {
                if (this.isSign) {
                    this.engineInitSign((PrivateKey)this.sigKey);
                } else {
                    this.engineInitVerify((PublicKey)this.sigKey);
                }
            }
            catch (InvalidKeyException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (this.isSingle) {
            this.singleUpdate(data, off, len);
        } else {
            try {
                this.sig.engineUpdate(this.session, data, off, len);
            }
            catch (PKCS11Exception ex) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineUpdate(byte[], int, int)", (Throwable)ex);
                }
                this.cancelOperation();
                if (this.session != null) {
                    this.sessionManager.releaseSession(this.session);
                    this.session = null;
                }
                throw ex;
            }
        }
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineUpdate(byte[], int, int");
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSign");
        }
        if (!this.initialized || !this.isSign) {
            if (debug != null) {
                debug.text(16384L, (Object)"GeneralSignature", "engineSign", "Signature is initialized? " + this.initialized + " Signature is for signing? " + this.isSign);
            }
            throw new SignatureException("Signature is not initialized properly");
        }
        if (this.session == null) {
            try {
                this.engineInitSign((PrivateKey)this.sigKey);
            }
            catch (InvalidKeyException ex) {
                throw new SignatureException(ex);
            }
        }
        byte[] signature = null;
        try {
            if (this.isSingle) {
                if (this.md != null) {
                    byte[] digest = this.md.digest();
                    signature = this.sig.engineSign(this.session, digest, digest.length);
                } else {
                    if (this.bytesProcessed > this.buffer.length) {
                        throw new SignatureException("Data for NONEwithECDSA should not be longer than 1024 bits");
                    }
                    signature = this.sig.engineSign(this.session, this.buffer, this.bytesProcessed);
                }
            } else {
                signature = this.sig.engineSign(this.session);
            }
        }
        catch (PKCS11Exception ex) {
            if (debug != null) {
                debug.exception(16384L, (Object)"GeneralSignature", "engineSign", (Throwable)ex);
            }
            this.cancelOperation();
            throw ex;
        }
        finally {
            if (this.session != null) {
                this.sessionManager.releaseSession(this.session);
                this.session = null;
            }
            if (this.md != null) {
                this.md.reset();
            }
            this.bytesProcessed = 0;
        }
        switch (this.mechanism) {
            case 18: {
                return this.bytearrayToASN1(20, signature);
            }
            case 4161: 
            case 4162: {
                int len = signature.length >> 1;
                return this.bytearrayToASN1(len, signature);
            }
        }
        return signature;
    }

    private byte[] bytearrayToASN1(int length, byte[] signature) throws SignatureException {
        try {
            byte[] r = new byte[length];
            byte[] s = new byte[length];
            System.arraycopy(signature, 0, r, 0, length);
            System.arraycopy(signature, length, s, 0, signature.length - length);
            DerOutputStream out = new DerOutputStream(100);
            out.putInteger(new BigInteger(1, r));
            out.putInteger(new BigInteger(1, s));
            DerValue result = new DerValue(48, out.toByteArray());
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineSign", "Signature = " + new HexDumpEncoder().encode(signature));
                debug.text(16384L, (Object)className, "engineSign", "Encoded Sign len = " + result.toByteArray().length);
                debug.text(16384L, (Object)className, "engineSign", "Sign len = " + signature.length);
                debug.exit(16384L, (Object)className, "engineSign");
            }
            return result.toByteArray();
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineSign", (Throwable)e);
                debug.exit(16384L, (Object)className, "engineSign");
            }
            throw new SignatureException("error encoding signature");
        }
    }

    @Override
    protected boolean engineVerify(byte[] signature) throws SignatureException {
        boolean result = false;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineVerify", (Object)signature);
            debug.exit(16384L, (Object)className, "engineVerify");
        }
        if (!this.initialized || this.isSign) {
            throw new SignatureException("Signature is not initialized properly");
        }
        if (this.session == null) {
            try {
                this.engineInitVerify((PublicKey)this.sigKey);
            }
            catch (InvalidKeyException ex) {
                throw new SignatureException(ex);
            }
        }
        try {
            if (this.isSingle) {
                if (this.md != null) {
                    byte[] digest = this.md.digest();
                    result = this.sig.engineVerify(this.session, signature, digest, digest.length);
                } else {
                    if (this.bytesProcessed > this.buffer.length) {
                        throw new SignatureException("Data for NONEwithECDSA algorithm should not be longer than 1024 bits");
                    }
                    result = this.sig.engineVerify(this.session, signature, this.buffer, this.bytesProcessed);
                }
            } else {
                result = this.sig.engineVerify(this.session, signature);
            }
        }
        catch (PKCS11Exception ex) {
            if (debug != null) {
                debug.exception(16384L, (Object)"GeneralSignature", "engineVerify", (Throwable)ex);
            }
            this.cancelOperation();
            throw ex;
        }
        finally {
            if (this.session != null) {
                this.sessionManager.releaseSession(this.session);
                this.session = null;
            }
            if (this.md != null) {
                this.md.reset();
            }
            this.bytesProcessed = 0;
        }
        return result;
    }

    private void singleUpdate(byte[] b, int offset, int len) {
        if (this.md != null) {
            this.md.update(b, offset, len);
            ++this.bytesProcessed;
        } else {
            if (this.bytesProcessed >= this.buffer.length) {
                this.bytesProcessed = this.buffer.length + 1;
                if (debug != null) {
                    debug.text(16384L, (Object)className, "singleUpdate", "number of bytes processed can not exceed buffer length:" + this.bytesProcessed);
                }
                return;
            }
            if (b.length == 1) {
                this.buffer[this.bytesProcessed++] = b[0];
            } else {
                System.arraycopy(b, offset, this.buffer, this.bytesProcessed, len);
                this.bytesProcessed += len;
            }
        }
    }
}

