/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PublicKey;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

class DHPKCS11PublicKey
implements PKCS11PublicKey,
DHPublicKey,
Serializable {
    private static final long serialVersionUID = 3258135773294114104L;
    private BigInteger y = null;
    private byte[] key = null;
    private byte[] encodedKey = null;
    private BigInteger p = null;
    private BigInteger g = null;
    private PKCS11Object p11Object = null;
    private static final int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private SessionManager sessionManager;
    private Session session = null;

    public DHPKCS11PublicKey(BigInteger y, BigInteger p, BigInteger g, SessionManager sessionManager, Config config) throws InvalidKeyException {
        this.y = y;
        this.p = p;
        this.g = g;
        try {
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
        }
        catch (IOException e) {
            throw new InvalidKeyException("Cannot produce ASN.1 encoding for the public key");
        }
        this.sessionManager = sessionManager;
        this.importPublicKeyIntoToken(sessionManager, config);
    }

    public DHPKCS11PublicKey(PKCS11Object obj, Session sess) throws InvalidKeyException {
        this.p11Object = obj;
        try {
            this.y = new BigInteger(1, (byte[])this.getAttrValue(sess, this.p11Object, 17));
            this.p = (BigInteger)this.getAttrValue(sess, this.p11Object, 304);
            this.g = (BigInteger)this.getAttrValue(sess, this.p11Object, 306);
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
        }
        catch (IOException e) {
            throw new InvalidKeyException("Cannot produce ASN.1 encoding");
        }
        this.sessionManager = sess.getSessionManager();
    }

    public DHPKCS11PublicKey(byte[] encodedKey, SessionManager sessionManager, Config config) throws InvalidKeyException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(encodedKey);
        try {
            DerValue derKeyVal = new DerValue((InputStream)inStream);
            if (derKeyVal.getTag() != 48) {
                throw new InvalidKeyException("Invalid key format");
            }
            DerValue algid = derKeyVal.getData().getDerValue();
            if (algid.getTag() != 48) {
                throw new InvalidKeyException("AlgId is not a SEQUENCE");
            }
            DerInputStream derInStream = algid.toDerInputStream();
            ObjectIdentifier oid = derInStream.getOID();
            if (derInStream.available() == 0) {
                throw new InvalidKeyException("Parameters missing");
            }
            if (!oid.equals(ObjectIdentifier.newInternal((int[])DH_data))) {
                throw new InvalidKeyException("AlgorithID is not PKCS DH");
            }
            DerValue params = derInStream.getDerValue();
            if (params.getTag() == 5) {
                throw new InvalidKeyException("Null parameters");
            }
            if (params.getTag() != 48) {
                throw new InvalidKeyException("Parameters not a SEQUENCE");
            }
            params.getData().reset();
            this.p = params.getData().getInteger();
            this.g = params.getData().getInteger();
            if (params.getData().available() != 0) {
                int l = params.getData().getInteger().intValue();
            }
            if (params.getData().available() != 0) {
                throw new InvalidKeyException("Extra parameter data");
            }
            this.key = derKeyVal.getData().getBitString();
            this.parseKeyBits();
            if (derKeyVal.getData().available() != 0) {
                throw new InvalidKeyException("Excess key data");
            }
            this.encodedKey = (byte[])encodedKey.clone();
            this.sessionManager = sessionManager;
            this.importPublicKeyIntoToken(sessionManager, config);
        }
        catch (NumberFormatException e) {
            throw new InvalidKeyException("Private-value length too big");
        }
        catch (IOException e) {
            throw new InvalidKeyException(e.getMessage());
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importPublicKeyIntoToken(SessionManager sessionManager, Config config) {
        HashMap<Integer, Object> attribs = new HashMap<Integer, Object>();
        attribs.put(0, PKCS11Object.PUBLIC_KEY);
        attribs.put(256, PKCS11Object.DH);
        attribs.put(304, this.p);
        attribs.put(306, this.g);
        attribs.put(17, this.y.toByteArray());
        attribs.putAll(config.getAttributes("IMPORT", PKCS11Object.PUBLIC_KEY, PKCS11Object.DH));
        int[] pubTypes = new int[attribs.size()];
        Object[] pubValues = new Object[attribs.size()];
        Iterator it = attribs.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            pubTypes[i] = (Integer)entry.getKey();
            pubValues[i++] = entry.getValue();
        }
        Session session = null;
        try {
            boolean isToken;
            block8: {
                session = sessionManager.getObjSession();
                this.p11Object = session.createObject(pubTypes, pubValues);
                isToken = false;
                try {
                    isToken = session.getBoolAttributeValue(this.p11Object, 1);
                    if (debug != null) {
                        debug.text(16384L, (Object)"DHPKCS11PublicKey", "importPublicKeyIntoToken", "DH public key is token object: " + isToken);
                    }
                }
                catch (PKCS11Exception ex) {
                    if (debug == null) break block8;
                    debug.exception(16384L, (Object)"DHPKCS11PublicKey", "importPublicKeyIntoToken", (Throwable)ex);
                    debug.text(16384L, (Object)"DHPKCS11PublicKey", "importPublicKeyIntoToken", "DH public key is token object: " + isToken);
                }
            }
            if (!isToken) {
                session.addObject();
                this.session = session;
            }
        }
        finally {
            sessionManager.releaseSession(session);
        }
    }

    @Override
    public String getAlgorithm() {
        return "DH";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                DerOutputStream algid = new DerOutputStream();
                algid.putOID(new ObjectIdentifier(DH_data));
                DerOutputStream params = new DerOutputStream();
                params.putInteger(this.p);
                params.putInteger(this.g);
                DerValue paramSequence = new DerValue(48, params.toByteArray());
                algid.putDerValue(paramSequence);
                DerOutputStream tmpDerKey = new DerOutputStream();
                tmpDerKey.write((byte)48, algid);
                tmpDerKey.putBitString(this.key);
                DerOutputStream derKey = new DerOutputStream();
                derKey.write((byte)48, tmpDerKey);
                this.encodedKey = derKey.toByteArray();
            }
            catch (IOException e) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    @Override
    public BigInteger getY() {
        return this.y;
    }

    @Override
    public DHParameterSpec getParams() {
        return new DHParameterSpec(this.p, this.g);
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer("IBMPKCS11 Diffie-Hellman Public Key:\ny:\n" + this.y.toString() + "\n" + "p:\n" + this.p.toString() + "\n" + "g:\n" + this.g.toString());
        return strbuf.toString();
    }

    private void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream in = new DerInputStream(this.key);
            this.y = in.getInteger();
        }
        catch (IOException e) {
            throw new InvalidKeyException(e.toString());
        }
    }

    @Override
    public byte[] getSubject() {
        return null;
    }

    @Override
    public Boolean getEncrypt() {
        return null;
    }

    @Override
    public Boolean getVerify() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rm() {
        Session sess = null;
        if (this.session != null) {
            this.session.removeObject();
        }
        if (this.p11Object != null) {
            try {
                sess = this.sessionManager.getOpSession();
                sess.destroyObject(this.getObject());
                this.p11Object = null;
                this.session = null;
            }
            catch (Exception exception) {
            }
            finally {
                this.sessionManager.releaseSession(sess);
            }
        }
    }

    protected void finalize() throws Throwable {
    }

    @Override
    public Boolean getVerifyRecover() {
        return null;
    }

    @Override
    public Boolean getWrap() {
        return null;
    }

    @Override
    public PKCS11Object getObject() {
        return this.p11Object;
    }

    @Override
    public Boolean getToken() {
        Boolean val = (Boolean)this.getAttrValue(this.p11Object, 1);
        return new Boolean(val);
    }

    @Override
    public Boolean getPrivate() {
        return Boolean.FALSE;
    }

    @Override
    public String getLabel() {
        return (String)this.getAttrValue(this.p11Object, 3);
    }

    @Override
    public Boolean getModifiable() {
        Boolean val = (Boolean)this.getAttrValue(this.p11Object, 368);
        return new Boolean(val);
    }

    @Override
    public Integer getKeyType() {
        return PKCS11Object.DH;
    }

    @Override
    public byte[] getID() {
        return (byte[])((byte[])this.getAttrValue(this.p11Object, 258)).clone();
    }

    @Override
    public Date getStartDate() {
        return null;
    }

    @Override
    public Date getEndDate() {
        return null;
    }

    @Override
    public Boolean getDerive() {
        Boolean val = (Boolean)this.getAttrValue(this.p11Object, 268);
        return new Boolean(val);
    }

    @Override
    public Boolean getLocal() {
        Boolean val = (Boolean)this.getAttrValue(this.p11Object, 355);
        return new Boolean(val);
    }

    private Object getAttrValue(PKCS11Object pkcs11obj, int attr) {
        Object rtn;
        Session sess = null;
        try {
            sess = this.sessionManager.getOpSession();
            rtn = sess.getAttrValue(pkcs11obj, attr);
        }
        catch (Exception e) {
            rtn = null;
            this.sessionManager.releaseSession(sess);
        }
        return rtn;
    }

    private Object getAttrValue(Session sess, PKCS11Object pkcs11obj, int attr) {
        return sess.getAttrValue(pkcs11obj, attr);
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSession(Session sess) {
        this.session = sess;
    }
}

