/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util.list;

public final class LinkedList {
    private Item head = null;
    private Item tail = null;

    public void addFirst(Item item) {
        if (this.head == null) {
            this.head = this.tail = item;
        } else {
            item.setNext(this.head);
            this.head = item;
        }
    }

    public void addLast(Item item) {
        if (this.tail == null) {
            this.head = this.tail = item;
        } else {
            this.tail.setNext(item);
            this.tail = item;
        }
    }

    public Item getFirst() {
        return this.head;
    }

    public Item getLast() {
        return this.tail;
    }

    public Item removeFirst() {
        Item item = this.head;
        if (this.head != null) {
            this.head = this.head.getNext();
            if (this.head == null) {
                this.tail = null;
            }
            item.setNext(null);
        }
        return item;
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    public void clear() {
        while (this.head != null) {
            this.removeFirst();
        }
    }

    public void clearBeforeItem(Item item) {
        while (this.head != item) {
            this.removeFirst();
            if (this.head != null) continue;
            break;
        }
    }

    public static abstract class Item {
        private Item next = null;

        public final Item getNext() {
            return this.next;
        }

        final void setNext(Item item) {
            this.next = item;
        }
    }
}

