/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.ras;

import com.ibm.CORBA.transport.TransportConnection;
import com.ibm.rmi.ras.Message;
import com.ibm.rmi.ras.Trace;
import com.ibm.rmi.ras.Utility;
import java.io.PrintWriter;

public class ReplyMessage
extends Message {
    private static final int NO_EXCEPTION = 0;
    private static final int USER_EXCEPTION = 1;
    private static final int SYSTEM_EXCEPTION = 2;
    private static final int LOCATION_FORWARD = 3;
    private static final int LOCATION_FORWARD_PERM = 4;
    private static final int NEEDS_ADDRESSING_MODE = 5;
    private static final int COMPLETED_YES = 0;
    private static final int COMPLETED_NO = 1;
    private static final int COMPLETED_MAYBE = 2;
    private int GIOP12Reply;

    public ReplyMessage(byte[] byArray) {
        super(byArray, byArray.length);
    }

    public ReplyMessage(byte[] byArray, int n) {
        super(byArray, n);
    }

    public void dumpMessage(PrintWriter printWriter, TransportConnection transportConnection) {
        this.pw = printWriter;
        this.resetStream();
        printWriter.println();
        printWriter.println(Utility.getMessage("Trace.ReplyMessage"));
        if (transportConnection != null) {
            super.dumpMessage(printWriter, transportConnection);
        } else {
            super.dumpMessage(printWriter);
        }
        if (this.GIOPMajor == 1 && (this.GIOPMinor == 0 || this.GIOPMinor == 1)) {
            this.dumpServiceContextList();
            printWriter.println(Utility.getMessage("Trace.RequestID", Integer.toString(this.is.read_long())));
            this.dumpReplyStatus();
            if (Trace.split) {
                this.dataOffset = this.is.mark();
            } else {
                printWriter.println(Utility.getMessage("Trace.DataOffset", Integer.toString(this.is.mark(), 16)));
            }
        } else if (this.GIOPMajor == 1 && this.GIOPMinor == 2) {
            printWriter.println(Utility.getMessage("Trace.RequestID", Integer.toString(this.is.read_long())));
            if (!this.dumpMessageHeader()) {
                return;
            }
            this.dumpReplyStatusGIOP12();
            this.dumpServiceContextList();
            this.handleReplyStatusGIOP12();
        }
        printWriter.println();
    }

    public void dumpMessage(PrintWriter printWriter) {
        this.dumpMessage(printWriter, null);
    }

    private void dumpReplyStatus() {
        int n = this.is.read_long();
        block0 : switch (n) {
            case 0: {
                this.pw.println(Utility.getMessage("Trace.ReplyStatus", "NO_EXCEPTION"));
                break;
            }
            case 1: {
                this.pw.println(Utility.getMessage("Trace.ReplyStatus", "USER_EXCEPTION"));
                break;
            }
            case 2: {
                this.pw.println(Utility.getMessage("Trace.ReplyStatus", "SYSTEM_EXCEPTION"));
                this.pw.println(Utility.getMessage("Trace.ExceptionID", this.is.read_string()));
                int n2 = this.is.read_ulong();
                this.pw.println(Utility.getMessage("Trace.MinorCode", n2 + "(0x" + Integer.toString(n2, 16) + ')'));
                int n3 = this.is.read_ulong();
                switch (n3) {
                    case 0: {
                        this.pw.println(Utility.getMessage("Trace.CompletionStatus", "YES"));
                        break block0;
                    }
                    case 1: {
                        this.pw.println(Utility.getMessage("Trace.CompletionStatus", "NO"));
                        break block0;
                    }
                    case 2: {
                        this.pw.println(Utility.getMessage("Trace.CompletionStatus", "MAYBE"));
                        break block0;
                    }
                }
                this.pw.println(Utility.getMessage("Trace.UnknownCompletionStatus", Integer.toString(n3)));
                break;
            }
            case 3: {
                this.pw.println(Utility.getMessage("Trace.ReplyStatus", "LOCATION_FORWARD"));
                this.dumpObjectKey();
                break;
            }
            default: {
                this.pw.println(Utility.getMessage("Trace.UnknownReplyStatus", Integer.toString(n)));
            }
        }
    }

    private void dumpReplyStatusGIOP12() {
        int n = this.is.read_long();
        switch (n) {
            case 0: {
                this.GIOP12Reply = 0;
                break;
            }
            case 1: {
                this.GIOP12Reply = 1;
                break;
            }
            case 2: {
                this.GIOP12Reply = 2;
                break;
            }
            case 3: {
                this.GIOP12Reply = 3;
                break;
            }
            case 4: {
                this.GIOP12Reply = 4;
                break;
            }
            case 5: {
                this.GIOP12Reply = 5;
                break;
            }
            default: {
                this.pw.println(Utility.getMessage("Trace.UnknownReplyStatus", Integer.toString(n)));
            }
        }
    }

    private void handleReplyStatusGIOP12() {
        this.is.alignAndCheck(8, 0);
        block0 : switch (this.GIOP12Reply) {
            case 0: {
                this.pw.println(Utility.getMessage("Trace.ReplyStatus", "NO_EXCEPTION"));
                break;
            }
            case 1: {
                this.pw.println(Utility.getMessage("Trace.ReplyStatus", "USER_EXCEPTION"));
                break;
            }
            case 2: {
                this.pw.println(Utility.getMessage("Trace.ReplyStatus", "SYSTEM_EXCEPTION"));
                this.pw.println(Utility.getMessage("Trace.ExceptionID", this.is.read_string()));
                int n = this.is.read_ulong();
                this.pw.println(Utility.getMessage("Trace.MinorCode", n + "(0x" + Integer.toString(n, 16) + ')'));
                int n2 = this.is.read_ulong();
                switch (n2) {
                    case 0: {
                        this.pw.println(Utility.getMessage("Trace.CompletionStatus", "YES"));
                        break block0;
                    }
                    case 1: {
                        this.pw.println(Utility.getMessage("Trace.CompletionStatus", "NO"));
                        break block0;
                    }
                    case 2: {
                        this.pw.println(Utility.getMessage("Trace.CompletionStatus", "MAYBE"));
                        break block0;
                    }
                }
                this.pw.println(Utility.getMessage("Trace.UnknownCompletionStatus", Integer.toString(n2)));
                break;
            }
            case 3: {
                this.pw.println(Utility.getMessage("Trace.ReplyStatus", "LOCATION_FORWARD"));
                this.dumpObjectKey();
                break;
            }
            case 4: {
                this.pw.println(Utility.getMessage("Trace.ReplyStatus", "LOCATION_FORWARD_PERMANENT"));
                this.dumpObjectKey();
                break;
            }
            case 5: {
                this.pw.println(Utility.getMessage("Trace.ReplyStatus", "NEEDS_ADDRESSING_MODE"));
                this.pw.println(Utility.getMessage("Trace.AddressingDisposition", Short.toString(this.is.read_short())));
            }
        }
    }
}

