/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.iiop.ClientDelegate;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.iiop.ORBForTransports;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.transport.Transport;
import com.ibm.rmi.Profile;
import com.ibm.rmi.corba.ClientSubcontract;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.GIOPImpl;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.iiop.TransportInterface;

public class TransportManager
implements ORBForTransports,
TransportInterface {
    private Transport theTransport = null;
    private GIOPImpl theGIOPImpl = null;
    private ORB theORB = null;
    private boolean serverHasBeenInitialized = false;

    public TransportManager(ORB oRB, GIOPImpl gIOPImpl) {
        this.theGIOPImpl = gIOPImpl;
        this.theORB = oRB;
    }

    public Connection getConnection(IOR iOR, ClientDelegate clientDelegate, String string) {
        return this.get((Profile)iOR.getProfile(), clientDelegate, string);
    }

    public Connection get(Profile profile, ClientSubcontract clientSubcontract, String string) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "get:85", "before calling Transport.getConnection");
        }
        ORBConnection oRBConnection = this.theTransport.getConnection(profile, string, clientSubcontract);
        Connection connection = (Connection)oRBConnection;
        if (profile != null) {
            int n = profile.getPartnerVersion();
            connection.setPartnerVersion((short)(n >>> 16), (short)(n & 0xFFFF), profile.getPartnerExtended());
        }
        return connection;
    }

    public void setTransport(Transport transport) {
        this.theTransport = transport;
    }

    public ORBConnection createORBConnection() {
        Connection connection = new Connection(this.theORB, this.theGIOPImpl, false);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "createORBConnection:116", " created " + connection);
        }
        return connection;
    }

    public ORBConnection createORBConnectionForServer() {
        Connection connection = new Connection(this.theORB, this.theGIOPImpl, true);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "createORBConnectionForServer:133", " created " + connection);
        }
        return connection;
    }

    public void initTransports() {
        if (!this.serverHasBeenInitialized) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, this, "initTransports:148", "before calling Transport.initTransports");
            }
            this.theTransport.initTransports();
            this.serverHasBeenInitialized = true;
        }
    }

    public Profile getServerIIOPProfile() {
        this.initTransports();
        return (Profile)this.theTransport.getIIOPProfile();
    }

    public String getProperty(String string) {
        return this.theORB.getProperty(string);
    }

    public void createListener(int n) {
        this.theTransport.createListener(n);
    }

    public void destroyListener(int n) {
        this.theTransport.destroyListener(n);
    }

    public void shutdown() {
        this.theTransport.shutdown();
    }

    public String getHostIPAddress(String string) {
        return this.theTransport.getHostIPAddress(string);
    }

    public String getLocalHost() {
        return this.theTransport.getLocalHost();
    }

    public void setTransportData(Object object) {
        this.theTransport.setTransportData(object);
    }

    public Object getTransportData() {
        return this.theTransport.getTransportData();
    }

    public int getConnectTimeout() {
        return this.theORB.getConnectTimeout();
    }

    public String getUserSpecifiedLocalHost() {
        return this.theORB.getUserSpecifiedLocalHost();
    }

    Transport getTheTransport() {
        return this.theTransport;
    }
}

