/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba;

import com.ibm.CORBA.iiop.INSUtil;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.ObjectURL;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.rmi.corba.IIOPAddrImpl;
import com.ibm.rmi.corba.ORB;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.rmi.iiop.CDROutputStream;
import com.ibm.rmi.iiop.CDRWriter;
import com.ibm.rmi.util.Utility;
import java.util.ArrayList;
import java.util.Iterator;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.Object;

public class IorURL
implements ObjectURL {
    private Object objref;
    private String url;
    private IOR ior;
    private ArrayList iiopList = new ArrayList(1);
    private ObjectKey objectKey;
    private byte[] iorBytes;
    private boolean resolved = false;

    public boolean isCorbaloc() {
        return false;
    }

    public boolean isCorbaname() {
        return false;
    }

    public boolean isIOR() {
        return true;
    }

    public boolean isRir() {
        return false;
    }

    public Object resolve(ORB oRB) {
        if (!this.resolved) {
            this.iorbytesToObjref(oRB);
            if (this.ior == null) {
                this.ior = oRB.objectToIOR(this.objref);
                this.extractIorFields();
            }
        }
        return this.objref;
    }

    private void iorbytesToObjref(ORB oRB) {
        CDRInputStream cDRInputStream = new CDRInputStream((org.omg.CORBA.ORB)oRB, this.iorBytes, this.iorBytes.length);
        cDRInputStream.consumeEndian();
        this.objref = cDRInputStream.read_Object();
        this.resolved = true;
    }

    IorURL(String string) {
        this.url = string;
        if (!string.startsWith("IOR:")) {
            throw new BAD_PARAM(string + " does not start with IOR:", 1330446343, CompletionStatus.COMPLETED_NO);
        }
        if ((string.length() & 1) != 0) {
            throw new DATA_CONVERSION(string + " not an even length", 1229124482, CompletionStatus.COMPLETED_NO);
        }
        this.iorBytes = new byte[(string.length() - 4) / 2];
        int n = 0;
        for (int i = 4; i < string.length(); i += 2) {
            this.iorBytes[n] = (byte)(Utility.hexOf(string.charAt(i)) << 4 & 0xF0);
            int n2 = n++;
            this.iorBytes[n2] = (byte)(this.iorBytes[n2] | (byte)(Utility.hexOf(string.charAt(i + 1)) << 0 & 0xF));
        }
    }

    IorURL(IOR iOR, ORB oRB) {
        this.ior = iOR;
        this.extractIorFields();
        CDROutputStream cDROutputStream = new CDROutputStream((org.omg.CORBA.ORB)oRB);
        cDROutputStream.putEndian();
        iOR.write(cDROutputStream);
        this.iorBytes = ((CDRWriter)cDROutputStream).toByteArray();
        ((CDRWriter)cDROutputStream).releaseBuffer();
        this.iorbytesToObjref(oRB);
    }

    private void extractIorFields() {
        Profile profile = this.ior.getProfile();
        IIOPAddrImpl iIOPAddrImpl = new IIOPAddrImpl(profile.getHost(), profile.getPort(), profile.getMajor(), profile.getMinor());
        this.iiopList.add(iIOPAddrImpl);
        this.objectKey = profile.getObjectKeyObject();
    }

    public String getStringName() {
        return null;
    }

    public ObjectKey getObjectKey() {
        return this.objectKey;
    }

    public String getKeyString() {
        if (this.objectKey != null) {
            return INSUtil.encode2936(new String(this.objectKey.getBytes()));
        }
        return null;
    }

    public Iterator getProtList() {
        return this.getIIOPList();
    }

    public Iterator getIIOPList() {
        if (this.iiopList != null) {
            return this.iiopList.iterator();
        }
        return null;
    }

    public String toString() {
        if (this.url != null) {
            return this.url;
        }
        this.url = this.ior.stringify().trim();
        return this.url;
    }
}

