/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.giop;

import com.ibm.CORBA.channel.giop.CancelRequestException;
import com.ibm.CORBA.channel.giop.CloseConnectionMessageException;
import com.ibm.CORBA.channel.giop.GIOPChannelPlugin;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.channel.giop.GIOPWriteCompletedCallback;
import com.ibm.CORBA.channel.orb.CallLink;
import com.ibm.CORBA.iiop.Message;
import com.ibm.CORBA.iiop.ServiceContext;
import com.ibm.CORBA.iiop.ServiceContextList;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.ras.Trc;
import com.ibm.CORBA.transport.TransportConnection;
import com.ibm.rmi.channel.giop.GIOPChannelConfig;
import com.ibm.rmi.channel.giop.GIOPConnection;
import com.ibm.rmi.iiop.GIOPMessageContextBase;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.iiop.ReplyMessage;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.io.OutputStream;

public class MessageWriter
extends OutputStream
implements TCPWriteRequestContext,
TCPWriteCompletedCallback {
    private static final String CLASS = GIOPConnection.class.getName();
    private TCPWriteRequestContext devWriteContext;
    private GIOPChannelPlugin giopPlugin;
    private GIOPConnection giopConn;
    private GIOPChannelConfig giopConfig;
    private TCPWriteCompletedCallback appCallback;
    private final TransportConnection transport;
    private ORB orb;

    public MessageWriter(VirtualConnection virtualConnection, TransportConnection transportConnection, TCPWriteRequestContext tCPWriteRequestContext, GIOPConnection gIOPConnection, GIOPChannelConfig gIOPChannelConfig, GIOPChannelPlugin gIOPChannelPlugin) {
        this.transport = transportConnection;
        this.devWriteContext = tCPWriteRequestContext;
        this.giopConn = gIOPConnection;
        this.giopConfig = gIOPChannelConfig;
        this.orb = gIOPChannelConfig.getOrb();
        this.giopPlugin = gIOPChannelPlugin;
    }

    public void write(int n) {
        throw new UnsupportedOperationException("write should not be called directly");
    }

    private void updateConnectionContext(GIOPMessageContext gIOPMessageContext, ServiceContext[] serviceContextArray) {
        if (serviceContextArray != null && serviceContextArray.length > 0) {
            ServiceContextList serviceContextList = gIOPMessageContext.getServiceContexts();
            for (int i = 0; i < serviceContextArray.length; ++i) {
                serviceContextList.add(serviceContextArray[i], true);
            }
        }
    }

    private GIOPMessageContext processMessageContext(CallLink callLink, GIOPMessageContext gIOPMessageContext) throws CancelRequestException, CloseConnectionMessageException, IOException {
        GIOPMessageContext gIOPMessageContext2 = null;
        if (gIOPMessageContext.getType() == 1) {
            this.updateConnectionContext(gIOPMessageContext, this.giopConn.getReplyServiceContexts());
        } else if (gIOPMessageContext.getType() == 0) {
            Message message = gIOPMessageContext.getMessage();
            this.updateConnectionContext(gIOPMessageContext, this.giopConn.getRequestServiceContexts(gIOPMessageContext.getCurrentIOR(), message.getGIOPMajor(), message.getGIOPMinor()));
            if (!this.giopConn.isPostInitialRequestContexts() && !gIOPMessageContext.getInitialIOR().isBootstrap()) {
                this.giopConn.storeNonBootstrapRequest(gIOPMessageContext.getRequestIdToken());
            }
        }
        try {
            gIOPMessageContext2 = this.giopPlugin.processOutgoingContext(callLink, this.giopConn, gIOPMessageContext);
        }
        catch (CloseConnectionMessageException closeConnectionMessageException) {
            throw closeConnectionMessageException;
        }
        catch (CancelRequestException cancelRequestException) {
            throw cancelRequestException;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        return gIOPMessageContext2;
    }

    public long writeMessage(CallLink callLink, GIOPMessageContext gIOPMessageContext, int n) throws CancelRequestException, CloseConnectionMessageException, IOException {
        GIOPMessageContext gIOPMessageContext2 = this.processMessageContext(callLink, gIOPMessageContext);
        long l = 0L;
        if (gIOPMessageContext2 != null) {
            l = ((GIOPMessageContextBase)gIOPMessageContext2).write(this, n);
        }
        return l;
    }

    public VirtualConnection writeMessage(CallLink callLink, GIOPMessageContext gIOPMessageContext, GIOPWriteCompletedCallback gIOPWriteCompletedCallback, boolean bl, int n) throws CancelRequestException, CloseConnectionMessageException, IOException {
        GIOPMessageContext gIOPMessageContext2 = this.processMessageContext(callLink, gIOPMessageContext);
        VirtualConnection virtualConnection = null;
        if (gIOPMessageContext2 != null) {
            virtualConnection = ((GIOPMessageContextBase)gIOPMessageContext2).write(this, gIOPWriteCompletedCallback, bl, n);
        }
        return virtualConnection;
    }

    public long write(Message message, WsByteBuffer[] wsByteBufferArray, long l, int n) throws IOException {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "write:266", (Object)("writeRequestContext=" + this.devWriteContext + " giopConn=" + this.giopConn + " msg=" + message + " buffer=" + wsByteBufferArray + " size=" + l + " timeout=" + n));
        }
        WsByteBuffer[] wsByteBufferArray2 = null;
        try {
            wsByteBufferArray2 = this.giopPlugin.processOutgoingMsg(this.giopConn, wsByteBufferArray);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        long l2 = 0L;
        if (wsByteBufferArray2 != null) {
            this.preWrite();
            ((com.ibm.rmi.iiop.Message)message).dumpMessageIfTracing(this.orb, wsByteBufferArray2, this.transport);
            try {
                this.devWriteContext.setBuffers(wsByteBufferArray2);
                l2 = this.devWriteContext.write(l, n);
                this.postWrite();
                this.setPostInitialConnectionContexts(message);
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exit(4100L, this, "write:292", (Object)("written=" + l2));
                }
            }
            catch (IOException iOException) {
                Trc.warn(iOException, CLASS, "write:295");
                this.handleWriteError(iOException);
                throw iOException;
            }
        }
        return l2;
    }

    public VirtualConnection write(Message message, WsByteBuffer[] wsByteBufferArray, long l, TCPWriteCompletedCallback tCPWriteCompletedCallback, boolean bl, int n) throws IOException {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "write:339", (Object)("msg=" + message + " buffer=" + wsByteBufferArray.toString() + " size=" + l + " callback=" + tCPWriteCompletedCallback + " forceQueue=" + bl + " timeout=" + n));
        }
        ((com.ibm.rmi.iiop.Message)message).dumpMessageIfTracing(this.orb, wsByteBufferArray, this.transport);
        WsByteBuffer[] wsByteBufferArray2 = null;
        try {
            wsByteBufferArray2 = this.giopPlugin.processOutgoingMsg(this.giopConn, wsByteBufferArray);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        VirtualConnection virtualConnection = null;
        if (wsByteBufferArray2 != null) {
            this.preWrite();
            ((com.ibm.rmi.iiop.Message)message).dumpMessageIfTracing(this.giopConfig.getOrb(), wsByteBufferArray2, this.transport);
            this.devWriteContext.setBuffers(wsByteBufferArray2);
            virtualConnection = this.devWriteContext.write(l, (TCPWriteCompletedCallback)this, bl, n);
            if (virtualConnection != null) {
                this.postWrite();
            } else {
                this.appCallback = tCPWriteCompletedCallback;
            }
            this.setPostInitialConnectionContexts(message);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "write:379", (Object)("vc=" + virtualConnection));
        }
        return virtualConnection;
    }

    private void setPostInitialConnectionContexts(Message message) {
        if (message.getType() == 1 && !this.giopConn.isPostInitialReplyContexts() && ((ReplyMessage)message).getServiceContexts() != null) {
            this.giopConn.setPostInitialReplyContexts();
        }
    }

    private void preWrite() throws IOException {
        this.giopConn.obtainPermissionToWrite();
    }

    private void postWrite() {
        this.giopConn.relinquishPermissionToWrite();
    }

    private void handleWriteError(Exception exception) {
        this.postWrite();
        this.giopConn.closeConnection(exception);
    }

    public TCPConnectionContext getInterface() {
        return this.giopConn;
    }

    public long write(long l, int n) throws IOException {
        throw new UnsupportedOperationException("write should not be called directly.  You should call  the writeMessage methods of GIOPConnectionContext.");
    }

    public VirtualConnection write(long l, TCPWriteCompletedCallback tCPWriteCompletedCallback, boolean bl, int n) {
        throw new UnsupportedOperationException("write should not be called directly.  You should call  the writeMessage methods of GIOPConnectionContext.");
    }

    public void clearBuffers() {
        throw new UnsupportedOperationException("clearBuffers should not be called directly");
    }

    public WsByteBuffer[] getBuffers() {
        throw new UnsupportedOperationException("getBuffers should not be called directly");
    }

    public void setBuffers(WsByteBuffer[] wsByteBufferArray) {
        throw new UnsupportedOperationException("setBuffers should not be called directly");
    }

    public WsByteBuffer getBuffer() {
        throw new UnsupportedOperationException("getBuffer should not be called directly");
    }

    public void setBuffer(WsByteBuffer wsByteBuffer) {
        throw new UnsupportedOperationException("setBuffer should not be called directly");
    }

    public void complete(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext) {
        TCPWriteCompletedCallback tCPWriteCompletedCallback = this.appCallback;
        this.postWrite();
        tCPWriteCompletedCallback.complete(virtualConnection, tCPWriteRequestContext);
    }

    public void error(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext, IOException iOException) {
        this.appCallback.error(virtualConnection, tCPWriteRequestContext, iOException);
        this.handleWriteError(iOException);
    }
}

