/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.DOMUtil;
import com.ibm.xml.crypto.dsig.dom.KeyInfoImpl;
import com.ibm.xml.crypto.dsig.dom.Marshalling;
import com.ibm.xml.crypto.dsig.dom.ReferenceImpl;
import com.ibm.xml.crypto.dsig.dom.SignedInfoImpl;
import com.ibm.xml.crypto.dsig.dom.XMLStructureImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import org.w3c.dom.Node;

class XMLSignatureImpl
extends XMLStructureImpl
implements XMLSignature {
    private SignedInfo signedInfo;
    private KeyInfo keyInfo;
    List objects;
    private String id;
    private String svId;
    private byte[] signatureValue;
    private XMLSignature.SignatureValue signatureValueInstance;
    private boolean validated;
    private boolean cachedResult;
    private Node signatureValueNode;
    private Node node;

    XMLSignatureImpl(AlgorithmFactory f, SignedInfo si, KeyInfo ki, List objs, String id, String svi) {
        super(f);
        if (si == null) {
            throw new NullPointerException("SignatureMethod must not be null.");
        }
        this.signedInfo = si;
        this.keyInfo = ki;
        if (objs == null || objs.size() == 0) {
            this.objects = null;
        } else {
            this.objects = new ArrayList(objs.size());
            Iterator iter = objs.iterator();
            while (iter.hasNext()) {
                XMLObject obj = (XMLObject)iter.next();
                this.objects.add(obj);
            }
        }
        this.id = id;
        this.svId = svi;
        this.signatureValue = null;
        this.signatureValueInstance = null;
        this.signatureValueNode = null;
        this.node = null;
        this.validated = false;
        this.cachedResult = false;
    }

    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public String getId() {
        return this.id;
    }

    public List getObjects() {
        return this.objects == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.objects);
    }

    public KeySelectorResult getKeySelectorResult() {
        return ((SignedInfoImpl)this.signedInfo).getKeySelectorResult();
    }

    public XMLSignature.SignatureValue getSignatureValue() {
        if (this.signatureValueInstance == null) {
            this.signatureValueInstance = new SignatureValueImpl(this.afactory, this);
        }
        return this.signatureValueInstance;
    }

    void setSignatureValue(byte[] sv) {
        this.signatureValue = sv;
    }

    void setNode(Node n) {
        this.node = n;
        ((SignedInfoImpl)this.signedInfo).setSignatureNode(this.node);
        if (this.keyInfo != null) {
            ((KeyInfoImpl)this.keyInfo).setSignatureNode(this.node);
        }
    }

    void setSignatureValueNode(Node n) {
        this.signatureValueNode = n;
    }

    public SignedInfo getSignedInfo() {
        return this.signedInfo;
    }

    public void sign(XMLSignContext scontext) throws MarshalException, XMLSignatureException {
        if (scontext == null) {
            throw new NullPointerException("Null context");
        }
        DOMSignContext dscontext = (DOMSignContext)scontext;
        if (this.node == null) {
            Marshalling.marshalSignature(this, dscontext, this.afactory);
            dscontext.getParent().insertBefore(this.node, dscontext.getNextSibling());
        }
        SignedInfoImpl si = (SignedInfoImpl)this.signedInfo;
        for (int i = 0; i < si.content.size(); ++i) {
            ReferenceImpl ref = (ReferenceImpl)si.content.get(i);
            ref.sign(scontext);
        }
        this.setSignatureValue(si.sign(scontext, this.keyInfo));
        if (this.signatureValueNode == null) {
            throw new XMLSignatureException("Internal Error: <ds:SignatureValue> element is not registered.");
        }
        DOMUtil.removeAllChildren(this.signatureValueNode);
        Marshalling.insertBase64Binary(this.signatureValueNode, this.signatureValue);
    }

    public boolean validate(XMLValidateContext vcontext) throws XMLSignatureException {
        if (vcontext == null) {
            throw new NullPointerException("Null context");
        }
        DOMValidateContext dvcontext = (DOMValidateContext)vcontext;
        if (this.validated) {
            return this.cachedResult;
        }
        SignedInfoImpl si = (SignedInfoImpl)this.signedInfo;
        for (int i = 0; i < si.content.size(); ++i) {
            Reference ref = (Reference)si.content.get(i);
            if (ref.validate(vcontext)) continue;
            this.cachedResult = false;
            this.validated = true;
            return this.cachedResult;
        }
        this.cachedResult = this.validateSignedInfo(vcontext);
        this.validated = true;
        return this.cachedResult;
    }

    boolean validateSignedInfo(XMLValidateContext vcontext) throws XMLSignatureException {
        SignedInfoImpl si = (SignedInfoImpl)this.signedInfo;
        return si.validate(vcontext, this.keyInfo, this.signatureValue);
    }

    static class SignatureValueImpl
    extends XMLStructureImpl
    implements XMLSignature.SignatureValue {
        XMLSignatureImpl parent;

        SignatureValueImpl(AlgorithmFactory f, XMLSignatureImpl xsig) {
            super(f);
            this.parent = xsig;
        }

        public String getId() {
            return this.parent.svId;
        }

        public byte[] getValue() {
            if (this.parent.signatureValue == null) {
                return null;
            }
            byte[] ret = new byte[this.parent.signatureValue.length];
            System.arraycopy(this.parent.signatureValue, 0, ret, 0, ret.length);
            return ret;
        }

        public boolean validate(XMLValidateContext vcontext) throws XMLSignatureException {
            return this.parent.validateSignedInfo(vcontext);
        }
    }
}

