/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.platform;

import com.ibm.dtfj.javacore.builder.IImageAddressSpaceBuilder;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.SectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.platform.IPlatformTypes;

public class PlatformSectionParser
extends SectionParser
implements IPlatformTypes {
    private IImageAddressSpaceBuilder fImageAddressSpaceBuilder;
    private IImageProcessBuilder fImageProcessBuilder;
    private static final int J9PORT_SIG_FLAG_SIGSEGV = 4;
    private static final int J9PORT_SIG_FLAG_SIGBUS = 8;
    private static final int J9PORT_SIG_FLAG_SIGILL = 16;
    private static final int J9PORT_SIG_FLAG_SIGFPE = 32;
    private static final int J9PORT_SIG_FLAG_SIGTRAP = 64;
    private static final int J9PORT_SIG_FLAG_SIGQUIT = 1024;
    private static final int J9PORT_SIG_FLAG_SIGABRT = 2048;
    private static final int J9PORT_SIG_FLAG_SIGTERM = 4096;
    private static final int J9PORT_SIG_FLAG_SIGFPE_DIV_BY_ZERO = 262176;
    private static final int J9PORT_SIG_FLAG_SIGFPE_INT_DIV_BY_ZERO = 524320;
    private static final int J9PORT_SIG_FLAG_SIGFPE_INT_OVERFLOW = 0x100020;

    public PlatformSectionParser() {
        super("GPINFO");
    }

    protected void topLevelRule() throws ParserException {
        this.fImageAddressSpaceBuilder = this.fImageBuilder.getCurrentAddressSpaceBuilder();
        if (this.fImageAddressSpaceBuilder != null) {
            this.fImageProcessBuilder = this.fImageAddressSpaceBuilder.getCurrentImageProcessBuilder();
        }
        this.hostInfo();
        this.crashInfo();
    }

    private void hostInfo() throws ParserException {
        IAttributeValueMap results = null;
        results = this.processTagLineRequired("2XHOSLEVEL");
        if (results != null) {
            String os_name = results.getTokenValue("platform_os_name");
            String os_version = results.getTokenValue("platform_os_version");
            this.fImageBuilder.setOSType(os_name);
            this.fImageBuilder.setOSSubType(os_version);
        }
        this.processTagLineRequired("2XHCPUS");
        results = this.processTagLineRequired("3XHCPUARCH");
        if (results != null) {
            String cpu_arch = results.getTokenValue("platform_cpu_arch");
            this.fImageBuilder.setcpuType(cpu_arch);
        }
        if ((results = this.processTagLineRequired("3XHNUMCPUS")) != null) {
            int cpu_count = results.getIntValue("platform_cpu_count");
            this.fImageBuilder.setcpuCount(cpu_count);
        }
    }

    private void crashInfo() throws ParserException {
        IAttributeValueMap results = null;
        while ((results = this.processTagLineOptional("1XHEXCPCODE")) != null) {
            int j9_signal = results.getIntValue("platform_signal");
            if (j9_signal == -1) continue;
            this.fImageProcessBuilder.setSignal(this.resolveGenericSignal(j9_signal));
        }
        this.processTagLineOptional("1XHERROR2");
    }

    private int resolveGenericSignal(int num) {
        if ((num & 0x400) != 0) {
            return 3;
        }
        if ((num & 0x10) != 0) {
            return 4;
        }
        if ((num & 0x40) != 0) {
            return 5;
        }
        if ((num & 0x800) != 0) {
            return 6;
        }
        if ((num & 0x20) != 0) {
            if (num == 262176) {
                return 35;
            }
            if (num == 524320) {
                return 36;
            }
            if (num == 0x100020) {
                return 37;
            }
            return 8;
        }
        if ((num & 8) != 0) {
            return 10;
        }
        if ((num & 4) != 0) {
            return 11;
        }
        if ((num & 0x1000) != 0) {
            return 15;
        }
        return num;
    }

    protected void sovOnlyRules(String startingTag) throws ParserException {
    }
}

