/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.classloader;

import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.javacore.builder.BuilderFailureException;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.builder.IJavaRuntimeBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.framework.scanner.IParserToken;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.SectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.classloader.IClassLoaderTypes;

public class ClassLoaderSectionParser
extends SectionParser
implements IClassLoaderTypes {
    private IJavaRuntimeBuilder fRuntimeBuilder;
    private IImageProcessBuilder fImageProcessBuilder;

    public ClassLoaderSectionParser() {
        super("CLASSES");
    }

    protected void topLevelRule() throws ParserException {
        this.fImageProcessBuilder = this.fImageBuilder.getCurrentAddressSpaceBuilder().getCurrentImageProcessBuilder();
        this.fRuntimeBuilder = this.fImageProcessBuilder.getCurrentJavaRuntimeBuilder();
        this.classLoaderSummaries();
        this.classLoaderLibraries();
        this.classLoaders();
    }

    private void classLoaderSummaries() throws ParserException {
        this.processTagLineRequired("1CLTEXTCLLOS");
        this.processTagLineRequired("1CLTEXTCLLSS");
        IAttributeValueMap results = null;
        results = this.processTagLineRequired("2CLTEXTCLLOADER");
        if (results != null) {
            this.processClassLoaderStats(results);
            while ((results = this.processTagLineOptional("2CLTEXTCLLOADER")) != null) {
                this.processClassLoaderStats(results);
            }
        }
    }

    private void classLoaderLibraries() throws ParserException {
        if (this.matchOptional("1CLTEXTCLLIB")) {
            this.consume();
            IParserToken token = this.lookAhead(1);
            if (token != null && token.getType().equals("UNPARSED")) {
                this.consume();
            }
            IAttributeValueMap results = null;
            results = this.processTagLineRequired("2CLTEXTCLLIB");
            if (results != null) {
                this.processLibraryLoader(results);
                while ((results = this.processTagLineOptional("2CLTEXTCLLIB")) != null) {
                    this.processLibraryLoader(results);
                }
            }
        }
    }

    private void classLoaders() throws ParserException {
        this.processTagLineRequired("1CLTEXTCLLOD");
        IAttributeValueMap results = null;
        results = this.processTagLineRequired("2CLTEXTCLLOAD");
        if (results != null) {
            this.processClassLoaders(results);
            while ((results = this.processTagLineOptional("2CLTEXTCLLOAD")) != null) {
                this.processClassLoaders(results);
            }
        }
    }

    private void processClassLoaderStats(IAttributeValueMap results) throws ParserException {
        String cl_name = results.getTokenValue("cl_name");
        long cl_address = results.getLongValue("cl_address");
        try {
            this.fRuntimeBuilder.addClassLoader(cl_name, cl_address, cl_address);
        }
        catch (BuilderFailureException e) {
            this.handleError("Failed to add class loader: " + cl_name + " " + cl_address + " ", e);
        }
        cl_name = results.getTokenValue("cl_parent_name");
        cl_address = results.getLongValue("cl_parent_address");
        if (cl_name != null || cl_address != -1L) {
            try {
                this.fRuntimeBuilder.addClassLoader(cl_name, cl_address, cl_address);
            }
            catch (BuilderFailureException e) {
                this.handleError("Failed to add class loader: " + cl_name + " " + cl_address + " ", e);
            }
        }
        this.processTagLineOptional("3CLNMBRLOADEDLIB");
        this.processTagLineOptional("3CLNMBRLOADEDCL");
    }

    private void processLibraryLoader(IAttributeValueMap results) throws ParserException {
        String cl_name = results.getTokenValue("cl_name");
        long cl_address = results.getLongValue("cl_address");
        try {
            this.fRuntimeBuilder.addClassLoader(cl_name, cl_address, cl_address);
        }
        catch (BuilderFailureException e) {
            this.handleError("Failed to add class loader: " + cl_name + " " + cl_address + " ", e);
        }
        results = null;
        results = this.processTagLineRequired("3CLTEXTLIB");
        if (results != null) {
            this.fImageProcessBuilder.addLibrary(results.getTokenValue("cl_att_lib_name"));
            while ((results = this.processTagLineOptional("3CLTEXTLIB")) != null) {
                this.fImageProcessBuilder.addLibrary(results.getTokenValue("cl_att_lib_name"));
            }
        }
    }

    private void processClassLoaders(IAttributeValueMap results) throws ParserException {
        JavaClassLoader loader = null;
        String cl_name = results.getTokenValue("cl_name");
        long cl_address = results.getLongValue("cl_address");
        try {
            loader = this.fRuntimeBuilder.addClassLoader(cl_name, cl_address, cl_address);
        }
        catch (BuilderFailureException e) {
            this.handleError("Failed to add class loader: " + cl_name + " " + cl_address + " ", e);
        }
        while ((results = this.processTagLineOptional("3CLTEXTCLASS")) != null) {
            String className = results.getTokenValue("class_name");
            long classID = results.getLongValue("class_address");
            try {
                this.fRuntimeBuilder.addClass(loader, className, classID, -1L, null);
            }
            catch (BuilderFailureException e) {
                this.handleError("Failed to add class: " + className + " " + classID + " ", e);
            }
        }
    }

    protected void sovOnlyRules(String startingTag) throws ParserException {
    }
}

