/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.j9.JavaField;
import com.ibm.dtfj.java.j9.JavaMethod;
import com.ibm.dtfj.java.j9.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;
import com.ibm.dtfj.java.j9.JavaStackFrame;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class JavaThread
implements com.ibm.dtfj.java.JavaThread {
    private JavaRuntime _javaVM;
    private ImagePointer _objectID;
    private String _threadState;
    private ImagePointer _jniEnv;
    private Vector _stackFrames = new Vector();
    private ImageThread _imageThread;
    private JavaStackSection _stackSection;
    private com.ibm.dtfj.java.JavaObject _javaObject = null;
    private static final HashMap _threadStateMap = new HashMap();

    public JavaThread(JavaRuntime vm, ImagePointer nativeID, ImagePointer objectID, String state, ImageThread imageThread) {
        if (null == vm) {
            throw new IllegalArgumentException("A Java thread cannot exist in a null Java VM");
        }
        this._javaVM = vm;
        this._imageThread = imageThread;
        this._objectID = objectID;
        this._threadState = state;
        this._jniEnv = nativeID;
    }

    public ImagePointer getJNIEnv() throws CorruptDataException {
        return this._jniEnv;
    }

    public int getPriority() throws CorruptDataException {
        com.ibm.dtfj.java.JavaObject theObject = this.getObject();
        if (null != theObject) {
            JavaClass threadClass = this._javaLangThreadSuperclass();
            Iterator fields = threadClass.getDeclaredFields();
            while (fields.hasNext()) {
                JavaField oneField = (JavaField)fields.next();
                if (!oneField.getName().equals("priority")) continue;
                try {
                    return oneField.getInt(theObject);
                }
                catch (MemoryAccessException e) {
                    throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("unable to read memory for 'priority' field", null));
                }
            }
            throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("unable to find 'priority' field", null));
        }
        return -1;
    }

    public com.ibm.dtfj.java.JavaObject getObject() throws CorruptDataException {
        if (null == this._javaObject && 0L != this._objectID.getAddress()) {
            this._javaObject = this._javaVM.getObjectAtAddress(this._objectID);
            if (null != this._javaObject && this._javaObject instanceof JavaObject) {
                ((JavaObject)this._javaObject).setAssociatedObject(this);
            }
        }
        return this._javaObject;
    }

    public int getState() throws CorruptDataException {
        if (_threadStateMap.containsKey(this._threadState)) {
            return (Integer)_threadStateMap.get(this._threadState);
        }
        throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("Invalid thread state", this._jniEnv));
    }

    public ImageThread getImageThread() throws CorruptDataException, DataUnavailable {
        if (null == this._imageThread) {
            throw new DataUnavailable("Native thread not found");
        }
        return this._imageThread;
    }

    public Iterator getStackSections() {
        List<Object> toReturn = null;
        toReturn = null == this._stackSection ? Collections.singletonList(new CorruptData("stack section missing", this._jniEnv)) : Collections.singletonList(this._stackSection);
        return toReturn.iterator();
    }

    public Iterator getStackFrames() {
        return this._stackFrames.iterator();
    }

    public String getName() throws CorruptDataException {
        com.ibm.dtfj.java.JavaObject theObject = this.getObject();
        if (null != theObject) {
            JavaClass threadClass = this._javaLangThreadSuperclass();
            Iterator fields = threadClass.getDeclaredFields();
            while (fields.hasNext()) {
                JavaField oneField = (JavaField)fields.next();
                if (!oneField.getName().equals("name")) continue;
                try {
                    return oneField.getString(theObject);
                }
                catch (MemoryAccessException e) {
                    throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("unable to read memory for 'name' field", null));
                }
            }
            throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("unable to find 'name' field", null));
        }
        return "vmthread @" + this._jniEnv.getAddress();
    }

    private JavaClass _javaLangThreadSuperclass() throws CorruptDataException {
        JavaClass clazz;
        for (clazz = this.getObject().getJavaClass(); null != clazz && !clazz.getName().equals("java/lang/Thread"); clazz = clazz.getSuperclass()) {
        }
        if (null == clazz) {
            throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("JavaThread is not a subclass of java/lang/Thread", this.getObject().getID()));
        }
        return clazz;
    }

    public void addFrame(Object frame) {
        this._stackFrames.add(frame);
    }

    public void setStackSection(long base, long size) {
        this._stackSection = new JavaStackSection(this._jniEnv.getAddressSpace().getPointer(base), size, this);
    }

    public boolean equals(Object obj) {
        boolean isEqual;
        boolean bl = null == this._imageThread ? this == obj : (isEqual = false);
        if (null != this._imageThread && obj instanceof JavaThread) {
            JavaThread local = (JavaThread)obj;
            isEqual = this._javaVM.equals(local._javaVM) && this._imageThread.equals(local._imageThread);
        }
        return isEqual;
    }

    public int hashCode() {
        int hash = null == this._imageThread ? this._jniEnv.hashCode() : this._imageThread.hashCode();
        return this._javaVM.hashCode() ^ hash;
    }

    public void addNewStackFrame(long arguments, long method, long pc, int lineNumber) {
        JavaMethod javaMethod = this._javaVM.methodForID(method);
        ImagePointer frameAddr = this._javaVM.pointerInAddressSpace(arguments);
        ImagePointer programCounter = this._javaVM.pointerInAddressSpace(pc);
        JavaStackFrame frame = new JavaStackFrame(this._javaVM, frameAddr, javaMethod, programCounter, lineNumber);
        this.addFrame(frame);
    }

    public void setStackCorrupt() {
        this.addFrame(new CorruptData("vmthread encountered error tag where stack expected", this._jniEnv));
    }

    static {
        _threadStateMap.put("Dead", new Integer(2));
        _threadStateMap.put("Suspended", new Integer(0x100001));
        _threadStateMap.put("Running", new Integer(5));
        _threadStateMap.put("Blocked", new Integer(1025));
        _threadStateMap.put("Waiting", new Integer(385));
        _threadStateMap.put("Sleeping", new Integer(193));
        _threadStateMap.put("Parked", new Integer(641));
    }

    class JavaStackSection
    implements ImageSection {
        private ImagePointer _start;
        private long _size;
        private JavaThread _parent;

        public JavaStackSection(ImagePointer start, long size, JavaThread parent) {
            this._start = start;
            this._size = size;
            this._parent = parent;
        }

        public ImagePointer getBaseAddress() {
            return this._start;
        }

        public long getSize() {
            return this._size;
        }

        public String getName() {
            String parentName = null;
            try {
                parentName = this._parent.getName();
            }
            catch (CorruptDataException e) {
                parentName = "(corrupt data)";
            }
            return "JavaStackSection for JavaThread: " + parentName;
        }

        public boolean isExecutable() throws DataUnavailable {
            return this._start.isExecutable();
        }

        public boolean isReadOnly() throws DataUnavailable {
            return this._start.isReadOnly();
        }

        public boolean isShared() throws DataUnavailable {
            return this._start.isShared();
        }
    }
}

