/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.image.j9.ImageAddressSpace;
import com.ibm.dtfj.image.j9.ImageProcess;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaVMInitArgs;
import com.ibm.dtfj.java.j9.JavaAbstractClass;
import com.ibm.dtfj.java.j9.JavaClassLoader;
import com.ibm.dtfj.java.j9.JavaHeap;
import com.ibm.dtfj.java.j9.JavaHeapRegion;
import com.ibm.dtfj.java.j9.JavaMethod;
import com.ibm.dtfj.java.j9.JavaMonitor;
import com.ibm.dtfj.java.j9.JavaObject;
import com.ibm.dtfj.java.j9.JavaReference;
import com.ibm.dtfj.java.j9.JavaThread;
import com.ibm.dtfj.java.j9.TraceBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Vector;

public class JavaRuntime
implements com.ibm.dtfj.java.JavaRuntime {
    private ImageProcess _containingProc;
    private ImagePointer _address;
    private LinkedHashMap _classLoaders = new LinkedHashMap();
    private Vector _vmThreads = new Vector();
    private LinkedHashMap _classes = new LinkedHashMap();
    private Vector _monitors = new Vector();
    private Vector _heaps = new Vector();
    private Vector _heapRoots = new Vector();
    private HashMap _traceBuffers = new HashMap();
    private Properties _systemProperties = new Properties();
    private com.ibm.dtfj.java.j9.JavaVMInitArgs _javaVMInitArgs;
    private boolean _objectsShouldInferHash = false;
    private HashMap _methodsByID = new HashMap();
    private Vector deferMonitors = new Vector();

    public JavaRuntime(ImageProcess containingProc, ImagePointer baseAddress, String runtimeVersion) {
        if (null == baseAddress) {
            throw new IllegalArgumentException("A Java Runtime cannot have a null base address");
        }
        this._containingProc = containingProc;
        this._address = baseAddress;
        this._objectsShouldInferHash = "2.2".equals(runtimeVersion) || "2.3".equals(runtimeVersion) || "2.4".equals(runtimeVersion);
    }

    public ImagePointer getJavaVM() throws CorruptDataException {
        return this._address;
    }

    public Iterator getJavaClassLoaders() {
        return this._classLoaders.values().iterator();
    }

    public Iterator getThreads() {
        return this._vmThreads.iterator();
    }

    public Iterator getCompiledMethods() {
        Iterator classes = this._classes.values().iterator();
        Vector<JavaMethod> compiledMethods = new Vector<JavaMethod>();
        while (classes.hasNext()) {
            JavaAbstractClass oneClass = (JavaAbstractClass)classes.next();
            Iterator methods = oneClass.getDeclaredMethods();
            while (methods.hasNext()) {
                JavaMethod method = (JavaMethod)methods.next();
                if (!method.getCompiledSections().hasNext()) continue;
                compiledMethods.add(method);
            }
        }
        return compiledMethods.iterator();
    }

    public Iterator getMonitors() {
        this.checkDeferredMonitors();
        return this._monitors.iterator();
    }

    public Iterator getHeaps() {
        return this._heaps.iterator();
    }

    public Object getTraceBuffer(String bufferName, boolean formatted) throws CorruptDataException {
        return this._traceBuffers.get(bufferName);
    }

    public String getFullVersion() throws CorruptDataException {
        return this.getVersion();
    }

    public String getVersion() throws CorruptDataException {
        String javaFullVersion = this.getRequiredSystemProperty("java.fullversion");
        String javaRuntimeVersion = this.getRequiredSystemProperty("java.runtime.version");
        String javaRuntimeName = this.getRequiredSystemProperty("java.runtime.name");
        String javaVMName = this.getRequiredSystemProperty("java.vm.name");
        String version = javaRuntimeName + "(build " + javaRuntimeVersion + ")\n";
        version = version + javaVMName + "(" + javaFullVersion + ")";
        return version;
    }

    public void addClass(JavaAbstractClass theClass) {
        long id = theClass.getID().getAddress();
        this._classes.put(new Long(id), theClass);
    }

    public void addClassLoader(JavaClassLoader loader) {
        long id = loader.getID();
        this._classLoaders.put(new Long(id), loader);
    }

    public JavaClass getClassForID(long classID) {
        return (JavaClass)this._classes.get(new Long(classID));
    }

    public long getClassIDForClassName(String className, com.ibm.dtfj.java.JavaClassLoader classLoader) {
        long classID = 0L;
        for (JavaClass theClass : this._classes.values()) {
            try {
                if (!theClass.getName().equals(className) || classLoader != null && !classLoader.equals(theClass.getClassLoader())) continue;
                classID = theClass.getID().getAddress();
                break;
            }
            catch (CorruptDataException e) {
            }
        }
        return classID;
    }

    public com.ibm.dtfj.java.JavaClassLoader getClassLoaderForID(long loaderID) {
        return (com.ibm.dtfj.java.JavaClassLoader)this._classLoaders.get(new Long(loaderID));
    }

    public void addMonitor(JavaMonitor monitor) {
        this._monitors.add(monitor);
        for (int i = 0; i < this.deferMonitors.size(); ++i) {
            DeferMonitor mon = (DeferMonitor)this.deferMonitors.get(i);
            if (monitor.getID().getAddress() != mon.id) continue;
            if (mon.blocked) {
                monitor.addBlockedThread(mon.thread);
            } else {
                monitor.addWaitingThread(mon.thread);
            }
            mon.id = 0L;
        }
    }

    public void addHeap(JavaHeap heap) {
        this._heaps.add(heap);
    }

    public void addHeapRoot(JavaReference heapRoot) {
        this._heapRoots.add(heapRoot);
    }

    private void checkDeferredMonitors() {
        int errs = 0;
        for (int i = 0; i < this.deferMonitors.size(); ++i) {
            DeferMonitor mon = (DeferMonitor)this.deferMonitors.get(i);
            if (mon.id == 0L) continue;
            ImagePointer ptr = this.pointerInAddressSpace(mon.id);
            JavaMonitor autoMon = new JavaMonitor(this, ptr, "Auto-generated monitor #" + mon.id, null, 0L);
            this.addMonitor(autoMon);
            ++errs;
        }
        this.deferMonitors.clear();
    }

    public void addThread(JavaThread thread, long blockedOnMonitor, long waitingOnMonitor) {
        JavaMonitor monitor;
        boolean found;
        Iterator iter;
        this._vmThreads.add(thread);
        if (0L != blockedOnMonitor) {
            assert (0L == waitingOnMonitor) : "Thread cannot be blocked and waiting at the same time";
            iter = this._monitors.iterator();
            found = false;
            while (iter.hasNext()) {
                monitor = (JavaMonitor)iter.next();
                if (monitor.getID().getAddress() != blockedOnMonitor) continue;
                monitor.addBlockedThread(thread);
                found = true;
                break;
            }
            if (!found) {
                this.deferMonitors.add(new DeferMonitor(blockedOnMonitor, true, thread));
            }
        }
        if (0L != waitingOnMonitor) {
            assert (0L == blockedOnMonitor) : "Thread cannot be blocked and waiting at the same time";
            iter = this._monitors.iterator();
            found = false;
            while (iter.hasNext()) {
                monitor = (JavaMonitor)iter.next();
                if (monitor.getID().getAddress() != waitingOnMonitor) continue;
                monitor.addWaitingThread(thread);
                found = true;
                break;
            }
            if (!found) {
                this.deferMonitors.add(new DeferMonitor(waitingOnMonitor, false, thread));
            }
        }
    }

    public void setTraceBufferForName(TraceBuffer buffer, String key) {
        this._traceBuffers.put(key, buffer);
    }

    public String getSystemProperty(String key) {
        return this._systemProperties.getProperty(key);
    }

    public String getSystemProperty(String key, String defaultValue) {
        return this._systemProperties.getProperty(key, defaultValue);
    }

    String getRequiredSystemProperty(String key) throws CorruptDataException {
        String value = this.getSystemProperty(key);
        if (value == null) {
            throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("Required system property " + key + " not found in JExtract output", null));
        }
        return value;
    }

    public void setSystemProperty(String key, String value) {
        this._systemProperties.setProperty(key, value);
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof JavaRuntime) {
            isEqual = this._address.equals(((JavaRuntime)obj)._address);
        }
        return isEqual;
    }

    public int hashCode() {
        return this._address.hashCode();
    }

    public JavaVMInitArgs getJavaVMInitArgs() throws DataUnavailable, CorruptDataException {
        if (this._javaVMInitArgs == null) {
            throw new DataUnavailable("JavaVMInitArgs");
        }
        return this._javaVMInitArgs;
    }

    boolean objectShouldInferHash() {
        return this._objectsShouldInferHash;
    }

    public ImagePointer pointerInAddressSpace(long id) {
        return this._address.getAddressSpace().getPointer(id);
    }

    public ImageThread nativeThreadForID(long nativeID) {
        ImageThread thread = null;
        try {
            if (null != this._containingProc) {
                Iterator iter = this._containingProc.getThreads();
                while (iter.hasNext()) {
                    ImageThread t = (ImageThread)iter.next();
                    if (Long.decode(t.getID()) != nativeID) continue;
                    thread = t;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return thread;
    }

    public JavaMethod methodForID(long method) {
        return (JavaMethod)this._methodsByID.get(new Long(method));
    }

    public void addMethodForID(JavaMethod method, long id) {
        this._methodsByID.put(new Long(id), method);
    }

    public com.ibm.dtfj.java.j9.JavaVMInitArgs createJavaVMInitArgs(int version, boolean ignoreUnrecognized) {
        if (null != this._javaVMInitArgs) {
            throw new IllegalStateException("JavaVMInitArgs being created more than once");
        }
        this._javaVMInitArgs = new com.ibm.dtfj.java.j9.JavaVMInitArgs(this._address.getAddressSpace(), version, ignoreUnrecognized);
        return this._javaVMInitArgs;
    }

    public int bytesPerPointer() {
        return ((ImageAddressSpace)this._address.getAddressSpace()).bytesPerPointer();
    }

    protected Iterator getClasses() {
        return this._classes.values().iterator();
    }

    public Iterator getHeapRoots() {
        return this._heapRoots.iterator();
    }

    public com.ibm.dtfj.java.JavaObject getObjectAtAddress(ImagePointer address) throws CorruptDataException, IllegalArgumentException {
        if (null == address || 0L == address.getAddress()) {
            return null;
        }
        Iterator heaps = this.getHeaps();
        JavaHeapRegion region = null;
        JavaHeap heap = null;
        while (null == region && heaps.hasNext()) {
            heap = (JavaHeap)heaps.next();
            region = heap.regionForPointer(address);
        }
        if (null == region) {
            return new JavaObject(this, address, heap, 0L, 0L, false);
        }
        return region.getObjectAtAddress(address);
    }

    private static class DeferMonitor {
        long id;
        boolean blocked;
        JavaThread thread;

        DeferMonitor(long id, boolean blocked, JavaThread thread) {
            this.id = id;
            this.blocked = blocked;
            this.thread = thread;
        }

        public String toString() {
            return "Defer monitor " + this.id;
        }
    }
}

