/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import java.security.AccessController;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

public class CharToByteUTF8
extends CharToByteConverter {
    private char highHalfZoneCode;
    private String bidiParms = bidiInit;
    private boolean bidiEnabled = false;
    private static String bidiInit;

    public CharToByteUTF8() {
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    public int flush(byte[] byArray, int n, int n2) throws MalformedInputException {
        if (this.highHalfZoneCode != '\u0000') {
            this.reset();
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    public int convert(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws ConversionBufferFullException, MalformedInputException {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        BidiConvert bidiConvert;
        int n10;
        char c = '\u0000';
        int n11 = n4;
        int n12 = n2;
        int n13 = n;
        int n14 = n3;
        if (this.highHalfZoneCode != '\u0000') {
            c = this.highHalfZoneCode;
            this.highHalfZoneCode = '\u0000';
            if (cArray[n] >= '\udc00' && cArray[n] <= '\udfff') {
                if (n14 + 4 > n11) {
                    this.charOff = n13;
                    this.byteOff = n14;
                    throw new ConversionBufferFullException();
                }
                n10 = (this.highHalfZoneCode - 55296) * 1024 + (cArray[n] - 56320) + 65536;
                byArray[n14++] = (byte)(0xF0 | n10 >> 18 & 7);
                byArray[n14++] = (byte)(0x80 | n10 >> 12 & 0x3F);
                byArray[n14++] = (byte)(0x80 | n10 >> 6 & 0x3F);
                byArray[n14++] = (byte)(0x80 | n10 & 0x3F);
                ++n13;
                this.highHalfZoneCode = '\u0000';
            } else {
                this.badInputLength = 0;
                this.charOff = n13;
                this.byteOff = n14;
                throw new MalformedInputException();
            }
        }
        if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(cArray, n13, n12, this.bidiParms, this.getCharacterEncoding())) {
            n9 = n13;
            n8 = n12;
            int n15 = 0;
            int n16 = n11 - n14;
            for (n7 = n9; n7 < n8; ++n7) {
                n6 = cArray[n7];
                if (n6 < 128) {
                    n5 = 1;
                } else if (n6 < 2048) {
                    n5 = 2;
                } else if (n6 < 55296 || n6 >= 57344) {
                    n5 = 3;
                } else {
                    char c2;
                    if (n6 < 56320 ? n7 + 1 >= n8 || (c2 = cArray[n7 + 1]) < '\udc00' || c2 >= '\ue000' : n7 == n9 || (c2 = cArray[n7 - 1]) < '\ud800' || c2 >= '\udc00') break;
                    n5 = 2;
                }
                if (n15 + n5 > n16) break;
                n15 += n5;
            }
            n5 = n7 - n9;
            char[] cArray2 = new char[n5];
            cArray2 = bidiConvert.toSbcs(cArray, n13, n13 + n5, this.bidiParms, this.getCharacterEncoding());
            System.arraycopy(cArray2, 0, cArray, n13, n5);
        }
        n9 = (n5 = n11 - n14) < (n10 = n12 - n13) ? n5 : n10;
        for (n8 = 0; n8 < n9 && (c = cArray[n13 + n8]) <= '\u007f'; ++n8) {
            byArray[n14 + n8] = (byte)c;
        }
        n13 += n8;
        n14 += n8;
        if (n8 == n10) {
            this.charOff = n13;
            this.byteOff = n14;
            return n9;
        }
        while (n13 < n12) {
            c = cArray[n13];
            if (c < '\u0080') {
                if (n14 >= n11) {
                    this.charOff = n13;
                    this.byteOff = n14;
                    throw new ConversionBufferFullException();
                }
                byArray[n14++] = (byte)c;
                ++n13;
                continue;
            }
            if (c < '\u0800') {
                if (n14 + 2 > n11) {
                    this.charOff = n13;
                    this.byteOff = n14;
                    throw new ConversionBufferFullException();
                }
                byArray[n14++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n14++] = (byte)(0x80 | c & 0x3F);
                ++n13;
                continue;
            }
            if (c < '\ud800' || c >= '\ue000') {
                if (n14 + 3 > n11) {
                    this.charOff = n13;
                    this.byteOff = n14;
                    throw new ConversionBufferFullException();
                }
                byArray[n14++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n14++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n14++] = (byte)(0x80 | c & 0x3F);
                ++n13;
                continue;
            }
            if (c >= '\udc00') {
                this.badInputLength = 1;
                this.charOff = n13;
                this.byteOff = n14;
                throw new MalformedInputException();
            }
            if (n13 + 1 >= n12) {
                this.highHalfZoneCode = c;
                break;
            }
            n7 = cArray[n13 + 1];
            if (n7 < 56320 || n7 > 57343) {
                this.badInputLength = 1;
                this.charOff = n13;
                this.byteOff = n14;
                throw new MalformedInputException();
            }
            if (n14 + 4 > n11) {
                this.charOff = n13;
                this.byteOff = n14;
                throw new ConversionBufferFullException();
            }
            n6 = (c - 55296) * 1024 + (n7 - 56320) + 65536;
            byArray[n14++] = (byte)(0xF0 | n6 >> 18 & 7);
            byArray[n14++] = (byte)(0x80 | n6 >> 12 & 0x3F);
            byArray[n14++] = (byte)(0x80 | n6 >> 6 & 0x3F);
            byArray[n14++] = (byte)(0x80 | n6 & 0x3F);
            n13 += 2;
        }
        this.charOff = n13;
        this.byteOff = n14;
        return n14 - n3;
    }

    public boolean canConvert(char c) {
        return true;
    }

    public int getMaxBytesPerChar() {
        return 3;
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        this.highHalfZoneCode = '\u0000';
    }

    public String getCharacterEncoding() {
        return "UTF8";
    }
}

