/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.beans.editors;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;

public class FontEditor
extends Panel
implements PropertyEditor {
    List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private Font value;
    private Object source;

    public FontEditor(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.source = object;
    }

    public FontEditor() {
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public String getJavaInitializationString() {
        String string = null;
        if (this.value != null) {
            String string2 = this.value.getName();
            int n = this.value.getStyle();
            int n2 = this.value.getSize();
            string = "new Font(" + string2 + "," + n + "," + n2 + ")";
        }
        return string;
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public void setValue(Object object) {
        Font font = this.value;
        this.value = (Font)object;
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "value", font, this.value);
        PropertyChangeListener[] propertyChangeListenerArray = new PropertyChangeListener[this.listeners.size()];
        this.listeners.toArray(propertyChangeListenerArray);
        for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Font font = (Font)this.getValue();
        if (font != null) {
            graphics.setFont(font);
            graphics.drawBytes("Hello".getBytes(), rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        }
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException(string == null ? string : this.value.toString());
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners != null) {
            this.listeners.remove(propertyChangeListener);
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ArrayList<PropertyChangeListener> arrayList = new ArrayList<PropertyChangeListener>(this.listeners.size());
        Object object = this.listeners;
        synchronized (object) {
            arrayList.addAll(this.listeners);
        }
        object = new PropertyChangeEvent(this.source, null, null, null);
        for (PropertyChangeListener propertyChangeListener : arrayList) {
            propertyChangeListener.propertyChange((PropertyChangeEvent)object);
        }
    }
}

