/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.StringTokenizer;
import org.apache.harmony.beans.internal.nls.Messages;

public class EventHandler
implements InvocationHandler {
    private Object target;
    private String action;
    private String eventPropertyName;
    private String listenerMethodName;

    public EventHandler(Object object, String string, String string2, String string3) {
        if (object == null || string == null) {
            throw new NullPointerException();
        }
        this.target = object;
        this.action = string;
        this.eventPropertyName = string2;
        this.listenerMethodName = string3;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        Class<?> clazz;
        Object object2 = null;
        Object[] objectArray2 = objectArray;
        if (objectArray == null) {
            objectArray2 = new Object[]{};
        }
        if (Proxy.isProxyClass(clazz = object.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
            if (invocationHandler instanceof EventHandler) {
                if (method.getDeclaringClass().equals(Object.class)) {
                    if (method.getName().equals("hashCode") && objectArray2.length == 0) {
                        object2 = this.hashCode();
                    } else if (method.getName().equals("equals") && objectArray2.length == 1 && objectArray2[0] != null) {
                        object2 = object == objectArray2[0];
                    } else if (method.getName().equals("toString") && objectArray2.length == 0) {
                        object2 = object.getClass().getSimpleName() + this.toString().substring(this.getClass().getName().length());
                    }
                } else if (this.isValidInvocation(method, objectArray2)) {
                    try {
                        Object[] objectArray3 = this.getArgs(objectArray2);
                        Method method2 = this.getMethod(object, method, objectArray2, objectArray3);
                        object2 = method2.invoke(this.target, objectArray3);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                } else if (this.listenerMethodName.equals(method.getName())) {
                    throw new IllegalArgumentException(Messages.getString("beans.4D"));
                }
            }
        } else if (null == method) {
            throw new NullPointerException(Messages.getString("beans.55"));
        }
        return object2;
    }

    public String getListenerMethodName() {
        return this.listenerMethodName;
    }

    public String getEventPropertyName() {
        return this.eventPropertyName;
    }

    public String getAction() {
        return this.action;
    }

    public Object getTarget() {
        return this.target;
    }

    public static <T> T create(Class<T> clazz, Object object, String string, String string2, String string3) {
        if (string == null || object == null || clazz == null) {
            throw new NullPointerException();
        }
        return (T)Proxy.newProxyInstance(object.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new EventHandler(object, string, string2, string3));
    }

    public static <T> T create(Class<T> clazz, Object object, String string, String string2) {
        return EventHandler.create(clazz, object, string, string2, null);
    }

    public static <T> T create(Class<T> clazz, Object object, String string) {
        return EventHandler.create(clazz, object, string, null, null);
    }

    private boolean isValidInvocation(Method method, Object[] objectArray) {
        boolean bl = false;
        bl = this.listenerMethodName == null ? true : (this.listenerMethodName.equals(method.getName()) ? (this.eventPropertyName == null && (objectArray == null || objectArray.length == 0) ? true : objectArray != null && objectArray.length == 1) : false);
        return bl;
    }

    private Object[] getArgs(Object[] objectArray) throws Exception {
        if (this.eventPropertyName == null) {
            return new Object[0];
        }
        if (objectArray == null || objectArray.length == 0) {
            return objectArray;
        }
        Object object = objectArray[0];
        StringTokenizer stringTokenizer = new StringTokenizer(this.eventPropertyName, ".");
        while (stringTokenizer.hasMoreTokens()) {
            Method method;
            String string = stringTokenizer.nextToken();
            PropertyDescriptor propertyDescriptor = this.findPropertyDescriptor(object.getClass(), string);
            if (propertyDescriptor != null) {
                method = propertyDescriptor.getReadMethod();
                if (method != null) {
                    object = method.invoke(object, new Object[0]);
                    continue;
                }
                throw new IntrospectionException(Messages.getString("beans.11", string));
            }
            method = this.findStaticGetter(object.getClass(), string);
            if (method != null) {
                object = method.invoke(null, new Object[0]);
                continue;
            }
            throw new NullPointerException(Messages.getString("beans.12", string));
        }
        return new Object[]{object};
    }

    private Method getMethod(Object object, Method method, Object[] objectArray, Object[] objectArray2) throws Exception {
        Method method2;
        block13: {
            Object object2;
            method2 = null;
            boolean bl = false;
            if (this.listenerMethodName == null) {
                object2 = object.getClass().getInterfaces();
                for (Class<?> clazz : object2) {
                    Method[] methodArray;
                    for (Method method3 : methodArray = clazz.getMethods()) {
                        if (!EventHandler.equalNames(method3, method) || !EventHandler.canInvokeWithArguments(method3, objectArray)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        continue;
                    }
                    break;
                }
            } else if (method.getName().equals(this.listenerMethodName)) {
                bl = true;
            }
            if (!bl) {
                return null;
            }
            try {
                method2 = this.findMethod(this.target.getClass(), objectArray2);
                if (method2 == null) {
                    object2 = this.findPropertyDescriptor(this.target.getClass(), this.action);
                    if (object2 != null) {
                        method2 = ((PropertyDescriptor)object2).getWriteMethod();
                        if (method2 == null) {
                            throw new NoSuchMethodException(Messages.getString("beans.13", this.action));
                        }
                        break block13;
                    }
                    throw new IndexOutOfBoundsException(Messages.getString("beans.14"));
                }
                return method2;
            }
            catch (IntrospectionException introspectionException) {
                throw new IndexOutOfBoundsException(Messages.getString("beans.14"));
            }
        }
        return method2;
    }

    private PropertyDescriptor findPropertyDescriptor(Class<?> clazz, String string) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptorArray;
        PropertyDescriptor propertyDescriptor = null;
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        for (PropertyDescriptor propertyDescriptor2 : propertyDescriptorArray = beanInfo.getPropertyDescriptors()) {
            if (!propertyDescriptor2.getName().equals(string)) continue;
            propertyDescriptor = propertyDescriptor2;
            break;
        }
        return propertyDescriptor;
    }

    private Method findStaticGetter(Class<?> clazz, String string) {
        Method[] methodArray;
        Method method = null;
        for (Method method2 : methodArray = clazz.getMethods()) {
            int n = method2.getModifiers();
            if (!Modifier.isStatic(n) || !Modifier.isPublic(n)) continue;
            String string2 = method2.getName();
            String string3 = null;
            if (string2.startsWith("get")) {
                string3 = string2.substring(3);
            } else {
                if (!string2.startsWith("is")) continue;
                string3 = string2.substring(2);
            }
            if (method2.getParameterTypes().length != 0 || method2.getReturnType() == Void.TYPE || !(string3 = Introspector.decapitalize(string3)).equals(string)) continue;
            method = method2;
            break;
        }
        return method;
    }

    private Method findMethod(Class<?> clazz, Object[] objectArray) {
        Method[] methodArray;
        for (Method method : methodArray = clazz.getMethods()) {
            if (!this.action.equals(method.getName()) || !EventHandler.canInvokeWithArguments(method, objectArray)) continue;
            return method;
        }
        return null;
    }

    private static boolean isPrimitiveWrapper(Class<?> clazz, Class<?> clazz2) {
        return clazz2 == Boolean.TYPE && clazz == Boolean.class || clazz2 == Byte.TYPE && clazz == Byte.class || clazz2 == Character.TYPE && clazz == Character.class || clazz2 == Short.TYPE && clazz == Short.class || clazz2 == Integer.TYPE && clazz == Integer.class || clazz2 == Long.TYPE && clazz == Long.class || clazz2 == Float.TYPE && clazz == Float.class || clazz2 == Double.TYPE && clazz == Double.class;
    }

    private static boolean canInvokeWithArguments(Method method, Object[] objectArray) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length == objectArray.length) {
            for (int i = 0; i < objectArray.length; ++i) {
                Class<?> clazz;
                Class<?> clazz2 = clazz = objectArray[i] == null ? null : objectArray[i].getClass();
                if (clazz == null || EventHandler.isPrimitiveWrapper(clazz, classArray[i]) || clazz.isAssignableFrom(classArray[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static boolean equalNames(Method method, Method method2) {
        return method.getName().equals(method2.getName());
    }
}

