/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NoSuchMechanismException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.DigestMethodParameterSpec;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;

public abstract class XMLSignatureFactory {
    private String mechanismType;
    private Provider provider;
    private static Class cl;
    private static final Class[] getImplParams;
    private static Method getImplMethod;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$security$Provider;

    protected XMLSignatureFactory() {
    }

    public static XMLSignatureFactory getInstance(String mechanismType) {
        if (mechanismType == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        return XMLSignatureFactory.findInstance(mechanismType, null);
    }

    private static XMLSignatureFactory findInstance(String mechanismType, Provider provider) {
        if (getImplMethod == null) {
            throw new NoSuchMechanismException("Cannot find " + mechanismType + " mechanism type");
        }
        Object[] objs = null;
        try {
            objs = (Object[])getImplMethod.invoke(null, mechanismType, "XMLSignatureFactory", provider);
        }
        catch (IllegalAccessException iae) {
            throw new NoSuchMechanismException("Cannot find " + mechanismType + " mechanism type", iae);
        }
        catch (InvocationTargetException ite) {
            throw new NoSuchMechanismException("Cannot find " + mechanismType + " mechanism type", ite);
        }
        XMLSignatureFactory factory = (XMLSignatureFactory)objs[0];
        factory.mechanismType = mechanismType;
        factory.provider = (Provider)objs[1];
        return factory;
    }

    public static XMLSignatureFactory getInstance(String mechanismType, Provider provider) {
        if (mechanismType == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        if (provider == null) {
            throw new NullPointerException("provider cannot be null");
        }
        return XMLSignatureFactory.findInstance(mechanismType, provider);
    }

    public static XMLSignatureFactory getInstance(String mechanismType, String provider) throws NoSuchProviderException {
        if (mechanismType == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        if (provider == null) {
            throw new NullPointerException("provider cannot be null");
        }
        Provider prov = Security.getProvider(provider);
        if (prov == null) {
            throw new NoSuchProviderException("cannot find provider named " + provider);
        }
        return XMLSignatureFactory.findInstance(mechanismType, prov);
    }

    public static XMLSignatureFactory getInstance() {
        return XMLSignatureFactory.getInstance("DOM");
    }

    public final String getMechanismType() {
        return this.mechanismType;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public abstract XMLSignature newXMLSignature(SignedInfo var1, KeyInfo var2);

    public abstract XMLSignature newXMLSignature(SignedInfo var1, KeyInfo var2, List var3, String var4, String var5);

    public abstract Reference newReference(String var1, DigestMethod var2);

    public abstract Reference newReference(String var1, DigestMethod var2, List var3, String var4, String var5);

    public abstract Reference newReference(String var1, DigestMethod var2, List var3, String var4, String var5, byte[] var6);

    public abstract Reference newReference(String var1, DigestMethod var2, List var3, Data var4, List var5, String var6, String var7);

    public abstract SignedInfo newSignedInfo(CanonicalizationMethod var1, SignatureMethod var2, List var3);

    public abstract SignedInfo newSignedInfo(CanonicalizationMethod var1, SignatureMethod var2, List var3, String var4);

    public abstract XMLObject newXMLObject(List var1, String var2, String var3, String var4);

    public abstract Manifest newManifest(List var1);

    public abstract Manifest newManifest(List var1, String var2);

    public abstract SignatureProperty newSignatureProperty(List var1, String var2, String var3);

    public abstract SignatureProperties newSignatureProperties(List var1, String var2);

    public abstract DigestMethod newDigestMethod(String var1, DigestMethodParameterSpec var2) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException;

    public abstract SignatureMethod newSignatureMethod(String var1, SignatureMethodParameterSpec var2) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException;

    public abstract Transform newTransform(String var1, TransformParameterSpec var2) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException;

    public abstract Transform newTransform(String var1, XMLStructure var2) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException;

    public abstract CanonicalizationMethod newCanonicalizationMethod(String var1, C14NMethodParameterSpec var2) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException;

    public abstract CanonicalizationMethod newCanonicalizationMethod(String var1, XMLStructure var2) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException;

    public final KeyInfoFactory getKeyInfoFactory() {
        return KeyInfoFactory.getInstance(this.getMechanismType(), this.getProvider());
    }

    public abstract XMLSignature unmarshalXMLSignature(XMLValidateContext var1) throws MarshalException;

    public abstract XMLSignature unmarshalXMLSignature(XMLStructure var1) throws MarshalException;

    public abstract boolean isFeatureSupported(String var1);

    public abstract URIDereferencer getURIDereferencer();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        getImplParams = new Class[]{class$java$lang$String == null ? (class$java$lang$String = XMLSignatureFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = XMLSignatureFactory.class$("java.lang.String")) : class$java$lang$String, class$java$security$Provider == null ? (class$java$security$Provider = XMLSignatureFactory.class$("java.security.Provider")) : class$java$security$Provider};
        try {
            cl = Class.forName("javax.xml.crypto.dsig.XMLDSigSecurity");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        getImplMethod = (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method m = null;
                try {
                    m = cl.getDeclaredMethod("getImpl", getImplParams);
                    if (m != null) {
                        m.setAccessible(true);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return m;
            }
        });
    }
}

