/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejb.portable;

import com.ibm.ws.ejb.portable.Constants;
import com.ibm.ws.ejb.portable.LegacyHandleDelegateImpl;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.HomeHandle;
import javax.ejb.spi.HandleDelegate;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.rmi.PortableRemoteObject;

public class HomeHandleImpl
implements HomeHandle,
Serializable {
    private static final long serialVersionUID = 3592459660841320056L;
    static final byte[] EYECATCHER = Constants.HOME_HANDLE_EYE_CATCHER;
    static final short PLATFORM = 1;
    private transient EJBHome ivEjbHome;
    private transient short ivActualVersion;
    private transient String ivJndiName = null;
    private transient String ivHomeInterface = null;
    private transient Properties ivInitialContextProperties = null;

    public HomeHandleImpl(EJBHome home) {
        this.ivEjbHome = home;
        this.ivActualVersion = (short)2;
    }

    public EJBHome getEJBHome() throws RemoteException {
        if (this.ivEjbHome == null) {
            try {
                Class<?> homeClass = null;
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    if (cl == null) {
                        throw new ClassNotFoundException();
                    }
                    homeClass = cl.loadClass(this.ivHomeInterface);
                }
                catch (ClassNotFoundException ex) {
                    try {
                        homeClass = Class.forName(this.ivHomeInterface);
                    }
                    catch (ClassNotFoundException e) {
                        throw new ClassNotFoundException(this.ivHomeInterface);
                    }
                }
                InitialContext ctx = null;
                try {
                    if (this.ivInitialContextProperties == null) {
                        ctx = new InitialContext();
                    } else {
                        try {
                            ctx = new InitialContext(this.ivInitialContextProperties);
                        }
                        catch (NamingException ne) {
                            ctx = new InitialContext();
                        }
                    }
                    this.ivEjbHome = (EJBHome)PortableRemoteObject.narrow((Object)ctx.lookup(this.ivJndiName), homeClass);
                }
                catch (NoInitialContextException e) {
                    Properties p = new Properties();
                    p.put("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
                    ctx = new InitialContext(p);
                    this.ivEjbHome = (EJBHome)PortableRemoteObject.narrow((Object)ctx.lookup(this.ivJndiName), homeClass);
                }
            }
            catch (NamingException e) {
                NoSuchObjectException re = new NoSuchObjectException("Could not find home in JNDI");
                re.detail = e;
                throw re;
            }
            catch (ClassNotFoundException e) {
                throw new RemoteException("Could not load home interface", e);
            }
        }
        return this.ivEjbHome;
    }

    private HandleDelegate lookupHandleDelegate() {
        HandleDelegate hd = null;
        try {
            InitialContext initCtx = new InitialContext();
            hd = (HandleDelegate)initCtx.lookup("java:comp/HandleDelegate");
        }
        catch (NamingException e) {
            hd = LegacyHandleDelegateImpl.getInstance();
        }
        return hd;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.write(EYECATCHER);
        out.writeShort(1);
        out.writeShort(this.ivActualVersion);
        this.lookupHandleDelegate().writeEJBHome(this.ivEjbHome, out);
        if (this.ivActualVersion == 1) {
            out.writeObject(this.ivInitialContextProperties);
            out.writeUTF(this.ivHomeInterface);
            out.writeUTF(this.ivJndiName);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block6: {
            in.defaultReadObject();
            byte[] tempEyeCatcher = new byte[4];
            int bytesRead = 0;
            for (int offset = 0; offset < 4; offset += bytesRead) {
                bytesRead = in.read(tempEyeCatcher, offset, 4 - offset);
                if (bytesRead != -1) continue;
                throw new IOException("end of input stream while reading eye catcher");
            }
            for (int i = 0; i < EYECATCHER.length; ++i) {
                if (tempEyeCatcher[i] == EYECATCHER[i]) continue;
                String eyeCatcherString = new String(tempEyeCatcher);
                throw new IOException("Invalid eye catcher '" + eyeCatcherString + "' in handle input stream");
            }
            short tempPlatform = in.readShort();
            this.ivActualVersion = in.readShort();
            if (this.ivActualVersion != 1 && this.ivActualVersion != 2) {
                throw new InvalidObjectException("Home Handle data stream is not of the correct version, this client should be updated.");
            }
            try {
                this.ivEjbHome = this.lookupHandleDelegate().readEJBHome(in);
            }
            catch (IOException ioe) {
                if (this.ivActualVersion == 1) break block6;
                throw ioe;
            }
        }
        if (this.ivActualVersion == 1) {
            this.ivInitialContextProperties = (Properties)in.readObject();
            this.ivHomeInterface = in.readUTF();
            this.ivJndiName = in.readUTF();
            this.ivEjbHome = null;
        }
    }
}

