/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xml.type.internal;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.xml.type.InvalidDatatypeValueException;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;

public final class XMLCalendar {
    public static final short DATETIME = 0;
    public static final short TIME = 1;
    public static final short DATE = 2;
    public static final short GYEARMONTH = 3;
    public static final short GYEAR = 4;
    public static final short GMONTHDAY = 5;
    public static final short GDAY = 6;
    public static final short GMONTH = 7;
    public static final int EQUALS = 0;
    public static final int LESS_THAN = -1;
    public static final int GREATER_THAN = 1;
    public static final int INDETERMINATE = 2;
    protected static final int CY = 0;
    protected static final int M = 1;
    protected static final int D = 2;
    protected static final int h = 3;
    protected static final int m = 4;
    protected static final int s = 5;
    protected static final int ms = 6;
    protected static final int utc = 7;
    protected static final int hh = 0;
    protected static final int mm = 1;
    protected static final int TOTAL_SIZE = 8;
    private static final int DAY_SIZE = 5;
    private static final int MONTHDAY_SIZE = 7;
    protected static final int YEAR = 2000;
    protected static final int MONTH = 1;
    protected static final int DAY = 15;
    private int[] dateValue;
    final short dataType;
    private Date date;
    protected static final DateFormat[] EDATE_FORMATS = new DateFormat[]{new SafeSimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"), new SafeSimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"), new SafeSimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'S"), new SafeSimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'S'Z'"), new SafeSimpleDateFormat("yyyy-MM-dd'Z'"), new SafeSimpleDateFormat("yyyy-MM-dd")};

    public XMLCalendar(String value2, short datatype) {
        EDATE_FORMATS[0].setTimeZone(TimeZone.getTimeZone("GMT"));
        EDATE_FORMATS[3].setTimeZone(TimeZone.getTimeZone("GMT"));
        if (value2 == null || value2.length() == 0) {
            throw new InvalidDatatypeValueException("Incomplete value");
        }
        this.dataType = datatype;
        switch (this.dataType) {
            case 0: {
                this.dateValue = this.parseDateTime(value2);
                break;
            }
            case 1: {
                this.dateValue = this.parseTime(value2);
                break;
            }
            case 2: {
                this.dateValue = this.parseDate(value2);
                break;
            }
            case 4: {
                this.dateValue = this.parseYear(value2);
                break;
            }
            case 3: {
                this.dateValue = this.parseYearMonth(value2);
                break;
            }
            case 5: {
                this.dateValue = this.parseMonthDay(value2);
                break;
            }
            case 7: {
                this.dateValue = this.parseMonth(value2);
                break;
            }
            case 6: {
                this.dateValue = this.parseDay(value2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal datatype value");
            }
        }
    }

    public XMLCalendar(Date date, short dataType) {
        EDATE_FORMATS[0].setTimeZone(TimeZone.getTimeZone("GMT"));
        EDATE_FORMATS[3].setTimeZone(TimeZone.getTimeZone("GMT"));
        this.date = date;
        this.dataType = dataType;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XMLCalendar)) {
            return false;
        }
        XMLCalendar xmlCalendarObj = (XMLCalendar)obj;
        if (this.dataType != xmlCalendarObj.dataType) {
            return false;
        }
        return XMLCalendar.compare(this, (XMLCalendar)obj) == 0;
    }

    public int hashCode() {
        int hashCode = this.dataType;
        int[] dateValue = this.getDateValue();
        int i = 0;
        while (i < 8) {
            hashCode ^= dateValue[i];
            ++i;
        }
        return hashCode;
    }

    public String toString() {
        switch (this.dataType) {
            case 0: {
                return this.dateTimeToString();
            }
            case 1: {
                return this.timeToString();
            }
            case 2: {
                return this.dateToString();
            }
            case 4: {
                return this.yearToString();
            }
            case 3: {
                return this.yearMonthToString();
            }
            case 5: {
                return this.monthDayToString();
            }
            case 7: {
                return this.monthToString();
            }
            case 6: {
                return this.dayToString();
            }
        }
        return null;
    }

    public static int compare(XMLCalendar value1, XMLCalendar value2) {
        return value1.dataType != value2.dataType ? 2 : XMLCalendar.compareDates(value1.getDateValue(), value2.getDateValue(), true);
    }

    protected int[] getDateValue() {
        if (this.dateValue == null) {
            this.dateValue = this.parseDateTime(EDATE_FORMATS[0].format(this.date));
        }
        return this.dateValue;
    }

    public Date getDate() {
        block13: {
            if (this.date == null) {
                try {
                    if (this.dataType == 0) {
                        try {
                            this.date = EDATE_FORMATS[0].parse(this.dateTimeToString());
                        }
                        catch (Exception e) {
                            try {
                                this.date = EDATE_FORMATS[1].parse(this.dateTimeToString());
                                break block13;
                            }
                            catch (Exception e2) {
                                try {
                                    this.date = EDATE_FORMATS[2].parse(this.dateTimeToString());
                                    break block13;
                                }
                                catch (Exception e3) {
                                    this.date = EDATE_FORMATS[3].parse(this.dateTimeToString());
                                }
                            }
                        }
                        break block13;
                    }
                    if (this.dataType == 2) {
                        try {
                            this.date = EDATE_FORMATS[4].parse(this.dateToString());
                        }
                        catch (Exception e) {
                            this.date = EDATE_FORMATS[5].parse(this.dateToString());
                        }
                    }
                }
                catch (Exception e) {
                    throw new WrappedException(e);
                }
            }
        }
        return this.date;
    }

    private static int compareDates(int[] date1, int[] date2, boolean strict) {
        if (date1[7] == date2[7]) {
            return XMLCalendar.compareOrder(date1, date2);
        }
        int[] tempDate = new int[8];
        int[] timeZone = new int[2];
        if (date1[7] == 90) {
            XMLCalendar.cloneDate(date2, tempDate);
            timeZone[0] = 14;
            timeZone[1] = 0;
            tempDate[7] = 43;
            XMLCalendar.normalize(tempDate, timeZone);
            short c1 = XMLCalendar.compareOrder(date1, tempDate);
            if (c1 == -1) {
                return c1;
            }
            XMLCalendar.cloneDate(date2, tempDate);
            timeZone[0] = 14;
            timeZone[1] = 0;
            tempDate[7] = 45;
            XMLCalendar.normalize(tempDate, timeZone);
            short c2 = XMLCalendar.compareOrder(date1, tempDate);
            if (c2 == 1) {
                return c2;
            }
            return 2;
        }
        if (date2[7] == 90) {
            XMLCalendar.cloneDate(date1, tempDate);
            timeZone[0] = 14;
            timeZone[1] = 0;
            tempDate[7] = 45;
            XMLCalendar.normalize(tempDate, timeZone);
            short c1 = XMLCalendar.compareOrder(tempDate, date2);
            if (c1 == -1) {
                return c1;
            }
            XMLCalendar.cloneDate(date1, tempDate);
            timeZone[0] = 14;
            timeZone[1] = 0;
            tempDate[7] = 43;
            XMLCalendar.normalize(tempDate, timeZone);
            short c2 = XMLCalendar.compareOrder(tempDate, date2);
            if (c2 == 1) {
                return c2;
            }
            return 2;
        }
        return 2;
    }

    protected static short compareOrder(int[] date1, int[] date2) {
        int i = 0;
        while (i < 8) {
            if (date1[i] < date2[i]) {
                return -1;
            }
            if (date1[i] > date2[i]) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    protected static void getTime(String buffer, int start, int end, int[] data, int[] timeZone) {
        int stop = start + 2;
        data[3] = XMLCalendar.parseInt(buffer, start, stop);
        if (buffer.charAt(stop++) != ':') {
            throw new InvalidDatatypeValueException("Error in parsing time zone");
        }
        start = stop;
        data[4] = XMLCalendar.parseInt(buffer, start, stop += 2);
        if (buffer.charAt(stop++) != ':') {
            throw new InvalidDatatypeValueException("Error in parsing time zone");
        }
        start = stop;
        data[5] = XMLCalendar.parseInt(buffer, start, stop += 2);
        if (stop == end) {
            return;
        }
        start = stop;
        int milisec = buffer.charAt(start) == '.' ? start : -1;
        int sign = XMLCalendar.findUTCSign(buffer, start, end);
        if (milisec != -1) {
            start = sign < 0 ? end : sign;
            data[6] = XMLCalendar.parseInt(buffer, milisec + 1, start);
        }
        if (sign > 0) {
            if (start != sign) {
                throw new InvalidDatatypeValueException("Error in parsing time zone");
            }
            XMLCalendar.getTimeZone(buffer, data, sign, end, timeZone);
        } else if (start != end) {
            throw new InvalidDatatypeValueException("Error in parsing time zone");
        }
    }

    protected static int getDate(String buffer, int start, int end, int[] date) {
        start = XMLCalendar.getYearMonth(buffer, start, end, date);
        if (buffer.charAt(start++) != '-') {
            throw new InvalidDatatypeValueException("CCYY-MM must be followed by '-' sign");
        }
        int stop = start + 2;
        date[2] = XMLCalendar.parseInt(buffer, start, stop);
        return stop;
    }

    protected static int getYearMonth(String buffer, int start, int end, int[] date) {
        int i;
        if (buffer.charAt(0) == '-') {
            ++start;
        }
        if ((i = XMLCalendar.indexOf(buffer, start, end, '-')) == -1) {
            throw new InvalidDatatypeValueException("Year separator is missing or misplaced");
        }
        int length = i - start;
        if (length < 4) {
            throw new InvalidDatatypeValueException("Year must have 'CCYY' format");
        }
        if (length > 4 && buffer.charAt(start) == '0') {
            throw new InvalidDatatypeValueException("Leading zeros are required if the year value would otherwise have fewer than four digits; otherwise they are forbidden");
        }
        date[0] = XMLCalendar.parseIntYear(buffer, i);
        if (buffer.charAt(i) != '-') {
            throw new InvalidDatatypeValueException("CCYY must be followed by '-' sign");
        }
        start = ++i;
        i = start + 2;
        date[1] = XMLCalendar.parseInt(buffer, start, i);
        return i;
    }

    protected static void parseTimeZone(String buffer, int start, int end, int[] date, int[] timeZone) {
        if (start < end) {
            int sign = XMLCalendar.findUTCSign(buffer, start, end);
            if (sign < 0) {
                throw new InvalidDatatypeValueException("Error in month parsing");
            }
            XMLCalendar.getTimeZone(buffer, date, sign, end, timeZone);
        }
    }

    protected static void getTimeZone(String buffer, int[] data, int sign, int end, int[] timeZone) {
        data[7] = buffer.charAt(sign);
        if (buffer.charAt(sign) == 'Z') {
            if (end > ++sign) {
                throw new InvalidDatatypeValueException("Error in parsing time zone");
            }
            return;
        }
        if (sign <= end - 6) {
            int stop = ++sign + 2;
            timeZone[0] = XMLCalendar.parseInt(buffer, sign, stop);
            if (buffer.charAt(stop++) != ':') {
                throw new InvalidDatatypeValueException("Error in parsing time zone");
            }
            timeZone[1] = XMLCalendar.parseInt(buffer, stop, stop + 2);
            if (stop + 2 != end) {
                throw new InvalidDatatypeValueException("Error in parsing time zone");
            }
        } else {
            throw new InvalidDatatypeValueException("Error in parsing time zone");
        }
    }

    protected static int indexOf(String buffer, int start, int end, char ch) {
        int i = start;
        while (i < end) {
            if (buffer.charAt(i) == ch) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected static void validateDateTime(int[] data, int[] timeZone) {
        if (data[0] == 0) {
            throw new InvalidDatatypeValueException("The year \"0000\" is an illegal year value");
        }
        if (data[1] < 1 || data[1] > 12) {
            throw new InvalidDatatypeValueException("The month must have values 1 to 12");
        }
        if (data[2] > XMLCalendar.maxDayInMonthFor(data[0], data[1]) || data[2] < 1) {
            throw new InvalidDatatypeValueException("The day must have values 1 to 31");
        }
        if (data[3] > 23 || data[3] < 0) {
            if (data[3] == 24 && data[4] == 0 && data[5] == 0 && data[6] == 0) {
                data[3] = 0;
                data[2] = data[2] + 1;
                if (data[2] > XMLCalendar.maxDayInMonthFor(data[0], data[1])) {
                    data[2] = 1;
                    data[1] = data[1] + 1;
                    if (data[1] > 12) {
                        data[1] = 1;
                        data[0] = data[0] + 1;
                        if (data[0] == 0) {
                            data[0] = 1;
                        }
                    }
                }
            } else {
                throw new InvalidDatatypeValueException("Hour must have values 0-23, unless 24:00:00");
            }
        }
        if (data[4] > 59 || data[4] < 0) {
            throw new InvalidDatatypeValueException("Minute must have values 0-59");
        }
        if (data[5] > 60 || data[5] < 0) {
            throw new InvalidDatatypeValueException("Second must have values 0-60");
        }
        if (timeZone[0] > 14 || timeZone[0] < -14) {
            throw new InvalidDatatypeValueException("Time zone should have range -14..+14");
        }
        if (timeZone[1] > 59 || timeZone[1] < -59) {
            throw new InvalidDatatypeValueException("Minute must have values 0-59");
        }
    }

    private static int findUTCSign(String buffer, int start, int end) {
        int i = start;
        while (i < end) {
            char c = buffer.charAt(i);
            if (c == 'Z' || c == '+' || c == '-') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected static int parseInt(String buffer, int start, int end) throws NumberFormatException {
        int radix = 10;
        int result = 0;
        int digit = 0;
        int limit = -2147483647;
        int multmin = limit / radix;
        int i = start;
        do {
            if ((digit = DataValue.TypeValidator.getDigit(buffer.charAt(i))) < 0) {
                throw new NumberFormatException("'" + buffer.toString() + "' has wrong format");
            }
            if (result < multmin) {
                throw new NumberFormatException("'" + buffer.toString() + "' has wrong format");
            }
            if ((result *= radix) < limit + digit) {
                throw new NumberFormatException("'" + buffer.toString() + "' has wrong format");
            }
            result -= digit;
        } while (++i < end);
        return -result;
    }

    protected static int parseIntYear(String buffer, int end) {
        int limit;
        int radix = 10;
        int result = 0;
        boolean negative = false;
        int i = 0;
        int digit = 0;
        if (buffer.charAt(0) == '-') {
            negative = true;
            limit = Integer.MIN_VALUE;
            ++i;
        } else {
            limit = -2147483647;
        }
        int multmin = limit / radix;
        while (i < end) {
            if ((digit = DataValue.TypeValidator.getDigit(buffer.charAt(i++))) < 0) {
                throw new NumberFormatException("'" + buffer.toString() + "' has wrong format");
            }
            if (result < multmin) {
                throw new NumberFormatException("'" + buffer.toString() + "' has wrong format");
            }
            if ((result *= radix) < limit + digit) {
                throw new NumberFormatException("'" + buffer.toString() + "' has wrong format");
            }
            result -= digit;
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException("'" + buffer.toString() + "' has wrong format");
        }
        return -result;
    }

    protected static void normalize(int[] date, int[] timeZone) {
        int negate = 1;
        if (date[7] == 43) {
            negate = -1;
        }
        int temp = date[4] + negate * timeZone[1];
        int carry = XMLCalendar.fQuotient(temp, 60);
        date[4] = XMLCalendar.mod(temp, 60, carry);
        temp = date[3] + negate * timeZone[0] + carry;
        carry = XMLCalendar.fQuotient(temp, 24);
        date[3] = XMLCalendar.mod(temp, 24, carry);
        date[2] = date[2] + carry;
        while (true) {
            temp = XMLCalendar.maxDayInMonthFor(date[0], date[1]);
            if (date[2] < 1) {
                date[2] = date[2] + XMLCalendar.maxDayInMonthFor(date[0], date[1] - 1);
                carry = -1;
            } else {
                if (date[2] <= temp) break;
                date[2] = date[2] - temp;
                carry = 1;
            }
            temp = date[1] + carry;
            date[1] = XMLCalendar.modulo(temp, 1, 13);
            date[0] = date[0] + XMLCalendar.fQuotient(temp, 1, 13);
        }
        date[7] = 90;
    }

    protected static void resetDateObj(int[] data) {
        int i = 0;
        while (i < 8) {
            data[i] = 0;
            ++i;
        }
    }

    protected static int maxDayInMonthFor(int year, int month) {
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            return 30;
        }
        if (month == 2) {
            if (XMLCalendar.isLeapYear(year)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    private static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    protected static int mod(int a, int b, int quotient) {
        return a - quotient * b;
    }

    protected static int fQuotient(int a, int b) {
        return (int)Math.floor((float)a / (float)b);
    }

    protected static int modulo(int temp, int low, int high) {
        int a = temp - low;
        int b = high - low;
        return XMLCalendar.mod(a, b, XMLCalendar.fQuotient(a, b)) + low;
    }

    protected static int fQuotient(int temp, int low, int high) {
        return XMLCalendar.fQuotient(temp - low, high - low);
    }

    private String dateTimeToString() {
        int[] dateValue = this.getDateValue();
        StringBuffer message = new StringBuffer(25);
        XMLCalendar.append(message, dateValue[0], 4);
        message.append('-');
        XMLCalendar.append(message, dateValue[1], 2);
        message.append('-');
        XMLCalendar.append(message, dateValue[2], 2);
        message.append('T');
        XMLCalendar.append(message, dateValue[3], 2);
        message.append(':');
        XMLCalendar.append(message, dateValue[4], 2);
        message.append(':');
        XMLCalendar.append(message, dateValue[5], 2);
        if (dateValue[6] > 0) {
            message.append('.');
            message.append(dateValue[6]);
        }
        XMLCalendar.append(message, (char)dateValue[7], 0);
        return message.toString();
    }

    private String dateToString() {
        StringBuffer message = new StringBuffer(25);
        int[] dateValue = this.getDateValue();
        XMLCalendar.append(message, dateValue[0], 4);
        message.append('-');
        XMLCalendar.append(message, dateValue[1], 2);
        message.append('-');
        XMLCalendar.append(message, dateValue[2], 2);
        XMLCalendar.append(message, (char)dateValue[7], 0);
        return message.toString();
    }

    private String dayToString() {
        StringBuffer message = new StringBuffer(6);
        message.append('-');
        message.append('-');
        message.append('-');
        XMLCalendar.append(message, this.dateValue[2], 2);
        XMLCalendar.append(message, (char)this.dateValue[7], 0);
        return message.toString();
    }

    private String monthDayToString() {
        StringBuffer message = new StringBuffer(8);
        message.append('-');
        message.append('-');
        XMLCalendar.append(message, this.dateValue[1], 2);
        message.append('-');
        XMLCalendar.append(message, this.dateValue[2], 2);
        XMLCalendar.append(message, (char)this.dateValue[7], 0);
        return message.toString();
    }

    private String monthToString() {
        StringBuffer message = new StringBuffer(5);
        message.append('-');
        message.append('-');
        XMLCalendar.append(message, this.dateValue[1], 2);
        XMLCalendar.append(message, (char)this.dateValue[7], 0);
        return message.toString();
    }

    private String timeToString() {
        StringBuffer message = new StringBuffer(16);
        XMLCalendar.append(message, this.dateValue[3], 2);
        message.append(':');
        XMLCalendar.append(message, this.dateValue[4], 2);
        message.append(':');
        XMLCalendar.append(message, this.dateValue[5], 2);
        message.append('.');
        message.append(this.dateValue[6]);
        XMLCalendar.append(message, (char)this.dateValue[7], 0);
        return message.toString();
    }

    private String yearToString() {
        StringBuffer message = new StringBuffer(5);
        XMLCalendar.append(message, this.dateValue[0], 4);
        XMLCalendar.append(message, (char)this.dateValue[7], 0);
        return message.toString();
    }

    private String yearMonthToString() {
        StringBuffer message = new StringBuffer(25);
        XMLCalendar.append(message, this.dateValue[0], 4);
        message.append('-');
        XMLCalendar.append(message, this.dateValue[1], 2);
        XMLCalendar.append(message, (char)this.dateValue[7], 0);
        return message.toString();
    }

    private static void append(StringBuffer message, int value2, int nch) {
        if (value2 == Integer.MIN_VALUE) {
            message.append(value2);
            return;
        }
        if (value2 < 0) {
            message.append('-');
            value2 = -value2;
        }
        if (nch == 4) {
            if (value2 < 10) {
                message.append("000");
            } else if (value2 < 100) {
                message.append("00");
            } else if (value2 < 1000) {
                message.append("0");
            }
            message.append(value2);
        } else if (nch == 2) {
            if (value2 < 10) {
                message.append('0');
            }
            message.append(value2);
        } else if (value2 != 0) {
            message.append((char)value2);
        }
    }

    private static void cloneDate(int[] finalValue, int[] tempDate) {
        System.arraycopy(finalValue, 0, tempDate, 0, 8);
    }

    private int[] parseDateTime(String str) throws InvalidDatatypeValueException {
        int len = str.length();
        int[] date = new int[8];
        int[] timeZone = new int[2];
        int end = XMLCalendar.indexOf(str, 0, len, 'T');
        XMLCalendar.getDate(str, 0, end, date);
        XMLCalendar.getTime(str, end + 1, len, date, timeZone);
        XMLCalendar.validateDateTime(date, timeZone);
        if (date[7] != 0 && date[7] != 90) {
            XMLCalendar.normalize(date, timeZone);
        }
        return date;
    }

    private int[] parseDate(String str) throws InvalidDatatypeValueException {
        int len = str.length();
        int[] date = new int[8];
        int[] timeZone = new int[2];
        int end = XMLCalendar.getDate(str, 0, len, date);
        XMLCalendar.parseTimeZone(str, end, len, date, timeZone);
        XMLCalendar.validateDateTime(date, timeZone);
        if (date[7] != 0 && date[7] != 90) {
            XMLCalendar.normalize(date, timeZone);
        }
        return date;
    }

    private int[] parseDay(String str) throws InvalidDatatypeValueException {
        int len = str.length();
        int[] date = new int[8];
        int[] timeZone = new int[2];
        if (str.charAt(0) != '-' || str.charAt(1) != '-' || str.charAt(2) != '-') {
            throw new InvalidDatatypeValueException("Error in day parsing");
        }
        date[0] = 2000;
        date[1] = 1;
        date[2] = XMLCalendar.parseInt(str, 3, 5);
        if (5 < len) {
            int sign = XMLCalendar.findUTCSign(str, 5, len);
            if (sign < 0) {
                throw new InvalidDatatypeValueException("Error in day parsing");
            }
            XMLCalendar.getTimeZone(str, date, sign, len, timeZone);
        }
        XMLCalendar.validateDateTime(date, timeZone);
        if (date[7] != 0 && date[7] != 90) {
            XMLCalendar.normalize(date, timeZone);
        }
        return date;
    }

    private int[] parseMonthDay(String str) throws InvalidDatatypeValueException {
        int len = str.length();
        int[] date = new int[8];
        int[] timeZone = new int[2];
        date[0] = 2000;
        if (str.charAt(0) != '-' || str.charAt(1) != '-') {
            throw new InvalidDatatypeValueException("Invalid format for gMonthDay: " + str);
        }
        date[1] = XMLCalendar.parseInt(str, 2, 4);
        int start = 4;
        if (str.charAt(start++) != '-') {
            throw new InvalidDatatypeValueException("Invalid format for gMonthDay: " + str);
        }
        date[2] = XMLCalendar.parseInt(str, start, start + 2);
        if (7 < len) {
            int sign = XMLCalendar.findUTCSign(str, 7, len);
            if (sign < 0) {
                throw new InvalidDatatypeValueException("Error in month parsing:" + str);
            }
            XMLCalendar.getTimeZone(str, date, sign, len, timeZone);
        }
        XMLCalendar.validateDateTime(date, timeZone);
        if (date[7] != 0 && date[7] != 90) {
            XMLCalendar.normalize(date, timeZone);
        }
        return date;
    }

    private int[] parseMonth(String str) throws InvalidDatatypeValueException {
        int len = str.length();
        int[] date = new int[8];
        int[] timeZone = new int[2];
        date[0] = 2000;
        date[2] = 15;
        if (str.charAt(0) != '-' || str.charAt(1) != '-') {
            throw new InvalidDatatypeValueException("Invalid format for gMonth: " + str);
        }
        int stop = 4;
        date[1] = XMLCalendar.parseInt(str, 2, stop);
        if (str.length() >= stop + 2 && str.charAt(stop) == '-' && str.charAt(stop + 1) == '-') {
            stop += 2;
        }
        if (stop < len) {
            int sign = XMLCalendar.findUTCSign(str, stop, len);
            if (sign < 0) {
                throw new InvalidDatatypeValueException("Error in month parsing: " + str);
            }
            XMLCalendar.getTimeZone(str, date, sign, len, timeZone);
        }
        XMLCalendar.validateDateTime(date, timeZone);
        if (date[7] != 0 && date[7] != 90) {
            XMLCalendar.normalize(date, timeZone);
        }
        return date;
    }

    private int[] parseYear(String str) throws InvalidDatatypeValueException {
        int sign;
        int len = str.length();
        int[] date = new int[8];
        int[] timeZone = new int[2];
        int start = 0;
        if (str.charAt(0) == '-') {
            start = 1;
        }
        if ((sign = XMLCalendar.findUTCSign(str, start, len)) == -1) {
            date[0] = XMLCalendar.parseIntYear(str, len);
        } else {
            date[0] = XMLCalendar.parseIntYear(str, sign);
            XMLCalendar.getTimeZone(str, date, sign, len, timeZone);
        }
        date[1] = 1;
        date[2] = 1;
        XMLCalendar.validateDateTime(date, timeZone);
        if (date[7] != 0 && date[7] != 90) {
            XMLCalendar.normalize(date, timeZone);
        }
        return date;
    }

    private int[] parseYearMonth(String str) throws InvalidDatatypeValueException {
        int len = str.length();
        int[] date = new int[8];
        int[] timeZone = new int[2];
        int end = XMLCalendar.getYearMonth(str, 0, len, date);
        date[2] = 15;
        XMLCalendar.parseTimeZone(str, end, len, date, timeZone);
        XMLCalendar.validateDateTime(date, timeZone);
        if (date[7] != 0 && date[7] != 90) {
            XMLCalendar.normalize(date, timeZone);
        }
        return date;
    }

    private int[] parseTime(String str) throws InvalidDatatypeValueException {
        int len = str.length();
        int[] date = new int[8];
        int[] timeZone = new int[2];
        date[0] = 2000;
        date[1] = 1;
        date[2] = 15;
        XMLCalendar.getTime(str, 0, len, date, timeZone);
        XMLCalendar.validateDateTime(date, timeZone);
        if (date[7] != 0) {
            XMLCalendar.normalize(date, timeZone);
        }
        return date;
    }

    private static class SafeSimpleDateFormat
    extends SimpleDateFormat {
        public SafeSimpleDateFormat(String pattern) {
            super(pattern);
        }

        public synchronized Date parse(String source) throws ParseException {
            return super.parse(source);
        }
    }
}

