/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;

public class BasicExtendedMetaData
implements ExtendedMetaData {
    protected String annotationURI;
    protected EPackage.Registry registry;
    protected EPackage.Registry demandRegistry;
    protected Map extendedMetaDataHolderCache;
    protected Map annotationMap;
    protected static final String UNINITIALIZED_STRING = "uninitialized";
    protected static final int UNINITIALIZED_INT = -2;
    protected static final EDataType UNINITIALIZED_EDATA_TYPE = EcoreFactory.eINSTANCE.createEDataType();
    protected static final EStructuralFeature UNINITIALIZED_ESTRUCTURAL_FEATURE = EcoreFactory.eINSTANCE.createEAttribute();

    public BasicExtendedMetaData() {
        this("http:///org/eclipse/emf/ecore/util/ExtendedMetaData", EPackage.Registry.INSTANCE);
    }

    public BasicExtendedMetaData(EPackage.Registry registry) {
        this("http:///org/eclipse/emf/ecore/util/ExtendedMetaData", registry);
    }

    public BasicExtendedMetaData(String annotationURI, EPackage.Registry registry) {
        this(annotationURI, registry, null);
    }

    public BasicExtendedMetaData(String annotationURI, EPackage.Registry registry, Map annotationMap) {
        this.annotationURI = annotationURI.intern();
        this.registry = registry;
        this.demandRegistry = new EPackageRegistryImpl();
        this.annotationMap = annotationMap;
        if (annotationURI != "http:///org/eclipse/emf/ecore/util/ExtendedMetaData") {
            this.extendedMetaDataHolderCache = new HashMap();
        }
    }

    protected EAnnotation getAnnotation(EModelElement eModelElement, boolean demandCreate) {
        if (this.annotationMap != null) {
            EAnnotation result = (EAnnotation)this.annotationMap.get(eModelElement);
            if (result == null && demandCreate) {
                result = EcoreFactory.eINSTANCE.createEAnnotation();
                result.setSource(this.annotationURI);
                this.annotationMap.put(eModelElement, result);
            }
            return result;
        }
        EAnnotation result = eModelElement.getEAnnotation(this.annotationURI);
        if (result == null && demandCreate) {
            result = EcoreFactory.eINSTANCE.createEAnnotation();
            result.setSource(this.annotationURI);
            eModelElement.getEAnnotations().add(result);
        }
        return result;
    }

    public EClassifier getType(EPackage ePackage, String name2) {
        return this.getExtendedMetaData(ePackage).getType(name2);
    }

    public EPackage getPackage(final String namespace) {
        return (EPackage)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BasicExtendedMetaData.this.registry.getEPackage(namespace);
            }
        });
    }

    public void putPackage(String namespace, EPackage ePackage) {
        this.registry.put(namespace, ePackage);
    }

    public EClass getDocumentRoot(EPackage ePackage) {
        return (EClass)this.getType(ePackage, "");
    }

    public void setDocumentRoot(EClass eClass) {
        this.setName(eClass, "");
        this.setContentKind(eClass, 3);
    }

    public EReference getXMLNSPrefixMapFeature(EClass eClass) {
        if (this.getContentKind(eClass) == 3) {
            EList eAllReferences = eClass.getEAllReferences();
            int i = 0;
            int size = eAllReferences.size();
            while (i < size) {
                EReference eReference = (EReference)eAllReferences.get(i);
                if ("xmlns:prefix".equals(this.getName(eReference))) {
                    return eReference;
                }
                ++i;
            }
        }
        return null;
    }

    public EReference getXSISchemaLocationMapFeature(EClass eClass) {
        if (this.getContentKind(eClass) == 3) {
            EList eAllReferences = eClass.getEAllReferences();
            int i = 0;
            int size = eAllReferences.size();
            while (i < size) {
                EReference eReference = (EReference)eAllReferences.get(i);
                if ("xsi:schemaLocation".equals(this.getName(eReference))) {
                    return eReference;
                }
                ++i;
            }
        }
        return null;
    }

    public boolean isQualified(EPackage ePackage) {
        return this.getExtendedMetaData(ePackage).isQualified();
    }

    protected boolean basicIsQualified(EPackage ePackage) {
        EAnnotation eAnnotation = this.getAnnotation(ePackage, false);
        return eAnnotation == null || !"false".equals(eAnnotation.getDetails().get("qualified"));
    }

    public void setQualified(EPackage ePackage, boolean isQualified) {
        if (!isQualified) {
            EAnnotation eAnnotation = this.getAnnotation(ePackage, true);
            eAnnotation.getDetails().put("qualified", "false");
        } else {
            EAnnotation eAnnotation = this.getAnnotation(ePackage, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("qualified");
            }
        }
        this.getExtendedMetaData(ePackage).setQualified(isQualified);
    }

    public String getNamespace(EPackage ePackage) {
        if (this.isQualified(ePackage)) {
            return ePackage.getNsURI();
        }
        return null;
    }

    public String getNamespace(EClassifier eClassifier) {
        return this.getNamespace(eClassifier.getEPackage());
    }

    public String getNamespace(EStructuralFeature eStructuralFeature) {
        return this.getExtendedMetaData(eStructuralFeature).getNamespace();
    }

    public String basicGetNamespace(EStructuralFeature eStructuralFeature) {
        EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
        if (eAnnotation == null) {
            return null;
        }
        String result = (String)eAnnotation.getDetails().get("namespace");
        if ("##targetNamespace".equals(result)) {
            return this.getNamespace(eStructuralFeature.getEContainingClass().getEPackage());
        }
        return result;
    }

    public void setNamespace(EStructuralFeature eStructuralFeature, String namespace) {
        String packageNamespace = this.getNamespace(eStructuralFeature.getEContainingClass().getEPackage());
        String convertedNamespace = namespace;
        if (namespace == null ? packageNamespace == null : namespace.equals(packageNamespace)) {
            convertedNamespace = "##targetNamespace";
        }
        if (convertedNamespace != null) {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, true);
            eAnnotation.getDetails().put("namespace", convertedNamespace);
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("namespace");
            }
        }
        this.getExtendedMetaData(eStructuralFeature).setNamespace(namespace);
    }

    public String getName(EClassifier eClassifier) {
        return this.getExtendedMetaData(eClassifier).getName();
    }

    protected String basicGetName(EClassifier eClassifier) {
        String result;
        EAnnotation eAnnotation = this.getAnnotation(eClassifier, false);
        if (eAnnotation != null && (result = (String)eAnnotation.getDetails().get("name")) != null) {
            return result;
        }
        return eClassifier.getName();
    }

    public void setName(EClassifier eClassifier, String name2) {
        EAnnotation eAnnotation = this.getAnnotation(eClassifier, true);
        eAnnotation.getDetails().put("name", name2);
        this.getExtendedMetaData(eClassifier).setName(name2);
        EPackage ePackage = eClassifier.getEPackage();
        if (ePackage != null) {
            this.getExtendedMetaData(ePackage).rename(eClassifier, name2);
        }
    }

    public boolean isAnonymous(EClassifier eClassifier) {
        String name2 = this.getExtendedMetaData(eClassifier).getName();
        return name2.length() == 0 || name2.indexOf("_._") != -1;
    }

    public String getName(EStructuralFeature eStructuralFeature) {
        return this.getExtendedMetaData(eStructuralFeature).getName();
    }

    protected String basicGetName(EStructuralFeature eStructuralFeature) {
        String result;
        EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
        if (eAnnotation != null && (result = (String)eAnnotation.getDetails().get("name")) != null) {
            return result;
        }
        return eStructuralFeature.getName();
    }

    public void setName(EStructuralFeature eStructuralFeature, String name2) {
        EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, true);
        eAnnotation.getDetails().put("name", name2);
        this.getExtendedMetaData(eStructuralFeature).setName(name2);
    }

    protected String getQualifiedName(String defaultNamespace, EClassifier eClassifier) {
        String namespace = this.getNamespace(eClassifier);
        String name2 = this.getName(eClassifier);
        if (namespace == null) {
            return namespace == defaultNamespace ? name2 : "#" + name2;
        }
        return namespace.equals(defaultNamespace) ? name2 : String.valueOf(namespace) + "#" + name2;
    }

    protected String getQualifiedName(String defaultNamespace, EStructuralFeature eStructuralFeature) {
        String namespace = this.getNamespace(eStructuralFeature);
        String name2 = this.getName(eStructuralFeature);
        if (namespace == null) {
            return namespace == defaultNamespace ? name2 : "#" + name2;
        }
        return namespace.equals(defaultNamespace) ? name2 : String.valueOf(namespace) + "#" + name2;
    }

    public EClassifier getType(String namespace, String name2) {
        EPackage ePackage = this.getPackage(namespace);
        return ePackage == null ? null : this.getType(ePackage, name2);
    }

    public EStructuralFeature getAttribute(String namespace, String name2) {
        EClass documentRoot;
        EPackage ePackage = this.getPackage(namespace);
        if (ePackage != null && (documentRoot = this.getDocumentRoot(ePackage)) != null) {
            return this.getLocalAttribute(documentRoot, namespace, name2);
        }
        return null;
    }

    public EStructuralFeature getElement(String namespace, String name2) {
        EClass documentRoot;
        EPackage ePackage = this.getPackage(namespace);
        if (ePackage != null && (documentRoot = this.getDocumentRoot(ePackage)) != null) {
            return this.getLocalElement(documentRoot, namespace, name2);
        }
        return null;
    }

    public int getFeatureKind(EStructuralFeature eStructuralFeature) {
        return this.getExtendedMetaData(eStructuralFeature).getFeatureKind();
    }

    protected int basicGetFeatureKind(EStructuralFeature eStructuralFeature) {
        Object kind;
        EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
        if (eAnnotation != null && (kind = eAnnotation.getDetails().get("kind")) != null) {
            int i = 1;
            while (i < FEATURE_KINDS.length) {
                if (FEATURE_KINDS[i].equals(kind)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public void setFeatureKind(EStructuralFeature eStructuralFeature, int kind) {
        if (kind > 0 && kind < FEATURE_KINDS.length) {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, true);
            eAnnotation.getDetails().put("kind", FEATURE_KINDS[kind]);
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("kind");
            }
        }
        this.getExtendedMetaData(eStructuralFeature).setFeatureKind(kind);
    }

    public int getContentKind(EClass eClass) {
        return this.getExtendedMetaData(eClass).getContentKind();
    }

    protected int basicGetContentKind(EClass eClass) {
        Object kind;
        EAnnotation eAnnotation = this.getAnnotation(eClass, false);
        if (eAnnotation != null && (kind = eAnnotation.getDetails().get("kind")) != null) {
            int i = 1;
            while (i < CONTENT_KINDS.length) {
                if (CONTENT_KINDS[i].equals(kind)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public void setContentKind(EClass eClass, int kind) {
        if (kind > 0 && kind < CONTENT_KINDS.length) {
            EAnnotation eAnnotation = this.getAnnotation(eClass, true);
            eAnnotation.getDetails().put("kind", CONTENT_KINDS[kind]);
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eClass, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("kind");
            }
        }
        this.getExtendedMetaData(eClass).setContentKind(kind);
    }

    public int getDerivationKind(EDataType eDataType) {
        return this.getExtendedMetaData(eDataType).getDerivationKind();
    }

    protected int basicGetDerivationKind(EClassifier eClassifier) {
        EAnnotation eAnnotation = this.getAnnotation(eClassifier, false);
        if (eAnnotation != null) {
            EMap details = eAnnotation.getDetails();
            Object kind = details.get("restriction");
            if (kind != null) {
                return 1;
            }
            kind = details.get("list");
            if (kind != null) {
                return 2;
            }
            kind = details.get("union");
            if (kind != null) {
                return 3;
            }
        }
        return 0;
    }

    public EDataType getBaseType(EDataType eDataType) {
        return this.getExtendedMetaData(eDataType).getBaseType();
    }

    public EDataType basicGetBaseType(EDataType eDataType) {
        EMap details;
        String baseType;
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null && (baseType = (String)(details = eAnnotation.getDetails()).get("baseType")) != null) {
            EClassifier type;
            int index = baseType.lastIndexOf("#");
            EClassifier eClassifier = index == -1 ? this.getType(eDataType.getEPackage(), baseType) : (type = index == 0 ? this.getType((String)null, baseType.substring(1)) : this.getType(baseType.substring(0, index), baseType.substring(index + 1)));
            if (type instanceof EDataType) {
                return (EDataType)type;
            }
        }
        return null;
    }

    public void setBaseType(EDataType eDataType, EDataType baseType) {
        if (baseType == null) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("baseType");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put("baseType", this.getQualifiedName(this.getNamespace(eDataType), baseType));
        }
        this.getExtendedMetaData(eDataType).setBaseType(baseType);
    }

    public EDataType getItemType(EDataType eDataType) {
        return this.getExtendedMetaData(eDataType).getItemType();
    }

    protected EDataType basicGetItemType(EDataType eDataType) {
        EMap details;
        String itemType;
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null && (itemType = (String)(details = eAnnotation.getDetails()).get("itemType")) != null) {
            EClassifier type;
            int index = itemType.lastIndexOf("#");
            EClassifier eClassifier = index == -1 ? this.getType(eDataType.getEPackage(), itemType) : (type = index == 0 ? this.getType((String)null, itemType.substring(1)) : this.getType(itemType.substring(0, index), itemType.substring(index + 1)));
            if (type instanceof EDataType) {
                return (EDataType)type;
            }
        }
        return null;
    }

    public void setItemType(EDataType eDataType, EDataType itemType) {
        if (itemType == null) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("itemType");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put("itemType", this.getQualifiedName(this.getNamespace(eDataType), itemType));
        }
        this.getExtendedMetaData(eDataType).setItemType(itemType);
    }

    public List getMemberTypes(EDataType eDataType) {
        return this.getExtendedMetaData(eDataType).getMemberTypes();
    }

    protected List basicGetMemberTypes(EDataType eDataType) {
        String memberTypes;
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null && (memberTypes = (String)eAnnotation.getDetails().get("memberTypes")) != null) {
            ArrayList<EClassifier> result = new ArrayList<EClassifier>();
            StringTokenizer stringTokenizer = new StringTokenizer(memberTypes);
            while (stringTokenizer.hasMoreTokens()) {
                EClassifier type;
                String member = stringTokenizer.nextToken();
                int index = member.lastIndexOf("#");
                EClassifier eClassifier = index == -1 ? this.getType(eDataType.getEPackage(), member) : (type = index == 0 ? this.getType((String)null, member.substring(1)) : this.getType(member.substring(0, index), member.substring(index + 1)));
                if (!(type instanceof EDataType)) continue;
                result.add(type);
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public void setMemberTypes(EDataType eDataType, List memberTypes) {
        if (memberTypes.isEmpty()) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("memberTypes");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            String namespace = this.getNamespace(eDataType);
            StringBuffer result = new StringBuffer();
            int i = 0;
            int size = memberTypes.size();
            while (i < size) {
                result.append(this.getQualifiedName(namespace, (EDataType)memberTypes.get(i)));
                result.append(' ');
                ++i;
            }
            eAnnotation.getDetails().put("memberTypes", result.substring(0, result.length() - 1));
        }
        this.getExtendedMetaData(eDataType).setMemberTypes(memberTypes);
    }

    protected boolean isFeatureKindSpecific() {
        return true;
    }

    public EStructuralFeature getLocalAttribute(EClass eClass, String namespace, String name2) {
        if (this.isFeatureKindSpecific()) {
            List allAttributes = this.getAllAttributes(eClass);
            int i = 0;
            int size = allAttributes.size();
            while (i < size) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)allAttributes.get(i);
                if (name2.equals(this.getName(eStructuralFeature)) && (namespace == null ? this.getNamespace(eStructuralFeature) == null : namespace.equals(this.getNamespace(eStructuralFeature)))) {
                    return eStructuralFeature;
                }
                ++i;
            }
        } else {
            int i = 0;
            int size = eClass.getFeatureCount();
            while (i < size) {
                EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
                switch (this.getFeatureKind(eStructuralFeature)) {
                    case 0: 
                    case 2: {
                        if (!name2.equals(this.getName(eStructuralFeature)) || !(namespace == null ? this.getNamespace(eStructuralFeature) == null : namespace.equals(this.getNamespace(eStructuralFeature)))) break;
                        return eStructuralFeature;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public EStructuralFeature getAttribute(EClass eClass, String namespace, String name2) {
        EStructuralFeature result = this.getLocalAttribute(eClass, namespace, name2);
        if (result == null && (result = this.getAttribute(namespace, name2)) != null && this.getAffiliation(eClass, result) == null) {
            return null;
        }
        return result;
    }

    protected EStructuralFeature getLocalElement(EClass eClass, String namespace, String name2) {
        if (this.isFeatureKindSpecific()) {
            List allElements = this.getAllElements(eClass);
            int i = 0;
            int size = allElements.size();
            while (i < size) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)allElements.get(i);
                if (name2.equals(this.getName(eStructuralFeature)) && (namespace == null ? this.getNamespace(eStructuralFeature) == null : namespace.equals(this.getNamespace(eStructuralFeature)))) {
                    return eStructuralFeature;
                }
                ++i;
            }
        } else {
            int i = 0;
            int size = eClass.getFeatureCount();
            while (i < size) {
                EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
                switch (this.getFeatureKind(eStructuralFeature)) {
                    case 0: 
                    case 4: {
                        if (!name2.equals(this.getName(eStructuralFeature)) || !(namespace == null ? this.getNamespace(eStructuralFeature) == null : namespace.equals(this.getNamespace(eStructuralFeature)))) break;
                        return eStructuralFeature;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public EStructuralFeature getElement(EClass eClass, String namespace, String name2) {
        EStructuralFeature result = this.getLocalElement(eClass, namespace, name2);
        if (result == null && (result = this.getElement(namespace, name2)) != null && this.getAffiliation(eClass, result) == null) {
            return null;
        }
        return result;
    }

    public List getAllAttributes(EClass eClass) {
        EList superTypes = eClass.getESuperTypes();
        List result = null;
        boolean changeable = false;
        int i = 0;
        int size = superTypes.size();
        while (i < size) {
            EClass eSuperType = (EClass)superTypes.get(i);
            List allAttributes = this.getAllAttributes(eSuperType);
            if (!allAttributes.isEmpty()) {
                if (result == null) {
                    result = allAttributes;
                } else {
                    if (!changeable) {
                        changeable = true;
                        result = new UniqueEList(result);
                    }
                    result.addAll(allAttributes);
                }
            }
            ++i;
        }
        List attributes = this.getAttributes(eClass);
        if (!attributes.isEmpty()) {
            if (result == null) {
                return attributes;
            }
            if (!changeable) {
                result = new UniqueEList(result);
            }
            result.addAll(attributes);
            return result;
        }
        return result == null ? Collections.EMPTY_LIST : result;
    }

    public List getAllElements(EClass eClass) {
        EList superTypes = eClass.getESuperTypes();
        List result = null;
        boolean changeable = false;
        int i = 0;
        int size = superTypes.size();
        while (i < size) {
            EClass eSuperType = (EClass)superTypes.get(i);
            List allElements = this.getAllElements(eSuperType);
            if (!allElements.isEmpty()) {
                if (result == null) {
                    result = allElements;
                } else {
                    if (!changeable) {
                        changeable = true;
                        result = new UniqueEList(result);
                    }
                    result.addAll(allElements);
                }
            }
            ++i;
        }
        List elements = this.getElements(eClass);
        if (!elements.isEmpty()) {
            if (result == null) {
                return elements;
            }
            if (!changeable) {
                result = new UniqueEList(result);
            }
            result.addAll(elements);
            return result;
        }
        return result == null ? Collections.EMPTY_LIST : result;
    }

    public List getAttributes(EClass eClass) {
        EList eStructuralFeatures = eClass.getEStructuralFeatures();
        ArrayList<EStructuralFeature> result = null;
        int i = 0;
        int size = eStructuralFeatures.size();
        while (i < size) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)eStructuralFeatures.get(i);
            switch (this.getFeatureKind(eStructuralFeature)) {
                case 2: 
                case 3: {
                    if (result == null) {
                        result = new ArrayList<EStructuralFeature>();
                    }
                    result.add(eStructuralFeature);
                }
            }
            ++i;
        }
        return result == null ? Collections.EMPTY_LIST : result;
    }

    public List getElements(EClass eClass) {
        EList eStructuralFeatures = eClass.getEStructuralFeatures();
        ArrayList<EStructuralFeature> result = null;
        int i = 0;
        int size = eStructuralFeatures.size();
        while (i < size) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)eStructuralFeatures.get(i);
            switch (this.getFeatureKind(eStructuralFeature)) {
                case 4: 
                case 5: 
                case 6: {
                    if (result == null) {
                        result = new ArrayList<EStructuralFeature>();
                    }
                    result.add(eStructuralFeature);
                }
            }
            ++i;
        }
        return result == null ? Collections.EMPTY_LIST : result;
    }

    public EStructuralFeature getSimpleFeature(EClass eClass) {
        if (this.getContentKind(eClass) == 2) {
            int i = 0;
            int size = eClass.getFeatureCount();
            while (i < size) {
                EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
                if (this.getFeatureKind(eStructuralFeature) == 1) {
                    return eStructuralFeature;
                }
                ++i;
            }
        }
        return null;
    }

    public EAttribute getMixedFeature(EClass eClass) {
        switch (this.getContentKind(eClass)) {
            case 2: 
            case 3: {
                EList eAllAttributes = eClass.getEAllAttributes();
                int i = 0;
                int size = eAllAttributes.size();
                while (i < size) {
                    EAttribute eAttribute = (EAttribute)eAllAttributes.get(i);
                    if (this.getFeatureKind(eAttribute) == 5) {
                        return eAttribute;
                    }
                    ++i;
                }
                break;
            }
        }
        return null;
    }

    public List getWildcards(EStructuralFeature eStructuralFeature) {
        return this.getExtendedMetaData(eStructuralFeature).getWildcards();
    }

    protected List basicGetWildcards(EStructuralFeature eStructuralFeature) {
        String wildcards;
        EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
        if (eAnnotation != null && (wildcards = (String)eAnnotation.getDetails().get("wildcards")) != null) {
            ArrayList<String> result = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(wildcards);
            while (stringTokenizer.hasMoreTokens()) {
                String wildcard = stringTokenizer.nextToken();
                if (wildcard.equals("##other")) {
                    result.add("!##" + this.getNamespace(eStructuralFeature.getEContainingClass().getEPackage()));
                    continue;
                }
                if (wildcard.equals("##local")) {
                    result.add(null);
                    continue;
                }
                if (wildcard.equals("##targetNamespace")) {
                    result.add(this.getNamespace(eStructuralFeature.getEContainingClass().getEPackage()));
                    continue;
                }
                result.add(wildcard);
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public void setWildcards(EStructuralFeature eStructuralFeature, List wildcards) {
        if (wildcards.isEmpty()) {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("wildcards");
                eAnnotation.getDetails().remove("name");
            }
        } else {
            String namespace = this.getNamespace(eStructuralFeature.getEContainingClass().getEPackage());
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, true);
            eAnnotation.getDetails().put("wildcards", BasicExtendedMetaData.getEncodedWildcards(namespace, wildcards));
            eAnnotation.getDetails().put("name", "");
        }
        this.getExtendedMetaData(eStructuralFeature).setWildcards(wildcards);
    }

    public static String getEncodedWildcards(String namespace, List wildcards) {
        if (wildcards.isEmpty()) {
            return "";
        }
        StringBuffer value2 = new StringBuffer();
        int i = 0;
        int size = wildcards.size();
        while (i < size) {
            String wildcard = (String)wildcards.get(i);
            if (wildcard == null) {
                if (namespace == null) {
                    value2.append("##targetNamespace");
                } else {
                    value2.append("##local");
                }
            } else if (wildcard.startsWith("!##")) {
                if (namespace == null ? wildcard.length() == 3 : wildcard.endsWith(namespace) && wildcard.length() == namespace.length() + 3) {
                    value2.append("##other");
                } else {
                    value2.append(wildcard);
                }
            } else if (wildcard.equals(namespace)) {
                value2.append("##targetNamespace");
            } else {
                value2.append(wildcard);
            }
            if (++i >= size) continue;
            value2.append(' ');
        }
        return value2.toString();
    }

    public int getProcessingKind(EStructuralFeature eStructuralFeature) {
        return this.getExtendedMetaData(eStructuralFeature).getProcessingKind();
    }

    protected int basicGetProcessingKind(EStructuralFeature eStructuralFeature) {
        Object kind;
        EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
        if (eAnnotation != null && (kind = eAnnotation.getDetails().get("processing")) != null) {
            int i = 1;
            while (i < PROCESSING_KINDS.length) {
                if (PROCESSING_KINDS[i].equals(kind)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public void setProcessingKind(EStructuralFeature eStructuralFeature, int kind) {
        if (kind > 0 && kind < PROCESSING_KINDS.length) {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, true);
            eAnnotation.getDetails().put("processing", PROCESSING_KINDS[kind]);
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("processing");
            }
        }
        this.getExtendedMetaData(eStructuralFeature).setProcessingKind(kind);
    }

    public EStructuralFeature getGroup(EStructuralFeature eStructuralFeature) {
        return this.getExtendedMetaData(eStructuralFeature).getGroup();
    }

    protected EStructuralFeature basicGetGroup(EStructuralFeature eStructuralFeature) {
        String qualifiedName;
        EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
        if (eAnnotation != null && (qualifiedName = (String)eAnnotation.getDetails().get("group")) != null) {
            int fragmentIndex = qualifiedName.lastIndexOf(35);
            if (fragmentIndex == -1) {
                return this.getElement(eStructuralFeature.getEContainingClass(), this.getNamespace(eStructuralFeature.getEContainingClass().getEPackage()), qualifiedName);
            }
            if (fragmentIndex == 0) {
                return this.getElement(eStructuralFeature.getEContainingClass(), null, qualifiedName.substring(1));
            }
            return this.getElement(eStructuralFeature.getEContainingClass(), qualifiedName.substring(0, fragmentIndex), qualifiedName.substring(fragmentIndex + 1));
        }
        return null;
    }

    public void setGroup(EStructuralFeature eStructuralFeature, EStructuralFeature group) {
        if (group == null) {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("group");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, true);
            eAnnotation.getDetails().put("group", this.getQualifiedName(this.getNamespace(eStructuralFeature.getEContainingClass().getEPackage()), group));
        }
        this.getExtendedMetaData(eStructuralFeature).setGroup(group);
    }

    public EStructuralFeature getAffiliation(EStructuralFeature eStructuralFeature) {
        return this.getExtendedMetaData(eStructuralFeature).getAffiliation();
    }

    protected EStructuralFeature basicGetAffiliation(EStructuralFeature eStructuralFeature) {
        String qualifiedName;
        EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
        if (eAnnotation != null && (qualifiedName = (String)eAnnotation.getDetails().get("affiliation")) != null) {
            int fragmentIndex = qualifiedName.lastIndexOf(35);
            if (fragmentIndex == -1) {
                return this.getElement(this.getNamespace(eStructuralFeature.getEContainingClass().getEPackage()), qualifiedName);
            }
            if (fragmentIndex == 0) {
                return this.getElement(null, qualifiedName.substring(1));
            }
            return this.getElement(qualifiedName.substring(0, fragmentIndex), qualifiedName.substring(fragmentIndex + 1));
        }
        return null;
    }

    public void setAffiliation(EStructuralFeature eStructuralFeature, EStructuralFeature affiliation) {
        if (affiliation == null) {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("affiliation");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eStructuralFeature, true);
            eAnnotation.getDetails().put("affiliation", this.getQualifiedName(this.getNamespace(eStructuralFeature.getEContainingClass().getEPackage()), affiliation));
        }
        this.getExtendedMetaData(eStructuralFeature).setAffiliation(affiliation);
    }

    public EStructuralFeature getAffiliation(EClass eClass, EStructuralFeature eStructuralFeature) {
        if (eClass.getFeatureID(eStructuralFeature) >= 0) {
            return eStructuralFeature;
        }
        switch (this.getFeatureKind(eStructuralFeature)) {
            case 2: {
                String namespace = this.getNamespace(eStructuralFeature);
                String name2 = this.getName(eStructuralFeature);
                EStructuralFeature result = this.getLocalAttribute(eClass, namespace, name2);
                if (result != null) {
                    return result;
                }
                List allAttributes = this.getAllAttributes(eClass);
                int i = 0;
                int size = allAttributes.size();
                while (i < size) {
                    result = (EStructuralFeature)allAttributes.get(i);
                    if (this.matches(this.getWildcards(result), namespace)) {
                        return result;
                    }
                    ++i;
                }
                return null;
            }
            case 4: {
                EStructuralFeature affiliation = eStructuralFeature;
                while (affiliation != null) {
                    String name3;
                    String namespace = this.getNamespace(affiliation);
                    EStructuralFeature result = this.getLocalElement(eClass, namespace, name3 = this.getName(affiliation));
                    if (result != null) {
                        return result;
                    }
                    affiliation = this.getAffiliation(affiliation);
                }
                String namespace = this.getNamespace(eStructuralFeature);
                if ("http://www.eclipse.org/emf/2003/XMLType".equals(namespace)) {
                    return this.getMixedFeature(eClass);
                }
                List allElements = this.getAllElements(eClass);
                int i = 0;
                int size = allElements.size();
                while (i < size) {
                    EStructuralFeature result = (EStructuralFeature)allElements.get(i);
                    if (this.matches(this.getWildcards(result), namespace)) {
                        return result;
                    }
                    ++i;
                }
                return null;
            }
        }
        return null;
    }

    public EStructuralFeature getAttributeWildcardAffiliation(EClass eClass, String namespace, String name2) {
        List allAttributes = this.getAllAttributes(eClass);
        int i = 0;
        int size = allAttributes.size();
        while (i < size) {
            EStructuralFeature result = (EStructuralFeature)allAttributes.get(i);
            if (this.matches(this.getWildcards(result), namespace)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public EStructuralFeature getElementWildcardAffiliation(EClass eClass, String namespace, String name2) {
        List allElements = this.getAllElements(eClass);
        int i = 0;
        int size = allElements.size();
        while (i < size) {
            EStructuralFeature result = (EStructuralFeature)allElements.get(i);
            if (this.matches(this.getWildcards(result), namespace)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public boolean matches(List wildcards, String namespace) {
        if (!wildcards.isEmpty()) {
            int i = 0;
            int size = wildcards.size();
            while (i < size) {
                String wildcard = (String)wildcards.get(i);
                if (this.matches(wildcard, namespace)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean matches(String wildcard, String namespace) {
        return wildcard == null ? namespace == null : (wildcard.startsWith("!##") ? (namespace == null ? wildcard.length() != 3 : !(wildcard.endsWith(namespace) && wildcard.length() == namespace.length() + 3 || "http://www.eclipse.org/emf/2003/XMLType".equals(namespace))) : wildcard.equals("##any") && !"http://www.eclipse.org/emf/2003/XMLType".equals(namespace) || wildcard.equals(namespace));
    }

    public int getWhiteSpaceFacet(EDataType eDataType) {
        return this.getExtendedMetaData(eDataType).getWhiteSpaceFacet();
    }

    protected int basicGetWhiteSpaceFacet(EDataType eDataType) {
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null) {
            String whiteSpaceLiteral = (String)eAnnotation.getDetails().get("whiteSpace");
            int i = 1;
            while (i < WHITE_SPACE_KINDS.length) {
                if (WHITE_SPACE_KINDS[i].equals(whiteSpaceLiteral)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public void setWhiteSpaceFacet(EDataType eDataType, int whiteSpace) {
        if (whiteSpace == 0) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("whiteSpace");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put("whiteSpace", WHITE_SPACE_KINDS[whiteSpace]);
        }
        this.getExtendedMetaData(eDataType).setWhiteSpaceFacet(whiteSpace);
    }

    public List getEnumerationFacet(EDataType eDataType) {
        return this.getExtendedMetaData(eDataType).getEnumerationFacet();
    }

    protected List basicGetEnumerationFacet(EDataType eDataType) {
        String enumerationLiteral;
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null && (enumerationLiteral = (String)eAnnotation.getDetails().get("enumeration")) != null) {
            ArrayList<String> result = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(enumerationLiteral, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String enumeration = BasicExtendedMetaData.replace(BasicExtendedMetaData.replace(stringTokenizer.nextToken(), "%20", " "), "%25", "%");
                result.add(enumeration);
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public void setEnumerationFacet(EDataType eDataType, List literals) {
        if (literals.isEmpty()) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("enumeration");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            StringBuffer result = new StringBuffer();
            int i = 0;
            int size = literals.size();
            while (i < size) {
                result.append(BasicExtendedMetaData.replace(BasicExtendedMetaData.replace((String)literals.get(i), "%", "%25"), " ", "%20"));
                result.append(' ');
                ++i;
            }
            eAnnotation.getDetails().put("enumeration", result.substring(0, result.length() - 1));
        }
        this.getExtendedMetaData(eDataType).setEnumerationFacet(literals);
    }

    public List getPatternFacet(EDataType eDataType) {
        return this.getExtendedMetaData(eDataType).getPatternFacet();
    }

    protected List basicGetPatternFacet(EDataType eDataType) {
        String patternLiteral;
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null && (patternLiteral = (String)eAnnotation.getDetails().get("pattern")) != null) {
            ArrayList<String> result = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(patternLiteral, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String pattern = BasicExtendedMetaData.replace(BasicExtendedMetaData.replace(stringTokenizer.nextToken(), "%20", " "), "%25", "%");
                result.add(pattern);
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public void setPatternFacet(EDataType eDataType, List pattern) {
        if (pattern.isEmpty()) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("pattern");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            StringBuffer result = new StringBuffer();
            int i = 0;
            int size = pattern.size();
            while (i < size) {
                result.append(BasicExtendedMetaData.replace(BasicExtendedMetaData.replace((String)pattern.get(i), "%", "%25"), " ", "%20"));
                result.append(' ');
                ++i;
            }
            eAnnotation.getDetails().put("pattern", result.substring(0, result.length() - 1));
        }
        this.getExtendedMetaData(eDataType).setPatternFacet(pattern);
    }

    public int getTotalDigitsFacet(EDataType eDataType) {
        return this.getExtendedMetaData(eDataType).getTotalDigitsFacet();
    }

    protected int basicGetTotalDigitsFacet(EDataType eDataType) {
        String totalDigitsLiteral;
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null && (totalDigitsLiteral = (String)eAnnotation.getDetails().get("totalDigits")) != null) {
            return Integer.parseInt(totalDigitsLiteral);
        }
        return -1;
    }

    public void setTotalDigitsFacet(EDataType eDataType, int digits) {
        if (digits == -1) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("totalDigits");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put("totalDigits", Integer.toString(digits));
        }
        this.getExtendedMetaData(eDataType).setTotalDigitsFacet(digits);
    }

    public int getFractionDigitsFacet(EDataType eDataType) {
        return this.getExtendedMetaData(eDataType).getFractionDigitsFacet();
    }

    protected int basicGetFractionDigitsFacet(EDataType eDataType) {
        String fractionDigitsLiteral;
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null && (fractionDigitsLiteral = (String)eAnnotation.getDetails().get("fractionDigits")) != null) {
            return Integer.parseInt(fractionDigitsLiteral);
        }
        return -1;
    }

    public void setFractionDigitsFacet(EDataType eDataType, int digits) {
        if (digits == -1) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("fractionDigits");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put("fractionDigits", Integer.toString(digits));
        }
        this.getExtendedMetaData(eDataType).setFractionDigitsFacet(digits);
    }

    public int getLengthFacet(EDataType eDataType) {
        return this.getExtendedMetaData(eDataType).getLengthFacet();
    }

    protected int basicGetLengthFacet(EDataType eDataType) {
        String lengthLiteral;
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null && (lengthLiteral = (String)eAnnotation.getDetails().get("length")) != null) {
            return Integer.parseInt(lengthLiteral);
        }
        return -1;
    }

    public void setLengthFacet(EDataType eDataType, int length) {
        if (length == -1) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("length");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put("length", Integer.toString(length));
        }
        this.getExtendedMetaData(eDataType).setLengthFacet(length);
    }

    public int getMinLengthFacet(EDataType eDataType) {
        return this.getExtendedMetaData(eDataType).getMinLengthFacet();
    }

    protected int basicGetMinLengthFacet(EDataType eDataType) {
        String minLengthLiteral;
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null && (minLengthLiteral = (String)eAnnotation.getDetails().get("minLength")) != null) {
            return Integer.parseInt(minLengthLiteral);
        }
        return -1;
    }

    public void setMinLengthFacet(EDataType eDataType, int length) {
        if (length == -1) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("minLength");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put("minLength", Integer.toString(length));
        }
        this.getExtendedMetaData(eDataType).setMinLengthFacet(length);
    }

    public int getMaxLengthFacet(EDataType eDataType) {
        return this.getExtendedMetaData(eDataType).getMaxLengthFacet();
    }

    protected int basicGetMaxLengthFacet(EDataType eDataType) {
        String maxLengthLiteral;
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        if (eAnnotation != null && (maxLengthLiteral = (String)eAnnotation.getDetails().get("maxLength")) != null) {
            return Integer.parseInt(maxLengthLiteral);
        }
        return -1;
    }

    public void setMaxLengthFacet(EDataType eDataType, int length) {
        if (length == -1) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("maxLength");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put("maxLength", Integer.toString(length));
        }
        this.getExtendedMetaData(eDataType).setMaxLengthFacet(length);
    }

    public String getMinExclusiveFacet(EDataType eDataType) {
        return this.getExtendedMetaData(eDataType).getMinExclusiveFacet();
    }

    protected String basicGetMinExclusiveFacet(EDataType eDataType) {
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        return eAnnotation == null ? null : (String)eAnnotation.getDetails().get("minExclusive");
    }

    public void setMinExclusiveFacet(EDataType eDataType, String literal) {
        if (literal == null) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("minExclusive");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put("minExclusive", literal);
        }
        this.getExtendedMetaData(eDataType).setMinExclusiveFacet(literal);
    }

    public String getMaxExclusiveFacet(EDataType eDataType) {
        return this.getExtendedMetaData(eDataType).getMaxExclusiveFacet();
    }

    protected String basicGetMaxExclusiveFacet(EDataType eDataType) {
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        return eAnnotation == null ? null : (String)eAnnotation.getDetails().get("maxExclusive");
    }

    public void setMaxExclusiveFacet(EDataType eDataType, String literal) {
        if (literal == null) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("maxExclusive");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put("maxExclusive", literal);
        }
        this.getExtendedMetaData(eDataType).setMaxExclusiveFacet(literal);
    }

    public String getMinInclusiveFacet(EDataType eDataType) {
        return this.getExtendedMetaData(eDataType).getMinInclusiveFacet();
    }

    protected String basicGetMinInclusiveFacet(EDataType eDataType) {
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        return eAnnotation == null ? null : (String)eAnnotation.getDetails().get("minInclusive");
    }

    public void setMinInclusiveFacet(EDataType eDataType, String literal) {
        if (literal == null) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("minInclusive");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put("minInclusive", literal);
        }
        this.getExtendedMetaData(eDataType).setMinInclusiveFacet(literal);
    }

    public String getMaxInclusiveFacet(EDataType eDataType) {
        return this.getExtendedMetaData(eDataType).getMaxInclusiveFacet();
    }

    protected String basicGetMaxInclusiveFacet(EDataType eDataType) {
        EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
        return eAnnotation == null ? null : (String)eAnnotation.getDetails().get("maxInclusive");
    }

    public void setMaxInclusiveFacet(EDataType eDataType, String literal) {
        if (literal == null) {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, false);
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("maxInclusive");
            }
        } else {
            EAnnotation eAnnotation = this.getAnnotation(eDataType, true);
            eAnnotation.getDetails().put("maxInclusive", literal);
        }
        this.getExtendedMetaData(eDataType).setMaxInclusiveFacet(literal);
    }

    public EPackage demandPackage(String namespace) {
        EPackage ePackage = this.demandRegistry.getEPackage(namespace);
        if (ePackage == null) {
            ePackage = EcoreFactory.eINSTANCE.createEPackage();
            ePackage.setNsURI(namespace);
            this.setQualified(ePackage, namespace != null);
            if (namespace != null) {
                ePackage.setNsPrefix(namespace.equals("http://www.w3.org/2000/xmlns/") ? (namespace.equals("http://www.w3.org/XML/1998/namespace") ? "xml" : "xmlns") : this.computePrefix(namespace));
            }
            this.demandRegistry.put(namespace, ePackage);
            EClass documentRootEClass = EcoreFactory.eINSTANCE.createEClass();
            documentRootEClass.getESuperTypes().add(XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot());
            documentRootEClass.setName("DocumentRoot");
            ePackage.getEClassifiers().add(documentRootEClass);
            this.setDocumentRoot(documentRootEClass);
        }
        return ePackage;
    }

    protected String computePrefix(String namespace) {
        int length;
        char character;
        int index = namespace.length();
        boolean containsLetter = false;
        StringBuffer prefix = new StringBuffer(index);
        while (--index >= 0) {
            character = namespace.charAt(index);
            if (!DataValue.XMLChar.isNCName(character)) continue;
            prefix.append(character);
            containsLetter = Character.isLetter(character);
            break;
        }
        while (--index >= 0) {
            character = namespace.charAt(index);
            if (DataValue.XMLChar.isNCName(character)) {
                prefix.append(character);
                if (containsLetter) continue;
                containsLetter = Character.isLetter(character);
                continue;
            }
            if (containsLetter) break;
            prefix.append('_');
        }
        if ((length = prefix.length()) == 0 || !DataValue.XMLChar.isNCNameStart(prefix.charAt(length - 1))) {
            prefix.append('_');
        }
        return prefix.reverse().toString();
    }

    public EClassifier demandType(String namespace, String name2) {
        EPackage ePackage = this.demandPackage(namespace);
        EClassifier eClassifier = this.getType(ePackage, name2);
        if (eClassifier != null) {
            return eClassifier;
        }
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        eClass.setName(name2);
        eClass.getESuperTypes().add(XMLTypePackage.eINSTANCE.getAnyType());
        this.setContentKind(eClass, 3);
        ePackage.getEClassifiers().add(eClass);
        return eClass;
    }

    public EStructuralFeature demandFeature(String namespace, String name2, boolean isElement) {
        return this.demandFeature(namespace, name2, isElement, isElement);
    }

    public EStructuralFeature demandFeature(String namespace, String name2, boolean isElement, boolean isReference) {
        EStructuralFeature eStructuralFeature;
        EPackage ePackage = this.demandPackage(namespace);
        EClass documentRootEClass = this.getDocumentRoot(ePackage);
        EStructuralFeature eStructuralFeature2 = eStructuralFeature = isElement ? this.getLocalElement(documentRootEClass, namespace, name2) : this.getLocalAttribute(documentRootEClass, namespace, name2);
        if (eStructuralFeature != null) {
            return eStructuralFeature;
        }
        if (isReference) {
            EReference eReference = EcoreFactory.eINSTANCE.createEReference();
            eReference.setContainment(isElement);
            eReference.setEType(EcorePackage.eINSTANCE.getEObject());
            eReference.setName(name2);
            eReference.setDerived(true);
            eReference.setTransient(true);
            eReference.setVolatile(true);
            documentRootEClass.getEStructuralFeatures().add(eReference);
            this.setFeatureKind(eReference, isElement ? 4 : 2);
            this.setNamespace(eReference, namespace);
            if (isElement) {
                eReference.setUpperBound(-2);
            }
            return eReference;
        }
        EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
        eAttribute.setName(name2);
        eAttribute.setEType(XMLTypePackage.eINSTANCE.getAnySimpleType());
        eAttribute.setDerived(true);
        eAttribute.setTransient(true);
        eAttribute.setVolatile(true);
        documentRootEClass.getEStructuralFeatures().add(eAttribute);
        this.setFeatureKind(eAttribute, isElement ? 4 : 2);
        this.setNamespace(eAttribute, namespace);
        if (isElement) {
            eAttribute.setUpperBound(-2);
        }
        return eAttribute;
    }

    public Collection demandedPackages() {
        return this.demandRegistry.values();
    }

    protected EPackageExtendedMetaData getExtendedMetaData(EPackage ePackage) {
        if (this.extendedMetaDataHolderCache != null) {
            EPackageExtendedMetaData result = (EPackageExtendedMetaData)this.extendedMetaDataHolderCache.get(ePackage);
            if (result == null) {
                result = this.createEPackageExtendedMetaData(ePackage);
                this.extendedMetaDataHolderCache.put(ePackage, result);
            }
            return result;
        }
        EPackageExtendedMetaData.Holder holder = (EPackageExtendedMetaData.Holder)((Object)ePackage);
        EPackageExtendedMetaData result = holder.getExtendedMetaData();
        if (result == null) {
            result = this.createEPackageExtendedMetaData(ePackage);
            holder.setExtendedMetaData(result);
        }
        return result;
    }

    protected EPackageExtendedMetaData createEPackageExtendedMetaData(EPackage ePackage) {
        return new EPackageExtendedMetaDataImpl(ePackage);
    }

    protected EClassifierExtendedMetaData getExtendedMetaData(EClassifier eClassifier) {
        if (this.extendedMetaDataHolderCache != null) {
            EClassifierExtendedMetaData result = (EClassifierExtendedMetaData)this.extendedMetaDataHolderCache.get(eClassifier);
            if (result == null) {
                result = this.createEClassifierExtendedMetaData(eClassifier);
                this.extendedMetaDataHolderCache.put(eClassifier, result);
            }
            return result;
        }
        EClassifierExtendedMetaData.Holder holder = (EClassifierExtendedMetaData.Holder)((Object)eClassifier);
        EClassifierExtendedMetaData result = holder.getExtendedMetaData();
        if (result == null) {
            result = this.createEClassifierExtendedMetaData(eClassifier);
            holder.setExtendedMetaData(result);
        }
        return result;
    }

    protected EClassifierExtendedMetaData createEClassifierExtendedMetaData(EClassifier eClassifier) {
        if (eClassifier instanceof EClass) {
            return new EClassExtendedMetaDataImpl((EClass)eClassifier);
        }
        return new EDataTypeExtendedMetaDataImpl((EDataType)eClassifier);
    }

    protected EStructuralFeatureExtendedMetaData getExtendedMetaData(EStructuralFeature eStructuralFeature) {
        if (this.extendedMetaDataHolderCache != null) {
            EStructuralFeatureExtendedMetaData result = (EStructuralFeatureExtendedMetaData)this.extendedMetaDataHolderCache.get(eStructuralFeature);
            if (result == null) {
                result = this.createEStructuralFeatureExtendedMetaData(eStructuralFeature);
                this.extendedMetaDataHolderCache.put(eStructuralFeature, result);
            }
            return result;
        }
        EStructuralFeatureExtendedMetaData.Holder holder = (EStructuralFeatureExtendedMetaData.Holder)((Object)eStructuralFeature);
        EStructuralFeatureExtendedMetaData result = holder.getExtendedMetaData();
        if (result == null) {
            result = this.createEStructuralFeatureExtendedMetaData(eStructuralFeature);
            holder.setExtendedMetaData(result);
        }
        return result;
    }

    protected EStructuralFeatureExtendedMetaData createEStructuralFeatureExtendedMetaData(EStructuralFeature eStructuralFeature) {
        return new EStructuralFeatureExtendedMetaDataImpl(eStructuralFeature);
    }

    private static String replace(String in, String oldString, String newString) {
        if (in == null || oldString == null) {
            return in;
        }
        int oldStringLength = oldString.length();
        if (oldStringLength == 0) {
            return in;
        }
        if (newString == null) {
            newString = "";
        }
        int newStringLength = newString.length();
        int index = -newStringLength;
        StringBuffer result = new StringBuffer(in);
        while ((index = BasicExtendedMetaData.indexOf(result, oldString, index + newStringLength)) >= 0) {
            result.replace(index, index + oldStringLength, newString);
        }
        return result.toString();
    }

    private static int indexOf(StringBuffer in, String str, int fromIndex) {
        int lengthStr;
        int lengthIn;
        if (in == null) {
            return -1;
        }
        if (str == null) {
            str = "";
        }
        if ((lengthIn = in.length()) < (lengthStr = str.length())) {
            return -1;
        }
        if (fromIndex > lengthIn) {
            if (lengthIn == 0 && fromIndex == 0 && lengthStr == 0) {
                return 0;
            }
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (lengthStr == 0) {
            return fromIndex;
        }
        int strPos = 0;
        int i = fromIndex;
        while (i < lengthIn) {
            if (in.charAt(i) == str.charAt(strPos)) {
                if (++strPos == lengthStr) {
                    return i - lengthStr + 1;
                }
            } else {
                strPos = 0;
            }
            ++i;
        }
        return -1;
    }

    public static interface EPackageExtendedMetaData {
        public boolean isQualified();

        public void setQualified(boolean var1);

        public EClassifier getType(String var1);

        public void rename(EClassifier var1, String var2);

        public static interface Holder {
            public EPackageExtendedMetaData getExtendedMetaData();

            public void setExtendedMetaData(EPackageExtendedMetaData var1);
        }
    }

    public class EPackageExtendedMetaDataImpl
    implements EPackageExtendedMetaData {
        protected EPackage ePackage;
        protected boolean isInitialized;
        protected boolean isQualified;
        protected Map nameToClassifierMap;

        public EPackageExtendedMetaDataImpl(EPackage ePackage) {
            this.ePackage = ePackage;
        }

        public boolean isQualified() {
            if (!this.isInitialized) {
                this.setQualified(BasicExtendedMetaData.this.basicIsQualified(this.ePackage));
            }
            return this.isQualified;
        }

        public void setQualified(boolean isQualified) {
            this.isQualified = isQualified;
            this.isInitialized = true;
        }

        public EClassifier getType(String name2) {
            EClassifier result = null;
            if (this.nameToClassifierMap != null) {
                result = (EClassifier)this.nameToClassifierMap.get(name2);
            }
            if (result == null) {
                EClassifier conflictingEClassifier;
                String eClassifierName;
                EClassifier eClassifier;
                HashMap<String, EClassifier> nameToClassifierMap = new HashMap<String, EClassifier>();
                if (this.nameToClassifierMap != null) {
                    nameToClassifierMap.putAll(this.nameToClassifierMap);
                }
                EList eClassifiers = this.ePackage.getEClassifiers();
                int i = nameToClassifierMap.size();
                int size = eClassifiers.size();
                while (i < size) {
                    eClassifier = (EClassifier)eClassifiers.get(i);
                    eClassifierName = BasicExtendedMetaData.this.getName(eClassifier);
                    conflictingEClassifier = nameToClassifierMap.put(eClassifierName, eClassifier);
                    if (conflictingEClassifier != null && conflictingEClassifier != eClassifier) {
                        nameToClassifierMap.put(eClassifierName, conflictingEClassifier);
                    }
                    ++i;
                }
                if (nameToClassifierMap.size() != eClassifiers.size()) {
                    i = 0;
                    size = eClassifiers.size();
                    while (i < size) {
                        eClassifier = (EClassifier)eClassifiers.get(i);
                        eClassifierName = BasicExtendedMetaData.this.getName(eClassifier);
                        conflictingEClassifier = nameToClassifierMap.put(eClassifierName, eClassifier);
                        if (conflictingEClassifier != null && conflictingEClassifier != eClassifier) {
                            nameToClassifierMap.put(eClassifierName, conflictingEClassifier);
                        }
                        ++i;
                    }
                }
                result = (EClassifier)nameToClassifierMap.get(name2);
                this.nameToClassifierMap = nameToClassifierMap;
            }
            return result;
        }

        public void rename(EClassifier eClassifier, String newName) {
            if (this.nameToClassifierMap != null) {
                this.nameToClassifierMap.values().remove(eClassifier);
                this.nameToClassifierMap.put(newName, eClassifier);
            }
        }
    }

    public static interface EClassifierExtendedMetaData {
        public String getName();

        public void setName(String var1);

        public int getContentKind();

        public void setContentKind(int var1);

        public int getDerivationKind();

        public EDataType getBaseType();

        public void setBaseType(EDataType var1);

        public EDataType getItemType();

        public void setItemType(EDataType var1);

        public List getMemberTypes();

        public void setMemberTypes(List var1);

        public int getWhiteSpaceFacet();

        public void setWhiteSpaceFacet(int var1);

        public List getEnumerationFacet();

        public void setEnumerationFacet(List var1);

        public List getPatternFacet();

        public void setPatternFacet(List var1);

        public int getTotalDigitsFacet();

        public void setTotalDigitsFacet(int var1);

        public int getFractionDigitsFacet();

        public void setFractionDigitsFacet(int var1);

        public int getLengthFacet();

        public void setLengthFacet(int var1);

        public int getMinLengthFacet();

        public void setMinLengthFacet(int var1);

        public int getMaxLengthFacet();

        public void setMaxLengthFacet(int var1);

        public String getMinExclusiveFacet();

        public void setMinExclusiveFacet(String var1);

        public String getMaxExclusiveFacet();

        public void setMaxExclusiveFacet(String var1);

        public String getMinInclusiveFacet();

        public void setMinInclusiveFacet(String var1);

        public String getMaxInclusiveFacet();

        public void setMaxInclusiveFacet(String var1);

        public static interface Holder {
            public EClassifierExtendedMetaData getExtendedMetaData();

            public void setExtendedMetaData(EClassifierExtendedMetaData var1);
        }
    }

    public class EClassExtendedMetaDataImpl
    implements EClassifierExtendedMetaData {
        protected EClass eClass;
        protected String name = "uninitialized";
        protected int contentKind = -2;

        public EClassExtendedMetaDataImpl(EClass eClass) {
            this.eClass = eClass;
        }

        public String getName() {
            if (this.name == BasicExtendedMetaData.UNINITIALIZED_STRING) {
                this.setName(BasicExtendedMetaData.this.basicGetName(this.eClass));
            }
            return this.name;
        }

        public void setName(String name2) {
            this.name = name2;
        }

        public int getContentKind() {
            if (this.contentKind == -2) {
                this.setContentKind(BasicExtendedMetaData.this.basicGetContentKind(this.eClass));
            }
            return this.contentKind;
        }

        public void setContentKind(int kind) {
            this.contentKind = kind;
        }

        public int getDerivationKind() {
            return 0;
        }

        public EDataType getBaseType() {
            return null;
        }

        public void setBaseType(EDataType baseType) {
            throw new UnsupportedOperationException("Can't set the base type of an EClass");
        }

        public EDataType getItemType() {
            return null;
        }

        public void setItemType(EDataType itemType) {
            throw new UnsupportedOperationException("Can't set the item type of an EClass");
        }

        public List getMemberTypes() {
            return Collections.EMPTY_LIST;
        }

        public void setMemberTypes(List memberTypes) {
            throw new UnsupportedOperationException("Can't set the member types of an EClass");
        }

        public int getWhiteSpaceFacet() {
            return 0;
        }

        public void setWhiteSpaceFacet(int whiteSpace) {
            throw new UnsupportedOperationException("Can't set the white space of an EClass");
        }

        public List getEnumerationFacet() {
            return Collections.EMPTY_LIST;
        }

        public void setEnumerationFacet(List literals) {
            throw new UnsupportedOperationException("Can't set the enumeration of an EClass");
        }

        public List getPatternFacet() {
            return Collections.EMPTY_LIST;
        }

        public void setPatternFacet(List pattern) {
            throw new UnsupportedOperationException("Can't set the pattern of an EClass");
        }

        public int getTotalDigitsFacet() {
            return -1;
        }

        public void setTotalDigitsFacet(int digits) {
            throw new UnsupportedOperationException("Can't set the total digits of an EClass");
        }

        public int getFractionDigitsFacet() {
            return -1;
        }

        public void setFractionDigitsFacet(int digits) {
            throw new UnsupportedOperationException("Can't set the fraction digits of an EClass");
        }

        public int getLengthFacet() {
            return -1;
        }

        public void setLengthFacet(int length) {
            throw new UnsupportedOperationException("Can't set the length of an EClass");
        }

        public int getMinLengthFacet() {
            return -1;
        }

        public void setMinLengthFacet(int minLength) {
            throw new UnsupportedOperationException("Can't set the min length of an EClass");
        }

        public int getMaxLengthFacet() {
            return -1;
        }

        public void setMaxLengthFacet(int maxLength) {
            throw new UnsupportedOperationException("Can't set the max length of an EClass");
        }

        public String getMinExclusiveFacet() {
            return null;
        }

        public void setMinExclusiveFacet(String literal) {
            throw new UnsupportedOperationException("Can't set the min exclusive of an EClass");
        }

        public String getMaxExclusiveFacet() {
            return null;
        }

        public void setMaxExclusiveFacet(String literal) {
            throw new UnsupportedOperationException("Can't set the max exclusive of an EClass");
        }

        public String getMinInclusiveFacet() {
            return null;
        }

        public void setMinInclusiveFacet(String literal) {
            throw new UnsupportedOperationException("Can't set the min inclusive of an EClass");
        }

        public String getMaxInclusiveFacet() {
            return null;
        }

        public void setMaxInclusiveFacet(String literal) {
            throw new UnsupportedOperationException("Can't set the max inclusive of an EClass");
        }
    }

    public class EDataTypeExtendedMetaDataImpl
    implements EClassifierExtendedMetaData {
        protected EDataType eDataType;
        protected String name = "uninitialized";
        protected EDataType baseType = UNINITIALIZED_EDATA_TYPE;
        protected EDataType itemType = UNINITIALIZED_EDATA_TYPE;
        protected List memberTypes;
        protected int derivationKind = -2;
        protected int whiteSpace = -2;
        protected List enumerationLiterals;
        protected List pattern;
        int totalDigits = -2;
        int fractionDigits = -2;
        int length = -2;
        int minLength = -2;
        int maxLength = -2;
        String minExclusive = "uninitialized";
        String maxExclusive = "uninitialized";
        String minInclusive = "uninitialized";
        String maxInclusive = "uninitialized";

        public EDataTypeExtendedMetaDataImpl(EDataType eDataType) {
            this.eDataType = eDataType;
        }

        public String getName() {
            if (this.name == BasicExtendedMetaData.UNINITIALIZED_STRING) {
                this.setName(BasicExtendedMetaData.this.basicGetName(this.eDataType));
            }
            return this.name;
        }

        public void setName(String name2) {
            this.name = name2;
        }

        public int getContentKind() {
            return 0;
        }

        public void setContentKind(int kind) {
            throw new UnsupportedOperationException("Can't set the content kind of an EDataType");
        }

        public int getDerivationKind() {
            if (this.derivationKind == -2) {
                this.derivationKind = this.getBaseType() != null ? 1 : (this.getItemType() != null ? 2 : (!this.memberTypes.isEmpty() ? 3 : 0));
            }
            return this.derivationKind;
        }

        public EDataType getBaseType() {
            if (this.baseType == UNINITIALIZED_EDATA_TYPE) {
                this.setBaseType(BasicExtendedMetaData.this.basicGetBaseType(this.eDataType));
            }
            return this.baseType;
        }

        public void setBaseType(EDataType baseType) {
            this.baseType = baseType;
            this.derivationKind = -2;
        }

        public EDataType getItemType() {
            if (this.itemType == UNINITIALIZED_EDATA_TYPE) {
                this.setItemType(BasicExtendedMetaData.this.basicGetItemType(this.eDataType));
            }
            return this.itemType;
        }

        public void setItemType(EDataType itemType) {
            this.itemType = itemType;
            this.derivationKind = -2;
        }

        public List getMemberTypes() {
            if (this.memberTypes == null) {
                this.setMemberTypes(BasicExtendedMetaData.this.basicGetMemberTypes(this.eDataType));
            }
            return this.memberTypes;
        }

        public void setMemberTypes(List memberTypes) {
            this.memberTypes = memberTypes;
            this.derivationKind = -2;
        }

        public int getWhiteSpaceFacet() {
            if (this.whiteSpace == -2) {
                this.setWhiteSpaceFacet(BasicExtendedMetaData.this.basicGetWhiteSpaceFacet(this.eDataType));
            }
            return this.whiteSpace;
        }

        public void setWhiteSpaceFacet(int whiteSpace) {
            this.whiteSpace = whiteSpace;
        }

        public List getEnumerationFacet() {
            if (this.enumerationLiterals == null) {
                this.setEnumerationFacet(BasicExtendedMetaData.this.basicGetEnumerationFacet(this.eDataType));
            }
            return this.enumerationLiterals;
        }

        public void setEnumerationFacet(List literals) {
            this.enumerationLiterals = literals;
        }

        public List getPatternFacet() {
            if (this.pattern == null) {
                this.setPatternFacet(BasicExtendedMetaData.this.basicGetPatternFacet(this.eDataType));
            }
            return this.pattern;
        }

        public void setPatternFacet(List pattern) {
            this.pattern = pattern;
        }

        public int getTotalDigitsFacet() {
            if (this.totalDigits == -2) {
                this.setTotalDigitsFacet(BasicExtendedMetaData.this.basicGetTotalDigitsFacet(this.eDataType));
            }
            return this.totalDigits;
        }

        public void setTotalDigitsFacet(int digits) {
            this.totalDigits = digits;
        }

        public int getFractionDigitsFacet() {
            if (this.fractionDigits == -2) {
                this.setFractionDigitsFacet(BasicExtendedMetaData.this.basicGetFractionDigitsFacet(this.eDataType));
            }
            return this.fractionDigits;
        }

        public void setFractionDigitsFacet(int digits) {
            this.fractionDigits = digits;
        }

        public int getLengthFacet() {
            if (this.length == -2) {
                this.setLengthFacet(BasicExtendedMetaData.this.basicGetLengthFacet(this.eDataType));
            }
            return this.length;
        }

        public void setLengthFacet(int length) {
            this.length = length;
        }

        public int getMinLengthFacet() {
            if (this.minLength == -2) {
                this.setMinLengthFacet(BasicExtendedMetaData.this.basicGetMinLengthFacet(this.eDataType));
            }
            return this.minLength;
        }

        public void setMinLengthFacet(int minLength) {
            this.minLength = minLength;
        }

        public int getMaxLengthFacet() {
            if (this.maxLength == -2) {
                this.setMaxLengthFacet(BasicExtendedMetaData.this.basicGetMaxLengthFacet(this.eDataType));
            }
            return this.maxLength;
        }

        public void setMaxLengthFacet(int maxLength) {
            this.maxLength = maxLength;
        }

        public String getMinExclusiveFacet() {
            if (this.minExclusive == BasicExtendedMetaData.UNINITIALIZED_STRING) {
                this.setMinExclusiveFacet(BasicExtendedMetaData.this.basicGetMinExclusiveFacet(this.eDataType));
            }
            return this.minExclusive;
        }

        public void setMinExclusiveFacet(String literal) {
            this.minExclusive = literal;
        }

        public String getMaxExclusiveFacet() {
            if (this.maxExclusive == BasicExtendedMetaData.UNINITIALIZED_STRING) {
                this.setMaxExclusiveFacet(BasicExtendedMetaData.this.basicGetMaxExclusiveFacet(this.eDataType));
            }
            return this.maxExclusive;
        }

        public void setMaxExclusiveFacet(String literal) {
            this.maxExclusive = literal;
        }

        public String getMinInclusiveFacet() {
            if (this.minInclusive == BasicExtendedMetaData.UNINITIALIZED_STRING) {
                this.setMinInclusiveFacet(BasicExtendedMetaData.this.basicGetMinInclusiveFacet(this.eDataType));
            }
            return this.minInclusive;
        }

        public void setMinInclusiveFacet(String literal) {
            this.minInclusive = literal;
        }

        public String getMaxInclusiveFacet() {
            if (this.maxInclusive == BasicExtendedMetaData.UNINITIALIZED_STRING) {
                this.setMaxInclusiveFacet(BasicExtendedMetaData.this.basicGetMaxInclusiveFacet(this.eDataType));
            }
            return this.maxInclusive;
        }

        public void setMaxInclusiveFacet(String literal) {
            this.maxInclusive = literal;
        }
    }

    public static interface EStructuralFeatureExtendedMetaData {
        public String getName();

        public void setName(String var1);

        public String getNamespace();

        public void setNamespace(String var1);

        public int getFeatureKind();

        public void setFeatureKind(int var1);

        public List getWildcards();

        public void setWildcards(List var1);

        public int getProcessingKind();

        public void setProcessingKind(int var1);

        public EStructuralFeature getGroup();

        public void setGroup(EStructuralFeature var1);

        public EStructuralFeature getAffiliation();

        public void setAffiliation(EStructuralFeature var1);

        public Map getValidatorMap();

        public static interface Holder {
            public EStructuralFeatureExtendedMetaData getExtendedMetaData();

            public void setExtendedMetaData(EStructuralFeatureExtendedMetaData var1);
        }
    }

    public class EStructuralFeatureExtendedMetaDataImpl
    implements EStructuralFeatureExtendedMetaData {
        protected EStructuralFeature eStructuralFeature;
        protected String name = "uninitialized";
        protected String namespace = "uninitialized";
        protected int featureKind = -2;
        protected List wildcards;
        protected int processingKind = -2;
        protected EStructuralFeature group = UNINITIALIZED_ESTRUCTURAL_FEATURE;
        protected EStructuralFeature affiliation = UNINITIALIZED_ESTRUCTURAL_FEATURE;
        protected Map validatorMap;

        public EStructuralFeatureExtendedMetaDataImpl(EStructuralFeature eStructuralFeature) {
            this.eStructuralFeature = eStructuralFeature;
        }

        public Map getValidatorMap() {
            if (this.validatorMap == null) {
                this.validatorMap = new Hashtable();
            }
            return this.validatorMap;
        }

        public String getName() {
            if (this.name == BasicExtendedMetaData.UNINITIALIZED_STRING) {
                this.setName(BasicExtendedMetaData.this.basicGetName(this.eStructuralFeature));
            }
            return this.name;
        }

        public void setName(String name2) {
            this.name = name2;
        }

        public String getNamespace() {
            if (this.namespace == BasicExtendedMetaData.UNINITIALIZED_STRING) {
                this.setNamespace(BasicExtendedMetaData.this.basicGetNamespace(this.eStructuralFeature));
            }
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public int getFeatureKind() {
            if (this.featureKind == -2) {
                this.setFeatureKind(BasicExtendedMetaData.this.basicGetFeatureKind(this.eStructuralFeature));
            }
            return this.featureKind;
        }

        public void setFeatureKind(int kind) {
            this.featureKind = kind;
        }

        public List getWildcards() {
            if (this.wildcards == null) {
                this.setWildcards(BasicExtendedMetaData.this.basicGetWildcards(this.eStructuralFeature));
            }
            return this.wildcards;
        }

        public void setWildcards(List wildcards) {
            this.wildcards = wildcards;
        }

        public int getProcessingKind() {
            if (this.processingKind == -2) {
                this.setProcessingKind(BasicExtendedMetaData.this.basicGetProcessingKind(this.eStructuralFeature));
            }
            return this.processingKind;
        }

        public void setProcessingKind(int kind) {
            this.processingKind = kind;
        }

        public EStructuralFeature getGroup() {
            if (this.group == UNINITIALIZED_ESTRUCTURAL_FEATURE) {
                this.setGroup(BasicExtendedMetaData.this.basicGetGroup(this.eStructuralFeature));
            }
            return this.group;
        }

        public void setGroup(EStructuralFeature group) {
            this.group = group;
        }

        public EStructuralFeature getAffiliation() {
            if (this.affiliation == UNINITIALIZED_ESTRUCTURAL_FEATURE) {
                this.setAffiliation(BasicExtendedMetaData.this.basicGetAffiliation(this.eStructuralFeature));
            }
            return this.affiliation;
        }

        public void setAffiliation(EStructuralFeature affiliation) {
            this.affiliation = affiliation;
        }
    }
}

