/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.MessageFactory;

public class BooleanConverter
implements Converter {
    public static final String CONVERTER_ID = "javax.faces.Boolean";
    public static final String BOOLEAN_ID = "javax.faces.converter.BooleanConverter.BOOLEAN";
    public static final String STRING_ID = "javax.faces.converter.STRING";

    @Override
    public Object getAsObject(FacesContext context, UIComponent component, String value2) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value2 == null) {
            return null;
        }
        if ((value2 = value2.trim()).length() < 1) {
            return null;
        }
        try {
            return Boolean.valueOf(value2);
        }
        catch (Exception e) {
            throw new ConverterException(MessageFactory.getMessage(context, BOOLEAN_ID, value2, MessageFactory.getLabel(context, component)), (Throwable)e);
        }
    }

    @Override
    public String getAsString(FacesContext context, UIComponent component, Object value2) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value2 == null) {
            return "";
        }
        try {
            return value2.toString();
        }
        catch (Exception e) {
            throw new ConverterException(MessageFactory.getMessage(context, STRING_ID, value2, MessageFactory.getLabel(context, component)), (Throwable)e);
        }
    }
}

