/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.ValidationContext;
import com.ibm.xml.xlxp2.datatype.XDateTime;
import com.ibm.xml.xlxp2.datatype.validation.AbstractDateTimeDV;
import com.ibm.xml.xlxp2.datatype.validation.XMLStringUtil;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class TimeDV
extends AbstractDateTimeDV {
    public TimeDV(String string, String string2, String string3, String[] stringArray, XDateTime[] xDateTimeArray, XDateTime xDateTime, XDateTime xDateTime2, XDateTime xDateTime3, XDateTime xDateTime4, int n) {
        super(string, string2, string3, stringArray, xDateTimeArray, xDateTime, xDateTime2, xDateTime3, xDateTime4, 9, n);
    }

    public static XDateTime parse(XMLString xMLString) {
        return TimeDV.parse(xMLString, dummyOneElementArray);
    }

    private static XDateTime parse(XMLString xMLString, int[] nArray) {
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return null;
        }
        XDateTime xDateTime = null;
        nArray[0] = 0;
        xDateTime = TimeDV.parseTimeBuffered(xMLString, nArray);
        return xDateTime;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        XDateTime xDateTime = TimeDV.parse(xMLString);
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xDateTime;
            validatedInfo.errorCode = validatedInfo.actualValue != null ? 0 : 1;
        }
        return xDateTime;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        int[] nArray = validationContext.tempErrorCode;
        XDateTime xDateTime = TimeDV.parse(xMLString, nArray);
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = xDateTime.equals((XDateTime)validatedInfo.actualValue) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        if (this.definedFacets != 0) {
            validatedInfo2.errorCode = this.checkFacets(xDateTime, xMLString);
            if (validatedInfo2.errorCode != 0) {
                return;
            }
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = xDateTime;
    }

    public int checkFacets(XDateTime xDateTime, XMLString xMLString) {
        if ((this.definedFacets & 0x100) != 0 && xDateTime.compareDates(this.minInclusive, true) < 0) {
            return 1;
        }
        if ((this.definedFacets & 0x80) != 0 && xDateTime.compareDates(this.minExclusive, true) <= 0) {
            return 1;
        }
        if ((this.definedFacets & 0x20) != 0 && xDateTime.compareDates(this.maxInclusive, true) > 0) {
            return 1;
        }
        if ((this.definedFacets & 0x40) != 0 && xDateTime.compareDates(this.maxExclusive, true) >= 0) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (!this.enumeration[i].equals(xDateTime)) continue;
                return 0;
            }
            return 1;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static XDateTime parseTimeBuffered(XMLString xMLString, int[] nArray) {
        XDateTime xDateTime;
        int n;
        int n2;
        int n3;
        DataBuffer dataBuffer;
        DataBuffer dataBuffer2;
        block49: {
            int n4;
            int n5;
            int n6;
            block50: {
                block47: {
                    block48: {
                        dataBuffer2 = xMLString.firstBuffer;
                        dataBuffer = xMLString.lastBuffer == null ? dataBuffer2 : xMLString.lastBuffer;
                        n3 = xMLString.startOffset;
                        n2 = dataBuffer2 == dataBuffer ? xMLString.endOffset : dataBuffer2.endOffset;
                        n = dataBuffer2.bytes[n3];
                        if (n <= 32) {
                            while (true) {
                                if ((n == 32 || n == 10 || n == 9 || n == 13) && ++n3 < n2) {
                                    n = dataBuffer2.bytes[n3];
                                    continue;
                                }
                                if (n3 != n2 || dataBuffer2 == dataBuffer) break;
                                dataBuffer2 = dataBuffer2.next;
                                n3 = dataBuffer2.startOffset;
                                n2 = dataBuffer2 == dataBuffer ? xMLString.endOffset : dataBuffer2.endOffset;
                                n = dataBuffer2.bytes[n3];
                            }
                        }
                        if (n < 48 || n > 50) {
                            nArray[0] = 1;
                            return null;
                        }
                        n6 = n - 48;
                        n5 = 1;
                        while (true) {
                            if (++n3 < n2) {
                                if (n5 > 2) {
                                    nArray[0] = 1;
                                    return null;
                                }
                                n = dataBuffer2.bytes[n3];
                                if (n >= 48 && n <= 57) {
                                    ++n5;
                                    n6 *= 10;
                                    n6 += n - 48;
                                    continue;
                                }
                                if (n == 58) break;
                                nArray[0] = 1;
                                return null;
                            }
                            if (dataBuffer2 == dataBuffer) break;
                            dataBuffer2 = dataBuffer2.next;
                            n3 = dataBuffer2.startOffset - 1;
                            n2 = dataBuffer2 == dataBuffer ? xMLString.endOffset : dataBuffer2.endOffset;
                        }
                        if (n5 < 2 || n3 == n2) {
                            nArray[0] = 1;
                            return null;
                        }
                        xDateTime = new XDateTime();
                        xDateTime.type = 9;
                        xDateTime.position = 3;
                        xDateTime.year = 2000;
                        xDateTime.month = 1;
                        xDateTime.day = 15;
                        xDateTime.hour = n6;
                        n5 = 0;
                        n6 = 0;
                        while (true) {
                            if (++n3 < n2) {
                                if (n5 > 2) {
                                    nArray[0] = 1;
                                    return null;
                                }
                                n = dataBuffer2.bytes[n3];
                                if (n >= 48 && n <= 57) {
                                    ++n5;
                                    n6 *= 10;
                                    n6 += n - 48;
                                    continue;
                                }
                                if (n == 58) break;
                                nArray[0] = 1;
                                return null;
                            }
                            if (dataBuffer2 == dataBuffer) break;
                            dataBuffer2 = dataBuffer2.next;
                            n3 = dataBuffer2.startOffset - 1;
                            n2 = dataBuffer2 == dataBuffer ? xMLString.endOffset : dataBuffer2.endOffset;
                        }
                        if (n5 < 2 || n3 == n2) {
                            nArray[0] = 1;
                            return null;
                        }
                        xDateTime.minute = n6;
                        double d = 0.0;
                        n5 = 0;
                        while (true) {
                            if (++n3 < n2) {
                                if (n5 > 2) {
                                    nArray[0] = 1;
                                    return null;
                                }
                                n = dataBuffer2.bytes[n3];
                                if (n < 48 || n > 57) break;
                                ++n5;
                                d *= 10.0;
                                d += (double)(n - 48);
                                continue;
                            }
                            if (dataBuffer2 == dataBuffer) break;
                            dataBuffer2 = dataBuffer2.next;
                            n3 = dataBuffer2.startOffset - 1;
                            n2 = dataBuffer2 == dataBuffer ? xMLString.endOffset : dataBuffer2.endOffset;
                        }
                        if (n5 < 2) {
                            nArray[0] = 1;
                            return null;
                        }
                        if (n == 46) {
                            double d2 = 1.0;
                            while (true) {
                                if (++n3 < n2) {
                                    n = dataBuffer2.bytes[n3];
                                    if (n < 48 || n > 57) break;
                                    d += (double)(n - 48) / (d2 *= 10.0);
                                    continue;
                                }
                                if (dataBuffer2 == dataBuffer) break;
                                dataBuffer2 = dataBuffer2.next;
                                n3 = dataBuffer2.startOffset - 1;
                                n2 = dataBuffer2 == dataBuffer ? xMLString.endOffset : dataBuffer2.endOffset;
                            }
                            if (d2 == 1.0) {
                                nArray[0] = 1;
                                return null;
                            }
                        }
                        xDateTime.second = d;
                        if (n == 45 || n == 43) break block48;
                        if (n == 90) {
                            ++n3;
                            xDateTime.utc = 90;
                        }
                        break block49;
                    }
                    xDateTime.utc = n;
                    n4 = 1;
                    if (n == 45) {
                        n4 = -1;
                    }
                    while (true) {
                        if (++n3 < n2) {
                            n = dataBuffer2.bytes[n3];
                            if (n >= 48) {
                                break;
                            }
                            break block47;
                        }
                        if (dataBuffer2 == dataBuffer) {
                            nArray[0] = 1;
                            return null;
                        }
                        dataBuffer2 = dataBuffer2.next;
                        n3 = dataBuffer2.startOffset - 1;
                        n2 = dataBuffer2 == dataBuffer ? xMLString.endOffset : dataBuffer2.endOffset;
                    }
                    if (n <= 49) break block50;
                }
                nArray[0] = 1;
                return null;
            }
            n6 = n - 48;
            n5 = 1;
            while (true) {
                if (++n3 < n2) {
                    if (n5 > 2) {
                        nArray[0] = 1;
                        return null;
                    }
                    n = dataBuffer2.bytes[n3];
                    if (n >= 48 && n <= 57) {
                        ++n5;
                        n6 *= 10;
                        n6 += n - 48;
                        continue;
                    }
                    if (n == 58) break;
                    nArray[0] = 1;
                    return null;
                }
                if (dataBuffer2 == dataBuffer) break;
                dataBuffer2 = dataBuffer2.next;
                n3 = dataBuffer2.startOffset - 1;
                n2 = dataBuffer2 == dataBuffer ? xMLString.endOffset : dataBuffer2.endOffset;
            }
            if (n5 < 2 || n3 == n2) {
                nArray[0] = 1;
                return null;
            }
            xDateTime.timezoneHr = n4 * n6;
            n6 = 0;
            n5 = 0;
            while (true) {
                if (++n3 < n2) {
                    if (n5 > 2) {
                        nArray[0] = 1;
                        return null;
                    }
                    n = dataBuffer2.bytes[n3];
                    if (n < 48 || n > 57) break;
                    ++n5;
                    n6 *= 10;
                    n6 += n - 48;
                    continue;
                }
                if (dataBuffer2 == dataBuffer) break;
                dataBuffer2 = dataBuffer2.next;
                n3 = dataBuffer2.startOffset - 1;
                n2 = dataBuffer2 == dataBuffer ? xMLString.endOffset : dataBuffer2.endOffset;
            }
            if (n5 < 2) {
                nArray[0] = 1;
                return null;
            }
            xDateTime.timezoneMin = n4 * n6;
        }
        if (n3 < n2 && n <= 32) {
            while (true) {
                if ((n == 32 || n == 10 || n == 9 || n == 13) && ++n3 < n2) {
                    n = dataBuffer2.bytes[n3];
                    continue;
                }
                if (n3 != n2 || dataBuffer2 == dataBuffer) break;
                dataBuffer2 = dataBuffer2.next;
                n3 = dataBuffer2.startOffset;
                n2 = dataBuffer2 == dataBuffer ? xMLString.endOffset : dataBuffer2.endOffset;
                n = dataBuffer2.bytes[n3];
            }
        }
        if (n3 < n2) {
            nArray[0] = 1;
            return null;
        }
        if (!TimeDV.validateDateTime(xDateTime)) {
            nArray[0] = 1;
            return null;
        }
        xDateTime.normalize();
        return xDateTime;
    }

    private static XDateTime parseTimeUnbuffered(XMLString xMLString, int[] nArray) {
        int n = xMLString.startOffset;
        byte[] byArray = xMLString.bytes;
        int n2 = xMLString.endOffset;
        if ((n = XMLStringUtil.removeWhitespace(byArray, n, n2)) == n2) {
            nArray[0] = 1;
            return null;
        }
        XDateTime xDateTime = new XDateTime();
        xDateTime.type = 9;
        xDateTime.position = 3;
        xDateTime.year = 2000;
        xDateTime.month = 1;
        xDateTime.day = 15;
        if ((n = TimeDV.parseUHour(byArray, xDateTime, n, n2)) == -1 || xMLString.bytes[n] != 58 || ++n >= n2) {
            nArray[0] = 1;
            return null;
        }
        if ((n = TimeDV.parseUMinute(byArray, xDateTime, n, n2)) == -1 || xMLString.bytes[n] != 58 || ++n >= n2) {
            nArray[0] = 1;
            return null;
        }
        if ((n = TimeDV.parseUSeconds(byArray, xDateTime, n, n2)) == -1) {
            nArray[0] = 1;
            return null;
        }
        if ((n = TimeDV.parseUTimeZone(byArray, xDateTime, n, n2)) == -1) {
            nArray[0] = 1;
            return null;
        }
        if ((n = XMLStringUtil.removeWhitespace(byArray, n, n2)) < n2) {
            nArray[0] = 1;
            return null;
        }
        if (!TimeDV.validateDateTime(xDateTime)) {
            nArray[0] = 1;
            return null;
        }
        xDateTime.normalize();
        return xDateTime;
    }

    protected int parseDateTimeUnbuffered(ParsedEntity parsedEntity, XDateTime xDateTime, boolean[] blArray) {
        byte[] byArray = parsedEntity.bytes;
        int n = parsedEntity.offset;
        int n2 = parsedEntity.endOffset;
        if ((n = TimeDV.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
            return -1;
        }
        xDateTime.year = 2000;
        xDateTime.month = 1;
        xDateTime.day = 15;
        if ((n = TimeDV.parseUHour(byArray, xDateTime, n, n2)) == -1 || byArray[n] != 58 || ++n >= n2) {
            return -1;
        }
        if ((n = TimeDV.parseUMinute(byArray, xDateTime, n, n2)) == -1 || byArray[n] != 58 || ++n >= n2) {
            return -1;
        }
        if ((n = TimeDV.parseUSeconds(byArray, xDateTime, n, n2)) == -1) {
            return -1;
        }
        if ((n = TimeDV.parseUTimeZone(byArray, xDateTime, n, n2)) == -1) {
            return -1;
        }
        if ((n = TimeDV.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
            return -1;
        }
        if (!TimeDV.validateDateTime(xDateTime)) {
            return -1;
        }
        xDateTime.normalize();
        return n;
    }
}

