/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.token;

import com.ibm.xml.soapsec.Result;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public interface TokenResult
extends Result {
    public String getIdName();

    public static class Username
    implements TokenResult {
        Subject subject;
        String username;
        boolean idAssertion;
        String idname;
        Element element;

        public Username(Subject subject, String username, boolean idAssertion, String id) {
            this.subject = subject;
            this.username = username;
            this.idAssertion = idAssertion;
            this.idname = id;
        }

        public Subject getSubject() {
            return this.subject;
        }

        public String getUsername() {
            return this.username;
        }

        public boolean isIdAssertion() {
            return this.idAssertion;
        }

        public String getIdName() {
            return this.idname;
        }

        public Username(Subject subject, String username, boolean idAssertion, Element elem) {
            this.subject = subject;
            this.username = username;
            this.idAssertion = idAssertion;
            this.element = elem;
        }

        public Element getElement() {
            return this.element;
        }
    }

    public static class Generic
    implements TokenResult {
        QName type;
        Subject subject;
        String idname;

        public Generic(QName t, Subject s, String i) {
            this.type = t;
            this.subject = s;
            this.idname = i;
        }

        public QName getType() {
            return this.type;
        }

        public Subject getSubject() {
            return this.subject;
        }

        public String getIdName() {
            return this.idname;
        }
    }

    public static class X509
    implements TokenResult {
        X509Certificate content;
        String idname;
        String trustAnchorRef;
        String certStoreRef;
        boolean trustAny = false;
        boolean used = false;
        boolean usedAsAuthenticatedId = false;

        public X509(X509Certificate c, String i, String tr, String cr, boolean ta) {
            this.content = c;
            this.idname = i;
            this.trustAnchorRef = tr;
            this.certStoreRef = cr;
            this.trustAny = ta;
        }

        public X509Certificate getCertificate() {
            return this.content;
        }

        public String getIdName() {
            return this.idname;
        }

        public String getTrustAnchorRef() {
            return this.trustAnchorRef;
        }

        public String getCertStoreRef() {
            return this.certStoreRef;
        }

        public boolean getTrustAnyCertificate() {
            return this.trustAny;
        }

        public void setUsed(boolean used) {
            this.used = used;
        }

        public boolean getUsed() {
            return this.used;
        }

        public void setAuthenticatedId() {
            this.usedAsAuthenticatedId = true;
        }

        public boolean isAuthenticatedId() {
            return this.usedAsAuthenticatedId;
        }
    }
}

