/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.token;

import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.dsig.VerificationSettings;
import com.ibm.xml.soapsec.token.LoginMapping;
import com.ibm.xml.soapsec.token.ReceiverLogin;
import com.ibm.xml.soapsec.token.TokenReceiverConfig;
import com.ibm.xml.soapsec.token.TokenResult;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.ByteArrayInputStream;
import java.security.Provider;
import java.security.cert.CRL;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BinaryTokenReceiver
implements SoapSecurityComponent {
    private static final TraceComponent tc = Tr.register(BinaryTokenReceiver.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = BinaryTokenReceiver.class.getName();
    TokenReceiverConfig conf = null;

    public BinaryTokenReceiver() {
    }

    public BinaryTokenReceiver(TokenReceiverConfig conf) {
        this.conf = conf;
    }

    public void init(Map map) throws Exception {
        this.conf = (TokenReceiverConfig)map.get(TokenReceiverConfig.class);
    }

    public void invoke(Document doc, Element target, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + doc + "," + target + "," + context + ")");
        }
        String wsseNSSent = Constants.getWSSENS(context);
        QName invalidSecurityToken = Constants.getQName(wsseNSSent, "InvalidSecurityToken");
        QName unsupportedSecurityToken = Constants.getQName(wsseNSSent, "UnsupportedSecurityToken");
        if (this.conf == null) {
            throw SoapSecurityException.format((QName)invalidSecurityToken, (String)"token12");
        }
        String idattr = IdUtil.getInstance().getIdAttributeName(target);
        String id = idattr == null ? null : target.getAttribute(idattr);
        String stringValue = DOMUtil.getStringValue(target);
        byte[] binaryData = null;
        String encodingTypeStr = target.getAttribute("EncodingType");
        if (encodingTypeStr.equals("")) {
            throw SoapSecurityException.format((QName)invalidSecurityToken, (String)"security.wssecurity.BinaryTokenReceiver.token13");
        }
        QName encodingType = DOMUtil.getQName(target, encodingTypeStr);
        if (!NamespaceUtil.equals(encodingType, Constants.BASE64_BINARY_RCVR)) {
            if (NamespaceUtil.equals(encodingType, Constants.HEX_BINARY_RCVR)) {
                throw SoapSecurityException.format((QName)unsupportedSecurityToken, (String)"security.wssecurity.BinaryTokenReceiver.token14");
            }
            throw SoapSecurityException.format((QName)unsupportedSecurityToken, (String)"security.wssecurity.BinaryTokenReceiver.token15", (String)encodingTypeStr);
        }
        binaryData = Base64.decode((String)stringValue);
        String valueTypeStr = target.getAttribute("ValueType");
        if (valueTypeStr.equals("")) {
            throw SoapSecurityException.format((QName)invalidSecurityToken, (String)"security.wssecurity.BinaryTokenReceiver.token16");
        }
        QName valueType = DOMUtil.getQName(target, valueTypeStr);
        if (NamespaceUtil.equals(valueType, Constants.X509V3_RCVR)) {
            if (this.conf.isX509Ready()) {
                try {
                    X509Certificate tokenObject = null;
                    String anchorRef = null;
                    String storeRef = null;
                    boolean trustAny = false;
                    CertificateFactory factory = CertificateFactory.getInstance("X.509");
                    X509Certificate cert = null;
                    try {
                        cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(binaryData));
                    }
                    catch (CertificateException ce) {
                        throw SoapSecurityException.format((QName)invalidSecurityToken, (String)"security.wssecurity.BinaryTokenReceiver.token17", (String)ce.toString());
                    }
                    Iterator iter = this.conf.getVerificationSettingsList().iterator();
                    SoapSecurityException lastException = null;
                    while (iter.hasNext()) {
                        VerificationSettings settings = (VerificationSettings)iter.next();
                        Provider provider = settings.getCertPathProvider();
                        if (!settings.getTrustAnyCertificate()) {
                            CertPathBuilder builder = provider == null ? CertPathBuilder.getInstance("PKIX") : CertPathBuilder.getInstance("PKIX", provider);
                            PKIXBuilderParameters params = (PKIXBuilderParameters)settings.getPKIXBuilderParameters().clone();
                            X509CertSelector selector = (X509CertSelector)params.getTargetCertConstraints();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "CertPathProvider = " + (provider == null ? "default" : provider.getName()));
                                Tr.debug(tc, "CertPath Builder = " + builder.getClass().getName());
                                Tr.debug(tc, "CertPath Selector = " + selector.getClass().getName());
                                Tr.debug(tc, "SubjectDN = " + cert.getSubjectX500Principal().getName());
                            }
                            selector.setSubject(cert.getSubjectX500Principal().getEncoded());
                            params.setTargetCertConstraints(selector);
                            HashSet<X509Certificate> certSet = settings.getEeCerts();
                            if (certSet == null) {
                                certSet = new HashSet<X509Certificate>();
                            }
                            certSet.add(cert);
                            CertStore store = provider == null ? CertStore.getInstance("Collection", new CollectionCertStoreParameters(certSet)) : CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certSet), provider);
                            params.addCertStore(store);
                            params.setRevocationEnabled(false);
                            try {
                                List<CertStore> csList = params.getCertStores();
                                X509CRLSelector crlSelector = new X509CRLSelector();
                                boolean setRevocation = false;
                                if (csList != null) {
                                    for (CertStore cs : csList) {
                                        Iterator<? extends CRL> crlIt;
                                        Collection<? extends CRL> crlList = cs.getCRLs(crlSelector);
                                        if (crlList == null || !(crlIt = crlList.iterator()).hasNext()) continue;
                                        setRevocation = true;
                                        break;
                                    }
                                }
                                if (setRevocation) {
                                    params.setRevocationEnabled(true);
                                    Tr.debug(tc, " RevocationEnabled.");
                                } else {
                                    Tr.debug(tc, " Revocation Not Enabled.");
                                }
                            }
                            catch (Exception e) {
                                Tr.debug(tc, "Exception occurred while attempting to process CRLs: " + e);
                            }
                            try {
                                builder.build(params);
                                anchorRef = settings.getTrustAnchorRef();
                                storeRef = settings.getCertStoreRef();
                                tokenObject = cert;
                                break;
                            }
                            catch (CertPathBuilderException cpbe) {
                                lastException = SoapSecurityException.format((QName)invalidSecurityToken, (String)"security.wssecurity.BinaryTokenReceiver.token19", (String)cpbe.toString());
                                continue;
                            }
                        }
                        tokenObject = cert;
                        trustAny = true;
                        break;
                    }
                    if (tokenObject == null) {
                        throw lastException;
                    }
                    ResultPool.add(context, new TokenResult.X509(tokenObject, id, anchorRef, storeRef, trustAny));
                }
                catch (SoapSecurityException sse) {
                    Tr.processException((Throwable)sse, clsName + ".invoke", "184", this);
                    Tr.error(tc, "security.wssecurity.BinaryTokenReceiver.token20", (Object)sse);
                    throw sse;
                }
                catch (Exception e) {
                    String msgKey = "security.wssecurity.BinaryTokenReceiver.token20";
                    Tr.processException((Throwable)e, clsName + ".invoke", "189", this);
                    Tr.error(tc, msgKey, e);
                    throw SoapSecurityException.format((String)msgKey, (String)e.toString());
                }
            }
            Tr.warning(tc, "security.wssecurity.BinaryTokenReceiver.token40");
        } else if (binaryData != null && binaryData.length != 0) {
            LoginMapping mapping;
            if (NamespaceUtil.isWsse(valueType.getNamespaceURI())) {
                valueType = new QName(Constants.NS_WSSE, valueType.getLocalPart());
            }
            if ((mapping = this.conf.getLoginMapping(valueType)) != null) {
                Subject subject = ReceiverLogin.login(mapping, binaryData, null, null, context);
                ResultPool.add(context, new TokenResult.Generic(valueType, subject, id));
            } else {
                Tr.warning(tc, "security.wssecurity.BinaryTokenReceiver.token22", valueType.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target,Map context)");
        }
    }
}

