/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.time;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.time.TimestampResult;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Date;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TimestampChecker
implements SoapSecurityComponent {
    private static final TraceComponent tc = Tr.register(TimestampChecker.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";

    public void init(Map map) throws Exception {
    }

    public void invoke(Document doc, Element target, Map context) throws SoapSecurityException {
        Result[] results;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + doc + "," + target + "," + context + ")");
        }
        if ((results = ResultPool.get(context, TimestampResult.class)).length > 1) {
            String wsseNSSent = Constants.getWSSENS(context);
            throw SoapSecurityException.format((QName)Constants.getQName(wsseNSSent, "InvalidSecurity"), (String)"security.wssecurity.TimeStampChecker.time02");
        }
        if (results.length == 1) {
            TimestampResult result = (TimestampResult)results[0];
            Date expires = result.getExpires();
            Date now = new Date();
            if (expires != null && now.after(expires)) {
                String wsuNSSent = Constants.getWSUNS(context);
                throw SoapSecurityException.format((QName)Constants.getQName(wsuNSSent, "MessageExpired"), (String)"security.wssecurity.TimestampChecker.time01", (String)expires.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target,Map context)");
        }
    }
}

