/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.enc;

import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xss4j.enc.DecryptionContext;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolver;
import com.ibm.ws.wssecurity.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xss4j.enc.ResourceShower;
import com.ibm.ws.wssecurity.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xss4j.enc.type.DataReference;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedData;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xss4j.enc.type.KeyReference;
import com.ibm.ws.wssecurity.xss4j.enc.type.ReferenceList;
import com.ibm.ws.wssecurity.xss4j.enc.type.ReferenceType;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.wsspi.wssecurity.config.KeyLocatorException;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.enc.DecryptionResult;
import com.ibm.xml.soapsec.enc.EncryptionReceiverConfig;
import com.ibm.xml.soapsec.enc.EncryptionSettings;
import com.ibm.xml.soapsec.enc.KeyIdentifierKeyResolver;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EncryptionReceiver
implements SoapSecurityComponent {
    private static final TraceComponent tc = Tr.register(EncryptionReceiver.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = EncryptionReceiver.class.getName();
    private EncryptionReceiverConfig fConfig;

    private List getIds(Element elem) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIds(" + elem + ")");
        }
        Element refList = null;
        if (EncryptedKey.isOfType((Element)elem)) {
            refList = DOMUtil.getChildElement(elem, "http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
        } else if (ReferenceList.isOfType((Element)elem)) {
            refList = elem;
        }
        ArrayList<String> ids = new ArrayList<String>();
        if (refList != null) {
            ReferenceList refList2 = new ReferenceList(refList);
            for (ReferenceType refType : refList2.getReferences()) {
                if (refType instanceof DataReference) {
                    String uri = ((DataReference)refType).getURI();
                    if (uri == null) {
                        throw SoapSecurityException.format((String)"security.wssecurity.EncryptionReceiver.enc05");
                    }
                    if (uri.length() <= 1 || uri.charAt(0) != '#') continue;
                    ids.add(uri.substring(1));
                    continue;
                }
                if (!(refType instanceof KeyReference)) continue;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIds(Element elem) returns " + ids);
        }
        return ids;
    }

    private DecryptionContext createDecryptionContext(KeyLocator locator, IDResolver reslvr, Map ctx) throws KeyLocatorException, KeyStoreException, NoSuchAlgorithmException, SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDecryptionContext(" + locator + ", " + reslvr + ")");
        }
        DecryptionContext context = new DecryptionContext();
        context.setAlgorithmFactory(AlgorithmFactory.getInstance());
        context.setIdResolver(reslvr);
        KeyIdentifierKeyResolver resolver = new KeyIdentifierKeyResolver(locator, 2, ctx, false);
        context.setKeyInfoResolver((KeyInfoResolver)resolver);
        if (tc.isDebugEnabled()) {
            context.setResourceShower((ResourceShower)ShowerImpl.getInstance());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDecryptionContext(KeyLocator locator,  IDResolver reslvr) returns " + context);
        }
        return context;
    }

    private void checkEncryptionMethod(Element encType, String method) throws SoapSecurityException {
        Element encMeth;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkEncryptionMethod(" + encType + "," + method + ")");
        }
        if ((encMeth = DOMUtil.getChildElement(encType, "http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod")) == null) {
            throw SoapSecurityException.format((String)"security.wssecurity.EncryptionReceiver.enc10");
        }
        if (!encMeth.hasAttribute("Algorithm")) {
            throw SoapSecurityException.format((String)"security.wssecurity.EncryptionReceiver.enc06");
        }
        String alg = encMeth.getAttribute("Algorithm");
        if (!alg.equals(method)) {
            throw SoapSecurityException.format((String)"security.wssecurity.EncryptionReceiver.enc07", (String)alg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkEncryptionMethod(Element encType, Set methods)");
        }
    }

    private void checkCipherData(Element encType) throws SoapSecurityException {
        Element ciphData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCipherData(" + encType + ")");
        }
        if ((ciphData = DOMUtil.getChildElement(encType, "http://www.w3.org/2001/04/xmlenc#", "CipherData")) == null) {
            Tr.error(tc, "security.wssecurity.WSEC5196E");
            throw SoapSecurityException.format((String)"security.wssecurity.WSEC5196E");
        }
        Element ciphRef = DOMUtil.getChildElement(ciphData, "http://www.w3.org/2001/04/xmlenc#", "CipherReference");
        if (ciphRef == null) {
            return;
        }
        if (!ciphRef.hasAttribute("URI")) {
            Tr.error(tc, "security.wssecurity.WSEC5197E");
            throw SoapSecurityException.format((String)"security.wssecurity.WSEC5197E");
        }
        String uri = ciphRef.getAttribute("URI");
        if (uri.length() < 2 || uri.charAt(0) != '#') {
            Tr.error(tc, "security.wssecurity.WSEC5198E", uri);
            throw SoapSecurityException.format((String)"security.wssecurity.WSEC5198E", (String)uri);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCipherData()");
        }
    }

    private Key decryptEncryptedKey(Element encKey, DecryptionContext context, Element encData) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, XSignatureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decryptEncryptedKey(" + encKey + "," + context + "," + encData + ")");
        }
        context.setEncryptedType(encKey, null, null, null);
        context.setEncryptionMethod(DOMUtil.getChildElement(encData, "http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod"));
        context.decrypt();
        Key key = (Key)context.getData();
        context.setEncryptionMethod(null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decryptEncryptedKey(Element encKey, DecryptionContext context, Element encData) returns " + key);
        }
        return key;
    }

    private DecryptionResult decryptEncryptedData(Element encData, DecryptionContext context) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, ParserConfigurationException, SAXException, StructureException, XSignatureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decryptEncryptedData(" + encData + "," + context + ")");
        }
        context.setEncryptedType(encData, null, null, null);
        context.decrypt();
        context.replace();
        NodeList nodes = context.getDataAsNodeList();
        String type = context.getType();
        DecryptionResult result = this.createDecryptionResult(nodes, type);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decryptEncryptedData(Element encData, DecryptionContext context) returns " + result);
        }
        return result;
    }

    private DecryptionResult createDecryptionResult(NodeList nodes, String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDecryptionResult(" + nodes + "," + type + ")");
        }
        DecryptionResult result = new DecryptionResult();
        if (nodes.getLength() > 0) {
            Node node = nodes.item(0);
            if (type.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
                Element elem = (Element)node;
                String id = this.getId(elem);
                if (id != null) {
                    result.setElement(id, false);
                } else {
                    result.setElement(elem, false);
                }
            } else if (type.equals("http://www.w3.org/2001/04/xmlenc#Content") && (node = node.getParentNode()) != null && node.getNodeType() == 1) {
                if ("http://schemas.xmlsoap.org/soap/envelope/".equals(node.getNamespaceURI()) && "Body".equals(node.getLocalName())) {
                    result.setBodyContent();
                } else {
                    Element elem = (Element)node;
                    String id = this.getId(elem);
                    if (id != null) {
                        result.setElement(id, true);
                    } else {
                        result.setElement(elem, true);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDecryptionResult(NodeList nodes, String type) returns " + result);
        }
        return result;
    }

    private String getId(Element elem) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getId(" + elem + ")");
        }
        String name2 = IdUtil.getInstance().getIdAttributeName(elem);
        String value2 = null;
        if (name2 != null) {
            value2 = elem.getAttribute(name2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getId(Element elem) returns" + value2);
        }
        return value2;
    }

    private Exception unwrapException(Exception exc) {
        Exception exc2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unwrapException(" + exc + ")");
        }
        if (exc instanceof SAXException) {
            Exception exc22 = ((SAXException)exc).getException();
            if (exc22 != null) {
                exc = exc22;
            }
        } else if (exc instanceof XSignatureException && (exc2 = ((XSignatureException)((Object)exc)).getException()) != null) {
            exc = exc2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unwrapException(Exception exc) returns " + exc);
        }
        return exc;
    }

    public void init(Map map) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(" + map + ")");
        }
        this.fConfig = (EncryptionReceiverConfig)map.get(EncryptionReceiverConfig.class);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public void invoke(Document doc, Element target, Map context) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + doc + "," + target + "," + context + ")");
        }
        boolean succeeded = false;
        Exception lastException = null;
        List settingsList = this.fConfig.getEncryptionSettingsList();
        Iterator iter = settingsList.iterator();
        while (iter.hasNext()) {
            try {
                this.invoke0(doc, target, context, (EncryptionSettings)iter.next());
                succeeded = true;
                break;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (!succeeded) {
            Tr.error(tc, "security.wssecurity.EncryptionReceiver.exception", lastException);
            throw SoapSecurityException.format((String)"security.wssecurity.EncryptionReceiver.enc14", (Throwable)lastException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target, Map context)");
        }
    }

    private void invoke0(Document doc, Element target, Map context, EncryptionSettings settings) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke0(" + doc + "," + target + "," + context + "," + settings + ")");
        }
        try {
            List ids = this.getIds(target);
            IdUtil resolver = IdUtil.getInstance();
            DecryptionContext decCont = this.createDecryptionContext(settings.getKeyLocator(), resolver, context);
            Key key = null;
            for (String id : ids) {
                Element elem = resolver.resolveID(doc, id);
                if (elem == null) continue;
                if (EncryptedData.isOfType((Element)elem)) {
                    this.checkEncryptionMethod(elem, settings.getDataEncryptionMethod());
                    this.checkCipherData(elem);
                    decCont.setKey(null);
                    if (EncryptedKey.isOfType((Element)target)) {
                        if (key == null) {
                            this.checkEncryptionMethod(target, settings.getKeyEncryptionMethod());
                            this.checkCipherData(target);
                            key = this.decryptEncryptedKey(target, decCont, elem);
                        }
                        decCont.setKey(key);
                    }
                    DecryptionResult result = this.decryptEncryptedData(elem, decCont);
                    ResultPool.add(context, result);
                    continue;
                }
                throw SoapSecurityException.format((String)"security.wssecurity.EncryptionReceiver.enc13", (String)elem.getTagName());
            }
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, clsName + ".invoke", "381", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "An exception while decrypting the message: {0}", e);
            }
            throw this.unwrapException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke0(Document doc, Element target, Map context, EncryptionSettings settings)");
        }
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        public void showEncryptedResource(byte[] content, Object data, Element encType) {
            String dumpData = null;
            try {
                dumpData = EncryptedData.isOfType((Element)encType) ? new String(content, "UTF-8") : Base64.encode((byte[])content);
            }
            catch (Exception e) {
                Tr.debug(tc, "WARNING: An exception occured while the content is encoded with [UTF-8].");
            }
            if (EncryptedData.isOfType((Element)encType)) {
                Tr.debug(tc, "ResourceShower logs decrypt-" + encType.getAttribute("Id") + ": " + dumpData);
            } else {
                Tr.debug(tc, "ResourceShower logs decrypt-EncryptedKey: " + dumpData);
            }
        }
    }
}

