/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.enc;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.enc.DecryptionResult;
import com.ibm.xml.soapsec.enc.EncryptionReceiverConfig;
import com.ibm.xml.soapsec.token.TokenResult;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EncryptedPartChecker
implements SoapSecurityComponent {
    private static final TraceComponent tc = Tr.register(EncryptedPartChecker.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    EncryptionReceiverConfig config;

    public void init(Map map) throws Exception {
        this.config = (EncryptionReceiverConfig)map.get(EncryptionReceiverConfig.class);
    }

    public void invoke(Document doc, Element target, Map context) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + doc + "," + target + "," + context + ")");
        }
        Result[] decResults = ResultPool.get(context, DecryptionResult.class);
        for (String part : this.config.getRequiredConfidentialParts()) {
            int i;
            Element el;
            if (part.equals("bodycontent")) {
                boolean encrypted = false;
                for (int i2 = 0; i2 < decResults.length; ++i2) {
                    String idvalue;
                    String idattr;
                    DecryptionResult decResult = (DecryptionResult)decResults[i2];
                    if (decResult.isBodyContent()) {
                        encrypted = true;
                        break;
                    }
                    if (!decResult.isContentOnly()) continue;
                    el = doc.getDocumentElement();
                    if ((el = DOMUtil.getFirstElement(el, "http://schemas.xmlsoap.org/soap/envelope/", "Body")) == null || ((idattr = IdUtil.getInstance().getIdAttributeName(el)) == null || (idvalue = el.getAttribute(idattr)).length() <= 0 || !idvalue.equals(decResult.getId())) && el != decResult.getElement()) continue;
                    encrypted = true;
                    break;
                }
                if (encrypted) continue;
                String wsseNSSent = Constants.getWSSENS(context);
                throw SoapSecurityException.format((QName)Constants.getQName(wsseNSSent, "FailedCheck"), (String)"security.wssecurity.EncryptionReceiver.enc15", (Document)doc);
            }
            if (!part.equals("usernametoken")) continue;
            Result[] utResults = ResultPool.get(context, TokenResult.Username.class);
            boolean[] utEncrypted = new boolean[utResults.length];
            block2: for (i = 0; i < decResults.length; ++i) {
                DecryptionResult decResult = (DecryptionResult)decResults[i];
                if (decResult.isContentOnly()) continue;
                String id = decResult.getId();
                el = decResult.getElement();
                for (int j = 0; j < utResults.length; ++j) {
                    TokenResult.Username ut = (TokenResult.Username)utResults[j];
                    String utId = ut.getIdName();
                    Element utEl = ut.getElement();
                    if ((utId == null || !utId.equals(id)) && (utEl == null || utEl != el)) continue;
                    utEncrypted[j] = true;
                    continue block2;
                }
            }
            for (i = 0; i < utEncrypted.length; ++i) {
                if (utEncrypted[i]) continue;
                String wsseNSSent = Constants.getWSSENS(context);
                throw SoapSecurityException.format((QName)Constants.getQName(wsseNSSent, "FailedCheck"), (String)"security.wssecurity.EncryptionReceiver.enc16", (Document)doc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target, Map context)");
        }
    }
}

